/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.ISortFunc;
import JCollections.JArray;
import JCollections.JOrderedCollection;
import JCollections.JSet;
import Jxe.AttributedTextLine;
import Jxe.JXEOptions;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.ArrayTool;
import de.netcomputing.anyj.jwidgets.CompCreator;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IB_ContainerCreator;
import de.netcomputing.anyj.jwidgets.IClassCreator;
import editapp.Declaration;
import editapp.EditApp;
import editapp.FieldDescription;
import editapp.IndexEntry;
import editapp.MethodDescription;
import editapp.SourceBase;
import editapp.TPanel;
import java.awt.Frame;
import java.io.File;
import java.io.Writer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import jxeplugins.DocumentPosition;

public class CodeGenerator {
    public static void GenerateAccessors(JOrderedCollection jc, TextDocument doc, boolean setters, boolean getters, boolean removeFirst) {
        int x = doc.cX();
        int y = doc.cY();
        String sp1 = doc.constructSpace(JXEOptions.INDENT).toString();
        String sp2 = doc.constructSpace(JXEOptions.INDENT * 2).toString();
        int n = 0;
        while (n < jc.size()) {
            IndexEntry ie = (IndexEntry)jc.at(n);
            if (ie.decl() instanceof FieldDescription) {
                StringBuffer funH = new StringBuffer(40);
                FieldDescription decl = (FieldDescription)ie.decl();
                String varName = decl.name;
                if (removeFirst && varName.length() > 1) {
                    varName = varName.substring(1);
                }
                if (setters) {
                    funH.append(sp1 + "public void").append(" set").append(varName.toUpperCase().charAt(0)).append(varName.substring(1)).append("( ").append(decl.typeClass + " " + varName + " )");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(funH.toString());
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(sp1 + "{");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(sp2 + "this." + decl.name + " = " + varName + ";");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(sp1 + "}");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                }
                if (getters) {
                    doc.insertAndMove(sp1 + "public " + decl.typeClass + " get" + varName.toUpperCase().charAt(0) + varName.substring(1) + "()");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(sp1 + "{");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(sp2 + "return " + decl.name + ";");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                    doc.insertAndMove(sp1 + "}");
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                }
            }
            ++n;
        }
        doc.setSelection(x, y, doc.cX(), doc.cY());
        doc.repaint();
    }

    static String stripShitDecl(String str) {
        int idx = 0;
        int sp = 0;
        int cnt = -1;
        StringBuffer dest = new StringBuffer();
        while (idx < str.length()) {
            char ch = str.charAt(idx);
            if (Character.isJavaIdentifierPart(ch)) {
                if (str.regionMatches(idx, "abstract", 0, 8) && idx + 9 < str.length() && str.charAt(idx + 8) < '!') {
                    idx += 8;
                } else if (str.regionMatches(idx, "final", 0, 5) && idx + 6 < str.length() && str.charAt(idx + 5) < '!') {
                    idx += 5;
                } else {
                    if (sp > 0) {
                        dest.append(' ');
                    }
                    dest.append(ch);
                    while (++idx < str.length() && Character.isJavaIdentifierPart(ch = str.charAt(idx))) {
                        dest.append(ch);
                    }
                }
                sp = 0;
                if (cnt != 0) continue;
                ++cnt;
                continue;
            }
            if (Character.isSpace(ch)) {
                sp = 1;
            } else {
                if (ch == ')') {
                    dest.append(cnt > 0 ? " )" : ")");
                } else {
                    dest.append(ch);
                }
                if (ch == '(') {
                    cnt = 0;
                }
                sp = 0;
            }
            ++idx;
        }
        return dest.toString();
    }

    /*
     * Unable to fully structure code
     */
    static String stripShitCall(String str) {
        end = 0;
        idx = 0;
        pos = -1;
        dest = new StringBuffer();
        ** GOTO lbl18
        {
            --idx;
            do {
                if (idx > 0 && !Character.isJavaIdentifierPart(str.charAt(idx - 1))) continue block0;
                end = idx;
                while (--idx >= 0 && Character.isJavaIdentifierPart(str.charAt(idx))) {
                }
                while (++idx < end) {
                    dest.append(str.charAt(idx));
                }
                dest.append(", ");
lbl18:
                // 2 sources

                idx = pos = str.indexOf(44, pos + 1);
            } while (pos >= 0);
        }
        idx = str.length();
        while (idx > 0 && !Character.isJavaIdentifierPart(str.charAt(idx - 1))) {
            --idx;
        }
        end = idx;
        while (--idx >= 0 && Character.isJavaIdentifierPart(str.charAt(idx))) {
        }
        while (++idx < end) {
            dest.append(str.charAt(idx));
        }
        if (dest.length() > 0) {
            return " " + dest + " ";
        }
        return dest.toString();
    }

    public static void GenerateFunctions(JOrderedCollection jc, TextDocument doc, String redirect) {
        int x = doc.cX();
        int y = doc.cY();
        String sp1 = doc.constructSpace(JXEOptions.INDENT).toString();
        String sp2 = doc.constructSpace(JXEOptions.INDENT * 2).toString();
        int n = 0;
        while (n < jc.size()) {
            IndexEntry ie = (IndexEntry)jc.at(n);
            if (ie.decl() instanceof MethodDescription) {
                StringBuffer funH = new StringBuffer(40);
                MethodDescription decl = (MethodDescription)ie.decl();
                funH.append(Declaration.modifierFor(ie.decl().modifier));
                funH.append(decl.typeClass).append(" ").append(decl.name).append("( ").append(decl.argString + " )");
                doc.lineBreak();
                doc.moveCursorAbs(0, doc.cY());
                doc.insertAndMove(sp1 + CodeGenerator.stripShitDecl(funH.toString()));
                doc.lineBreak();
                doc.moveCursorAbs(0, doc.cY());
                doc.insertAndMove(sp1 + "{");
                doc.lineBreak();
                doc.moveCursorAbs(0, doc.cY());
                if (redirect != null) {
                    String s = redirect + "." + decl.name + "(" + CodeGenerator.stripShitCall(decl.argString) + ");";
                    if (decl.typeClass != null && decl.typeClass.length() > 0 && !decl.typeClass.equals("void")) {
                        doc.insertAndMove(sp2 + "return " + s);
                    } else {
                        doc.insertAndMove(sp2 + s);
                    }
                    doc.lineBreak();
                    doc.moveCursorAbs(0, doc.cY());
                }
                doc.insertAndMove(sp1 + "}");
                doc.lineBreak();
                doc.moveCursorAbs(0, doc.cY());
            }
            ++n;
        }
        doc.setSelection(x, y, doc.cX(), doc.cY());
        doc.repaint();
    }

    public static void GenereratePackage(String dir, String name) {
        try {
            String requiredDir = name.replace('.', File.separatorChar);
            if (!dir.endsWith(requiredDir)) {
                Confirm.ModalMsg((Frame)EditApp.App.jol.getFrame(), "Wrong Input", new String[]{"The directory names have to match the package name"});
                return;
            }
            String[] s = new File(dir).list();
            int n = 0;
            while (s != null && n < s.length) {
                if (s[n].toLowerCase().endsWith(".java")) {
                    TextDocument doc = new TextDocument(new File(dir + File.separator + s[n]));
                    doc.insertLine(0, new AttributedTextLine("package " + name + ";"));
                    doc.save();
                }
                ++n;
            }
        }
        catch (Exception e) {
            Confirm.ModalMsg((Frame)EditApp.App.jol.getFrame(), "An Error occurred", new String[]{e.getClass().getName(), e.getMessage()});
            e.printStackTrace();
        }
    }

    public static void GenerateJavaDoc(TextDocument doc) {
        SourceBase sb = SourceBase.This();
        String sp1 = doc.constructSpace(JXEOptions.INDENT).toString();
        String res = Confirm.DoModal(EditApp.App.mainFrame, null, "Please save", new String[]{"The file has to be saved to proceed.", "Note that comments are created for each method,", "even when there is already a comment existing.", "* The File must not contain syntax errors *"}, new String[]{"Proceed", "Cancel"});
        if (res == null || res != "Proceed") {
            return;
        }
        sb.update(doc.getFile().getAbsolutePath());
        JArray jar = sb.definitionsInFile(doc.getFile().getAbsolutePath());
        JArray.QuickSort(jar, new ISortFunc(){

            public boolean isGreaterOrEqual(Object gr, Object kl) {
                return ((IndexEntry)gr).docPos().line <= ((IndexEntry)kl).docPos().line;
            }
        });
        doc.lockUpdate(true);
        int n = 0;
        while (n < jar.size()) {
            if (!((IndexEntry)jar.at(n)).isField()) {
                FieldDescription decl;
                IndexEntry ie = (IndexEntry)jar.at(n);
                DocumentPosition dp = ie.docPos();
                String sp = ie.isClassOrInterface() ? "" : sp1;
                doc.moveCursorNoScroll(0, Math.max(0, dp.line - 1));
                doc.addLineAt(doc.cY(), new AttributedTextLine(""));
                if (doc.cY() > 0 && doc.lineAt(doc.cY() - 1).getLastChar() >= 0) {
                    doc.lineBreak();
                }
                doc.moveCursorNoScroll(0, doc.cY());
                doc.insertAndMove(sp + "/**");
                doc.lineBreak();
                doc.moveCursorNoScroll(0, doc.cY());
                doc.insertAndMove(sp + " * ");
                doc.lineBreak();
                doc.moveCursorNoScroll(0, doc.cY());
                doc.insertAndMove(sp + " *");
                if (ie.isClassOrInterface()) {
                    doc.lineBreak();
                    doc.moveCursorNoScroll(0, doc.cY());
                    doc.insertAndMove(sp + " * @version ");
                    doc.lineBreak();
                    doc.moveCursorNoScroll(0, doc.cY());
                    doc.insertAndMove(sp + " * @author  ");
                } else if (ie.isMethod()) {
                    decl = (MethodDescription)ie.decl();
                    StringTokenizer tok = new StringTokenizer(CodeGenerator.stripShitCall(decl.argString), ", ");
                    String s = null;
                    while (tok.hasMoreElements()) {
                        s = tok.nextToken();
                        if (s.length() <= 0) continue;
                        doc.lineBreak();
                        doc.moveCursorNoScroll(0, doc.cY());
                        doc.insertAndMove(sp + " * @param   " + s);
                    }
                    if (!decl.typeClass.startsWith("void")) {
                        doc.lineBreak();
                        doc.moveCursorNoScroll(0, doc.cY());
                        doc.insertAndMove(sp + " * @return  ");
                    }
                } else if (ie.isField()) {
                    decl = (FieldDescription)ie.decl();
                }
                doc.lineBreak();
                doc.moveCursorNoScroll(0, doc.cY());
                doc.insertAndMove(sp + " */");
            }
            ++n;
        }
        doc.lockUpdate(false);
    }

    public static void GenerateJIBInit(IClassCreator cc, File jibFile, Writer out) {
        TPanel tp = new TPanel();
        boolean old = CompCreator.shouldCache;
        CompCreator.shouldCache = false;
        Object[] pan = ArrayTool.LoadArrayFromAbsolutePath(jibFile.getAbsolutePath());
        pan = (Object[])ArrayTool.DecodeArray(pan);
        new IB_ContainerCreator().buildIn(cc, tp, (Object[])pan[1]);
        CompCreator.shouldCache = old;
        String[] classes = new String[tp.privateComp().size()];
        String[] names = new String[tp.privateComp().size()];
        JSet jsClasses = new JSet(tp.privateComp().size());
        Enumeration e = tp.privateComp().keys();
        int n = 0;
        while (e.hasMoreElements()) {
            names[n] = e.nextElement().toString();
            classes[n] = tp.privateComp().get(names[n]).getClass().getName();
            jsClasses.add(classes[n]);
            ++n;
        }
        try {
            String printCurrent;
            String current;
            e = jsClasses.enumerate();
            while (e.hasMoreElements()) {
                current = (String)e.nextElement();
                printCurrent = current.indexOf(46) >= 0 ? current.substring(current.lastIndexOf(46) + 1, current.length()) : current;
                out.write("\t" + printCurrent + "\n");
                n = 0;
                while (n < classes.length) {
                    if (classes[n].equals(current)) {
                        out.write("        " + names[n]);
                        if (n != classes.length - 1) {
                            out.write(",\n");
                        } else {
                            out.write(";\n");
                        }
                    }
                    ++n;
                }
            }
            out.write("\n");
            out.write("\tpublic void init()\n");
            out.write("\t{\n");
            e = jsClasses.enumerate();
            while (e.hasMoreElements()) {
                current = (String)e.nextElement();
                printCurrent = current.indexOf(46) >= 0 ? current.substring(current.lastIndexOf(46) + 1, current.length()) : current;
                n = 0;
                while (n < classes.length) {
                    if (classes[n].equals(current)) {
                        out.write("\t\t" + names[n] + " = (" + printCurrent + ") getComponent(\"" + names[n] + "\");\n");
                    }
                    ++n;
                }
            }
            out.write("\t}\n");
            out.write("\n");
            out.write("\tpublic String getJIBName()\n");
            out.write("\t{\n");
            out.write("\t\treturn \"" + jibFile.getName() + "\";\n");
            out.write("\t}\n\n");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

