/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import Jack.InputObject;
import editapp.Declaration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;

public class FieldDescription
extends Declaration {
    String name;
    String typePack;
    String typeClass;

    public static Vector ConstructFrom(InputObject is, FieldDescription template) {
        InputObject[] isarr = is.getContent();
        Vector<FieldDescription> result = new Vector<FieldDescription>();
        int n = 0;
        while (n < isarr.length) {
            FieldDescription fd = new FieldDescription();
            fd.setDP(template.path, isarr[n].linePosition() + 1, isarr[n].colPosition(), isarr[n].length());
            fd.className = template.className;
            fd.pack = template.pack;
            fd.name = isarr[n].toString();
            fd.modifier = template.modifier;
            fd.typeClass = template.typeClass;
            fd.typePack = template.typePack;
            result.addElement(fd);
            while (n < isarr.length && isarr[n].getIntVal() != 65589) {
                ++n;
            }
            ++n;
        }
        return result;
    }

    public String getTypePack() {
        return this.typePack;
    }

    public String getTypeClass() {
        return this.typeClass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldDescription) {
            FieldDescription o = (FieldDescription)obj;
            return o.name.equals(this.name) && o.className.equals(this.className) && o.typeClass.equals(this.typeClass) && this.path.equals(o.path);
        }
        return (this.typePack + "." + this.typeClass + " " + this.name).equals(obj);
    }

    public void storeProperty(DataOutputStream dos) throws Exception {
        super.storeProperty(dos);
        if (this.name == null) {
            this.name = "";
        }
        if (this.typeClass == null) {
            this.typeClass = "";
        }
        if (this.typePack == null) {
            this.typePack = "";
        }
        dos.writeUTF(this.name);
        dos.writeUTF(this.typeClass);
        dos.writeUTF(this.typePack);
    }

    public void loadProperty(DataInputStream dis) throws Exception {
        super.loadProperty(dis);
        this.name = dis.readUTF();
        this.typeClass = dis.readUTF();
        this.typePack = dis.readUTF().intern();
    }

    public String getName() {
        return this.name;
    }

    public String toExactString() {
        String tmpType = this.typeClass;
        while (tmpType.startsWith(".")) {
            tmpType = tmpType.substring(1);
        }
        return Declaration.modifierFor(this.modifier) + tmpType + " " + this.name;
    }

    public String toString() {
        if (this.displayString == null) {
            this.displayString = Declaration.modifierFor(this.modifier) + this.typePack + "." + this.typeClass + " " + this.name + " in " + this.pack + "." + this.className;
        }
        return this.displayString;
    }
}

