/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.IntTable;
import JCollections.JCollection;
import JCollections.JOrderedCollection;
import JCollections.JSet;
import JCollections.JSortedSetArray;
import JCollections.JUnsafeTable;
import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.FileEntry;
import editapp.IndexEntry;
import editapp.SourceBase;
import editapp.stringstore.StringStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import jxeplugins.FileSetupEntry;

public class FileRegistry {
    JUnsafeTable files = new JUnsafeTable(1000);
    public static FileRegistry This;
    static FileEntry Dummy;
    JSortedSetArray knownPack;

    FileRegistry() {
        This = this;
    }

    public String findFileEndingWith(String name) {
        Enumeration ee = this.files.keys();
        while (ee.hasMoreElements()) {
            String s = (String)ee.nextElement();
            if (!s.endsWith(name)) continue;
            return s;
        }
        return null;
    }

    public FileEntry get(String _path) {
        return this.get(_path, 0);
    }

    public FileEntry get(String _path, int initialSiz) {
        if (_path == null) {
            return Dummy;
        }
        String path = _path;
        if (this.files.get(path) == null) {
            this.files.put(path, new FileEntry(path, initialSiz));
        }
        return (FileEntry)this.files.get(path);
    }

    boolean isKnown(String path) {
        return this.files.get(path) != null;
    }

    void remove(String _path) {
        this.files.remove(_path);
    }

    void resetKnownPack() {
        this.knownPack = null;
    }

    public void getClassesInPackage(String pack, JCollection result) {
        Enumeration e = this.files.elements();
        while (e.hasMoreElements()) {
            FileEntry fe = (FileEntry)e.nextElement();
            if (fe.packageName == null || !fe.packageName.equals(pack)) continue;
            result.add(VFile.NameWithoutExtension(fe.fullPath));
        }
    }

    JSortedSetArray getKnownPackages() {
        if (this.knownPack == null) {
            JSortedSetArray result = new JSortedSetArray(30);
            Enumeration e = this.files.elements();
            while (e.hasMoreElements()) {
                FileEntry fe = (FileEntry)e.nextElement();
                if (fe.packageName == null || fe.packageName.startsWith(File.separator) || SourceBase.SoleInstance.matches(EditApp.App.getToExclude(), fe.packageName)) continue;
                result.add(fe.packageName);
            }
            this.knownPack = result;
        }
        return this.knownPack;
    }

    Enumeration enumerateFiles() {
        return this.files.keys();
    }

    Enumeration enumerate() {
        return this.files.elements();
    }

    void computeFilteredIndex(JOrderedCollection result) {
        long tim = System.currentTimeMillis();
        Enumeration e = this.enumerate();
        JUnsafeTable tab = new JUnsafeTable(1000);
        while (e.hasMoreElements()) {
            FileEntry fe = (FileEntry)e.nextElement();
            FileSetupEntry fse = EditApp.App.getOptionsFor(fe.fullPath);
            if (fse == null || !fse.doScan()) continue;
            tab.put(fe.fullPath, Boolean.TRUE);
        }
        Vector v = SourceBase.This().indexAsVector();
        int n = 0;
        while (n < v.size()) {
            IndexEntry ie = (IndexEntry)v.elementAt(n);
            if (ie.fileString().endsWith(")")) {
                String zip = ie.fileString();
                int i = zip.lastIndexOf(40);
                if (i >= 0) {
                    zip = zip.substring(0, i);
                }
                if (tab.get(zip) != null) {
                    result.add(ie);
                }
            } else if (tab.get(ie.fileString()) != null) {
                result.add(ie);
            }
            ++n;
        }
    }

    public boolean load(String fileName, JOrderedCollection index) {
        try {
            long tim = System.currentTimeMillis();
            StringStore.loadFrom(fileName + "string");
            NCApplication.Pln("-------------filereg.load (only Stringstore)" + (System.currentTimeMillis() - tim));
            ObjectInputStream o = null;
            if (!new File(fileName).exists()) {
                NCApplication.Pln("FileRegistry: could not load from:" + fileName);
                return false;
            }
            int le = (int)new File(fileName).length();
            FileInputStream fi = new FileInputStream(fileName);
            byte[] buf = new byte[le];
            fi.read(buf, 0, le);
            fi.close();
            ByteArrayInputStream bi = new ByteArrayInputStream(buf);
            o = new ObjectInputStream(bi);
            NCApplication.Pln("-------------filereg.load (only unifier)" + (System.currentTimeMillis() - tim));
            int len = o.readInt();
            IntTable id2File = new IntTable(500);
            id2File.put(0, "null");
            JSet tmpImports = new JSet(30);
            int fileN = 0;
            while (fileN < len) {
                int fileId = o.readInt();
                String name = StringStore.getString(fileId);
                if (name == null) {
                    name = "null";
                    Tracer.This.println("FATAL NAME=NULL:" + name + " fileId:" + fileId);
                } else {
                    String tmpPack = StringStore.getString(o.readInt()).intern();
                    long tmpLastParsed = o.readLong();
                    int siz = o.readInt();
                    FileEntry fe = this.get(name);
                    fe.setPackage(tmpPack);
                    fe.lastParsed = tmpLastParsed;
                    int n = 0;
                    while (n < siz) {
                        int i = o.readInt();
                        String ss = StringStore.getString(i);
                        if (ss == null) {
                            Tracer.This.println("FATAL, PACK == null id:" + i);
                        } else {
                            ss = ss.intern();
                            tmpImports.add(ss);
                        }
                        ++n;
                    }
                    fe.setImports(tmpImports);
                    tmpImports.clear();
                    id2File.put(fileId, fe);
                }
                ++fileN;
            }
            NCApplication.Pln("-------------filereg.load (only filreg)" + (System.currentTimeMillis() - tim));
            try {
                int indexSize = o.readInt();
                int n = 0;
                while (n < indexSize) {
                    FileEntry fe;
                    IndexEntry ie = new IndexEntry();
                    ie.readExternal(o, null);
                    index.add(ie);
                    if ((ie.fileId & 0xFFFFFF) != 0 && (fe = (FileEntry)id2File.get(ie.fileId & 0xFFFFFF)) != null) {
                        fe.add(ie);
                        ie.fileName = fe.fullPath;
                    }
                    ++n;
                }
            }
            catch (Throwable ex) {
                if (ex instanceof OutOfMemoryError) {
                    EditApp.App.outOfMemExit();
                }
                ex.printStackTrace();
            }
            o.close();
            NCApplication.Pln("-------------filereg.load finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean save(String fileName, JOrderedCollection index) {
        ObjectOutputStream o = null;
        try {
            IndexEntry ie;
            FileEntry fe;
            o = new ObjectOutputStream(new FileOutputStream(fileName));
            Enumeration e = this.files.keys();
            while (e.hasMoreElements()) {
                fe = this.get((String)e.nextElement());
                if (fe.packageName != null) continue;
                if (fe.fullPath.lastIndexOf(File.separator) >= 0) {
                    fe.packageName = fe.fullPath.substring(0, fe.fullPath.lastIndexOf(File.separator));
                    fe.packageName = fe.packageName.substring(fe.packageName.lastIndexOf(File.separator), fe.packageName.length());
                    continue;
                }
                fe.packageName = "unknown.package";
            }
            e = this.files.keys();
            o.writeInt(this.files.size());
            while (e.hasMoreElements()) {
                fe = this.get((String)e.nextElement());
                o.writeInt(StringStore.addString(fe.fullPath));
                o.writeInt(StringStore.addString(fe.packageName));
                o.writeLong(fe.lastParsed);
                String[] imp = fe.imports();
                o.writeInt(imp.length);
                int n = 0;
                while (n < imp.length) {
                    int i = StringStore.addString(imp[n]);
                    if (i == 0) {
                        Tracer.This.println("FATAL SAVING FE: addString returned Null " + imp[n]);
                    }
                    o.writeInt(i);
                    ++n;
                }
                Enumeration fee = fe.enumerate();
                while (fee.hasMoreElements()) {
                    ie = (IndexEntry)fee.nextElement();
                    ie.fileId = ie.fileId & 0xFF000000 | StringStore.addString(ie.getFileString());
                }
            }
            o.writeInt(index.size());
            int n = 0;
            while (n < index.size()) {
                ie = (IndexEntry)index.at(n);
                ie.writeExternal(o, null);
                ++n;
            }
            StringStore.saveTo(fileName + "string");
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
            StringStore.saveTo(fileName + "string");
            return false;
        }
        return true;
    }

    static {
        Dummy = new FileEntry("DUMMY", 0);
    }
}

