/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JWVFile.StringUnifier;
import JWVFile.VFile;
import Jxe.DocumentStream;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import editapp.ClassDescription;
import editapp.Declaration;
import editapp.FieldDescription;
import editapp.MethodDescription;
import editapp.SourceBase;
import editapp.stringstore.StringStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jxeplugins.DocumentPosition;
import jxeplugins.IJEIndexEntry;

public final class IndexEntry
extends BasicListItem
implements IJEIndexEntry {
    static DataOutputStream fo;
    static DataInputStream fi;
    static DataInputStream fixedFi;
    static DataOutputStream fixedFo;
    static RandomAccessFile dynamicFile;
    static RandomAccessFile fixedFile;
    static int CACHESIZE;
    static IndexEntry[] ExternalCache;
    static int ExternalCacheCnt;
    static boolean CacheTurnedOn;
    static Vector WriteQueue;
    int fieldId = 0;
    int classId = 0;
    int superId = 0;
    transient Declaration decl;
    int id = 0;
    int fileId;
    String fileName;
    boolean inCache = false;

    static void SetCacheSize(int n) {
        CACHESIZE = n;
        IndexEntry.ClearExternalCache();
        ExternalCache = new IndexEntry[CACHESIZE];
        ExternalCacheCnt = 0;
        CacheTurnedOn = true;
    }

    public Object dataObject() {
        return this;
    }

    public static void InitDBFile() {
        try {
            ExternalCache = new IndexEntry[CACHESIZE];
            ExternalCacheCnt = 0;
            String s = SourceBase.This().getDBFile();
            new File(s).getParentFile().mkdirs();
            RandomAccessFile f = new RandomAccessFile(s, "rw");
            fo = new DataOutputStream(new FileOutputStream(f.getFD()));
            fi = new DataInputStream(new FileInputStream(f.getFD()));
            dynamicFile = f;
            f = new RandomAccessFile(SourceBase.This().getFixedDBFile(), "rw");
            fixedFi = new DataInputStream(new FileInputStream(f.getFD()));
            fixedFo = new DataOutputStream(new FileOutputStream(f.getFD()));
            fixedFile = f;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void ExitDBFile() {
        try {
            dynamicFile.close();
            fixedFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String fieldName() {
        return StringStore.getString(this.fieldId);
    }

    public String className() {
        return StringStore.getString(this.classId);
    }

    String superClass() {
        return StringStore.getString(this.superId);
    }

    public void fieldName(String name) {
        this.fieldId = StringStore.addString(name);
    }

    public void className(String name) {
        this.classId = StringStore.addString(name);
    }

    void superClass(String name) {
        if (name == null) {
            name = "Object";
        }
        this.superId = StringStore.addString(name);
    }

    IndexEntry() {
    }

    IndexEntry(String _fieldName, String _className, Declaration _decl) {
        this.fieldName(_fieldName);
        this.className(_className);
        this.decl = _decl;
        if (this.decl instanceof ClassDescription) {
            this.superClass(((ClassDescription)this.decl).superClass());
        } else {
            this.superClass("");
        }
        this.id = 0;
        this.fileId = this.decl.packageName().startsWith("java.") || this.decl.packageName().startsWith("sun.") ? 0x1000000 : 0;
        this.fileName = _decl.getFile();
        this.writeZIP();
    }

    public void freeMem() {
        this.decl = null;
        this.inCache = false;
    }

    public void readExternal(ObjectInput in, StringUnifier uni) throws IOException, ClassNotFoundException {
        this.fieldId = in.readInt();
        this.classId = in.readInt();
        this.superId = in.readInt();
        this.id = in.readInt();
        this.fileId = in.readInt();
    }

    public void unifyTo(StringUnifier uni) {
    }

    public void writeExternal(ObjectOutput out, StringUnifier uni) throws IOException {
        if (this.fieldId == 0) {
            this.fieldName();
        }
        if (this.classId == 0) {
            this.className();
        }
        if (this.superId == 0) {
            this.superClass();
        }
        out.writeInt(this.fieldId);
        out.writeInt(this.classId);
        out.writeInt(this.superId);
        out.writeInt(this.id);
        out.writeInt(this.fileId);
    }

    public static void ClearExternalCache() {
        int n = 0;
        while (n < ExternalCache.length) {
            if (ExternalCache[n] != null) {
                ExternalCache[n].freeMem();
            }
            IndexEntry.ExternalCache[n] = null;
            ExternalCacheCnt = 0;
            ++n;
        }
    }

    public static void AddEntry(IndexEntry ie) {
        if (!CacheTurnedOn || ie.inCache) {
            return;
        }
        if (ExternalCache[ExternalCacheCnt] != null && ExternalCache[ExternalCacheCnt] != ie) {
            ExternalCache[ExternalCacheCnt].freeMem();
        }
        IndexEntry.ExternalCache[IndexEntry.ExternalCacheCnt] = ie;
        if ((ExternalCacheCnt = (ExternalCacheCnt + 1) % ExternalCache.length) == CACHESIZE - 1) {
            Tracer.This.println("**************** cache turnaround **************");
            new Exception("Stack trace").printStackTrace(Tracer.This);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void readZIP() {
        try {
            RandomAccessFile randomAccessFile = this.getRAFile();
            synchronized (randomAccessFile) {
                this.getRAFile().seek(this.id);
                byte clazz = this.getInStream().readByte();
                switch (clazz) {
                    case 1: {
                        this.decl = new ClassDescription();
                        break;
                    }
                    case 3: {
                        this.decl = new FieldDescription();
                        break;
                    }
                    case 2: {
                        this.decl = new MethodDescription();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown clasid in sourcebase, pls rebuild");
                    }
                }
                this.decl.loadProperty(this.getInStream());
                IndexEntry.AddEntry(this);
                this.inCache = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeZIP() {
        try {
            RandomAccessFile randomAccessFile = this.getRAFile();
            synchronized (randomAccessFile) {
                this.id = (int)this.getRAFile().length();
                this.getRAFile().seek(this.id);
                this.decl().storeProperty(this.getOutStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteZIP() {
        if (this.isFixed()) {
            return;
        }
        if (this.id == 0) {
            this.writeZIP();
            return;
        }
        try {
            RandomAccessFile randomAccessFile = this.getRAFile();
            synchronized (randomAccessFile) {
                this.getRAFile().seek(this.id);
                this.decl.rewriteProperty(this.getOutStream());
            }
        }
        catch (Exception e) {
            e.printStackTrace(Tracer.This);
        }
    }

    RandomAccessFile getRAFile() {
        if (this.isFixed()) {
            return fixedFile;
        }
        return dynamicFile;
    }

    DataOutputStream getOutStream() {
        if (this.isFixed()) {
            return fixedFo;
        }
        return fo;
    }

    DataInputStream getInStream() {
        if (this.isFixed()) {
            return fixedFi;
        }
        return fi;
    }

    public boolean isFixed() {
        return (this.fileId & 0xFF000000) != 0;
    }

    public boolean isConstructor() {
        return this.isMethod() && this.fieldName().startsWith(this.className());
    }

    public boolean isInterface() {
        return this.className().endsWith("(interface)");
    }

    public Declaration decl() {
        if (this.decl == null) {
            this.readZIP();
        }
        return this.decl;
    }

    public DocumentPosition docPos() {
        return this.decl().docPos();
    }

    public boolean isSameProtoIgnoreArgs(IndexEntry ie) {
        String a = this.fieldName();
        String b = ie.fieldName();
        String name = null;
        if (this.isMethod()) {
            int cnt1 = a.indexOf(40);
            name = this.fieldName().substring(0, cnt1);
        } else {
            name = this.fieldName();
        }
        return b.startsWith(name + (this.isMethod() ? "(" : "")) || this.isConstructor() && ie.isConstructor();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSameProto(IndexEntry ie) {
        if (!this.isMethod()) {
            return false;
        }
        String a = this.fieldName();
        String b = ie.fieldName();
        int cnt1 = a.indexOf(40);
        String name = this.fieldName().substring(0, cnt1);
        if (!(b.startsWith(name) || this.isConstructor() && ie.isConstructor())) {
            return false;
        }
        int cnt2 = ++cnt1;
        if (ie.isConstructor()) {
            cnt2 = b.indexOf(40) + 1;
        }
        try {
            while (true) {
                char tmp;
                if (a.length() >= cnt1 + 5 && a.charAt(cnt1) == 'f' && a.charAt(cnt1 + 1) == 'i' && a.charAt(cnt1 + 2) == 'n' && a.charAt(cnt1 + 3) == 'a' && a.charAt(cnt1 + 4) == 'l') {
                    cnt1 += 5;
                }
                if (b.length() >= cnt2 + 5 && b.charAt(cnt2) == 'f' && b.charAt(cnt2 + 1) == 'i' && b.charAt(cnt2 + 2) == 'n' && b.charAt(cnt2 + 3) == 'a' && b.charAt(cnt2 + 4) == 'l') {
                    cnt2 += 5;
                }
                while (a.charAt(cnt1) != ' ' && b.charAt(cnt2) == a.charAt(cnt1) && a.charAt(cnt1) != ')' && b.charAt(cnt1) != ')') {
                    ++cnt1;
                    ++cnt2;
                }
                if (b.charAt(cnt2) != a.charAt(cnt1)) {
                    return false;
                }
                if (b.charAt(cnt2) == a.charAt(cnt1) && a.charAt(cnt1) == ')') {
                    return true;
                }
                int kla1 = 0;
                int kla2 = 0;
                while ((tmp = a.charAt(cnt1)) != ',' && tmp != ')') {
                    void var9_10;
                    if (var9_10 == 91) {
                        ++kla1;
                    }
                    ++cnt1;
                }
                while ((tmp = b.charAt(cnt2)) != ',' && b.charAt(cnt2) != ')') {
                    if (tmp == '[') {
                        ++kla2;
                    }
                    ++cnt2;
                }
                if (kla1 != kla2) {
                    return false;
                }
                if (b.charAt(cnt2) == a.charAt(cnt1) && a.charAt(cnt1) == ')') {
                    return true;
                }
                if (b.charAt(cnt2) == ')' || a.charAt(cnt1) == ')') {
                    return false;
                }
                ++cnt1;
                ++cnt2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            NCApplication.Pln(this.toString() + "----" + ie.toString());
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DocumentPosition) {
            return ((DocumentPosition)o).equals(this.docPos());
        }
        if (o instanceof IndexEntry) {
            IndexEntry ie = (IndexEntry)o;
            return this.fieldId == ie.fieldId && this.classId == ie.classId && this.superId == ie.superId && this.fileString().equalsIgnoreCase(((IndexEntry)o).fileString());
        }
        return false;
    }

    public String declString() {
        Declaration decl = this.decl();
        if (decl == null) {
            return "INDEX CORRUPT, PLS RESET AND REBUILD";
        }
        return decl.toString();
    }

    public String fileString() {
        if (this.fileName == null) {
            this.fileName = this.decl().getFile();
        }
        return this.fileName;
    }

    public String getDisplayString() {
        return this.fieldName() + ", " + this.className();
    }

    public String toString() {
        return this.getDisplayString();
    }

    public String realClassName() {
        if (this.isClass()) {
            return this.fieldName();
        }
        return this.className();
    }

    public String realPackage() {
        try {
            String res = null;
            res = this.isClass() && !this.isInterface() ? this.className().substring(1) : this.decl().packageName();
            while (res.startsWith(".")) {
                res = res.substring(1);
            }
            return res;
        }
        catch (Exception ex) {
            return "SourceIndex CORRUPTED. Pls reset+rebuild";
        }
    }

    public boolean isClass() {
        return this.className().startsWith(" ");
    }

    public boolean isClassOrInterface() {
        return this.isClass() || this.isInterface();
    }

    public boolean isMethod() {
        return !this.isClass() && this.fieldName().endsWith(")");
    }

    public boolean isField() {
        return !this.isMethod() && !this.isClass();
    }

    StringBuffer getJarDoc(String id) {
        try {
            ZipFile zf = null;
            Tracer.This.println("jdoc lookup " + id);
            if (id.indexOf("\\java.awt.") >= 0) {
                zf = new ZipFile(new VFile("#staticdata/doc/agent/java.awt.zip"));
            } else if (id.indexOf("\\java.") >= 0) {
                zf = new ZipFile(new VFile("#staticdata/doc/agent/java.misc.zip"));
            } else if (id.indexOf("\\javax.") >= 0) {
                zf = new ZipFile(new VFile("#staticdata/doc/agent/javax.zip"));
            } else {
                return null;
            }
            Tracer.This.println("jdoc lookup file " + zf.getName());
            id = id.replace('\\', '/');
            ZipEntry ze = zf.getEntry(id);
            if (ze != null) {
                InputStream in = zf.getInputStream(ze);
                StringBuffer res = new StringBuffer(1000);
                int c = 0;
                while ((c = in.read()) >= 0) {
                    res.append((char)c);
                }
                in.close();
                return res;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public StringBuffer getJavaDoc() {
        StringBuffer buff = null;
        if (this.isFromClass() || this.isFromJar()) {
            String jarid = this.computeDocId();
            buff = this.getJarDoc(jarid);
            if (buff == null) {
                buff = new StringBuffer(1000);
                buff.append("<b>" + this.decl().toExactString() + "</b><br><br>");
                buff.append("No JavaDoc found, because scanned from " + this.fileString() + ".");
            }
            return buff;
        }
        StringBuffer buff0 = DocumentStream.FindJavaDoc(new File(this.getFileString()), this.getDocumentLine());
        if (buff0.length() == 0) {
            buff0.append("no javadoc found");
        }
        buff = new StringBuffer(buff0.length() + 50);
        buff.append("<b>" + this.decl().toExactString() + "</b> [" + VFile.NameWithExtension(this.fileString()) + "]<br><br>");
        boolean state = false;
        int n = 0;
        while (n < buff0.length()) {
            int c = buff0.charAt(n);
            if (c == 62) {
                int i = n;
                while (i >= 0 && buff0.charAt(i) != '<') {
                    --i;
                }
                if (i >= 0) {
                    int tagL = n - i;
                    char[] tagC = new char[tagL];
                    buff0.getChars(i, i + tagL, tagC, 0);
                    String tag = new String(tagC).toLowerCase();
                    if (tag.startsWith("<hr") || tag.startsWith("<a") || tag.startsWith("</a") || tag.startsWith("<img")) {
                        int nn = 0;
                        while (nn < tag.length()) {
                            buff.setCharAt(buff.length() - nn - 1, ' ');
                            ++nn;
                        }
                        c = 32;
                    }
                } else {
                    buff.append((char)c);
                }
            }
            buff.append((char)c);
            ++n;
        }
        return buff;
    }

    String computeDocId() {
        int i;
        String pack = this.realPackage();
        String clazz = this.realClassName();
        String fieldName = "";
        if ((this.isField() || this.isMethod()) && (i = (fieldName = this.fieldName()).indexOf("(")) >= 0) {
            fieldName = fieldName.substring(0, i);
        }
        return "temp\\jdocsplit\\" + pack + "\\" + clazz + "_" + fieldName;
    }

    public String getArglist() {
        if (this.isMethod()) {
            return ((MethodDescription)this.decl()).argString;
        }
        return null;
    }

    public String getDeclarationString() {
        return this.decl().toString();
    }

    public int getDocumentColumn() {
        return this.decl().getCol();
    }

    public int getDocumentLine() {
        return this.decl().getLine();
    }

    public int getDocumentEndColumn() {
        return this.decl().getColEnd();
    }

    public int getDocumentEndLine() {
        return this.decl().getLineEnd();
    }

    public boolean isFromJar() {
        return this.getFileString().endsWith(")");
    }

    public boolean isFromClass() {
        return this.getFileString().endsWith(".class");
    }

    public String getFileString() {
        return this.fileString();
    }

    public String[] getInterfaces() {
        return ((ClassDescription)this.decl()).interfacesAsArray();
    }

    public String getName() {
        return this.fieldName();
    }

    public String getPackageName() {
        return this.realPackage();
    }

    public String getSuperClass() {
        if (this.isClass() || this.isInterface()) {
            return this.superClass();
        }
        return null;
    }

    public String getType() {
        if (this.isClass() || this.isInterface()) {
            return this.className() + "." + this.fieldName();
        }
        return ((FieldDescription)this.decl()).typeClass;
    }

    public boolean isSameProto(IJEIndexEntry ie) {
        return this.isSameProto((IndexEntry)ie);
    }

    public ArrayList getMethodsAndFields() {
        return SourceBase.This().getMethodsAndFieldsOf(this);
    }

    public ArrayList getFields() {
        ArrayList arr = this.getMethodsAndFields();
        int i = arr.size() - 1;
        while (i >= 0) {
            IndexEntry ie = (IndexEntry)arr.get(i);
            if (!ie.isField()) {
                arr.remove(i);
            }
            --i;
        }
        return arr;
    }

    public ArrayList getMethods() {
        ArrayList arr = this.getMethodsAndFields();
        int i = arr.size() - 1;
        while (i >= 0) {
            IndexEntry ie = (IndexEntry)arr.get(i);
            if (!ie.isMethod()) {
                arr.remove(i);
            }
            --i;
        }
        return arr;
    }

    static {
        CACHESIZE = 6000;
        ExternalCache = new IndexEntry[CACHESIZE];
        ExternalCacheCnt = 0;
        CacheTurnedOn = true;
        WriteQueue = new Vector(200);
    }
}

