/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.ISortFunc;
import JCollections.JArray;
import JCollections.JSet;
import JCollections.JSortedArray;
import JCollections.JSortedSetArray;
import JCollections.JUnsafeArray;
import JCollections.JUnsafeTable;
import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.ISyntaxHighlighter;
import Jxe.TextDocument;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.INCStatus;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import editapp.ClassDescription;
import editapp.Declaration;
import editapp.EditApp;
import editapp.FieldDescription;
import editapp.FileEntry;
import editapp.FileRegistry;
import editapp.IndexEntry;
import editapp.JWJavaParser;
import editapp.MethodDescription;
import editapp.SourceBaseBuilder;
import editapp.stringstore.StringStore;
import java.awt.Point;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import netcomputing.tools.INCExtendedPrintout;

public class SourceBase
implements Serializable,
ISyntaxHighlighter {
    static int MAXLINESEARCH = 150;
    static SourceBase SoleInstance;
    static boolean DONTLOAD;
    static boolean ScanFixed;
    static String fixedZFileName;
    static String fixedZIndexName;
    static String zFileName;
    static String zIndexName;
    static String zFileCopy;
    static String zIndexFileCopy;
    static String zIndexCopy;
    FileRegistry fileReg = new FileRegistry();
    public JSortedArray index;
    public JSortedArray filteredIndex;
    JArray classDefs;
    boolean isChanged = false;
    NCApplication app;
    Vector toExclude = new Vector(10);
    Vector toNoPrivate = new Vector(10);
    static JSet nativeTypes;
    int recurseCount = 0;
    static ISortFunc FieldsSortFunc;
    static ISortFunc PlainFieldsSortFunc;
    JSet classHash = new JSet(1000);
    static JUnsafeTable keyWords;
    static JUnsafeTable keyWordsWithoutTypes;
    SourceBaseBuilder builder = new SourceBaseBuilder();
    static /* synthetic */ Class class$editapp$FieldDescription;
    static /* synthetic */ Class class$editapp$MethodDescription;

    public static void ResetDBNames() {
        fixedZFileName = "#sourcebase/fixedbase40.jdb";
        fixedZIndexName = "#sourcebase/decidx40.idx";
        zFileName = "#sourcebase/decbase40.jdb";
        zIndexName = "#sourcebase/decidx40.idx";
        zFileCopy = "#staticdata/decbase40.jdb";
        zIndexFileCopy = "#staticdata/fixedbase40.jdb";
        zIndexCopy = "#staticdata/decidx40.idx";
    }

    public static String RemovePack(String clazz) {
        int i = clazz.lastIndexOf(46);
        if (i >= 0) {
            clazz = clazz.substring(i + 1, clazz.length());
        }
        return clazz;
    }

    public static SourceBase This() {
        if (SoleInstance == null) {
            SoleInstance = new SourceBase();
        }
        return SoleInstance;
    }

    static void splitClass(String s, String[] clazz_pack) {
        if (s.lastIndexOf(46) == -1) {
            clazz_pack[0] = s;
            clazz_pack[1] = "";
            return;
        }
        clazz_pack[1] = s.substring(0, s.lastIndexOf(46));
        clazz_pack[0] = s.substring(s.lastIndexOf(46) + 1, s.length());
    }

    void testFunc(String[] arr, Object[] tucke) {
    }

    public SourceBase() {
        this.index = new JSortedSetArray(new JArray(20000), JArray.UpperCaseStringSortFunc());
        this.app = EditApp.App;
        this.resetIndex();
    }

    String getDBFile() {
        if (zFileName.startsWith("#")) {
            zFileName = VFile.resolveName(zFileName);
        }
        return zFileName;
    }

    String getFixedDBFile() {
        if (fixedZFileName.startsWith("#")) {
            fixedZFileName = VFile.resolveName(fixedZFileName);
        }
        return fixedZFileName;
    }

    public void addSubTypes(ArrayList li) {
        int i = 0;
        while (i < li.size()) {
            int ii;
            IndexEntry ie = (IndexEntry)li.get(i);
            if (ie.isInterface()) {
                JSortedSetArray arr1 = this.allImplementorsOfInterface(ie);
                ii = 0;
                while (ii < arr1.size()) {
                    if (!li.contains(arr1.at(ii))) {
                        li.add(arr1.at(ii));
                    }
                    ++ii;
                }
            } else if (!"Object".equals(ie.realClassName()) || !"java.lang".equals(ie.realPackage())) {
                JArray arr = this.subclassesOf(ie.realClassName(), ie.realPackage(), false);
                ii = 0;
                while (ii < arr.size()) {
                    if (!li.contains(arr.at(ii))) {
                        li.add(arr.at(ii));
                    }
                    ++ii;
                }
            }
            ++i;
        }
    }

    String getFixedIndexFile() {
        if (zIndexName.startsWith("#")) {
            fixedZIndexName = VFile.resolveName(fixedZIndexName);
        }
        return fixedZIndexName;
    }

    public String getIndexFile() {
        if (zIndexName.startsWith("#")) {
            zIndexName = VFile.resolveName(zIndexName);
        }
        return zIndexName;
    }

    void save(String fileName) {
        this.hardTerminate();
        this.fileReg.save(fileName, this.index.getBase());
        this.isChanged = false;
    }

    public void load(String fileName) {
        Object o = null;
        if (!new File(fileName).exists() || DONTLOAD) {
            return;
        }
        this.fileReg.load(fileName, this.index.getBase());
        Tracer.This.println("[SB LOADED]");
    }

    JSortedSetArray getKnownPackages() {
        return this.fileReg.getKnownPackages();
    }

    JArray knownClassesAsArray() {
        JArray v = new JArray(this.classDefs.size());
        int n = 0;
        while (n < this.classDefs.size()) {
            IndexEntry ie = (IndexEntry)this.classDefs.at(n);
            if (!ie.isInterface()) {
                v.add(ie.realClassName());
            } else {
                v.add(ie.realClassName() + " (interface)");
            }
            ++n;
        }
        return v;
    }

    public JArray knownClassAndInterfacesAsArray() {
        JArray v = new JArray(this.classDefs.size());
        int n = 0;
        while (n < this.classDefs.size()) {
            IndexEntry ie = (IndexEntry)this.classDefs.at(n);
            if (ie.isInterface() || ie.isClass()) {
                v.add(ie.realClassName());
            }
            ++n;
        }
        return v;
    }

    public JArray getClassDefs() {
        return this.classDefs;
    }

    public Vector allMainClasses() {
        Vector<String> result = new Vector<String>(30);
        JSortedArray index = this.filteredIndex();
        int idx = index.indexOf("main(String ");
        while (index.at(idx).toString().toLowerCase().startsWith("main(string ")) {
            IndexEntry ie = (IndexEntry)index.at(idx);
            String decl = ie.declString();
            if (decl.startsWith("public static void main(String ") && (decl.startsWith("public static void main(String [ ] ") || decl.indexOf("[ ])") >= 0 || decl.indexOf("[])") >= 0)) {
                result.addElement(ie.realPackage() + "." + ie.realClassName());
            }
            ++idx;
        }
        return result;
    }

    JArray knownInterfacesAsArray() {
        JArray v = new JArray(this.classDefs.size());
        int n = 0;
        while (n < this.classDefs.size()) {
            IndexEntry ie = (IndexEntry)this.classDefs.at(n);
            if (ie.isInterface()) {
                v.add(ie.realClassName());
            }
            ++n;
        }
        return v;
    }

    Vector knownClasses() {
        Vector<String> v = new Vector<String>(this.classDefs.size());
        int n = 0;
        while (n < this.classDefs.size()) {
            IndexEntry ie = (IndexEntry)this.classDefs.at(n);
            if (!ie.isInterface()) {
                v.addElement(ie.realClassName());
            } else {
                v.addElement(ie.realClassName() + " (interface)");
            }
            ++n;
        }
        return v;
    }

    Vector knownInterfaces() {
        Vector<String> v = new Vector<String>(this.classDefs.size());
        int n = 0;
        while (n < this.classDefs.size()) {
            IndexEntry ie = (IndexEntry)this.classDefs.at(n);
            if (ie.isInterface()) {
                v.addElement(ie.realClassName());
            }
            ++n;
        }
        return v;
    }

    public Object actionSleep(Object arg, Object sender) {
        EditApp.UpdateEvent(null);
        return null;
    }

    public boolean isMethodOrFieldIdentifier(String s) {
        return this.isMethodIdentifier(s) || this.isInstanceVarIdentifier(s);
    }

    public boolean isMethodIdentifier(String s) {
        if (s == null) {
            return false;
        }
        int i = this.filteredIndex().indexOf(s + "(");
        if (i < 0 || i >= this.filteredIndex().size()) {
            return false;
        }
        IndexEntry ie = (IndexEntry)this.filteredIndex().at(i);
        if (ie != null && ie.isMethod() && !ie.isConstructor() && ie.getDisplayString().toLowerCase().startsWith(s.toLowerCase() + "(")) {
            return !ie.isConstructor();
        }
        return false;
    }

    public boolean isInstanceVarIdentifier(String s) {
        if (s == null) {
            return false;
        }
        int i = this.filteredIndex().indexOf(s + ",");
        if (i < 0 || i >= this.filteredIndex().size()) {
            return false;
        }
        IndexEntry ie = (IndexEntry)this.filteredIndex().at(i);
        return ie != null && ie.isField() && ie.getDisplayString().toLowerCase().startsWith(s.toLowerCase() + ",");
    }

    void scanImports(TextDocument doc, String file2) {
        FileEntry fe = this.fileReg.get(file2);
        if (fe == null) {
            return;
        }
        if (file2.endsWith(".java")) {
            JSet imps = new JSet(20);
            String s = DocumentStream.ScanImports(doc, imps);
            if (s != null) {
                fe.setPackage(s);
            }
            fe.setImports(imps);
        } else if (file2.endsWith(".jsp")) {
            JSet imps = fe.importsAsSet();
            imps.add("javax.servlet");
            imps.add("javax.servlet.http");
            imps.add("javax.servlet.jsp");
            imps.add("org.apache.jasper.runtime");
            fe.setPackage("org.apache.jsp");
            fe.setImports(imps);
        }
    }

    void registerImport(String file2, String pack) {
        FileEntry fe = this.fileReg.get(file2);
        if (fe != null) {
            fe.addImport(pack);
        }
    }

    public boolean shouldUpdate(File f) {
        return this.builder.shouldUpdate(f);
    }

    boolean matches(Vector arr, String what) {
        int n = 0;
        while (n < arr.size()) {
            if (what.startsWith(arr.elementAt(n).toString())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void updateExcludes() {
        this.toExclude = EditApp.App.getToExclude();
        this.toNoPrivate = EditApp.App.getToScanNoPrivate();
    }

    public void changeClassName(File f) {
        try {
            EditFrame fr = EditApp.App.getEditFrameIfPresent(f);
            if (fr != null) {
                fr.save();
            }
            this.update(f.getAbsolutePath());
            String def = f.getName();
            JArray arr = this.classDefinitionsIn(f.getAbsolutePath());
            int n = 0;
            while (arr != null && n < arr.size()) {
                IndexEntry ie = (IndexEntry)arr.at(n);
                ClassDescription d = (ClassDescription)ie.decl();
                if ((d.modifier & 1) != 0) {
                    def = d.className + ".java";
                    break;
                }
                ++n;
            }
            String res = Confirm.GetText(EditApp.App.getMainWindow(), null, "Rename File", new String[]{"Please enter the new name"}, def);
            if (res != null) {
                File newF = new File(f.getParent(), res);
                f.renameTo(newF);
                if (fr != null) {
                    fr.load(newF);
                    fr.getDocument().repaint();
                }
                this.update(newF.getAbsolutePath());
                EditApp.App.jol.updateAllNodesContents();
            }
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Declaration d) {
        FileRegistry.This.resetKnownPack();
        SourceBaseBuilder sourceBaseBuilder = this.builder;
        synchronized (sourceBaseBuilder) {
            this.isChanged = true;
            IndexEntry ie = null;
            if ((d.modifier & 0x101) == 0) {
                d.modifier |= 2;
            }
            if (this.matches(this.toExclude, d.pack)) {
                this.fileReg.remove(d.getFile());
                return;
            }
            if ((d.modifier & 2) != 0 && this.matches(this.toNoPrivate, d.pack)) {
                return;
            }
            if (d instanceof ClassDescription) {
                ie = new IndexEntry(d.className, " " + d.pack + (((ClassDescription)d).isInterface() ? " (interface)" : ""), d);
                this.fileReg.get(d.getFile()).add(ie);
                String clzName = ie.fieldName();
                this.classDefs.add(ie);
                if (clzName.indexOf("$") >= 0) {
                    String clz = clzName.substring(clzName.lastIndexOf(36) + 1);
                    this.classHash.add(clz);
                } else {
                    this.classHash.add(clzName);
                }
            } else if (d instanceof MethodDescription) {
                ie = new IndexEntry(((MethodDescription)d).name + "(" + ((MethodDescription)d).argString + ")", d.className, d);
                this.fileReg.get(d.getFile()).add(ie);
            } else if (d instanceof FieldDescription) {
                ie = new IndexEntry(((FieldDescription)d).name, d.className, d);
                this.fileReg.get(d.getFile()).add(ie);
            }
            this.index.add(ie);
            if (this.filteredIndex != null) {
                this.filteredIndex.add(ie);
            }
            ie.freeMem();
        }
    }

    Vector buildLocalTypeMap(TextDocument doc, int x, int y, String exclude, JUnsafeTable result) {
        Object res = null;
        TextDocument tmp = new TextDocument(doc.getModifiedLinesSinceLastSave());
        if (tmp.size() > 0) {
            this.buildLocalTypeMap(tmp, 0, Math.max(tmp.size() - MAXLINESEARCH, 0), exclude, result, true, true);
        }
        this.buildLocalTypeMap(doc, x, y, exclude, result, true, false);
        return this.buildLocalTypeMap(doc, x, y, exclude, result, false, false);
    }

    Vector buildLocalTypeMap(TextDocument doc, int x, int y, String exclude, JUnsafeTable result, boolean fuzzy, boolean treatCommentsAsCode) {
        int sureCount = 0;
        int ncount = 0;
        if (fuzzy) {
            try {
                y = Math.max(y, 0);
                DocumentStream ds = new DocumentStream(doc, 0, y);
                String next = null;
                String act = null;
                String type = null;
                StringBuffer buff = new StringBuffer(100);
                boolean wasArray = false;
                while (sureCount < doc.size() && ncount < 200) {
                    ++ncount;
                    buff.setLength(0);
                    int prevLine = ds.posY();
                    ds.readJavaToken(buff, treatCommentsAsCode);
                    if (ds.posY() != prevLine) {
                        ++sureCount;
                    }
                    act = next;
                    next = buff.toString();
                    if (act == null || act.length() != 0) {
                        if (act != null && (act.charAt(0) == ';' || act.charAt(0) == '{')) {
                            type = null;
                        }
                        if (next.length() > 0 && Character.isJavaIdentifierStart(next.charAt(0)) && act != null && (this.classHash.contains(act) || nativeTypes.contains(act))) {
                            type = act;
                            wasArray = false;
                            int tmp = type.indexOf(91);
                            if (tmp < 0 || type.indexOf(93) != tmp + 1) continue;
                            act = act + "[]";
                            type = type.substring(0, type.indexOf(91));
                            wasArray = true;
                            continue;
                        }
                        if (act == null || type == null || act.equals(exclude) || keyWordsWithoutTypes.get(act) != null || result.get(act) != null || !Character.isJavaIdentifierStart(act.charAt(0)) || next.charAt(0) != '=' && next.charAt(0) != ';' && next.charAt(0) != ',' && next.charAt(0) != '(' && (next.charAt(0) != ')' || result.get(act) != null)) continue;
                        result.put(act, type);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ncount > 400) {
                throw new RuntimeException("Notausgang");
            }
        } else {
            try {
                String s;
                int[] err;
                DocumentStream ds = new DocumentStream(doc, doc.cX(), doc.cY());
                Point p = null;
                p = ds.searchFunctionHeader();
                boolean addClass = true;
                if (p == null) {
                    Tracer.This.println("********** kein fundefstart gefunden *****************");
                    p = new Point(0, 0);
                    addClass = false;
                }
                Vector res = null;
                if (p != null && (err = JWJavaParser.GuessErrorRange(res = JWJavaParser.parseFunction(s = doc.createCopy(p.y, doc.cY(), p.x, doc.cX()).toString(), result, addClass))) != null) {
                    err[1] = err[1] + (p.y - 1);
                    err[3] = err[3] + (p.y - 1);
                    if (err[3] < doc.cY() || err[3] == doc.cY() && err[2] < doc.cX() - 2) {
                        EditApp.App.markErrorInDoc(doc.getFile(), err);
                    }
                }
                return res;
            }
            catch (Exception e) {
                e.printStackTrace(Tracer.This);
                return this.buildLocalTypeMap(doc, x, y, exclude, result, true, true);
            }
        }
        return null;
    }

    JSet classNamesForClass(File definedIn, String clazz) {
        JArray cls = new JArray(1);
        IndexEntry ie = this.getPossibleClassDefFor(clazz, definedIn.getAbsolutePath());
        if (ie != null) {
            cls.add(ie);
            return this.classNamesFor(cls);
        }
        return null;
    }

    public String possibleTypeOf(String var, File f) {
        String toSearch = (var + ", ").toUpperCase();
        String file2 = f.getAbsolutePath().toUpperCase();
        IndexEntry ie = null;
        int i = this.filteredIndex().indexOf(toSearch);
        while (i >= 0 && i < this.filteredIndex().size() && (ie = (IndexEntry)this.filteredIndex().at(i)).getDisplayString().toUpperCase().startsWith(toSearch)) {
            if (ie.fileString().toUpperCase().equals(file2)) {
                return ((FieldDescription)ie.decl()).typeClass;
            }
            ++i;
        }
        return null;
    }

    public IndexEntry getPossibleClassDefinitionOf(String var, File f) {
        String toSearch = (var + ",  ").toUpperCase();
        String file2 = f.getAbsolutePath().toUpperCase();
        IndexEntry ie = null;
        int i = this.filteredIndex().indexOf(toSearch);
        while (i >= 0 && i < this.filteredIndex().size() && (ie = (IndexEntry)this.filteredIndex().at(i)).getDisplayString().toUpperCase().startsWith(toSearch)) {
            if (ie.fileString().toUpperCase().equals(file2)) {
                return ie;
            }
            ++i;
        }
        return null;
    }

    public IndexEntry getPossibleDefinitionOf(String var, File f) {
        String toSearch = (var + ", ").toUpperCase();
        String file2 = f.getAbsolutePath().toUpperCase();
        IndexEntry ie = null;
        int i = this.filteredIndex().indexOf(toSearch);
        while (i >= 0 && i < this.filteredIndex().size() && (ie = (IndexEntry)this.filteredIndex().at(i)).getDisplayString().toUpperCase().startsWith(toSearch)) {
            if (ie.fileString().toUpperCase().equals(file2)) {
                return ie;
            }
            ++i;
        }
        return null;
    }

    JSet classNamesFor(JArray cls) {
        JSet all = null;
        SourceBase sb = SourceBase.This();
        int n = 0;
        while (n < cls.size()) {
            IndexEntry ie;
            IndexEntry[] line;
            if (all == null) {
                all = new JSet(20);
            }
            if ((line = sb.deriveLineFor(ie = (IndexEntry)cls.at(n))) != null) {
                int nn = 0;
                while (nn < line.length) {
                    all.add(line[nn].realClassName());
                    ++nn;
                }
            }
            ++n;
        }
        return all;
    }

    String[] completionsFor(String _search, String fileName, JSet definedIn, Enumeration additionalStrings, boolean checkKeyWords) {
        JSet result = new JSet(20);
        JSet imps = null;
        FileEntry f = this.fileReg.get(fileName);
        if (f != null) {
            imps = f.importsAsSet();
        }
        String dp = fileName;
        dp = dp.substring(0, dp.lastIndexOf(File.separator));
        dp = dp.substring(dp.lastIndexOf(File.separator), dp.length());
        f.addImport(dp);
        int i = this.filteredIndex().indexOf(_search.toUpperCase());
        String toAdd = ((BasicListItem)this.filteredIndex().at(i)).getDisplayString().toUpperCase();
        String search = _search.toUpperCase();
        int n = 0;
        while (result.size() < 21 && n + i < this.filteredIndex().size() && n < 2000 && toAdd.startsWith(search)) {
            IndexEntry ie = (IndexEntry)this.filteredIndex().at(i + n);
            if ((ie.isClassOrInterface() || definedIn == null || definedIn.contains(ie.className())) && ie.getDisplayString().startsWith(_search) && (ie.realPackage().equals(f.packageName()) || definedIn != null && definedIn.contains(ie.realClassName()) || imps.find(ie.realPackage()) != null)) {
                toAdd = toAdd.indexOf("(") > 0 ? toAdd.substring(0, toAdd.indexOf("(")) : toAdd;
                toAdd = toAdd.indexOf(",") > 0 ? toAdd.substring(0, toAdd.indexOf(",")) : toAdd;
                toAdd = toAdd.indexOf(" ") > 0 ? toAdd.substring(0, toAdd.indexOf(" ")) : toAdd;
                result.add(this.filteredIndex().at(i + n).toString().substring(0, toAdd.length()));
            }
            toAdd = ((BasicListItem)this.filteredIndex().at(i + n + 1)).getDisplayString().toUpperCase();
            ++n;
        }
        if (checkKeyWords) {
            Enumeration en = keyWords.keys();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                if (!s.startsWith(_search) || s.endsWith("(")) continue;
                result.add(s);
            }
        }
        if (additionalStrings != null) {
            while (additionalStrings.hasMoreElements()) {
                String s = (String)additionalStrings.nextElement();
                if (!s.startsWith(_search) || s.endsWith("(")) continue;
                result.add(s);
            }
        }
        if (result.size() < 1) {
            return null;
        }
        String[] sr = new String[result.size() + 1];
        Enumeration e = result.enumerate();
        int n2 = 0;
        String unique = null;
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (unique == null) {
                unique = s;
            }
            while (!s.toUpperCase().startsWith(unique.toUpperCase())) {
                unique = unique.substring(0, unique.length() - 1);
            }
            sr[++n2] = s;
        }
        sr[0] = unique;
        return sr;
    }

    IndexEntry[] possibleDefinitions(String _search, String fileName, JSet jsPossibleClasses0) {
        JSet result = new JSet(20);
        JSet imps = null;
        FileEntry f = this.fileReg.get(fileName);
        if (f != null) {
            imps = f.importsAsSet();
            if (fileName != null) {
                String dp = fileName;
                dp = dp.substring(0, dp.lastIndexOf(File.separator));
                dp = dp.substring(dp.lastIndexOf(File.separator), dp.length());
                f.addImport(dp);
            }
        }
        JSet jsPossibleClasses = null;
        if (jsPossibleClasses0 != null) {
            IndexEntry[] possibleClasses = null;
            Enumeration predClasses = jsPossibleClasses0.enumerate();
            jsPossibleClasses = new JSet(30);
            while (predClasses.hasMoreElements()) {
                IndexEntry calledOn = null;
                String cl = predClasses.nextElement().toString().trim();
                calledOn = this.getPossibleClassDefFor(cl, fileName, false);
                if (calledOn == null) {
                    calledOn = this.getPossibleClassDefFor(cl, null, false);
                }
                if (calledOn == null && fileName != null) {
                    calledOn = this.findInnerClass(cl, fileName);
                }
                if (calledOn != null) {
                    possibleClasses = this.deriveLineFor(calledOn);
                }
                if (possibleClasses == null) continue;
                int n = 0;
                while (n < possibleClasses.length) {
                    jsPossibleClasses.add(possibleClasses[n].realClassName());
                    ++n;
                }
            }
        }
        int i = this.filteredIndex().indexOf(_search.toUpperCase());
        String toAdd = ((BasicListItem)this.filteredIndex().at(i)).getDisplayString().toUpperCase();
        String search = _search.toUpperCase();
        int n = 0;
        while (result.size() < 11 && toAdd.startsWith(search)) {
            if (((IndexEntry)this.filteredIndex().at(i + n)).getDisplayString().startsWith(_search)) {
                IndexEntry ie = (IndexEntry)this.filteredIndex().at(i + n);
                if (!(f != null && !ie.realPackage().equals(f.packageName()) && imps.find(ie.realPackage()) == null || jsPossibleClasses != null && jsPossibleClasses.find(ie.realClassName()) == null)) {
                    toAdd = toAdd.indexOf("(") > 0 ? toAdd.substring(0, toAdd.indexOf("(")) : toAdd;
                    toAdd = toAdd.indexOf(",") > 0 ? toAdd.substring(0, toAdd.indexOf(",")) : toAdd;
                    toAdd = toAdd.indexOf(" ") > 0 ? toAdd.substring(0, toAdd.indexOf(" ")) : toAdd;
                    result.add(this.filteredIndex().at(i + n));
                }
            }
            toAdd = ((BasicListItem)this.filteredIndex().at(i + n + 1)).getDisplayString().toUpperCase();
            ++n;
        }
        if (result.size() < 1) {
            return null;
        }
        IndexEntry[] sr = new IndexEntry[result.size() + 1];
        Enumeration e = result.enumerate();
        int n2 = 0;
        while (e.hasMoreElements()) {
            sr[n2++] = (IndexEntry)e.nextElement();
        }
        return sr;
    }

    IndexEntry findInnerClass(String cl, String fileName) {
        IndexEntry[] outerLine;
        IndexEntry calledOn = null;
        String outerName = VFile.NameWithoutExtension(fileName);
        if (outerName.equals(cl)) {
            return null;
        }
        IndexEntry outerClazz = this.getPossibleClassDefFor(outerName, fileName, false);
        if (outerClazz != null && (outerLine = this.deriveLineFor(outerClazz)) != null) {
            int i = 0;
            while (i < outerLine.length) {
                calledOn = this.getPossibleClassDefFor(outerLine[i].fieldName() + "$" + cl, null, false);
                if (calledOn != null) break;
                ++i;
            }
        }
        return calledOn;
    }

    public ArrayList findPossiblePackages(String clazzName) {
        ArrayList<String> res = new ArrayList<String>(2);
        String toFind = clazzName + ",  ";
        int i = this.filteredIndex().indexOf(toFind);
        while (i >= 0 && i < this.filteredIndex().size() && this.filteredIndex().at(i).toString().startsWith(toFind)) {
            res.add(((IndexEntry)this.filteredIndex().at(i)).realPackage());
            ++i;
        }
        return res;
    }

    Vector indexAsVector() {
        return ((JArray)this.index.getBase()).getVector();
    }

    public Vector filteredIndexAsVector() {
        return ((JArray)this.filteredIndex().getBase()).getVector();
    }

    void checkIndex() {
        Tracer.This.println("checking Index");
        JSortedArray id = this.index;
        ISortFunc f = JArray.UpperCaseStringSortFunc();
        int n = 0;
        while (n < id.size() - 1) {
            if (!f.isGreaterOrEqual(id.at(n + 1).toString(), id.at(n).toString())) {
                Confirm.ModalMsg(EditApp.App.mainFrame, "INDEX INVALID", new String[]{id.at(n).toString(), id.at(n + 1).toString()});
            }
            ++n;
        }
        Tracer.This.println("..finished checking Index");
    }

    public synchronized JSortedArray filteredIndex() {
        if (this.filteredIndex == null) {
            this.filteredIndex = new JSortedSetArray(new JArray(5000), JArray.UpperCaseStringSortFunc());
            this.fileReg.computeFilteredIndex(this.filteredIndex.getBase());
        }
        return this.filteredIndex;
    }

    JSortedArray index() {
        return this.index;
    }

    JArray subclassesOf(String cl, String pack, boolean filtered) {
        JArray result = new JArray();
        JArray ibase = this.classDefs;
        JSet js = null;
        String packCl = pack + "." + cl;
        int n = 0;
        while (n < ibase.size()) {
            IndexEntry ie = (IndexEntry)ibase.at(n);
            if ("APIBase".equals(ie.superClass())) {
                js = this.importsFor(ie.fileString());
            }
            try {
                String tmp = null;
                if ((cl.equals("Object") && ((tmp = ie.superClass()).equals("_") || tmp.equals("java.lang.Object")) || ie.superClass().equals(cl) || ie.superClass().equals(packCl)) && (cl.equals("Object") || ie.superClass().indexOf(46) >= 0 || (js = this.importsFor(ie.fileString())) != null && (js.find(pack) != null || js.find(packCl) != null)) && (!filtered || this.filteredIndex().indexOfByEqualness(ie) >= 0)) {
                    result.add(ie);
                }
            }
            catch (Exception e) {
                NCApplication.Pln("cl " + cl + "  ie " + ie + "  superClass " + ie.superClass());
            }
            ++n;
        }
        return result;
    }

    static ISortFunc FieldsSortFunc() {
        if (FieldsSortFunc == null) {
            FieldsSortFunc = new ISortFunc(){

                public boolean isGreaterOrEqual(Object g, Object k) {
                    IndexEntry gg = (IndexEntry)g;
                    IndexEntry kk = (IndexEntry)k;
                    int tmp = (gg.isField() ? 0 : 16) + (gg.isConstructor() ? 0 : 8) + (gg.decl().hasAllModifiers(128) ? 0 : 32) + (gg.fieldName().compareTo(kk.fieldName()) >= 0 ? 4 : 0);
                    int tmp1 = (kk.isField() ? 0 : 16) + (kk.isConstructor() ? 0 : 8) + (kk.decl().hasAllModifiers(128) ? 0 : 32) + ((tmp & 4) == 0 ? 4 : 0);
                    return tmp >= tmp1;
                }
            };
        }
        return FieldsSortFunc;
    }

    static ISortFunc PlainFieldsSortFunc() {
        if (PlainFieldsSortFunc == null) {
            PlainFieldsSortFunc = new ISortFunc(){

                public boolean isGreaterOrEqual(Object g, Object k) {
                    IndexEntry gg = (IndexEntry)g;
                    IndexEntry kk = (IndexEntry)k;
                    return gg.getName().trim().compareTo(kk.getName().trim()) >= 0;
                }
            };
        }
        return PlainFieldsSortFunc;
    }

    void allinterf(IndexEntry ie, JArray res) {
        if (ie == null || !ie.isInterface()) {
            return;
        }
        res.add(ie);
        String[] s = ie.getInterfaces();
        String fi = ie.getFileString();
        int n = 0;
        while (n < s.length) {
            IndexEntry iea = this.getPossibleClassDefFor(s[n], fi, false);
            if (iea != null) {
                this.allinterf(iea, res);
            }
            ++n;
        }
    }

    public JArray allMethodsAndFieldsOf(String cl, String file2, int filter) {
        return this.allMethodsAndFieldsOf(cl, file2, filter, false);
    }

    JArray allMethodsAndFieldsOf(String cl, String file2, int filter, boolean plain) {
        return this.allMethodsAndFieldsOf(cl, file2, filter, false, true);
    }

    public JArray allMethodsAndFieldsOf(String cl, String file2, int filter, boolean plain, boolean sort) {
        IndexEntry ie = this.getPossibleClassDefFor(cl, file2);
        if (ie == null) {
            return new JArray(0);
        }
        JSet result = new JSet(150);
        if (ie.isInterface()) {
            JArray alIn = new JArray(10);
            this.allinterf(ie, alIn);
            int n = 0;
            while (n < alIn.size()) {
                result.addAll(this.methodsAndFieldsOf(((IndexEntry)alIn.at(n)).realClassName(), ((IndexEntry)alIn.at(n)).realPackage(), filter));
                ++n;
            }
        } else {
            IndexEntry[] aie = this.deriveLineFor(ie);
            JSet interfSet = new JSet(10);
            JArray temp = new JArray(20);
            int n = 0;
            while (n < aie.length) {
                String[] interf = aie[n].getInterfaces();
                int nn = 0;
                while (interf != null && nn < interf.length) {
                    IndexEntry ieInt = this.getPossibleClassDefFor(interf[nn], aie[n].getFileString());
                    if (ieInt != null) {
                        interfSet.add(ie);
                        temp.setSize(0);
                        this.allinterf(ieInt, temp);
                        interfSet.addAll(temp);
                    }
                    ++nn;
                }
                result.addAll(this.methodsAndFieldsOf(aie[n].realClassName(), aie[n].realPackage(), filter));
                ++n;
            }
            Enumeration en = interfSet.enumerate();
            while (en.hasMoreElements()) {
                IndexEntry act = (IndexEntry)en.nextElement();
                result.addAll(this.methodsAndFieldsOf(act.realClassName(), act.realPackage(), filter));
            }
        }
        JArray res = result.asJArray();
        if (sort) {
            ISortFunc sf = plain ? SourceBase.PlainFieldsSortFunc() : SourceBase.FieldsSortFunc();
            JArray.QuickSort(res, sf);
        }
        return res;
    }

    JArray sortedMethodsAndFieldsOf(String cl, String pack, int filter) {
        JArray v = this.methodsAndFieldsOf(cl, pack, filter);
        JArray.QuickSort(v, SourceBase.FieldsSortFunc());
        return v;
    }

    public ArrayList getMethodsAndFieldsOf(IndexEntry clazzEntry) {
        ArrayList<IndexEntry> result = new ArrayList<IndexEntry>(27);
        JArray ibase = this.definitionsInFile(clazzEntry.fileString());
        String cl = clazzEntry.realClassName();
        String pack = clazzEntry.realPackage();
        int n = 0;
        while (n < ibase.size()) {
            IndexEntry ie = (IndexEntry)ibase.at(n);
            if (ie.className() != null && !ie.isClassOrInterface() && ie.className().equals(cl) && ie.realPackage().equals(pack)) {
                result.add(ie);
            }
            ++n;
        }
        return result;
    }

    public JArray methodsAndFieldsOf(String cl, String pack, int filter) {
        IndexEntry tmp;
        JArray result = new JArray();
        if (pack.endsWith("(interface)")) {
            pack = pack.substring(0, pack.length() - 12);
        }
        JArray ibase = (tmp = this.getClassDef(cl, pack)) != null ? this.definitionsInFile(tmp.fileString()) : (JArray)this.filteredIndex().getBase();
        boolean useFilter = filter != 0;
        int pType = 259;
        int n = 0;
        while (n < ibase.size()) {
            IndexEntry ie = (IndexEntry)ibase.at(n);
            if (ie.className() != null && !ie.isClassOrInterface() && ie.className().equals(cl) && (!useFilter || ie.decl().getClass() == (class$editapp$FieldDescription == null ? SourceBase.class$("editapp.FieldDescription") : class$editapp$FieldDescription) && (filter & 0x800) == 0 || ie.decl().getClass() == (class$editapp$MethodDescription == null ? SourceBase.class$("editapp.MethodDescription") : class$editapp$MethodDescription) && (filter & 0x400) == 0) && (this.builder.getPackageName() == null || ie.realPackage().equals(pack)) && (useFilter && !ie.decl().hasAnyModifiers(filter & pType) && ((filter & 0x80) == 0 && ie.decl().hasAllModifiers(128) || (filter & 0x200) == 0 && !ie.decl().hasAllModifiers(128)) || !useFilter)) {
                result.add(ie);
            }
            ++n;
        }
        return result;
    }

    public ArrayList deriveLineAndInterfacesFor(IndexEntry classIE) {
        ArrayList<IndexEntry> list = new ArrayList<IndexEntry>(7);
        IndexEntry[] ies = this.deriveLineFor(classIE);
        if (ies == null) {
            return null;
        }
        if (classIE.isInterface()) {
            int i = 0;
            while (i < ies.length) {
                list.add(ies[i]);
                ++i;
            }
            return list;
        }
        int i = 0;
        while (i < ies.length) {
            IndexEntry curIE = ies[i];
            list.add(curIE);
            this.addInterfaces(classIE, curIE, list);
            ++i;
        }
        return list;
    }

    void addInterfaces(IndexEntry classIE, IndexEntry curIE, ArrayList list) {
        try {
            JSet interf = ((ClassDescription)curIE.decl()).interfaceSet();
            Enumeration en = interf.enumerate();
            String fi = classIE.fileString();
            while (en.hasMoreElements()) {
                int idx;
                IndexEntry ie = this.getPossibleClassDefFor((String)en.nextElement(), fi);
                if (ie == null || (idx = list.indexOf(ie)) >= 0) continue;
                list.add(ie);
                this.addInterfaces(curIE, ie, list);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public IndexEntry[] deriveLineFor(IndexEntry classIE) {
        IndexEntry tmie;
        if (!classIE.isClass() && !classIE.isInterface()) {
            return null;
        }
        if (classIE.isInterface()) {
            JArray res = new JArray(20);
            this.allinterf(classIE, res);
            Tracer.This.println("deriveLine interface result for " + classIE.realClassName() + " " + res.size());
            IndexEntry[] result = new IndexEntry[res.size()];
            int n = 0;
            while (n < result.length) {
                result[n] = (IndexEntry)res.at(n);
                ++n;
            }
            return result;
        }
        Vector<IndexEntry> v = new Vector<IndexEntry>(10);
        v.addElement(classIE);
        IndexEntry ie = classIE;
        IndexEntry ieTmp = null;
        int endless = 20;
        while (!(endless-- <= 0 || ieTmp != null && ieTmp.realClassName().equals("Object") && ieTmp.realPackage().equals("java.lang") || (ieTmp = this.getPossibleClassDefFor(ie.superClass(), ie.fileString(), false)) == null || !ieTmp.fieldName().startsWith(ie.superClass()) && ie.superClass().indexOf(".") < 0)) {
            ie = ieTmp;
            if (ie == null) continue;
            v.addElement(ie);
        }
        if (!((IndexEntry)v.lastElement()).realClassName().equals("Object") && (tmie = this.getClassDef("Object", "java.lang")) != null) {
            v.addElement(tmie);
        }
        IndexEntry[] result = new IndexEntry[v.size()];
        int n = 0;
        while (n < v.size()) {
            result[n] = (IndexEntry)v.elementAt(n);
            ++n;
        }
        return result;
    }

    JSet importsFor(String file2) {
        FileEntry f = this.fileReg.get(file2);
        if (f != null) {
            return f.importsAsSet();
        }
        return null;
    }

    JSet importsFor(String clazz, String pack) {
        String s = clazz + ",  " + pack;
        IndexEntry ie = (IndexEntry)this.filteredIndex().find(s);
        if (ie.getDisplayString().equals(s)) {
            return this.importsFor(ie.fileString());
        }
        return null;
    }

    public IndexEntry getPossibleClassDefFor(String clazz, String file2) {
        return this.getPossibleClassDefFor(clazz, file2, true);
    }

    private IndexEntry getPossibleClassDefFor(String clazz, String file2, boolean checkForInner) {
        FileEntry f;
        if (this.filteredIndex().size() == 0) {
            return null;
        }
        if ((clazz = clazz.trim()).equals("_")) {
            return this.getClassDef("Object", "java.lang");
        }
        if (clazz.endsWith("(interface)")) {
            clazz = clazz.substring(0, clazz.length() - 12);
        }
        if (file2 == null) {
            String toSearch = clazz + ",  ";
            int i = this.filteredIndex().indexOf(toSearch);
            if (!((IndexEntry)this.filteredIndex().at(i)).getDisplayString().startsWith(toSearch)) {
                Tracer.This.println("   1");
                return null;
            }
            return (IndexEntry)this.filteredIndex().at(i);
        }
        if (clazz.indexOf(".") >= 0) {
            String[] clp = new String[]{null, null};
            SourceBase.splitClass(clazz, clp);
            String tmp = clp[0] + ",  " + clp[1];
            int i = this.filteredIndex().indexOf(tmp);
            if (i < this.filteredIndex().size() && i >= 0 && ((IndexEntry)this.filteredIndex().at(i)).getDisplayString().startsWith(tmp)) {
                return (IndexEntry)this.filteredIndex().at(i);
            }
        }
        if ((f = this.fileReg.get(file2)) == null) {
            return null;
        }
        IndexEntry result = null;
        String toSearch = clazz + ",  " + f.packageName();
        int i = this.filteredIndex().indexOf(toSearch);
        if (i < this.filteredIndex().size()) {
            result = (IndexEntry)this.filteredIndex().at(i);
        }
        if (result != null && result.isClassOrInterface() && result.getDisplayString().equals(toSearch)) {
            return result;
        }
        toSearch = clazz + ",  ";
        i = this.filteredIndex().indexOf(toSearch);
        while (i < this.filteredIndex().size() && ((IndexEntry)this.filteredIndex().at(i)).getDisplayString().startsWith(toSearch)) {
            IndexEntry candidate = (IndexEntry)this.filteredIndex().at(i);
            if (f.importsContain(candidate.realPackage())) {
                return candidate;
            }
            ++i;
        }
        if (file2 != null && checkForInner) {
            return this.findInnerClass(clazz, file2);
        }
        if (file2 != null) {
            return this.getPossibleClassDefFor(clazz, null, checkForInner);
        }
        return null;
    }

    public JSortedSetArray allImplementorsOfInterface(IndexEntry ie) {
        JSortedSetArray result = new JSortedSetArray(new JUnsafeArray(100), JArray.UpperCaseStringSortFunc());
        this.allImplementorsOfInterface(ie, result);
        return result;
    }

    JSortedSetArray allImplementorsOfInterface(IndexEntry ie, JSortedSetArray result) {
        if (!ie.isInterface()) {
            return result;
        }
        String className = ie.realClassName();
        String toSearch1 = ie.realPackage() + "." + className;
        int n = 0;
        while (n < this.classDefs.size()) {
            IndexEntry atie;
            JSet set;
            if (this.filteredIndex().indexOfByEqualness(this.classDefs.at(n)) >= 0 && ((set = ((ClassDescription)(atie = (IndexEntry)this.classDefs.at(n)).decl()).interfaceSet()).find(className) != null || set.find(toSearch1) != null)) {
                result.add(atie);
                if (atie.isInterface()) {
                    this.allImplementorsOfInterface(atie, result);
                }
            }
            ++n;
        }
        return result;
    }

    JSet allImplementorsOfMethod(IndexEntry ie) {
        if (ie == null || !ie.isField() && !ie.isMethod()) {
            return new JSet(1);
        }
        int i = this.filteredIndex().indexOf(ie.fieldName());
        JSet res = new JSet(10);
        while (((IndexEntry)this.filteredIndex().at(i)).fieldName().equals(ie.fieldName())) {
            res.add(this.getClassDef(ie.realClassName(), ie.realPackage()));
        }
        return res;
    }

    String getPossibleClassFileFor(String clazz) {
        String[] s = new String[2];
        SourceBase.splitClass(clazz, s);
        String toSearch = s[0] + ",  " + s[1];
        IndexEntry ie = (IndexEntry)this.filteredIndex().find(s[0] + ",  " + s[1]);
        if (ie != null && ie.getDisplayString().startsWith(toSearch)) {
            return ie.docPos().path;
        }
        return null;
    }

    public IndexEntry getClassDef(String fqclazz) {
        int i = fqclazz.lastIndexOf(46);
        if (i >= 0) {
            return this.getClassDef(fqclazz.substring(i + 1), fqclazz.substring(0, i));
        }
        return this.getPossibleClassDefFor(fqclazz, null);
    }

    public IndexEntry getClassDef(String clazz, String pack) {
        IndexEntry result = (IndexEntry)this.filteredIndex().at(this.filteredIndex().indexOf(clazz + ",  " + pack));
        if (result == null || !result.isClassOrInterface()) {
            if (clazz.equals("Object") && pack.equals("java.lang")) {
                ClassDescription obj = new ClassDescription();
                obj.className = "Object";
                obj.pack = "java.lang";
                obj.setDP("", 0, 0, 0, 0);
                obj.superClass = "java.lang.Object";
                this.add(obj);
            }
            return null;
        }
        return result;
    }

    public int typeOf(String word) {
        if (!Character.isJavaIdentifierPart(word.charAt(0))) {
            return 6;
        }
        Object intg = keyWords.get(word);
        if (intg != null) {
            return (Integer)intg;
        }
        if (word.charAt(word.length() - 1) == '(') {
            return 2;
        }
        if (Character.isDigit(word.charAt(0))) {
            return 3;
        }
        if (this.classHash.find(word) != null) {
            return 1;
        }
        return 6;
    }

    public boolean isClass(String s) {
        return this.classHash.find(s) != null;
    }

    public JArray classDefinitionsIn(String filePath) {
        FileEntry fe = this.fileReg.get(filePath);
        JArray result = new JArray();
        if (fe == null) {
            return result;
        }
        Enumeration e = fe.enumerate();
        while (e.hasMoreElements()) {
            IndexEntry ie = (IndexEntry)e.nextElement();
            if (!ie.isClassOrInterface()) continue;
            result.add(ie);
        }
        JArray.QuickSort(result, JArray.StringSortFunc());
        return result;
    }

    public Vector applyMethodFilter(String cl, JArray ibase, int filter, boolean useFilter) {
        Vector<IndexEntry> result = new Vector<IndexEntry>(ibase.size());
        int pType = 259;
        int n = 0;
        while (n < ibase.size()) {
            IndexEntry ie = (IndexEntry)ibase.at(n);
            if (ie.className() != null && !ie.isClassOrInterface() && ie.className().equals(cl) && (!useFilter || ie.decl().getClass() == (class$editapp$FieldDescription == null ? SourceBase.class$("editapp.FieldDescription") : class$editapp$FieldDescription) && (filter & 0x800) == 0 || ie.decl().getClass() == (class$editapp$MethodDescription == null ? SourceBase.class$("editapp.MethodDescription") : class$editapp$MethodDescription) && (filter & 0x400) == 0) && (useFilter && !ie.decl().hasAnyModifiers(filter & pType) && ((filter & 0x80) == 0 && ie.decl().hasAllModifiers(128) || (filter & 0x200) == 0 && !ie.decl().hasAllModifiers(128)) || !useFilter)) {
                result.add(ie);
            }
            ++n;
        }
        return result;
    }

    public JArray definitionsInFile(String filePath) {
        FileEntry fe = this.fileReg.get(filePath);
        JArray result = new JArray();
        if (fe == null) {
            return result;
        }
        Enumeration e = fe.enumerate();
        while (e.hasMoreElements()) {
            IndexEntry ie = (IndexEntry)e.nextElement();
            result.add(ie);
        }
        return result;
    }

    void resetIndex() {
    }

    void rebuildIndex() {
        this.classDefs = new JArray(500);
        this.classHash = new JSet(500);
        JArray ibase = (JArray)this.filteredIndex().getBase();
        int n = 0;
        while (n < ibase.size()) {
            IndexEntry ie = (IndexEntry)ibase.at(n);
            try {
                if (ie.isClassOrInterface()) {
                    String clzName = ie.fieldName();
                    this.classDefs.add(ie);
                    if (clzName.indexOf("$") >= 0) {
                        String clz = clzName.substring(clzName.lastIndexOf(36) + 1);
                        this.classHash.add(clz);
                    } else {
                        this.classHash.add(clzName);
                    }
                }
            }
            catch (Exception e) {
                NCApplication.Pln("rebuildFromIndex  ie: " + ie);
                e.printStackTrace();
            }
            ++n;
        }
        this.app.binderApplication().notifyTargets("rebuildIndex");
    }

    public void build(Vector fileList, INCExtendedPrintout _errorPanel, INCStatus _status, boolean _recurse, boolean _rebuild) {
        this.builder.build(fileList, _errorPanel, _status, _recurse, _rebuild, true);
    }

    public void build(Vector fileList, INCExtendedPrintout _errorPanel, INCStatus _status, boolean _recurse, boolean _rebuild, boolean checkDeleted) {
        this.builder.build(fileList, _errorPanel, _status, _recurse, _rebuild, checkDeleted);
    }

    public void buildSynchronous(Vector fileList, INCExtendedPrintout _errorPanel, INCStatus _status, boolean _recurse, boolean _rebuild, boolean checkExisting) {
        this.builder.checkForDeleted = checkExisting;
        this.buildSynchronous(fileList, _errorPanel, _status, _recurse, _rebuild);
    }

    public void buildSynchronous(Vector fileList, INCExtendedPrintout _errorPanel, INCStatus _status, boolean _recurse, boolean _rebuild) {
        this.builder.buildSynchronous(fileList, _errorPanel, _status, _recurse, _rebuild);
    }

    public synchronized void update(String file2) {
        this.update(file2, false);
    }

    public synchronized void update(String file2, boolean force) {
        this.builder.update(file2, force);
    }

    public void reset() {
        IndexEntry.ExitDBFile();
        try {
            new File(this.getDBFile()).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new File(this.getFixedDBFile()).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new File(this.getIndexFile()).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            new File(this.getFixedIndexFile()).delete();
            new VFile("#sourcebase/decidx.idxstring").delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.resetIndex();
            SourceBase.This().filteredIndex = null;
            this.index = new JSortedSetArray(new JArray(10000), JArray.UpperCaseStringSortFunc());
            this.fileReg = new FileRegistry();
            try {
                StringStore.Reset();
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            try {
                IndexEntry.ClearExternalCache();
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            try {
                this.load(this.getIndexFile());
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            this.rebuildIndex();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IndexEntry.InitDBFile();
        EditApp.App.binderApplication().notifyTargets("sourcebase reset");
    }

    void compact(INCStatus status) {
        status.setText("loading all entries");
        status.setToDo(this.index.size());
        IndexEntry.CacheTurnedOn = false;
        int n = 0;
        while (n < this.index.size()) {
            IndexEntry ie = (IndexEntry)this.index.at(n);
            if (!ie.isFixed()) {
                ie.decl();
            }
            status.setDone(n);
            ++n;
        }
        status.setText("deleting old file");
        IndexEntry.ExitDBFile();
        try {
            File f = new File(this.getDBFile());
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IndexEntry.InitDBFile();
        status.setText("rewriting entries");
        status.setToDo(this.index.size());
        int n2 = 0;
        while (n2 < this.index.size()) {
            IndexEntry ie = (IndexEntry)this.index.at(n2);
            if (!ie.isFixed()) {
                ie.writeZIP();
                ie.freeMem();
            }
            status.setDone(n2);
            ++n2;
        }
        IndexEntry.CacheTurnedOn = true;
        status.setText("saving index");
        this.isChanged = true;
        this.save(this.getIndexFile());
        status.setText("finished compact");
    }

    synchronized void removeFromIndex(String file2) {
        JSortedArray[] remColls = new JSortedArray[]{this.index(), this.filteredIndex()};
        if (this.fileReg.get(file2) != null) {
            this.fileReg.get(file2).cleanUp(remColls);
            this.fileReg.remove(file2);
        }
    }

    boolean cleanUp(String file2) {
        JSortedArray[] remColls = new JSortedArray[]{this.index(), this.filteredIndex()};
        if (this.fileReg.get(file2) != null && !file2.endsWith(")")) {
            this.fileReg.get(file2).cleanUp(remColls);
            if (!new File(file2).exists()) {
                this.fileReg.remove(file2);
                return false;
            }
            return true;
        }
        return false;
    }

    public void waitForBuilderStop() {
        this.builder.waitForBuilderStop();
    }

    void hardTerminate() {
        try {
            this.builder.hardTerminate();
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DONTLOAD = false;
        ScanFixed = false;
        fixedZFileName = "#sourcebase/fixedbase40.jdb";
        fixedZIndexName = "#sourcebase/decidx40.idx";
        zFileName = "#sourcebase/decbase40.jdb";
        zIndexName = "#sourcebase/decidx40.idx";
        zFileCopy = "#staticdata/decbase40.jdb";
        zIndexFileCopy = "#staticdata/fixedbase40.jdb";
        zIndexCopy = "#staticdata/decidx40.idx";
        nativeTypes = new JSet(10);
        nativeTypes.add("boolean");
        nativeTypes.add("int");
        nativeTypes.add("long");
        nativeTypes.add("float");
        nativeTypes.add("short");
        nativeTypes.add("byte");
        nativeTypes.add("char");
        nativeTypes.add("double");
        String[] kw = new String[]{"public", "private", "static", "native", "transient", "protected", "final", "abstract", "synchronized", "synchronized(", "class", "interface", "extends", "implements", "super", "this", "void", "float", "double", "int", "byte", "long", "char", "boolean", "true", "false", "null", "if(", "if", "else", "continue", "for(", "for", "while(", "while", "do", "switch(", "switch", "case", "break", "catch(", "catch", "try", "throws", "throw", "finally", "new", "return", "return(", "instanceof", "instanceof(", "default", "import", "package", "short", "assert"};
        String[] kwt = new String[]{"public", "private", "static", "native", "transient", "protected", "final", "abstract", "synchronized", "synchronized(", "class", "interface", "extends", "implements", "super", "this", "void", "true", "false", "null", "if(", "if", "else", "continue", "for(", "for", "while(", "while", "do", "switch(", "switch", "case", "break", "catch(", "catch", "try", "throws", "throw", "finally", "new", "return", "return(", "instanceof", "instanceof(", "default", "import", "package"};
        keyWords = new JUnsafeTable(kw.length * 2);
        keyWordsWithoutTypes = new JUnsafeTable(kwt.length * 2);
        int n = 0;
        while (n < kw.length) {
            keyWords.put(kw[n], new Integer(4));
            ++n;
        }
        int n2 = 0;
        while (n2 < kwt.length) {
            keyWordsWithoutTypes.put(kwt[n2], Boolean.TRUE);
            ++n2;
        }
    }
}

