/*
 * Decompiled with CFR 0.152.
 */
package editapp.appwizards;

import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.BasicApplicationWizard;
import editapp.EditApp;
import java.awt.Container;
import java.awt.Image;
import java.io.File;
import java.util.Vector;
import jxeplugins.FileSetupEntry;
import plugins.JavacPlugin;

public class SimpleServletAppWizard
extends BasicApplicationWizard {
    String prev_name = "";

    public String getName() {
        return "Apache Tomcat Web Application";
    }

    public void setCompileOptions(JavacPlugin pin) {
        pin.setOptions(true, false, false, false, true);
    }

    public String getDescription() {
        return "This will create a Web Application Workspace (using Tomcat 4.03 LE). Enables you to create JSPs, Java Servlets. Requires a JDK 1.4 or higher.";
    }

    protected Vector getLibraries() {
        Vector result = new Vector(13);
        return result;
    }

    public Image getDescriptionImage() {
        return NCApplication.GetImage("simpleservlet");
    }

    public Image getSmallIconImage() {
        return null;
    }

    public int getProjectType() {
        return 3;
    }

    public String getTemplateDir() {
        return VFile.ResolveName("#templates/predefined/tomcat");
    }

    public String getMainClass() {
        return null;
    }

    public String getMainClassCline() {
        return null;
    }

    public void createProject(String directory, String name, EditApp app, Container toMakeFurtherQueriesIn) {
        this.prev_name = name;
        super.createProject(directory, name, app, toMakeFurtherQueriesIn);
        EditApp.App.getTemplateEngine().instantiateTemplateDir(VFile.ResolveName("#jxebase/templates/predefined/tomcat/"), directory + File.separator + name, this.prev_name);
        try {
            EditApp.App.jol.xmlImport(new VFile("#actproject/anyjproj.ajpr"));
            JavacPlugin.This().setOutputDir(NCStringUtilities.Replace("($workspaceDir)/tomcat/webapps/" + this.prev_name + "/WEB-INF/classes", "/", File.separator));
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        try {
            String version = EditApp.App.findJavaVersion();
            if (version != null && version.indexOf("1.4") < 0 && version.indexOf("1.5") < 0) {
                Confirm.ModalMsg("Wrong JDK version", new String[]{"The tomcat release bundled with AnyJ", "requires a JDK 1.4 or higher.", "Please choose an appropriate JDK in", "Preferences, JDK's"});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        EditApp.App.openBrowserOn(VFile.ResolveName("#actproject/tomcat/webapps/ROOT/index.html").replace('/', File.separatorChar));
        EditApp.App.addFileSetupEntry(new FileSetupEntry(true, false, false, VFile.ResolveName("#actproject/tomcat/work/localhost/" + this.prev_name), false, false), false, true);
        EditApp.App.updateSourceBase();
    }

    public void initKeyValues() {
        this.keys = new String[0];
        this.values = new String[0];
    }

    public void pastRunAction(EditApp app) {
    }

    static {
        NCApplication.PutImage("simpleservlet", "servlet.gif");
    }
}

