/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.HTMLDocument;
import horst.parser.HTMLDefs;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element {
    Element m_parent;
    Element m_anchor;
    HTMLDocument m_doc;
    Vector m_children = new Vector();
    Vector m_relatedElements = new Vector();
    Vector m_origRelatedElements = new Vector();
    Hashtable m_attributes = new Hashtable(10);
    int m_type;
    Font m_font;
    boolean m_bDrawFocusBox;
    boolean m_bHasFocus;
    boolean m_bInPreformat = false;
    Color m_focusColor = Color.red;
    int m_p0;
    int m_p1;
    int m_origP0;
    int m_origP1;
    int m_textbufferPosition = -1;

    public Element(int type) {
        this.m_type = type;
        this.m_bInPreformat = false;
    }

    public Element(int type, int p0, int p1) {
        this.m_type = type;
        this.m_p0 = p0;
        this.m_p1 = p1;
        this.m_origP0 = p0;
        this.m_origP1 = p1;
    }

    public Element(Element copy) {
        this.m_origP0 = copy.m_origP0;
        this.m_origP1 = copy.m_origP1;
        this.m_p0 = copy.m_p0;
        this.m_p1 = copy.m_p1;
        this.m_attributes = copy.getAttributes();
        this.m_type = copy.getType();
        this.m_font = copy.getFont();
        this.m_bHasFocus = copy.getHasFocus();
        this.m_focusColor = copy.getFocusColor();
        this.m_bDrawFocusBox = copy.getDrawFocusBox();
        this.m_doc = copy.getDocument();
        this.m_bInPreformat = copy.m_bInPreformat;
        this.m_anchor = copy.m_anchor;
    }

    public void addChild(Element e) {
        this.m_children.addElement(e);
        e.m_parent = this;
    }

    void addRelatedElement(Element e) {
        this.m_relatedElements.addElement(e);
        this.m_origRelatedElements.addElement(e);
    }

    protected void flushResources() {
        this.m_relatedElements.removeAllElements();
        Object[] elems = new Element[this.m_children.size()];
        this.m_children.copyInto(elems);
        int i = 0;
        while (i < elems.length) {
            ((Element)elems[i]).flushResources();
            ++i;
        }
    }

    public Object getAttribute(Object key) {
        return this.m_attributes.get(key);
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public char[] getCharData() {
        StringBuffer buf;
        if (this.m_p0 >= 0 && this.m_p1 >= this.m_p0 && (buf = this.getDocument().getTextBuffer()) != null) {
            char[] data = new char[this.m_p1 - this.m_p0 + 1];
            buf.getChars(this.m_p0, this.m_p1 + 1, data, 0);
            return data;
        }
        return null;
    }

    public Vector getChildren() {
        return this.m_children;
    }

    public HTMLDocument getDocument() {
        return this.m_doc;
    }

    protected boolean getDrawFocusBox() {
        return this.m_bDrawFocusBox;
    }

    public Element getElementAt(int index) {
        return (Element)this.m_children.elementAt(index);
    }

    public int getElementCount() {
        return this.m_children.size();
    }

    public int getElementIndex(Element e) {
        return this.m_children.indexOf(e);
    }

    protected Color getFocusColor() {
        return this.m_focusColor;
    }

    public Font getFont() {
        return this.m_font;
    }

    protected boolean getHasFocus() {
        return this.m_bHasFocus;
    }

    public String getName() {
        return HTMLDefs.getName(this.m_type);
    }

    public Element getParent() {
        return this.m_parent;
    }

    Element[] getRelatedElements() {
        Object[] elems = new Element[this.m_relatedElements.size()];
        this.m_relatedElements.copyInto(elems);
        return elems;
    }

    public int getType() {
        return this.m_type;
    }

    public void insertElementAt(Element e, int idx) {
        if (e != null && idx <= this.m_children.size() - 1) {
            this.m_children.insertElementAt(e, idx);
            e.m_parent = this;
        }
        throw new IllegalArgumentException("Illegal Element insertion!");
    }

    public boolean isAttributeDefined(Object key) {
        return this.m_attributes.containsKey(key);
    }

    public boolean isLink() {
        return this.getAttribute("href") != null;
    }

    protected void propagateDrawFocusBox(boolean bDraw) {
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setDrawFocusBox(bDraw);
        }
    }

    protected void propagateFocus(boolean bFocus) {
        this.m_bHasFocus = bFocus;
        if (!bFocus) {
            this.m_bDrawFocusBox = false;
        }
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setFocus(bFocus);
            elem.setDrawFocusBox(this.m_bDrawFocusBox);
        }
    }

    protected void propagateFocus(boolean bFocus, boolean bDrawFocusBox) {
        this.m_bHasFocus = bFocus;
        this.m_bDrawFocusBox = bDrawFocusBox;
        Enumeration e = this.m_relatedElements.elements();
        while (e.hasMoreElements()) {
            Element elem = (Element)e.nextElement();
            elem.setFocus(bFocus);
            elem.setDrawFocusBox(this.m_bDrawFocusBox);
        }
    }

    public void removeAttribute(Object key) {
        this.m_attributes.remove(key);
    }

    void replaceRelatedElement(Element oldElem, Element[] newElems) {
        int sz = this.m_relatedElements.size();
        int i = 0;
        while (i < sz) {
            Element elem = (Element)this.m_relatedElements.elementAt(i);
            if (elem == oldElem) {
                this.m_relatedElements.removeElementAt(i);
                int j = 0;
                while (j < newElems.length) {
                    this.m_relatedElements.addElement(newElems[j]);
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    void reset() {
        this.m_p0 = this.m_origP0;
        this.m_p1 = this.m_origP1;
        this.m_relatedElements.removeAllElements();
        Enumeration e = this.m_origRelatedElements.elements();
        while (e.hasMoreElements()) {
            this.m_relatedElements.addElement(e.nextElement());
        }
        Enumeration e2 = this.m_children.elements();
        while (e2.hasMoreElements()) {
            ((Element)e2.nextElement()).reset();
        }
    }

    public void setAttribute(Object key, Object value) {
        this.m_attributes.put(key, value);
    }

    public void setAttributes(Hashtable atts) {
        this.m_attributes = atts;
    }

    public void setDocument(HTMLDocument doc) {
        this.m_doc = doc;
        Object[] elems = new Element[this.m_children.size()];
        this.m_children.copyInto(elems);
        int i = 0;
        while (i < elems.length) {
            ((Element)elems[i]).setDocument(doc);
            ++i;
        }
    }

    protected void setDrawFocusBox(boolean bDraw) {
        this.m_bDrawFocusBox = bDraw;
    }

    protected void setFocus(boolean bFocus) {
        this.m_bHasFocus = bFocus;
        if (!bFocus) {
            this.m_bDrawFocusBox = false;
        }
    }

    public void setFont(Font f) {
        this.m_font = f;
    }

    void setTextPointers(int p0, int p1) {
        this.m_origP0 = p0;
        this.m_origP1 = p1;
        this.m_p0 = p0;
        this.m_p1 = p1;
    }

    void trimLeft() {
        StringBuffer buf = this.getDocument().getTextBuffer();
        if (buf != null) {
            while (this.m_p0 <= this.m_p1) {
                char[] data = new char[this.m_p1 - this.m_p0 + 1];
                buf.getChars(this.m_p0, this.m_p1 + 1, data, 0);
                if (data[0] != ' ') break;
                ++this.m_p0;
            }
        }
    }

    void trimRight() {
        StringBuffer buf = this.getDocument().getTextBuffer();
        if (buf != null) {
            while (this.m_p0 <= this.m_p1) {
                char[] data = new char[this.m_p1 - this.m_p0 + 1];
                buf.getChars(this.m_p0, this.m_p1 + 1, data, 0);
                if (data[data.length - 1] != ' ') break;
                --this.m_p1;
            }
        }
    }
}

