/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.BlockView;
import horst.Element;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class HRView
extends BlockView {
    int m_size;
    int m_borderSize;
    int m_width;
    boolean m_bNoShade;
    float m_pctWidth;

    public HRView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    protected int getPreferredSpan(int axis) {
        if (axis == 0) {
            return this.m_size + 2 * this.m_borderSize + this.m_insets.top + this.m_insets.bottom;
        }
        if (this.m_width > 0) {
            return this.m_width;
        }
        return this.m_size + 2 * this.m_borderSize;
    }

    protected void init() {
        this.m_borderSize = 1;
        this.setInsets(2, 0, 2, 0);
        this.m_bNoShade = this.m_elem.isAttributeDefined("noshade");
        this.m_size = Utilities.setIntegerProperty(1, "size", this.m_elem.getAttributes());
        this.m_pctWidth = Utilities.setPercentageProperty(-1.0f, "width", this.m_elem.getAttributes());
        this.m_alignment = Utilities.setAlignmentProperty(false, 1, "align", this.m_elem.getAttributes());
        this.m_width = Utilities.setIntegerProperty(-1, "width", this.m_elem.getAttributes());
    }

    protected boolean isContainerView() {
        return false;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        int viewWidth = Math.max(0, width - info.leftMargin - info.rightMargin);
        if (this.m_width > 0 && this.m_width < viewWidth) {
            viewWidth = this.m_width;
        }
        this.m_bounds = new Rectangle(x, y, viewWidth, this.m_size + 2 * this.m_borderSize + this.m_insets.top + this.m_insets.bottom);
        return this.m_bounds;
    }

    public void paint(Graphics g, Shape alloc) {
        Color oldColor = g.getColor();
        Color c = Color.lightGray;
        g.setColor(c);
        int x = this.m_bounds.x;
        int y = this.m_bounds.y + this.m_insets.top;
        int w = this.m_bounds.width - 2 * this.m_borderSize;
        int h = this.m_size + 1;
        if (this.m_pctWidth > 0.0f && this.m_pctWidth <= 1.0f) {
            w = (int)(this.m_pctWidth * (float)w);
        } else if (this.m_width > 0) {
            w = this.m_width;
        }
        if (w > this.m_bounds.width) {
            w = this.m_bounds.width;
        }
        if (this.m_alignment == 1) {
            x += (this.m_bounds.width - 2 * this.m_borderSize - w) / 2;
        } else if (this.m_alignment == 2) {
            x += this.m_bounds.width - 2 * this.m_borderSize - w;
        }
        if (this.m_bNoShade) {
            g.setColor(c.darker());
            g.fillRect(x, y, w, this.m_size);
        } else {
            Utilities.drawBorder(g, new Rectangle(x, y, w + 1, h + 1));
        }
        g.setColor(oldColor);
    }
}

