/*
 * Decompiled with CFR 0.152.
 */
package horst;

import de.netcomputing.util.Tracer;
import horst.BusyFlag;
import horst.Element;
import horst.ElementViewInfo;
import horst.HTMLDocument;
import horst.HTMLPanePreferences;
import horst.HTMLPaneProperties;
import horst.HTMLPaneStatusListener;
import horst.HTMLWindow;
import horst.LayoutInfo;
import horst.LinkListener;
import horst.MyModelInfo;
import horst.ToolTip;
import horst.Utilities;
import horst.View;
import horst.ViewFactory;
import horst.parser.HTMLParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;

public class HTMLPane
extends JPanel
implements Scrollable,
MouseMotionListener {
    public String lastLink = null;
    protected int PRINTING_MARGIN = 10;
    protected BusyFlag m_busyflag;
    protected HTMLDocument m_document;
    protected HTMLParser m_parser;
    protected LayoutInfo m_layoutInfo = new LayoutInfo();
    protected HTMLPanePreferences m_preferences = new HTMLPanePreferences();
    protected HTMLPaneProperties m_props = new HTMLPaneProperties();
    protected View m_rootView;
    protected ViewFactory m_viewFactory;
    protected boolean m_bParsing = false;
    protected int m_lastLayoutWidth = -1;
    protected boolean m_bCreatingViews;
    protected boolean m_bLayoutInProgress;
    protected Thread m_parsingThread;
    protected ToolTip m_toolTip;
    protected boolean m_bPrinting = false;
    private static PrintWriter pwOut;
    private static int indent;

    public HTMLPane() {
        this.m_busyflag = new BusyFlag();
        this.m_parser = new HTMLParser();
        this.m_toolTip = new ToolTip("horst");
        this.m_viewFactory = new ViewFactory();
        this.enableEvents(48L);
        this.setBackground(Color.white);
        this.setLayout(null);
    }

    protected void addFloater(View v) {
        this.m_props.floaters.addElement(v);
    }

    public void addLinkListener(LinkListener l) {
        this.m_props.linkListeners.addElement(l);
    }

    public void addStatusListener(HTMLPaneStatusListener l) {
        this.m_props.statusListeners.addElement(l);
    }

    public void back() {
        URL u = this.m_props.history.back();
        if (u != null) {
            this.loadPage(u, false);
        }
    }

    protected boolean beginParsing(Reader r, URL baseURL) {
        this.m_props.floaters.removeAllElements();
        this.m_document = null;
        this.m_document = this.createDocument();
        if (this.m_props.bIsIFrame || this.m_props.bIsFrame) {
            this.m_document.m_bPrintTree = false;
        }
        this.m_parser.setCallback(this.m_document);
        try {
            this.m_parser.parse(r, baseURL);
            this.m_document.m_baseURL = baseURL;
        }
        catch (IOException e) {
            Tracer.This.println(e.getMessage());
            e.printStackTrace();
            this.notifyStatusListeners(9, null);
        }
        return true;
    }

    protected boolean beginParsing(URLConnection con) {
        URL u = con.getURL();
        this.m_props.floaters.removeAllElements();
        this.m_document = null;
        this.m_document = this.createDocument();
        if (this.m_props.bIsIFrame || this.m_props.bIsFrame) {
            this.m_document.m_bPrintTree = false;
        }
        this.m_parser.setCallback(this.m_document);
        try {
            this.m_parser.parse(con);
            u = this.m_document.getURL();
        }
        catch (IOException ex) {
            this.notifyStatusListeners(9, u);
            return false;
        }
        return true;
    }

    public boolean canMoveBack() {
        return this.m_props.history.canMoveBack();
    }

    public boolean canMoveForward() {
        return this.m_props.history.canMoveForward();
    }

    protected void clearFocusElement() {
        this.notifyMouseOverLink(null);
        if (this.m_props.focusElement != null) {
            this.m_props.focusElement.propagateFocus(false);
            this.m_props.focusElement = null;
            this.repaint();
        }
    }

    public static void closeLog() {
        if (pwOut != null) {
            pwOut.close();
            pwOut = null;
        }
    }

    protected HTMLDocument createDocument() {
        return new HTMLDocument(this);
    }

    protected void createViews(Element root) {
        if (this.m_bCreatingViews || this.m_bLayoutInProgress) {
            Tracer.This.println("createViews being called with m_bCreatingViews=" + this.m_bCreatingViews + " m_bLayoutInProgress=" + this.m_bLayoutInProgress);
            return;
        }
        this.m_bCreatingViews = true;
        this.removeAll();
        this.m_lastLayoutWidth = -1;
        if (this.m_rootView != null) {
            this.m_rootView.flushResources();
            this.m_rootView = null;
        }
        if (this.m_props.rootElement != null) {
            this.m_props.rootElement.flushResources();
            this.m_props.rootElement = null;
        }
        this.m_props.rootElement = root;
        this.m_rootView = this.m_viewFactory.createView(null, this.m_props.rootElement, this);
        if (this.m_rootView != null) {
            this.m_rootView.makeChildren(this.m_viewFactory);
            this.notifyStatusListeners(3, this.m_document.getURL());
            this.m_rootView.loadResources();
            this.notifyStatusListeners(9, this.m_document.getURL());
        }
        this.m_bCreatingViews = false;
    }

    public View elementToView(Element e) {
        if (this.m_rootView != null && e != null) {
            return this.m_rootView.elementToView(e);
        }
        return null;
    }

    public void enableDebugMessages(boolean bEnable) {
        Utilities.m_bDebugging = bEnable;
    }

    public void enableToolTips(boolean bEnable) {
        this.m_preferences.bShowToolTip = bEnable;
    }

    int findText(String text, int lastPos) {
        int pos = -1;
        if (this.m_document != null && this.m_rootView != null) {
            int idx;
            StringBuffer buffer = this.m_document.getTextBuffer();
            String str = buffer.toString().toLowerCase();
            text = text.toLowerCase();
            int save = 0;
            if (lastPos >= 0) {
                save = lastPos + text.length();
                str = str.substring(save, str.length());
            }
            if ((idx = str.indexOf(text)) != -1) {
                pos = save + idx;
            }
        }
        return pos;
    }

    protected ElementViewInfo floaterHitTest(int x, int y) {
        ElementViewInfo info = null;
        Enumeration e = this.m_props.floaters.elements();
        while (e.hasMoreElements()) {
            View v = (View)e.nextElement();
            info = v.viewToModel(x, y);
            if (info != null) break;
        }
        return info;
    }

    protected void forceLayout() {
        this.lock();
        JViewport vp = this.getViewport();
        if (vp != null) {
            this.layoutViews(vp.getExtentSize().width);
        } else {
            Container parent = this.getParent();
            if (parent != null && parent.getSize().width > 0) {
                this.layoutViews(parent.getSize().width);
            }
        }
        this.unlock();
    }

    public void forward() {
        URL u = this.m_props.history.forward();
        if (u != null) {
            this.loadPage(u, false);
        }
    }

    public HTMLDocument getDocument() {
        return this.m_document;
    }

    protected View[] getFloaters() {
        Object[] floats = new View[this.m_props.floaters.size()];
        this.m_props.floaters.copyInto(floats);
        return floats;
    }

    public boolean getFramesEnabled() {
        return this.m_preferences.bFramesEnabled;
    }

    public boolean getIFramesEnabled() {
        return this.m_preferences.bIFramesEnabled;
    }

    protected MyModelInfo getModelInfo(int x, int y) {
        MyModelInfo info = new MyModelInfo();
        if (this.m_rootView != null) {
            String link;
            info.m_ev = this.floaterHitTest(x, y);
            if (info.m_ev == null) {
                info.m_ev = this.m_rootView.viewToModel(x, y);
            }
            if (info.m_ev != null && info.m_ev.m_view.isLink() && (link = (String)info.m_ev.m_elem.getAttribute("href")) != null) {
                Element baseElem;
                info.target = (String)info.m_ev.m_elem.getAttribute("target");
                if (info.target == null && (baseElem = this.m_document.getBaseElement()) != null) {
                    info.target = (String)baseElem.getAttribute("target");
                }
                String ref = (String)this.m_rootView.getAttribute("href");
                URL refURL = null;
                if (ref != null) {
                    refURL = Utilities.getURL(ref);
                }
                info.url = refURL != null ? Utilities.getURL(refURL, link) : Utilities.getURL(link);
            }
        }
        return info;
    }

    public int getNumPages(int pgWidth, int pgHeight) {
        int nPages = this.paginate(pgWidth -= 2 * this.PRINTING_MARGIN, pgHeight -= 2 * this.PRINTING_MARGIN);
        this.m_layoutInfo.bPaginate = false;
        this.forceLayout();
        return nPages;
    }

    public int getPageHeight() {
        if (this.m_rootView != null) {
            return this.m_rootView.getBounds().height;
        }
        return 0;
    }

    public Image[] getPageImage(int pgNum, int pgWidth, int pgHeight) {
        if (this.m_rootView == null) {
            return null;
        }
        Object img = null;
        int nPages = this.paginate(pgWidth -= 2 * this.PRINTING_MARGIN, pgHeight -= 2 * this.PRINTING_MARGIN);
        Rectangle b = this.m_rootView.getBounds();
        Frame frame = Utilities.getFrame(this);
        Image offscreen = frame.createImage(b.width + 2 * this.PRINTING_MARGIN, this.m_layoutInfo.pageHeight + 2 * this.PRINTING_MARGIN);
        Graphics og = offscreen.getGraphics();
        og.setColor(this.getBackground());
        og.fillRect(0, 0, offscreen.getWidth(null), offscreen.getHeight(null));
        og.setClip(0, 0, b.width, this.m_layoutInfo.pageHeight);
        int y = (pgNum - 1) * (this.m_layoutInfo.pageHeight + this.m_layoutInfo.pageBreakHeight);
        og.translate(this.PRINTING_MARGIN, -y + this.PRINTING_MARGIN);
        this.renderToPrinter(og);
        Image[] ret = new Image[]{offscreen, offscreen.getScaledInstance(pgWidth, pgHeight, 8)};
        ret[1].getWidth(null);
        ret[1].getHeight(null);
        this.m_layoutInfo.bPaginate = false;
        this.forceLayout();
        return ret;
    }

    public int getPageWidth() {
        if (this.m_rootView != null) {
            return this.m_rootView.getBounds().width;
        }
        return 0;
    }

    protected int getPaneHeight() {
        JViewport jp = this.getViewport();
        if (jp != null) {
            return jp.getExtentSize().height;
        }
        return 800;
    }

    protected int getPaneWidth() {
        JViewport jp = this.getViewport();
        if (jp != null) {
            return jp.getExtentSize().width;
        }
        return 800;
    }

    public Dimension getPreferredScrollableViewportSize() {
        if (this.m_rootView != null) {
            return new Dimension(this.getPageWidth(), this.getPageHeight());
        }
        return new Dimension(2000, 2000);
    }

    public Dimension getPreferredSize() {
        Element root;
        this.lock();
        int portWidth = this.getPaneWidth();
        int portHeight = this.getPaneHeight();
        if (this.m_rootView == null && this.m_document != null && (root = this.m_document.getRootElement()) != null) {
            this.createViews(root);
        }
        if (this.m_rootView == null) {
            this.unlock();
            return new Dimension(portWidth, portHeight);
        }
        if (this.m_lastLayoutWidth != portWidth) {
            this.layoutViews(portWidth);
        }
        Dimension d = new Dimension(this.m_rootView.getBounds().width, this.m_rootView.getBounds().height);
        this.unlock();
        return d;
    }

    public int getPrintingLayoutWidth(int width) {
        return this.m_props.printingLayoutWidth;
    }

    public boolean getProgressiveDisplay() {
        return this.m_preferences.bProgressiveDisplay;
    }

    protected Element getRootElement() {
        return this.m_props.rootElement;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    public File getSourceFile() {
        File f = null;
        if (this.m_props.loadedPage != null) {
            HTMLParser parser = new HTMLParser();
            f = parser.getSourceFile(this.m_props.loadedPage);
        }
        return f;
    }

    protected JViewport getViewport() {
        Container parent = this.getParent();
        if (parent != null && parent instanceof JViewport) {
            return (JViewport)parent;
        }
        return null;
    }

    protected void imageMapHitTest(MouseEvent evt, MyModelInfo info) {
        if (info.m_ev.m_elem.getType() == 11 && (info.m_ev.m_elem.isAttributeDefined("ismap") || info.m_ev.m_elem.isAttributeDefined("usemap"))) {
            int x = evt.getX() - (info.m_ev.m_view.getBounds().x + info.m_ev.m_view.m_insets.left);
            int y = evt.getY() - (info.m_ev.m_view.getBounds().y + info.m_ev.m_view.m_insets.top);
            String mapName = (String)info.m_ev.m_elem.getAttribute("usemap");
            if (mapName != null && mapName.length() > 0) {
                while (mapName.charAt(0) == '#' && mapName.length() > 1) {
                    mapName = mapName.substring(1);
                }
                Enumeration e1 = this.m_document.getMapElements();
                while (e1.hasMoreElements()) {
                    Element mapElem = (Element)e1.nextElement();
                    String name = (String)mapElem.getAttribute("name");
                    if (name == null || !name.equalsIgnoreCase(mapName)) continue;
                    Enumeration e = mapElem.getChildren().elements();
                    while (e.hasMoreElements()) {
                        Shape s;
                        Element areaElem = (Element)e.nextElement();
                        if (areaElem.getType() != 50 || !areaElem.isAttributeDefined("href")) continue;
                        String shapeName = (String)areaElem.getAttribute("shape");
                        String coordinates = (String)areaElem.getAttribute("coords");
                        if (coordinates == null || (s = Utilities.createShape(shapeName, coordinates)) == null || !s.getBounds().contains(x, y)) continue;
                        URL u = Utilities.getURL(this.m_document.getBaseURL(), (String)areaElem.getAttribute("href"));
                        if (u != null) {
                            info.url = u;
                        }
                        return;
                    }
                    break;
                }
            } else {
                String href = (String)info.m_ev.m_elem.getAttribute("href");
                if (href != null) {
                    String params = "?" + x + "," + y;
                    URL u = Utilities.getURL(href + params);
                    if (u != null) {
                        info.url = u;
                    }
                }
            }
        }
    }

    protected boolean isTextSelected() {
        return this.m_props.selectStartPosition != -1 && this.m_props.selectEndPosition != -1;
    }

    protected Rectangle layoutViews(int width) {
        Utilities.debugOut("layoutViews width=" + width + " url=" + this.m_props.loadedPage);
        if (this.m_rootView == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (this.m_bLayoutInProgress) {
            Tracer.This.println("BUG HTMLPANE.layoutViews m_bLayoutInProgress recovering...");
            return new Rectangle(0, 0, 0, 0);
        }
        if (this.m_bCreatingViews) {
            Tracer.This.println("BUG HTMLPANE.layoutViews recovering...");
            return new Rectangle(0, 0, 0, 0);
        }
        this.m_bLayoutInProgress = true;
        this.notifyStatusListeners(2, this.m_props.loadedPage);
        this.m_layoutInfo.clear();
        this.m_props.floaters.removeAllElements();
        this.m_document.resetElements();
        this.m_rootView.reset();
        this.m_rootView.layout(0, 0, width, this.m_layoutInfo);
        this.m_rootView.setDimensions(this.getPaneWidth(), this.getPaneHeight());
        this.notifyStatusListeners(9, this.m_props.loadedPage);
        this.m_bLayoutInProgress = false;
        this.m_lastLayoutWidth = width;
        return this.m_rootView.getBounds();
    }

    public void loadApplets(boolean bLoad) {
        this.m_preferences.bLoadApplets = bLoad;
    }

    protected void loadImageContent(URL u) {
        this.m_document = this.createDocument();
        this.m_props.rootElement = new Element(11);
        this.m_props.rootElement.setDocument(this.m_document);
        this.m_props.rootElement.setAttribute("src", u.toString());
        this.m_props.rootElement.setAttribute("imagecontent", "true");
        this.m_props.loadedPage = u;
        this.createViews(this.m_props.rootElement);
        this.forceLayout();
        this.notifyStatusListeners(5, this.m_props.loadedPage);
    }

    public void loadImages(boolean bLoad) {
        this.m_preferences.bLoadImages = bLoad;
    }

    protected void loadPage(Reader r, URL baseURL, boolean bAddToHistory) {
        this.m_toolTip.hide();
        this.m_props.selectStartPosition = -1;
        this.m_props.selectEndPosition = -1;
        this.m_bParsing = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_parsingThread = new Thread(new ParsingThread(r, baseURL, bAddToHistory));
        this.m_parsingThread.start();
    }

    protected void loadPage(URL url, boolean bAddToHistory) {
        this.m_toolTip.hide();
        this.m_props.selectStartPosition = -1;
        this.m_props.selectEndPosition = -1;
        this.m_bParsing = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_parsingThread = new Thread(new ParsingThread(url, bAddToHistory));
        this.m_parsingThread.start();
    }

    void lock() {
        try {
            this.m_busyflag.getBusyFlag();
        }
        catch (Throwable ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void mouseDragged(MouseEvent mouseevent) {
    }

    public void mouseMoved(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof Component) {
            Component c = (Component)src;
            e.translatePoint(c.getBounds().x, c.getBounds().y);
            this.processMouseMotionEvent(e);
        }
    }

    protected void notifyMouseOverLink(URL u) {
        String href = "";
        if (u != null) {
            href = u.toString();
        }
        Enumeration e = this.m_props.linkListeners.elements();
        while (e.hasMoreElements()) {
            LinkListener l = (LinkListener)e.nextElement();
            l.mouseOverLink(href);
        }
    }

    protected boolean notifyMousePressedOverLink(URL u) {
        String href = "";
        if (u != null) {
            href = u.toString();
        }
        Enumeration e = this.m_props.linkListeners.elements();
        while (e.hasMoreElements()) {
            LinkListener l = (LinkListener)e.nextElement();
            boolean bLoad = l.mousePressedOverLink(href);
            if (bLoad) continue;
            return false;
        }
        return true;
    }

    protected boolean notifyStatusListeners(int val, Object info) {
        boolean retVal = true;
        Enumeration e = this.m_props.statusListeners.elements();
        while (e.hasMoreElements()) {
            HTMLPaneStatusListener l = (HTMLPaneStatusListener)e.nextElement();
            if (l.statusChanged(val, info)) continue;
            retVal = false;
        }
        return retVal;
    }

    public void openPage(Reader r, URL baseURL) {
        if (r != null) {
            this.loadPage(r, baseURL, true);
        }
    }

    public void openPage(URL u) {
        if (u != null) {
            this.loadPage(u, true);
        }
    }

    public int paginate(int pgWidth, int pgHeight) {
        int nPages = 1;
        if (this.m_rootView != null) {
            this.notifyStatusListeners(2, this.m_props.loadedPage);
            this.m_layoutInfo.clear();
            this.m_layoutInfo.bPaginate = true;
            this.m_layoutInfo.pageHeight = pgHeight;
            this.m_layoutInfo.pageWidth = pgWidth;
            this.m_props.floaters.removeAllElements();
            this.m_document.resetElements();
            this.m_rootView.reset();
            Rectangle b = this.m_rootView.layout(0, 0, pgWidth, this.m_layoutInfo);
            int start = this.m_layoutInfo.pageHeight;
            int end = start + this.m_layoutInfo.pageBreakHeight;
            while (start < b.y + b.height) {
                ++nPages;
                start = end + this.m_layoutInfo.pageHeight;
                end = start + this.m_layoutInfo.pageBreakHeight;
            }
            this.repaint();
        }
        return nPages;
    }

    public void paint(Graphics g) {
        if (this.m_props.bIsFrame) {
            Tracer.This.println("Paint frame url:" + this.m_props.loadedPage);
        }
        Dimension dim = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, dim.width, dim.height);
        if (this.m_rootView != null) {
            Rectangle alloc = null;
            JViewport jp = this.getViewport();
            alloc = jp != null ? jp.getViewRect() : new Rectangle(0, 0, dim.width, dim.height);
            g.setClip(alloc);
            this.m_rootView.paint(g, alloc);
            Enumeration e = this.m_props.floaters.elements();
            while (e.hasMoreElements()) {
                View v = (View)e.nextElement();
                Rectangle r = v.getBounds();
                if (r == null) continue;
                v.paint(g, r);
            }
            this.paintFocusBoxes(g, alloc);
        }
        this.paintChildren(g);
        if (this.m_layoutInfo.bPaginate) {
            Rectangle b = this.m_rootView.getBounds();
            int start = this.m_layoutInfo.pageHeight;
            int end = start + this.m_layoutInfo.pageBreakHeight;
            int nPage = 1;
            while (start < b.y + b.height) {
                g.setColor(Color.blue);
                g.drawString("Y = " + start, 20, start);
                g.drawLine(0, start, 800, start);
                g.drawString("Y = " + end + " Page " + nPage++, 20, end);
                g.drawLine(0, end, 800, end);
                start = end + this.m_layoutInfo.pageHeight;
                end = start + this.m_layoutInfo.pageBreakHeight;
            }
            g.setColor(Color.blue);
            g.drawLine(this.m_layoutInfo.pageWidth, 0, this.m_layoutInfo.pageWidth, 2000);
        }
    }

    void paintFocusBoxes(Graphics g, Shape alloc) {
        this.m_rootView.paintFocusBox(g, alloc);
        Enumeration e = this.m_props.floaters.elements();
        while (e.hasMoreElements()) {
            View v = (View)e.nextElement();
            Rectangle r = v.getBounds();
            if (r == null) continue;
            v.paintFocusBox(g, r);
        }
        Enumeration e2 = this.m_document.getAnchors();
        while (e2.hasMoreElements()) {
            Shape s;
            View vw;
            Element imgElem;
            String mapName;
            Element mapElem;
            Element elem = (Element)e2.nextElement();
            if (elem.getType() != 50 || !elem.getDrawFocusBox() || (mapElem = this.m_document.getMapElement(elem)) == null || (mapName = (String)mapElem.getAttribute("name")) == null || (imgElem = this.m_document.findElement(11, "usemap", mapName = "#" + mapName)) == null || (vw = this.m_rootView.elementToView(imgElem)) == null) continue;
            String shapeName = (String)elem.getAttribute("shape");
            String coordinates = (String)elem.getAttribute("coords");
            if (coordinates == null || (s = Utilities.createShape(shapeName, coordinates)) == null) continue;
            Rectangle r = s.getBounds();
            r.x += vw.getBounds().x;
            r.y += vw.getBounds().y;
            Utilities.drawFocusBorder(g, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printPage() {
        if (this.m_bPrinting) return;
        if (this.m_rootView == null) {
            return;
        }
        PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(null, "HTMLWindow", null);
        if (pj == null) return;
        try {
            try {
                Dimension pageDim = pj.getPageDimension();
                pageDim.width -= 2 * this.PRINTING_MARGIN;
                pageDim.height -= 2 * this.PRINTING_MARGIN;
                int nPages = this.paginate(pageDim.width, pageDim.height);
                Rectangle b = this.m_rootView.getBounds();
                Frame frame = null;
                boolean bUseImage = false;
                if (bUseImage) {
                    Tracer.This.println("bUseImage");
                    frame = Utilities.getFrame(this);
                }
                Rectangle alloc = new Rectangle(0, 0, pageDim.width, pageDim.height);
                int i = 0;
                while (true) {
                    if (i >= nPages) {
                        pj.end();
                        break;
                    }
                    Graphics g = pj.getGraphics();
                    g.setClip(alloc);
                    if (g != null) {
                        if (bUseImage) {
                            Image offscreen = frame.createImage(b.width, this.m_layoutInfo.pageHeight);
                            Graphics og = offscreen.getGraphics();
                            og.setClip(g.getClipRect());
                            int y = i * (this.m_layoutInfo.pageHeight + this.m_layoutInfo.pageBreakHeight);
                            og.translate(this.PRINTING_MARGIN, -y + this.PRINTING_MARGIN);
                            this.renderToPrinter(og);
                            Image scaledImg = offscreen.getScaledInstance(pageDim.width, pageDim.height, 8);
                            g.drawImage(scaledImg, 0, 0, null);
                            g.dispose();
                            scaledImg.flush();
                            offscreen.flush();
                        } else {
                            Tracer.This.println("printing page : " + i + 1 + " of " + nPages);
                            int y = i * (this.m_layoutInfo.pageHeight + this.m_layoutInfo.pageBreakHeight);
                            g.translate(this.PRINTING_MARGIN, -y + this.PRINTING_MARGIN);
                            this.renderToPrinter(g);
                            Tracer.This.println("after render to printer");
                            g.dispose();
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                Tracer.This.println("Exception in printing: " + e.getMessage());
                Object var15_17 = null;
                this.m_layoutInfo.bPaginate = false;
                this.layoutViews(this.getPaneWidth());
                return;
            }
            Object var15_16 = null;
            this.m_layoutInfo.bPaginate = false;
            this.layoutViews(this.getPaneWidth());
            return;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.m_layoutInfo.bPaginate = false;
            this.layoutViews(this.getPaneWidth());
            throw throwable;
        }
    }

    private void printViewTree(View v, int index) {
        String indent = "";
        int i = 0;
        while (i < index) {
            indent = indent + ' ';
            ++i;
        }
        String name = v.getClass().getName();
        HTMLPane.toLog(indent + name, 0);
        index += 2;
        int cnt = v.m_children.length;
        int i2 = 0;
        while (i2 < cnt) {
            this.printViewTree(v.m_children[i2], index);
            ++i2;
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.m_rootView == null) {
            return;
        }
        if (e.getID() == 401 && e.getKeyCode() == 9) {
            if (this.m_document != null) {
                Enumeration enumeration = this.m_document.getAnchors();
                if (this.m_props.focusElement != null) {
                    boolean bFound = false;
                    while (enumeration.hasMoreElements()) {
                        Element elem = (Element)enumeration.nextElement();
                        if (this.m_props.focusElement.getType() == 50 && elem == this.m_props.focusElement) {
                            bFound = true;
                            break;
                        }
                        if (elem.m_relatedElements.size() <= 0 || this.m_props.focusElement != elem.m_relatedElements.elementAt(0)) continue;
                        bFound = true;
                        break;
                    }
                    if (enumeration.hasMoreElements()) {
                        this.setAnchorFocus((Element)enumeration.nextElement());
                    } else {
                        this.clearFocusElement();
                    }
                } else {
                    Element anchor = null;
                    while (enumeration.hasMoreElements()) {
                        anchor = (Element)enumeration.nextElement();
                        if (anchor.m_relatedElements.size() > 0) break;
                    }
                    if (anchor != null) {
                        this.setAnchorFocus(anchor);
                    }
                }
                if (this.m_props.focusElement != null) {
                    this.scrollToVisible(this.m_props.focusElement.m_p0);
                }
                e.consume();
            }
        } else if (e.getID() == 401 && e.getKeyCode() == 36 && (e.getModifiers() & 2) > 0) {
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        } else if (e.getID() == 401 && e.getKeyCode() == 35 && (e.getModifiers() & 2) > 0) {
            this.scrollRectToVisible(new Rectangle(0, this.m_rootView.getBounds().y + this.m_rootView.getBounds().height - 1, 1, 1));
        } else if (e.getID() == 401 && e.getKeyCode() == 10) {
            URL u;
            if (this.m_props.focusElement != null && this.m_props.focusElement.isLink() && (u = Utilities.getURL(this.m_document.getBaseURL(), (String)this.m_props.focusElement.getAttribute("href"))) != null) {
                this.smartLoadPage(u, true);
            }
            e.consume();
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        boolean bRepaint;
        if (this.m_bParsing) {
            return;
        }
        super.processMouseEvent(evt);
        int x = evt.getX();
        int y = evt.getY();
        if (evt.getID() == 501) {
            this.requestFocus();
        }
        boolean bl = bRepaint = (evt.getModifiers() & 0x10) == 16;
        if (evt.getID() == 502) {
            if (this.lastLink != null) {
                this.notifyMousePressedOverLink(null);
            }
            return;
        }
        if (evt.isPopupTrigger() && this.m_props.loadedPage != null) {
            if (this.notifyStatusListeners(8, this.m_props.loadedPage)) {
                this.m_props.popup.show(this, evt.getX(), evt.getY());
            }
        } else if (evt.getID() == 501 && (evt.getModifiers() & 0x10) > 0) {
            if (this.m_props.popup != null && this.m_props.popup.isShowing()) {
                this.m_props.popup.setVisible(false);
            }
            bRepaint = this.m_props.selectStartPosition != -1 && this.m_props.selectEndPosition != -1;
            this.m_props.selectStartPosition = -1;
            this.m_props.selectEndPosition = -1;
            MyModelInfo info = this.getModelInfo(x, y);
            if (info.m_ev != null && info.m_ev.m_elem != null) {
                this.m_props.selectStartPosition = info.m_ev.m_elem.m_textbufferPosition;
            }
            this.clearFocusElement();
            if (info.url != null) {
                this.notifyMouseOverLink(info.url);
                this.m_props.focusElement = info.m_ev.m_elem;
                this.m_props.focusElement.propagateFocus(true);
                this.repaint();
            }
        } else if (evt.getID() == 502 && (evt.getModifiers() & 0x10) > 0) {
            MyModelInfo info = this.getModelInfo(x, y);
            if (info.m_ev == null) {
                return;
            }
            if (info.m_ev.m_elem != null && info.m_ev.m_elem.m_textbufferPosition != -1) {
                this.m_props.selectEndPosition = info.m_ev.m_elem.m_textbufferPosition;
            }
            this.imageMapHitTest(evt, info);
            if (info.url != null) {
                boolean bLoad = false;
                if (info.url != null) {
                    bLoad = this.notifyMousePressedOverLink(info.url);
                }
                if (bLoad && this.m_props.bIsFrame && this.m_props.framesetView != null && info.target != null) {
                    HTMLPane pane = this.m_props.framesetView.getFrame(info.target);
                    if (pane != null) {
                        pane.smartLoadPage(info.url, false);
                        pane.repaint();
                        return;
                    }
                    Container parent = this.getParent();
                    while (parent != null) {
                        if (parent instanceof HTMLPane) {
                            ((HTMLPane)parent).smartLoadPage(info.url, false);
                            return;
                        }
                        parent = parent.getParent();
                    }
                }
                if (bLoad) {
                    this.smartLoadPage(info.url, true);
                }
            }
            this.clearFocusElement();
        }
        if (bRepaint || this.m_props.selectEndPosition != -1 && this.m_props.selectStartPosition != -1) {
            this.repaint();
        }
        if (evt.getID() == 506) {
            Tracer.This.println("repainted");
            this.repaint();
        }
    }

    protected void processMouseMotionEvent(MouseEvent evt) {
        String tipText;
        boolean bDragging;
        if (this.m_bParsing) {
            return;
        }
        super.processMouseMotionEvent(evt);
        MyModelInfo info = this.getModelInfo(evt.getX(), evt.getY());
        if (info == null || info.m_ev == null || info.m_ev.m_elem == null || info.m_ev.m_view == null) {
            return;
        }
        this.imageMapHitTest(evt, info);
        boolean bl = bDragging = evt.getID() == 506 && (evt.getModifiers() & 0x10) > 0;
        if (bDragging && info.m_ev.m_elem.m_textbufferPosition != -1) {
            if (this.m_props.selectStartPosition == -1) {
                this.m_props.selectStartPosition = info.m_ev.m_elem.m_textbufferPosition;
            } else {
                this.m_props.selectEndPosition = info.m_ev.m_elem.m_textbufferPosition;
            }
            if (this.m_props.selectEndPosition != -1 && this.m_props.selectStartPosition != -1) {
                this.repaint();
            }
        }
        this.m_toolTip.hide();
        if (this.m_preferences.bShowToolTip && (tipText = info.m_ev.m_view.getToolTipText()) != null && !Utilities.isBlankSpaces(tipText)) {
            Point p = this.getLocationOnScreen();
            this.m_toolTip.text = tipText;
            this.m_toolTip.setLocation(p.x + evt.getX() + 15, p.y + evt.getY() + 15);
            this.m_toolTip.show();
        }
        this.lastLink = null;
        if (info.m_ev.m_view.isLink()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            if (info.m_ev != null && info.m_ev.m_elem != null && info.m_ev.m_elem.getAttribute("href") != null) {
                this.lastLink = "" + info.m_ev.m_elem.getAttribute("href");
                Tracer.This.println("Lastlink set:" + this.lastLink);
            }
        } else if (info.m_ev.m_elem.getType() == 9) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.notifyMouseOverLink(info.url);
    }

    public void reLoadPage() {
        if (this.m_props.loadedPage != null) {
            this.loadPage(this.m_props.loadedPage, false);
        }
    }

    protected void renderToPrinter(Graphics g) {
        Rectangle clip = g.getClipRect();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.m_rootView != null) {
            this.m_rootView.paint(g, clip);
            Enumeration e = this.m_props.floaters.elements();
            while (e.hasMoreElements()) {
                View v = (View)e.nextElement();
                Rectangle r = v.getBounds();
                if (r == null) continue;
                v.paint(g, r);
            }
        }
    }

    private void scrollToPosition(int pos) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof HTMLWindow) {
                ((HTMLWindow)parent).scrollToPosition(pos);
                return;
            }
            parent = parent.getParent();
        }
    }

    private void scrollToVisible(int pos) {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof HTMLWindow) {
                ((HTMLWindow)parent).scrollToVisible(pos);
                return;
            }
            parent = parent.getParent();
        }
    }

    public void setAlwaysSizableFrames(boolean bSizable) {
        this.m_preferences.bAlwaysSizableFrames = bSizable;
    }

    private void setAnchorFocus(Element anchor) {
        this.clearFocusElement();
        if (anchor.getType() == 50) {
            this.m_props.focusElement = anchor;
            anchor.setDrawFocusBox(true);
        } else {
            Element[] relates = anchor.getRelatedElements();
            if (relates.length > 0) {
                this.m_props.focusElement = relates[0];
                this.m_props.focusElement.setDrawFocusBox(true);
                this.m_props.focusElement.propagateDrawFocusBox(true);
            }
        }
        this.repaint();
    }

    public void setDefaultFont(Font f) {
        if (f != null) {
            this.m_props.m_defaultFont = f;
        }
    }

    public void setFramesEnabled(boolean bEnable) {
        this.m_preferences.bFramesEnabled = bEnable;
    }

    public void setIFramesEnabled(boolean bEnable) {
        this.m_preferences.bIFramesEnabled = bEnable;
    }

    protected void setMargins(int width, int height) {
        this.m_props.marginWidth = width;
        this.m_props.marginHeight = height;
    }

    public void setPopupMenu(JPopupMenu menu) {
        if (this.m_props.popup != null) {
            this.remove(this.m_props.popup);
        }
        this.m_props.popup = menu;
        this.add(this.m_props.popup);
    }

    public void setPrintingLayoutWidth(int width) throws Exception {
        if (width <= 500) {
            throw new Exception("Minimum printing layout width is 500 pixels!");
        }
        this.m_props.printingLayoutWidth = width;
    }

    public void setProgressiveDisplay(boolean bProgressive) {
        this.m_preferences.bProgressiveDisplay = bProgressive;
    }

    public void setSize(Dimension d) {
        this.lock();
        if (this.m_rootView != null) {
            if (d.width != this.m_rootView.getBounds().width) {
                this.layoutViews(d.width);
            }
            super.setSize(this.m_rootView.getBounds().width, this.m_rootView.getBounds().height);
            this.unlock();
            return;
        }
        super.setSize(d);
        this.unlock();
    }

    public void setViewFactory(ViewFactory factory) {
        this.m_viewFactory = factory;
    }

    protected void smartLoadPage(URL u, boolean bAddToHistory) {
        String urlStr;
        int idx;
        if (this.m_document != null && (idx = (urlStr = u.toString()).indexOf("#")) != -1) {
            Element e;
            String anchorName = urlStr.substring(idx + 1);
            urlStr = urlStr.substring(0, idx);
            URL newURL = Utilities.getURL(urlStr);
            if (this.m_props.loadedPage != null && this.m_props.loadedPage.equals(newURL) && (e = this.m_document.getAnchor(anchorName)) != null && e.m_p0 >= 0) {
                this.scrollToPosition(e.m_p0);
                return;
            }
        }
        this.loadPage(u, bAddToHistory);
    }

    public void stop() {
        if (this.m_parsingThread != null && this.m_parsingThread.isAlive()) {
            this.m_parsingThread.interrupt();
            this.m_parsingThread = null;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.notifyStatusListeners(9, this.m_props.loadedPage);
    }

    public void syncOpenPage(URL u) throws IOException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_toolTip.hide();
        this.m_props.selectStartPosition = -1;
        this.m_props.selectEndPosition = -1;
        URLConnection con = u.openConnection();
        String contentType = con.getContentType();
        if (this.notifyStatusListeners(6, contentType)) {
            Element root;
            this.beginParsing(con);
            if (this.m_document != null && (root = this.m_document.getRootElement()) != null) {
                Element elem;
                String urlStr;
                int idx;
                this.createViews(root);
                this.m_props.loadedPage = this.m_document.getURL();
                this.notifyStatusListeners(5, this.m_props.loadedPage);
                this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                if (this.m_props.loadedPage != null && (idx = (urlStr = this.m_props.loadedPage.toString()).indexOf("#")) != -1 && (elem = this.m_document.getAnchor(urlStr.substring(idx + 1))) != null && elem.m_p0 >= 0) {
                    this.scrollToPosition(elem.m_p0);
                }
                this.forceLayout();
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void syncOpenPage(Reader r, URL u) throws IOException {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_toolTip.hide();
        this.m_props.selectStartPosition = -1;
        this.m_props.selectEndPosition = -1;
        if (this.notifyStatusListeners(6, "")) {
            Element root;
            this.beginParsing(r, u);
            if (this.m_document != null && (root = this.m_document.getRootElement()) != null) {
                Element elem;
                String urlStr;
                int idx;
                this.createViews(root);
                this.m_props.loadedPage = this.m_document.getURL();
                this.notifyStatusListeners(5, this.m_props.loadedPage);
                this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                if (this.m_props.loadedPage != null && (idx = (urlStr = this.m_props.loadedPage.toString()).indexOf("#")) != -1 && (elem = this.m_document.getAnchor(urlStr.substring(idx + 1))) != null && elem.m_p0 >= 0) {
                    this.scrollToPosition(elem.m_p0);
                }
                this.forceLayout();
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void toLog(String str, int nIndent) {
        if (pwOut == null) {
            try {
                String dir = System.getProperty("user.dir");
                FileOutputStream fOut = new FileOutputStream(dir + "\\viewtree.log");
                pwOut = new PrintWriter(fOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nIndent > 0) {
            indent += nIndent;
        }
        String identStr = "";
        int i = 0;
        while (i < indent) {
            identStr = identStr + " ";
            ++i;
        }
        pwOut.println(identStr + str);
        if (nIndent < 0) {
            indent += nIndent;
        }
    }

    public void unLoadPage() {
        this.removeAll();
        this.m_document = null;
        this.m_rootView = null;
        this.m_props.floaters.removeAllElements();
        this.m_props.selectStartPosition = -1;
        this.m_props.selectEndPosition = -1;
        this.repaint();
    }

    void unlock() {
        this.m_busyflag.freeBusyFlag();
    }

    public Element viewToModel(int x, int y) {
        ElementViewInfo info = this.floaterHitTest(x, y);
        if (info != null) {
            return info.m_elem;
        }
        if (this.m_rootView != null && (info = this.m_rootView.viewToModel(x, y)) != null) {
            return info.m_elem;
        }
        return null;
    }

    class RenderingThread
    implements Runnable {
        URL u;
        Reader r;

        public void run() {
            if (this.r == null && this.u != null) {
                HTMLPane.this.loadImageContent(this.u);
                HTMLPane.this.repaint();
                return;
            }
            HTMLPane.this.m_rootView = null;
            HTMLPane.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            HTMLPane.this.m_props.loadedPage = HTMLPane.this.m_document.getURL();
            if (HTMLPane.this.m_document.m_refreshURL != null) {
                try {
                    HTMLPane.this.syncOpenPage(HTMLPane.this.m_document.m_refreshURL);
                }
                catch (IOException ex) {}
            } else {
                Element elem;
                String urlStr;
                int idx;
                Element root = HTMLPane.this.m_document.getRootElement();
                if (root != null) {
                    HTMLPane.this.createViews(root);
                    HTMLPane.this.forceLayout();
                }
                HTMLPane.this.notifyStatusListeners(5, HTMLPane.this.m_props.loadedPage);
                if (HTMLPane.this.m_props.loadedPage != null && (idx = (urlStr = HTMLPane.this.m_props.loadedPage.toString()).indexOf("#")) != -1 && (elem = HTMLPane.this.m_document.getAnchor(urlStr.substring(idx + 1))) != null && elem.m_p0 >= 0) {
                    HTMLPane.this.scrollToPosition(elem.m_p0);
                }
            }
        }

        RenderingThread(Reader r, URL u) {
            this.r = r;
            this.u = u;
        }

        RenderingThread(URL u) {
            this.u = u;
        }
    }

    class ParsingThread
    implements Runnable {
        URL url;
        boolean bAddToHistory;
        Reader r;

        public void run() {
            String contentType = "";
            if (this.r != null) {
                if (HTMLPane.this.beginParsing(this.r, this.url)) {
                    if (this.bAddToHistory) {
                        HTMLPane.this.m_props.history.add(this.url);
                    }
                    SwingUtilities.invokeLater(new RenderingThread(this.r, this.url));
                }
                HTMLPane.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (this.url != null) {
                URLConnection con = null;
                try {
                    HTMLPane.this.notifyStatusListeners(0, this.url);
                    con = this.url.openConnection();
                    contentType = con.getContentType();
                }
                catch (IOException e) {
                    Tracer.This.println("Exception : " + e.getMessage());
                    HTMLPane.this.m_bParsing = false;
                    return;
                }
                if (!HTMLPane.this.notifyStatusListeners(6, contentType)) {
                    HTMLPane.this.m_bParsing = false;
                    return;
                }
                if (contentType == null) {
                    contentType = "text/html";
                }
                contentType.trim();
                if ("image/jpeg".equals(contentType) || "image/gif".equals(contentType) || "image/jpg".equals(contentType)) {
                    HTMLPane.this.loadImageContent(this.url);
                } else if (contentType.startsWith("text/html") || contentType.startsWith("text/plain")) {
                    if (HTMLPane.this.beginParsing(con)) {
                        if (this.bAddToHistory) {
                            HTMLPane.this.m_props.history.add(this.url);
                        }
                        SwingUtilities.invokeLater(new RenderingThread(null));
                    }
                } else {
                    Tracer.This.println("Invalid content type: " + contentType);
                }
                HTMLPane.this.m_bParsing = false;
            }
        }

        ParsingThread(Reader reader, URL baseURL, boolean bAddToHistory) {
            this.r = reader;
            this.url = baseURL;
            this.bAddToHistory = bAddToHistory;
        }

        ParsingThread(URL url, boolean bAddToHistory) {
            this.url = url;
            this.bAddToHistory = bAddToHistory;
        }
    }
}

