/*
 * Decompiled with CFR 0.152.
 */
package horst;

import de.netcomputing.util.Tracer;
import horst.HTMLDocument;
import horst.TextInput;
import horst.parser.Tag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.PlainDocument;

public class Utilities {
    static boolean m_bDebugging;
    static Color _brightColor;
    static Color _darkColor;

    public static final void addComponent(Container con, Component comp, int anchor, int fill, int gridheight, int gridwidth, int gridx, int gridy, Insets insets, int ipadx, int ipady, double weightx, double weighty) {
        GridBagLayout gridbag = (GridBagLayout)con.getLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = anchor;
        c.fill = fill;
        c.gridheight = gridheight;
        c.gridwidth = gridwidth;
        c.gridx = gridx;
        c.gridy = gridy;
        c.insets = insets;
        c.ipadx = ipadx;
        c.ipady = ipady;
        c.weightx = weightx;
        c.weighty = weighty;
        gridbag.setConstraints(comp, c);
        con.add(comp);
    }

    public static final int[] clone(int[] ary) {
        int[] copy = new int[ary.length];
        int i = 0;
        while (i < copy.length) {
            copy[i] = ary[i];
            ++i;
        }
        return copy;
    }

    static final Component createFormComponent(HTMLDocument doc, Tag t) {
        JComponent c = null;
        if (t.getID() == 30) {
            String type = (String)t.getAttribute("type");
            if (type == null) {
                c = new TextInput();
                Utilities.setFieldAttributes(t, c);
                return c;
            }
            if (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("reset") || type.equalsIgnoreCase("button")) {
                String value = (String)t.getAttribute("value");
                if (value == null) {
                    value = type.equalsIgnoreCase("submit") ? "submit" : "reset";
                }
                JButton button = new JButton(value);
                Dimension prefSize = button.getPreferredSize();
                prefSize.height = Utilities.getButtonHeight();
                button.setPreferredSize(prefSize);
                button.setOpaque(true);
                c = button;
            } else if (type.equalsIgnoreCase("image")) {
                JButton button;
                String src = (String)t.getAttribute("src");
                try {
                    URL base = doc.getBaseURL();
                    URL srcURL = new URL(base, src);
                    ImageIcon icon = new ImageIcon(srcURL);
                    button = new JButton(icon);
                    button.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                    button.setMargin(new Insets(0, 0, 0, 0));
                    button.setOpaque(false);
                    button.setBorderPainted(false);
                }
                catch (MalformedURLException ex) {
                    button = new JButton();
                }
                c = button;
            } else if (type.equalsIgnoreCase("checkbox")) {
                c = new JCheckBox();
                if (t.isAttributeDefined("checked")) {
                    ((JCheckBox)c).setSelected(true);
                }
                ((JCheckBox)c).setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                ((JCheckBox)c).setOpaque(false);
            } else if (type.equalsIgnoreCase("radio")) {
                c = new JRadioButton();
                if (t.isAttributeDefined("checked")) {
                    ((JRadioButton)c).setSelected(true);
                }
                ((JRadioButton)c).setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
                ((JRadioButton)c).setOpaque(false);
            } else if (type.equalsIgnoreCase("text")) {
                c = new TextInput();
                Utilities.setFieldAttributes(t, c);
            } else if (type.equalsIgnoreCase("password")) {
                c = new TextInput();
                Utilities.setFieldAttributes(t, c);
            }
        } else if (t.getID() == 32) {
            Integer val;
            String rowStr;
            Integer val2;
            int columns = 10;
            int rows = 10;
            String colStr = (String)t.getAttribute("cols");
            if (colStr != null && (val2 = Utilities.getInteger(colStr)) != null && val2 > 0) {
                columns = val2;
            }
            if ((rowStr = (String)t.getAttribute("rows")) != null && (val = Utilities.getInteger(rowStr)) != null && val > 0) {
                rows = val;
            }
            PlainDocument d = new PlainDocument();
            JTextArea ta = new JTextArea(d, "", rows, columns);
            ta.setLineWrap(true);
            c = ta;
        } else {
            c = new TextInput();
            Utilities.setFieldAttributes(t, c);
        }
        return c;
    }

    public static final Shape createShape(String name, String coordinates) {
        Shape s = null;
        StringTokenizer st = new StringTokenizer(coordinates, ", ", false);
        if (name != null && name.equalsIgnoreCase("rect") || name == null && st.countTokens() == 4) {
            Rectangle r;
            s = r = new Rectangle();
            int nCount = 0;
            while (st.hasMoreTokens()) {
                Integer iVal = Utilities.getInteger(st.nextToken());
                if (iVal == null) continue;
                switch (nCount) {
                    default: {
                        break;
                    }
                    case 0: {
                        r.x = iVal;
                        ++nCount;
                        break;
                    }
                    case 1: {
                        r.y = iVal;
                        ++nCount;
                        break;
                    }
                    case 2: {
                        r.width = iVal - r.x;
                        ++nCount;
                        break;
                    }
                    case 3: {
                        r.height = iVal - r.y;
                        ++nCount;
                    }
                }
            }
        } else {
            Vector<Integer> xVector = new Vector<Integer>();
            Vector<Integer> yVector = new Vector<Integer>();
            boolean bIsXVal = true;
            while (st.hasMoreTokens()) {
                Integer iVal = Utilities.getInteger(st.nextToken());
                if (iVal == null) continue;
                if (bIsXVal) {
                    xVector.addElement(iVal);
                } else {
                    yVector.addElement(iVal);
                }
                boolean bl = bIsXVal = !bIsXVal;
            }
            int nPoints = Math.min(xVector.size(), yVector.size());
            int[] xPoints = new int[nPoints];
            int[] yPoints = new int[nPoints];
            int i = 0;
            while (i < xPoints.length) {
                xPoints[i] = (Integer)xVector.elementAt(i);
                ++i;
            }
            int i2 = 0;
            while (i2 < yPoints.length) {
                yPoints[i2] = (Integer)yVector.elementAt(i2);
                ++i2;
            }
            s = new Polygon(xPoints, yPoints, nPoints);
        }
        return s;
    }

    static final void debugOut(String msg) {
        if (m_bDebugging) {
            Tracer.This.println(msg);
        }
    }

    static final void drawBorder(Graphics g, Rectangle r) {
        g.setColor(_brightColor);
        g.drawLine(r.x, r.y + r.height - 1, r.x + r.width - 1, r.y + r.height - 1);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width - 1, r.y + r.height - 1);
        g.setColor(_darkColor);
        g.drawLine(r.x, r.y, r.x + r.width - 1, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + r.height - 1);
    }

    public static final void drawDottedLine(Graphics g, int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            if (y1 > y2) {
                int temp = y2;
                y2 = y1;
                y1 = temp;
            }
            if ((x1 & 1 ^ y1 & 1) != 0) {
                ++y1;
            }
            while (y1 < y2) {
                g.drawLine(x1, y1, x1, y1);
                y1 += 2;
            }
            return;
        }
        if (y1 != y2) {
            throw new IllegalArgumentException("Only horizonatl and Vertical Lines");
        }
        if (y1 > y2) {
            int temp = y2;
            y2 = y1;
            y1 = temp;
        }
        if ((x1 & 1 ^ y1 & 1) != 0) {
            ++x1;
        }
        while (x1 < x2) {
            g.drawLine(x1, y1, x1, y1);
            x1 += 2;
        }
    }

    public static final void drawDottedRectangle(Graphics g, int x, int y, int w, int h) {
        int x2 = x + w;
        int y2 = y + h;
        Utilities.drawDottedLine(g, x, y, x2, y);
        Utilities.drawDottedLine(g, x2, y, x2, y2);
        Utilities.drawDottedLine(g, x, y2, x2, y2);
        Utilities.drawDottedLine(g, x, y, x, y2);
    }

    public static final void drawFocusBorder(Graphics g, Rectangle r) {
        g.setColor(Color.orange);
        int i = 0;
        while (i < 2) {
            g.drawRect(r.x + i, r.y + i, r.width - 2 * i, r.height - 2 * i);
            ++i;
        }
    }

    static final Color getBrightBorderColor() {
        return _brightColor;
    }

    static final int getButtonHeight() {
        return 25;
    }

    static final Color getDarkBorderColor() {
        return _darkColor;
    }

    public static final Frame getFrame(Component c) {
        if (c instanceof Frame) {
            return (Frame)c;
        }
        Frame frame = null;
        Container parent = c.getParent();
        while (parent != null && !(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        frame = parent != null ? (Frame)parent : new Frame();
        return frame;
    }

    static final Integer getInteger(String val) {
        Integer i = null;
        try {
            i = new Integer(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    public static final String getInternetFormat(String str) {
        String s = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            s = c == '\\' ? s + "/" : s + c;
            ++i;
        }
        return s;
    }

    static final URL getURL(String src) {
        URL u = null;
        try {
            u = new URL(src);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u;
    }

    static final URL getURL(URL baseURL, String src) {
        URL u = null;
        try {
            u = new URL(baseURL, src);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return u;
    }

    static final Color hexToColor(String value) {
        if (value.startsWith("#")) {
            String digits = value.substring(1, Math.min(value.length(), 7));
            String hstr = "0x" + digits;
            try {
                Color c = Color.decode(hstr);
                return c;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static final boolean isBlank(char[] data) {
        int len = data.length;
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final boolean isBlankSpaces(String txt) {
        if (txt == null || txt.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < txt.length()) {
            if (txt.charAt(i) != ' ' && txt.charAt(i) != '\n') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static final Image loadImage(Component c, String path) {
        Image i = Toolkit.getDefaultToolkit().getImage(path);
        if (i == null) {
            return i;
        }
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(i, 0);
        try {
            tracker.waitForID(0);
            if (tracker.isErrorAny()) {
                return null;
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return i;
    }

    static final Integer parseInteger(String s, char c) {
        Integer i = null;
        int index = s.indexOf(c);
        if (index != -1) {
            try {
                s = s.substring(0, index).trim();
                i = new Integer(s);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return i;
    }

    static final String removeTrailingBackslashes(String text) {
        while (text.endsWith("/")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    static final int setAlignmentProperty(boolean bVertical, int defaultAlignment, Object key, Hashtable hash) {
        String val = (String)hash.get(key);
        if (val != null) {
            if (bVertical) {
                if (val.toLowerCase().equals("top")) {
                    return 0;
                }
                if (val.toLowerCase().equals("bottom")) {
                    return 2;
                }
            } else {
                if (val.toLowerCase().equals("right")) {
                    return 2;
                }
                if (val.toLowerCase().equals("left")) {
                    return 0;
                }
                if (val.toLowerCase().equals("center") || val.toLowerCase().equals("middle")) {
                    return 1;
                }
            }
        }
        return defaultAlignment;
    }

    static final boolean setBooleanProperty(boolean defaultVal, Object key, Hashtable hash) {
        String src = (String)hash.get(key);
        if (src != null) {
            if (src.equalsIgnoreCase("yes") || src.equalsIgnoreCase("true") || src.equalsIgnoreCase("1")) {
                return true;
            }
            if (src.equalsIgnoreCase("no") || src.equalsIgnoreCase("false") || src.equalsIgnoreCase("0")) {
                return false;
            }
        }
        return defaultVal;
    }

    static final Color setColorProperty(Color defaultColor, Object key, Hashtable hash) {
        Object val = hash.get(key);
        if (val == null) {
            return defaultColor;
        }
        if (val instanceof Color) {
            return (Color)val;
        }
        String str = (String)val;
        Color c = null;
        if (str != null) {
            c = Utilities.stringToColor(str);
        }
        return c == null ? defaultColor : c;
    }

    private static final void setFieldAttributes(Tag t, TextInput field) {
        String value;
        Integer iVal;
        Integer iVal2;
        field.setFont(new Font("Courier", 0, 12));
        field.setOpaque(true);
        int size = 20;
        String len = (String)t.getAttribute("maxlength");
        if (len != null && (iVal2 = Utilities.getInteger(len)) != null && iVal2 > 0) {
            size = iVal2;
        }
        field.setColumns(size);
        String sz = (String)t.getAttribute("size");
        if (sz != null && (iVal = Utilities.getInteger(sz)) != null && iVal > 0) {
            int h = Utilities.getButtonHeight();
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(field.getFont());
            int w = iVal * field.getColumnWidth();
            field.setPreferredSize(new Dimension(w, h));
        }
        if ((value = (String)t.getAttribute("value")) != null) {
            field.setText(value);
        }
    }

    static final int setIntegerProperty(int defaultVal, Object key, Hashtable hash) {
        Integer iVal;
        String val = (String)hash.get(key);
        if (val != null && val.length() > 0 && (iVal = Utilities.getInteger(val)) != null && iVal >= 0) {
            return iVal;
        }
        return defaultVal;
    }

    static final float setPercentageProperty(float defaultVal, Object key, Hashtable hash) {
        Integer val;
        int idx;
        String src = (String)hash.get(key);
        if (src != null && (idx = src.indexOf(37)) != -1 && (val = Utilities.getInteger(src.substring(0, idx))) != null && val > 0 && val <= 100) {
            return (float)val.intValue() / 100.0f;
        }
        return defaultVal;
    }

    static final URL setURLProperty(URL baseURL, Object key, Hashtable hash) {
        URL u = null;
        String src = (String)hash.get(key);
        if (src != null && src.length() > 0) {
            u = baseURL != null ? Utilities.getURL(baseURL, src) : Utilities.getURL(src);
        }
        return u;
    }

    static final Color stringToColor(String str) {
        if (str == null | str.length() == 0) {
            return null;
        }
        Color color = null;
        color = str.charAt(0) == '#' ? Utilities.hexToColor(str) : (str.equals("orange") ? Color.orange : (str.equals("magenta") ? Color.magenta : (str.equals("darkmagenta") ? Color.magenta.darker() : (str.equalsIgnoreCase("gold") ? Color.orange : (str.equalsIgnoreCase("Black") ? Utilities.hexToColor("#000000") : (str.equalsIgnoreCase("Silver") ? Utilities.hexToColor("#C0C0C0") : (str.equalsIgnoreCase("Gray") ? Utilities.hexToColor("#808080") : (str.equalsIgnoreCase("White") ? Utilities.hexToColor("#FFFFFF") : (str.equalsIgnoreCase("Maroon") ? Utilities.hexToColor("#800000") : (str.equalsIgnoreCase("Red") ? Utilities.hexToColor("#FF0000") : (str.equalsIgnoreCase("Purple") ? Utilities.hexToColor("#800080") : (str.equalsIgnoreCase("Fuchsia") ? Utilities.hexToColor("#FF00FF") : (str.equalsIgnoreCase("Green") ? Utilities.hexToColor("#008000") : (str.equalsIgnoreCase("Lime") ? Utilities.hexToColor("#00FF00") : (str.equalsIgnoreCase("Olive") ? Utilities.hexToColor("#808000") : (str.equalsIgnoreCase("Yellow") ? Utilities.hexToColor("#FFFF00") : (str.equalsIgnoreCase("Navy") ? Utilities.hexToColor("#000080") : (str.equalsIgnoreCase("Blue") ? Utilities.hexToColor("#0000FF") : (str.equalsIgnoreCase("Teal") ? Utilities.hexToColor("#008080") : (str.equalsIgnoreCase("Aqua") ? Utilities.hexToColor("#00FFFF") : Utilities.hexToColor("#" + str)))))))))))))))))))));
        return color;
    }

    static {
        _brightColor = Utilities.stringToColor("#dcdcdc");
        _darkColor = _brightColor.darker().darker();
    }
}

