/*
 * Decompiled with CFR 0.152.
 */
package jazzware.freestyle;

import java.awt.Point;
import java.awt.Polygon;

public class JW2DMatrix {
    public static final double PI2 = Math.PI * 2;
    public double[] val = new double[6];
    public JW2DMatrix reversed = null;

    public JW2DMatrix() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public JW2DMatrix(double a11, double a12, double a13, double a21, double a22, double a23) {
        this.val[0] = a11;
        this.val[1] = a12;
        this.val[2] = a13;
        this.val[3] = a21;
        this.val[4] = a22;
        this.val[5] = a23;
    }

    public JW2DMatrix(double[] values) {
        this(values[0], values[1], values[2], values[3], values[4], values[5]);
    }

    public JW2DMatrix(JW2DMatrix matrix) {
        this(matrix.val);
        this.reversed = matrix.reversed;
    }

    public JW2DMatrix reset(double a11, double a12, double a13, double a21, double a22, double a23) {
        this.val[0] = a11;
        this.val[1] = a12;
        this.val[2] = a13;
        this.val[3] = a21;
        this.val[4] = a22;
        this.val[5] = a23;
        return this;
    }

    public JW2DMatrix reset() {
        return this.reset(1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
    }

    public JW2DMatrix rotate(double radians) {
        this.reversed = null;
        double sin = Math.sin(radians);
        double cos = Math.cos(radians);
        double[] val = this.val;
        this.val = new double[6];
        this.val[0] = cos * val[0] - sin * val[3];
        this.val[1] = cos * val[1] - sin * val[4];
        this.val[2] = cos * val[2] - sin * val[5];
        this.val[3] = cos * val[3] + sin * val[0];
        this.val[4] = cos * val[4] + sin * val[1];
        this.val[5] = cos * val[5] + sin * val[2];
        return this;
    }

    public JW2DMatrix rotate(int degrees) {
        return this.rotate((double)degrees * (Math.PI * 2) / 360.0);
    }

    public JW2DMatrix translate(double x, double y) {
        this.reversed = null;
        this.val[2] = this.val[2] + x;
        this.val[5] = this.val[5] + y;
        return this;
    }

    public JW2DMatrix translate(int x, int y) {
        return this.translate((double)x, (double)y);
    }

    public JW2DMatrix scale(double x, double y) {
        this.reversed = null;
        this.val[0] = this.val[0] * x;
        this.val[1] = this.val[1] * x;
        this.val[2] = this.val[2] * x;
        this.val[3] = this.val[3] * y;
        this.val[4] = this.val[4] * y;
        this.val[5] = this.val[5] * y;
        return this;
    }

    public JW2DMatrix scale(double factor) {
        return this.scale(factor, factor);
    }

    public static double[] concatenate(double[] val1, double[] val2) {
        double[] val = new double[]{val2[0] * val1[0] + val2[1] * val1[3], val2[0] * val1[1] + val2[1] * val1[4], val2[0] * val1[2] + val2[1] * val1[5] + val2[2], val2[3] * val1[0] + val2[4] * val1[3], val2[3] * val1[1] + val2[4] * val1[4], val2[3] * val1[2] + val2[4] * val1[5] + val2[5]};
        return val;
    }

    public static JW2DMatrix concatenate(JW2DMatrix mtx1, JW2DMatrix mtx2) {
        return new JW2DMatrix(JW2DMatrix.concatenate(mtx1.val, mtx2.val));
    }

    public JW2DMatrix append(double[] val) {
        this.reversed = null;
        this.val = JW2DMatrix.concatenate(this.val, val);
        return this;
    }

    public JW2DMatrix append(JW2DMatrix matrix) {
        return this.append(matrix.val);
    }

    public JW2DMatrix prepend(double[] val) {
        this.reversed = null;
        this.val = JW2DMatrix.concatenate(val, this.val);
        return this;
    }

    public JW2DMatrix prepend(JW2DMatrix matrix) {
        return this.prepend(matrix.val);
    }

    public double transformX(double x, double y) {
        return this.val[0] * x + this.val[1] * y + this.val[2];
    }

    public double transformY(double x, double y) {
        return this.val[3] * x + this.val[4] * y + this.val[5];
    }

    public int transformX(int x, int y) {
        return (int)(this.transformX((double)x, (double)y) + 0.5);
    }

    public int transformY(int x, int y) {
        return (int)(this.transformY((double)x, (double)y) + 0.5);
    }

    public void transform(Polygon p) {
        int n = 0;
        while (n < p.npoints) {
            int xx = this.transformX(p.xpoints[n], p.ypoints[n]);
            p.ypoints[n] = this.transformY(p.xpoints[n], p.ypoints[n]);
            p.xpoints[n] = xx;
            ++n;
        }
    }

    public Point transform(Point point) {
        return new Point(this.transformX(point.x, point.y), this.transformY(point.x, point.y));
    }

    public JW2DMatrix getReversed() {
        if (this.reversed != null) {
            return this.reversed;
        }
        double det = this.val[0] * this.val[4] - this.val[1] * this.val[3];
        if (Math.abs(det) < Math.abs(1.0E-8 * this.val[0] * this.val[4])) {
            return null;
        }
        this.reversed = new JW2DMatrix(this.val[4] / det, this.val[1] / det, (this.val[1] * this.val[5] - this.val[4] * this.val[2]) / det, this.val[3] / det, this.val[0] / det, (this.val[0] * this.val[5] - this.val[3] * this.val[2]) / det);
        return this.reversed;
    }

    public boolean isReversible() {
        return this.getReversed() != null;
    }

    public double reverseX(double x, double y) {
        if (this.reversed == null && this.getReversed() == null) {
            return 0.0;
        }
        return this.reversed.transformX(x, y);
    }

    public double reverseY(double x, double y) {
        if (this.reversed == null && this.getReversed() == null) {
            return 0.0;
        }
        return this.reversed.transformY(x, y);
    }

    public int reverseX(int x, int y) {
        return (int)this.reverseX((double)x, (double)y);
    }

    public int reverseY(int x, int y) {
        return (int)this.reverseY((double)x, (double)y);
    }

    public Point reverse(Point point) {
        return new Point(this.reverseX(point.x, point.y), this.reverseY(point.x, point.y));
    }
}

