/*
 * Decompiled with CFR 0.152.
 */
package jazzware.freestyle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import java.util.Vector;
import jazzware.freestyle.JWCropVisual;
import jazzware.freestyle.JWUtil;

public class JWBasicICP
implements ImageProducer,
ImageConsumer,
ImageObserver,
JWCropVisual {
    protected int[] pixels = null;
    protected int width;
    protected int height;
    protected int length;
    protected int hints;
    protected int offset;
    protected ImageProducer source;
    protected Vector consumers = new Vector();
    protected Image image;
    protected boolean finished = false;
    protected boolean producing = false;
    protected ColorModel model = ColorModel.getRGBdefault();
    protected Dimension destsize = null;

    public JWBasicICP() {
        this.init();
    }

    public JWBasicICP(ImageProducer source) {
        this();
        this.setSource(source);
    }

    public JWBasicICP(Image image) {
        this();
        this.setSource(image);
    }

    public void init() {
    }

    public void setSource(Image image) {
        if (image != null) {
            this.setDimensions(image.getWidth(this), image.getHeight(this));
            this.setSource(image.getSource());
        } else {
            this.setSource((ImageProducer)null);
        }
    }

    public void setSource(ImageProducer source) {
        this.source = source;
    }

    public void setDestinationSize(int width, int height) {
        this.destsize = new Dimension(width, height);
    }

    public Dimension getDestinationSize() {
        return this.destsize;
    }

    public ImageProducer getSource() {
        return this.source;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setPixels(int[] pixels) {
        this.pixels = pixels;
    }

    public Dimension getDimensions() {
        return new Dimension(this.width, this.height);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean grabPixels() {
        return this.grabPixels(0L, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean grabPixels(long timeout, boolean forced) {
        if (!forced && this.finished && this.pixels != null && this.pixels.length == this.length) {
            return true;
        }
        if (this.source == null) {
            return false;
        }
        long end = timeout + System.currentTimeMillis();
        this.finished = false;
        this.source.startProduction(this);
        if (this.finished) return this.finished;
        try {
            if (timeout == 0L) {
                this.wait();
                return this.finished;
            }
            while (true) {
                if (this.finished) {
                    return this.finished;
                }
                timeout = end - System.currentTimeMillis();
                if (timeout <= 0L) return this.finished;
                this.wait(timeout);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return this.finished;
    }

    public Color getColor(double x, double y) {
        return this.getColor((int)(x * (double)this.width), (int)(y * (double)this.height));
    }

    public Color getColor(int x, int y) {
        return new Color(this.getRGB(x, y));
    }

    public int getRGB(int x, int y) {
        if (this.width <= 0 || this.height <= 0 || this.pixels == null || x + y * this.width < 0 || x > this.pixels.length) {
            return 0;
        }
        return this.pixels[x];
    }

    public Image createImage() {
        return Toolkit.getDefaultToolkit().createImage(this);
    }

    protected void preProduction() {
        this.offset = 0;
    }

    protected int[] produceLine(int y) {
        this.offset = y * this.width;
        return this.pixels;
    }

    protected void producePixels(ImageConsumer[] dest) {
        int idx = 0;
        while (idx < dest.length) {
            dest[idx].setPixels(0, 0, this.width, this.height, this.model, this.pixels, 0, this.width);
            ++idx;
        }
    }

    protected void postProduction() {
    }

    public boolean producesSeperateLines() {
        return false;
    }

    public void addConsumer(ImageConsumer consumer) {
        if (consumer != null && !this.consumers.contains(consumer)) {
            this.consumers.addElement(consumer);
        }
    }

    public boolean isConsumer(ImageConsumer consumer) {
        return this.consumers.contains(consumer);
    }

    public void removeConsumer(ImageConsumer consumer) {
        this.consumers.removeElement(consumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
        this.startProduction(consumer);
    }

    public void startProduction(ImageConsumer consumer) {
        if (!this.producing) {
            this.addConsumer(consumer);
            this.startProduction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startProduction() {
        Object[] dest;
        this.producing = true;
        if (this.source != null) {
            this.grabPixels();
        }
        Vector vector = this.consumers;
        synchronized (vector) {
            if (this.consumers.size() < 1) {
                return;
            }
            dest = new ImageConsumer[this.consumers.size()];
            this.consumers.copyInto(dest);
        }
        int width = this.width;
        int height = this.height;
        if (this.destsize != null) {
            width = this.destsize.width;
            height = this.destsize.height;
        }
        int idx = 0;
        while (idx < dest.length) {
            dest[idx].setColorModel(this.model);
            dest[idx].setDimensions(width, height);
            dest[idx].setHints(30);
            ++idx;
        }
        this.preProduction();
        if (this.producesSeperateLines()) {
            int idy = 0;
            while (idy < height) {
                int[] pix = this.produceLine(idy);
                idx = 0;
                while (idx < dest.length) {
                    dest[idx].setPixels(0, idy, width, 1, this.model, pix, this.offset, width);
                    ++idx;
                }
                ++idy;
            }
        } else {
            this.producePixels((ImageConsumer[])dest);
        }
        this.postProduction();
        idx = 0;
        while (idx < dest.length) {
            dest[idx].imageComplete(3);
            ++idx;
        }
        this.producing = false;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 2) != 0 || (infoflags & 1) != 0) {
            if ((infoflags & 1) == 0) {
                width = this.width;
            }
            if ((infoflags & 2) == 0) {
                height = this.height;
            }
            this.setDimensions(width, height);
        }
        return (infoflags & 0xE0) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageComplete(int status) {
        this.finished = true;
        this.source.removeConsumer(this);
        JWBasicICP jWBasicICP = this;
        synchronized (jWBasicICP) {
            this.notifyAll();
        }
    }

    public void setColorModel(ColorModel model) {
    }

    public void setDimensions(int width, int height) {
        if (this.width != width || this.height != height) {
            this.invalidate();
        }
        this.width = width;
        this.height = height;
        this.length = width * height;
    }

    public void setHints(int hintflags) {
        this.hints = hintflags;
    }

    public void setProperties(Hashtable props) {
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pix, int offs, int scansize) {
        if (this.finished || this.pixels == null || this.pixels.length != this.length) {
            this.pixels = new int[this.length];
            this.finished = false;
        }
        y *= this.width;
        int idx = 0;
        while (offs < pix.length) {
            this.pixels[idx + x + y] = model.getRGB(pix[offs++] & 0xFF);
            if (++idx < width) continue;
            offs += scansize - width;
            y += this.width;
            idx = 0;
        }
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pix, int offs, int scansize) {
        if (this.finished || this.pixels == null || this.pixels.length != this.length) {
            this.pixels = new int[this.length];
            this.finished = false;
        }
        y *= this.width;
        int idx = 0;
        while (offs < pix.length) {
            this.pixels[idx + x + y] = model.getRGB(pix[offs++]);
            if (++idx < width) continue;
            offs += scansize - width;
            y += this.width;
            idx = 0;
        }
    }

    public void invalidatePixels() {
        this.finished = false;
    }

    public void invalidate() {
        this.image = null;
    }

    public boolean needsRepaint() {
        return this.image == null;
    }

    public Dimension minimumSize() {
        return this.destsize != null ? this.destsize : new Dimension(this.width, this.height);
    }

    public void paint(Graphics g, int width, int height) {
        this.paint(g, width, height, 0, 0, width, height);
    }

    public void paint(Graphics g, int width, int height, int x, int y, int w, int h) {
        if (this.image == null) {
            this.image = this.createImage();
        }
        if (this.image == null) {
            return;
        }
        if (x != 0 || y != 0 || w != width || h != height) {
            g = g.create(x, y, w, h);
            g.drawImage(this.image, -x, -y, JWUtil.dummyObserver);
            g.dispose();
        } else {
            g.drawImage(this.image, 0, 0, JWUtil.dummyObserver);
        }
    }

    public boolean isOpaque() {
        return false;
    }
}

