/*
 * Decompiled with CFR 0.152.
 */
package layedit;

import de.netcomputing.anyj.jwidgets.Binder;
import de.netcomputing.util.Tracer;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import layedit.IConnection;
import layedit.LayoutableComponent;
import layedit.LayoutableContainer;
import layedit.Shit;
import layedit.access.NonGuiComponent;
import layedit.swing.AddDelAction;
import layedit.swing.BopComponent;
import layedit.swing.MoveUndoAction;
import netcomputing.collections.NCArray;
import netcomputing.undo.UndoTracker;

public class LayoutController {
    public static final int TOP = 0;
    public static final int BOT = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static int HANDLESIZE = 4;
    public static int DRAWHANDLESIZE = 6;
    static final int MOVE = 2;
    static final int SHAPE = 1;
    static final int NONE = 0;
    static final int DRAGRECT = 3;
    int mode = 0;
    int startDragX = 0;
    int startDragY = 0;
    boolean mlbutton = false;
    boolean isRasterEnabled = true;
    Rectangle initialDragShape = new Rectangle();
    LayoutableComponent dragged;
    Point dragStyle;
    boolean hasBeenDragging = false;
    boolean isActiveController = false;
    public LayoutableContainer view;
    public Point grid = new Point(4, 4);
    Binder binder;
    static byte[] buff = new byte[100000];
    static NCArray clipBoard = new NCArray(10);
    static NCArray clipBoardRects = new NCArray(10);
    Object libraryRoot;
    HashMap connectionToRect = new HashMap();
    boolean isFirstDrag = true;
    Rectangle[] preDragBounds;
    LayoutableContainer[] preContainer;

    public void setLibraryRoot(Object libraryRoot) {
        this.libraryRoot = libraryRoot;
    }

    public Object getLibraryRoot() {
        return this.libraryRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object CloneBySerialization(Serializable o) {
        Object result = null;
        byte[] byArray = buff;
        synchronized (byArray) {
            try {
                Shit out = new Shit();
                ObjectOutputStream oo = new ObjectOutputStream(out);
                oo.writeObject(o);
                ObjectInputStream oi = new ObjectInputStream(new ByteArrayInputStream(buff));
                result = oi.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void translatePoint(Component now, Component newC, Point p) {
        try {
            Point act = now.getLocationOnScreen();
            Point n = newC.getLocationOnScreen();
            act.x -= n.x;
            act.y -= n.y;
            p.x += act.x;
            p.y += act.y;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    LayoutController searchActiveController() {
        LayoutController res = null;
        int n = 0;
        while (n < this.view.componentCountBop()) {
            if (this.view.at(n) instanceof LayoutableContainer) {
                res = ((LayoutableContainer)this.view.at(n)).getControllerBop().searchActiveController();
            }
            if (res != null) {
                return res;
            }
            ++n;
        }
        if (this.isActiveController() && this.view.isSelectedBop()) {
            return this;
        }
        return null;
    }

    public LayoutableContainer getTopContainer() {
        LayoutableContainer act = this.view;
        while (!act.getControllerBop().isTop()) {
            act = act.getParentBop();
        }
        return act;
    }

    public LayoutController getActiveController() {
        LayoutController res = this.searchActiveController();
        if (res == null) {
            if (this.isTop()) {
                return this;
            }
            return this.view.getParentBop().getControllerBop().getActiveController();
        }
        return res;
    }

    public void registerConnectionHotZone(Rectangle rect, Object ob) {
        this.connectionToRect.put(ob, rect);
    }

    public void removeConnectionHotZone(Object ob) {
        this.connectionToRect.remove(ob);
    }

    public void clearConnectionHotZones() {
        this.connectionToRect = new HashMap();
    }

    public IConnection findConnection(int x, int y) {
        Iterator assocs = this.connectionToRect.keySet().iterator();
        while (assocs.hasNext()) {
            IConnection assoc = (IConnection)assocs.next();
            Rectangle rect = (Rectangle)this.connectionToRect.get(assoc);
            if (!rect.contains(x, y)) continue;
            return assoc;
        }
        return null;
    }

    public void setGrid(Point grid) {
        this.grid = grid;
    }

    public Point getGrid() {
        return this.grid;
    }

    public void setIsRasterEnabled(boolean isRasterEnabled) {
        this.isRasterEnabled = isRasterEnabled;
    }

    public boolean getIsRasterEnabled() {
        return this.isRasterEnabled;
    }

    public boolean isTop() {
        return this.view.isTopBop();
    }

    public void setActiveController(boolean isActiveController) {
        if (isActiveController) {
            LayoutableContainer lc = this.view;
            while (!lc.isTopBop()) {
                lc.getParentBop().getControllerBop().deselect();
                lc = lc.getParentBop();
            }
            lc = this.view;
            this.isActiveController = isActiveController;
            while (!lc.isTopBop()) {
                lc.selectBop(true);
                lc = lc.getParentBop();
            }
        }
        this.isActiveController = isActiveController;
    }

    public boolean isActiveController() {
        return this.isActiveController || this.isTop();
    }

    public boolean hasBeenDragging() {
        return this.hasBeenDragging;
    }

    public Binder binder() {
        if (!this.view.isTopBop()) {
            return this.getTopContainer().getControllerBop().binder();
        }
        if (this.binder == null) {
            this.binder = new Binder(this);
        }
        return this.binder;
    }

    public int snapTo(int coord, int grid) {
        return coord - coord % grid;
    }

    public void toggleSelection(LayoutableComponent lc) {
        this.setSelected(lc, !lc.isSelectedBop());
    }

    public void setSelected(LayoutableComponent lc, boolean b) {
        if (lc instanceof LayoutableContainer) {
            ((LayoutableContainer)lc).getControllerBop().setActiveController(false);
        }
        lc.selectBop(b);
    }

    public LayoutableComponent componentAt(int x, int y) {
        return this.componentAt(x, y, null);
    }

    public LayoutableComponent componentAt(int x, int y, LayoutableComponent toExclude) {
        Rectangle r = new Rectangle();
        int n = 0;
        while (n < this.view.componentCountBop()) {
            this.view.at(n).getBoundsBop(r);
            if (r.contains(x, y) && this.view.at(n) != toExclude) {
                return this.view.at(n);
            }
            ++n;
        }
        return null;
    }

    public LayoutableContainer containerAtRecursive(int x, int y, LayoutableComponent toExclude) {
        Rectangle r = new Rectangle();
        Tracer.This.println("containerAtRecursive" + x + " " + y);
        int n = 0;
        while (n < this.view.componentCountBop()) {
            this.view.at(n).getBoundsBop(r);
            if (r.contains(x, y) && this.view.at(n) != toExclude && this.view.at(n) instanceof LayoutableContainer) {
                Point p = new Point();
                this.view.getLocationBop(p);
                return ((LayoutableContainer)this.view.at(n)).getControllerBop().containerAtRecursive(x - p.x, y - p.y, toExclude);
            }
            ++n;
        }
        return this.view;
    }

    public LayoutableContainer containerAt(int x, int y, LayoutableComponent toExclude) {
        Tracer.This.println("CONTAINERAT:" + x + "," + y);
        Rectangle r = new Rectangle();
        int n = 0;
        while (n < this.view.componentCountBop()) {
            this.view.at(n).getBoundsBop(r);
            Tracer.This.println("COMPARE:" + r.x + "," + r.y + "," + r.width + "," + r.height + " =>" + r.contains(x, y) + "\n   ex:" + (this.view.at(n) != toExclude) + "\n   instanceof:" + (this.view.at(n) instanceof LayoutableContainer));
            if (r.contains(x, y) && this.view.at(n) != toExclude && this.view.at(n) instanceof LayoutableContainer) {
                return (LayoutableContainer)this.view.at(n);
            }
            ++n;
        }
        return null;
    }

    public Point checkForHandle(LayoutableComponent lc, int x, int y) {
        Point result = new Point(0, 0);
        if (!lc.isSelectedBop()) {
            return result;
        }
        Rectangle pos = new Rectangle();
        Rectangle posOrg = new Rectangle();
        lc.getBoundsBop(pos);
        lc.getBoundsBop(posOrg);
        pos.x -= HANDLESIZE;
        pos.y -= HANDLESIZE;
        pos.width += HANDLESIZE * 2;
        pos.height += HANDLESIZE * 2;
        if (!pos.contains(x, y)) {
            return result;
        }
        pos.x += HANDLESIZE * 2;
        pos.y += HANDLESIZE * 2;
        pos.width -= HANDLESIZE * 4;
        pos.height -= HANDLESIZE * 4;
        if (pos.contains(x, y)) {
            return result;
        }
        int cx = x - posOrg.x;
        int cy = y - posOrg.y;
        posOrg.y = 0;
        posOrg.x = 0;
        if (cx > HANDLESIZE && cx < posOrg.width / 2 - HANDLESIZE / 2) {
            return result;
        }
        if (cx < posOrg.width - HANDLESIZE && cx > posOrg.width / 2 + HANDLESIZE / 2) {
            return result;
        }
        if (cy > HANDLESIZE && cy < posOrg.height / 2 - HANDLESIZE / 2) {
            return result;
        }
        if (cy < posOrg.height - HANDLESIZE && cy > posOrg.height / 2 + HANDLESIZE / 2) {
            return result;
        }
        if (x <= pos.x) {
            result.x = -1;
        } else if (x >= pos.x + pos.width) {
            result.x = 1;
        }
        if (y <= pos.y) {
            result.y = -1;
        } else if (y >= pos.y + pos.height) {
            result.y = 1;
        }
        return result;
    }

    public LayoutableComponent lookForDrag(int x, int y) {
        LayoutableComponent lr = null;
        int n = 0;
        while (n < this.view.componentCountBop()) {
            lr = this.view.at(n);
            Point newMode = this.checkForHandle(lr, x, y);
            if (newMode.x != 0 || newMode.y != 0) {
                this.dragStyle = newMode;
                this.mode = 1;
                return lr;
            }
            ++n;
        }
        return null;
    }

    public void mouseDown(int x, int y, int click, int modifier, AWTEvent ev) {
        LayoutableComponent lc;
        LayoutableContainer cont;
        Tracer.This.println("mouseDown " + x + " " + y + " " + click + " " + modifier + " v" + this.componentAt(x, y));
        this.dragged = null;
        this.isFirstDrag = true;
        this.view.getUndoTracker().setMark();
        if (click > 1 && (cont = this.containerAt(x, y, null)) != null) {
            cont.getControllerBop().setActiveController(true);
            return;
        }
        if ((modifier & 0x10) != 0) {
            if (this.mlbutton) {
                return;
            }
            this.mlbutton = true;
        }
        if ((lc = this.lookForDrag(x, y)) != null) {
            this.startDragX = x;
            this.startDragY = y;
            this.dragged = lc;
            lc.startUseBop();
            lc.getBoundsBop(this.initialDragShape);
        } else {
            lc = this.componentAt(x, y);
            if (lc != null) {
                Object inner = lc.getWrappedBop();
                if (inner instanceof NonGuiComponent && ev instanceof MouseEvent) {
                    MouseEvent newMouse = (MouseEvent)ev;
                    Point trans = new Point();
                    lc.getLocationBop(trans);
                    newMouse.translatePoint(-trans.x, -trans.y);
                    if (((NonGuiComponent)inner).consumeEvent(newMouse, lc)) {
                        return;
                    }
                    newMouse.translatePoint(trans.x, trans.y);
                }
                this.mode = 2;
                this.startDragX = x;
                this.startDragY = y;
                this.dragged = lc;
                lc.startUseBop();
                lc.getBoundsBop(this.initialDragShape);
            } else {
                this.mode = 3;
                this.startDragX = x;
                this.startDragY = y;
                IConnection con = this.findConnection(x, y);
                if (con != null) {
                    con.setSelected(true);
                    this.deselect(con);
                    ((Component)((Object)this.view)).repaint();
                    this.mode = 0;
                    this.binder().notifyTargets(con);
                }
            }
        }
        if (lc != null) {
            LayoutableComponent[] sels = this.selectedTopLevelComponents();
            if (!this.dragged.isSelectedBop()) {
                LayoutableComponent[] tmpSels = new LayoutableComponent[sels.length + 1];
                int n = 0;
                while (n < sels.length) {
                    tmpSels[n] = sels[n];
                    ++n;
                }
                sels = tmpSels;
                sels[sels.length - 1] = this.dragged;
            }
            if (sels == null || sels.length == 0) {
                sels = new LayoutableComponent[]{this.dragged};
            }
            this.preDragBounds = new Rectangle[sels.length];
            this.preContainer = new LayoutableContainer[sels.length];
            int n = 0;
            while (n < sels.length) {
                this.preDragBounds[n] = new Rectangle();
                sels[n].getBoundsBop(this.preDragBounds[n]);
                this.preContainer[n] = sels[n].getParentBop();
                ++n;
            }
        }
    }

    public void mouseDrag(int x, int y, int modifier) {
        if (this.mode == 0) {
            return;
        }
        switch (this.mode) {
            case 2: {
                ((BopComponent)((Object)this.view)).getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
                Rectangle old = new Rectangle();
                this.dragged.getBoundsBop(old);
                int diffX = x - this.startDragX;
                int diffY = y - this.startDragY;
                if (Math.abs(diffX) >= this.grid.x || Math.abs(diffY) >= this.grid.x) {
                    this.hasBeenDragging = true;
                }
                int prevX = old.x;
                int prevY = old.y;
                int nX = this.snapTo(this.initialDragShape.x + diffX, this.grid.x);
                int nY = this.snapTo(this.initialDragShape.y + diffY, this.grid.y);
                int distX = nX - prevX;
                int distY = nY - prevY;
                LayoutableComponent[] selection = this.selectedComponents();
                if ((diffX != 0 || diffY != 0) && this.dragged.isSelectedBop()) {
                    int n = 0;
                    while (n < selection.length) {
                        LayoutableComponent lr = selection[n];
                        if (lr != this.dragged) {
                            lr.getBoundsBop(old);
                            lr.setLocationBop(old.x + distX, old.y + distY);
                        }
                        ++n;
                    }
                }
                this.dragged.setLocationBop(nX, nY);
                this.isFirstDrag = false;
                break;
            }
            case 1: {
                ((BopComponent)((Object)this.view)).getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
                this.dragComponent(this.dragStyle.x, this.dragStyle.y, x, y);
                this.isFirstDrag = false;
                if (!this.isFirstDrag) break;
                Rectangle actPos = new Rectangle();
                this.dragged.getBoundsBop(actPos);
                break;
            }
            case 3: {
                this.view.moveDragRectBop(this.startDragX, this.startDragY, x, y);
            }
        }
    }

    void dragComponent(int toLeft, int toTop, int actX, int actY) {
        LayoutableComponent[] toDrag = this.selectedComponents();
        int diffX = actX - this.startDragX;
        int diffY = actY - this.startDragY;
        Rectangle preDrag = new Rectangle();
        this.dragged.getBoundsBop(preDrag);
        Rectangle newRect = new Rectangle(this.initialDragShape.x, this.initialDragShape.y, this.initialDragShape.width, this.initialDragShape.height);
        if (Math.abs(diffX) >= this.grid.x || Math.abs(diffY) >= this.grid.x) {
            this.hasBeenDragging = true;
        }
        if (toLeft == -1) {
            newRect.width += newRect.x - this.snapTo(newRect.x + diffX, this.grid.x);
            newRect.x = this.snapTo(newRect.x + diffX, this.grid.x);
        } else if (toLeft == 1) {
            newRect.width = this.snapTo(newRect.width + diffX, this.grid.x);
        }
        if (toTop == -1) {
            newRect.height += newRect.y - this.snapTo(newRect.y + diffY, this.grid.y);
            newRect.y = this.snapTo(newRect.y + diffY, this.grid.y);
        } else if (toTop == 1) {
            newRect.height = this.snapTo(newRect.height + diffY, this.grid.y);
        }
        if (newRect.width >= 1 && newRect.height >= 1) {
            this.dragged.setBoundsBop(newRect.x, newRect.y, newRect.width, newRect.height);
        }
        Rectangle diff = new Rectangle(newRect.x - preDrag.x, newRect.y - preDrag.y, newRect.width - preDrag.width, newRect.height - preDrag.height);
    }

    public IConnection getSelectedConnections() {
        Iterator it = this.connectionToRect.keySet().iterator();
        while (it.hasNext()) {
            IConnection con = (IConnection)it.next();
            if (!con.isSelected()) continue;
            return con;
        }
        return null;
    }

    public void deselectConnections(Object toExclude) {
        Iterator it = this.connectionToRect.keySet().iterator();
        while (it.hasNext()) {
            IConnection con = (IConnection)it.next();
            if (con == toExclude) continue;
            con.setSelected(false);
        }
    }

    public void deselect(Object toExclude) {
        LayoutableComponent[] selection = this.selectedComponents();
        int n = 0;
        while (n < selection.length) {
            if (toExclude != selection[n]) {
                selection[n].selectBop(false);
            }
            ++n;
        }
        this.deselectConnections(toExclude);
    }

    public void deselect() {
        this.deselect(null);
        ((Component)((Object)this.view)).repaint();
    }

    public void checkForMove(LayoutableComponent lc, LayoutableComponent[] sels, int x, int y, int click, int modifier) {
        LayoutableComponent toExclude = lc instanceof LayoutableContainer ? lc : null;
        Tracer.This.println("Excluded:" + toExclude);
        LayoutableContainer cont = this.containerAt(x, y, toExclude);
        if (cont != null) {
            Tracer.This.println("container:" + cont.getClass().getName() + " cont != view:" + (cont != this.view));
        } else {
            Tracer.This.println("container: NULL toExclude == view:" + (toExclude == this.view));
        }
        if (cont != null && cont != this.view) {
            Rectangle p = new Rectangle();
            cont.getBoundsBop(p);
            Rectangle r = new Rectangle();
            int n = 0;
            while (n < sels.length) {
                LayoutableComponent comp = sels[n];
                if (comp != null && comp.getParentBop() != cont) {
                    comp.getBoundsBop(r);
                    if (p.x < r.x && p.x + p.width > r.x + r.width && p.y < r.y && p.y + p.height > r.y + r.height) {
                        this.hasBeenDragging = true;
                        r.x -= p.x;
                        r.y -= p.y;
                        this.view.remLayComponentBop(comp);
                        comp.selectBop(false);
                        cont.addLayComponentBop(0, 0, comp);
                        comp.setBoundsBop(r.x, r.y, r.width, r.height);
                        cont.getControllerBop().setActiveController(true);
                    }
                }
                ++n;
            }
        } else if (!this.isTop()) {
            boolean foundOne = false;
            Rectangle p = new Rectangle();
            this.view.getBoundsBop(p);
            Rectangle r = new Rectangle();
            int n = 0;
            while (n < sels.length) {
                LayoutableComponent comp = sels[n];
                comp.getBoundsBop(r);
                if (r.x + r.width < 0 || r.x > p.width || r.y + r.height < 0 || r.y > p.height) {
                    LayoutableContainer newCont;
                    foundOne = true;
                    this.view.remLayComponentBop(comp);
                    this.view.selectBop(false);
                    LayoutableContainer topLevel = newCont = this.getTopContainer().getControllerBop().view;
                    Point newCoords = new Point(r.x, r.y);
                    LayoutController.translatePoint((Component)((Object)this.view), (Component)((Object)newCont), newCoords);
                    newCont = newCont.getControllerBop().containerAtRecursive(newCoords.x, newCoords.y, null);
                    LayoutController.translatePoint((Component)((Object)topLevel), (Component)((Object)newCont), newCoords);
                    newCont.addLayComponentBop(0, 0, comp);
                    comp.setBoundsBop(newCoords.x, newCoords.y, r.width, r.height);
                    newCont.getControllerBop().setActiveController(true);
                }
                ++n;
            }
            if (foundOne) {
                this.view.getControllerBop().setActiveController(false);
                this.view.getControllerBop().deselect();
                return;
            }
        }
    }

    public void mouseUp(int x, int y, int click, int modifier, AWTEvent ev) {
        ((BopComponent)((Object)this.view)).getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        this.mlbutton = false;
        if (click > 1) {
            return;
        }
        if (this.mode == 3) {
            this.view.hideDragRectBop();
            Rectangle dragRect = new Rectangle();
            dragRect.x = Math.min(this.startDragX, x);
            dragRect.y = Math.min(this.startDragY, y);
            dragRect.width = Math.abs(this.startDragX - x);
            dragRect.height = Math.abs(this.startDragY - y);
            if ((modifier & 2) == 0) {
                this.deselect();
            }
            this.selectCompsIn(dragRect);
            this.binder().notifyTargets(dragRect);
        } else {
            LayoutableComponent lc = this.dragged != null ? this.dragged : this.componentAt(x, y);
            LayoutableComponent[] sels = this.selectedTopLevelComponents();
            if (this.dragged != null && !this.dragged.isSelectedBop()) {
                LayoutableComponent[] tmpSels = new LayoutableComponent[sels.length + 1];
                int n = 0;
                while (n < sels.length) {
                    tmpSels[n] = sels[n];
                    ++n;
                }
                sels = tmpSels;
                sels[sels.length - 1] = this.dragged;
            }
            if (sels == null || sels.length == 0) {
                sels = new LayoutableComponent[]{this.dragged};
            }
            this.checkForMove(lc, sels, x, y, click, modifier);
            if (lc != null && !this.hasBeenDragging) {
                Object inner = lc.getWrappedBop();
                if (inner instanceof NonGuiComponent && ev instanceof MouseEvent) {
                    MouseEvent newMouse = (MouseEvent)ev;
                    Point trans = new Point();
                    lc.getLocationBop(trans);
                    newMouse.translatePoint(-trans.x, -trans.y);
                    if (((NonGuiComponent)inner).consumeEvent(newMouse, lc)) {
                        return;
                    }
                    newMouse.translatePoint(trans.x, trans.y);
                }
                this.deselectConnections(null);
                if ((modifier & 2) == 0) {
                    LayoutableComponent[] selection = this.selectedComponents();
                    int n = 0;
                    while (n < selection.length) {
                        if (selection[n] != lc) {
                            this.setSelected(selection[n], false);
                        }
                        ++n;
                    }
                    this.toggleSelection(lc);
                } else {
                    this.toggleSelection(lc);
                }
                this.binder().notifyTargets(lc);
            } else if (this.hasBeenDragging()) {
                try {
                    int n = 0;
                    while (n < sels.length) {
                        Rectangle newBounds = new Rectangle();
                        sels[n].getBoundsBop(newBounds);
                        this.view.getUndoTracker().addUndoAction(new MoveUndoAction(sels[n], this.preDragBounds[n], newBounds, this.preContainer[n], sels[n].getParentBop()));
                        this.binder().notifyTargets(new Object[]{"move", sels[n]});
                        ++n;
                    }
                }
                catch (Exception e) {
                    Tracer.This.println("UNDO ERROR * UNDO ERROR * UNDO ERROR * UNDO ERROR *");
                    e.printStackTrace();
                }
            } else {
                System.out.println();
            }
        }
        this.mode = 0;
        this.hasBeenDragging = false;
        this.dragged = null;
    }

    public void mouseMove(int x, int y, int modifier) {
        LayoutableComponent lr = null;
        boolean showHand = false;
        int n = 0;
        while (n < this.view.componentCountBop()) {
            lr = this.view.at(n);
            if (lr instanceof Component) {
                Point newMode = this.checkForHandle(lr, x, y);
                if (newMode.x != 0 || newMode.y != 0) {
                    showHand = true;
                    break;
                }
            }
            ++n;
        }
        if (!showHand) {
            ((BopComponent)((Object)this.view)).getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
        } else {
            ((BopComponent)((Object)this.view)).getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void keyDown(int code, int modifier) {
        boolean cntrl;
        boolean bl = cntrl = (modifier & 2) != 0;
        if (code == 67 && cntrl) {
            this.cloneSelected();
            Tracer.This.println("***************** cloned");
        }
        if (code == 36) {
            this.selectedToFront();
            Tracer.This.println("***************** toFront");
        }
        if (code == 35) {
            this.selectedToBack();
            Tracer.This.println("***************** toBack");
        }
        if (code == 68 && cntrl || code == 127 || code == 8) {
            this.deleteSelected();
            Tracer.This.println("****************** deleted");
        }
        if (code == 86 && cntrl) {
            this.pasteClipboard(this.view);
            Tracer.This.println("****************** pasted");
        }
    }

    public void keyUp(int code, int modifier) {
    }

    public void selectCompsIn(Rectangle r) {
        Rectangle vr = new Rectangle();
        int n = 0;
        while (n < this.view.componentCountBop()) {
            this.view.at(n).getBoundsBop(vr);
            if (r.intersects(vr) && r.intersects(vr)) {
                this.setSelected(this.view.at(n), true);
            }
            ++n;
        }
    }

    public int countSelectedComponents(int init) {
        int n = 0;
        while (n < this.view.componentCountBop()) {
            if (this.view.at(n) != null && this.view.at(n).isSelectedBop()) {
                if (this.view.at(n) instanceof LayoutableContainer) {
                    init = ((LayoutableContainer)this.view.at(n)).getControllerBop().countSelectedComponents(init);
                }
                ++init;
            }
            ++n;
        }
        return init;
    }

    int selectedComponents(LayoutableComponent[] res, int cnt) {
        int n = 0;
        while (n < this.view.componentCountBop()) {
            if (this.view.at(n).isSelectedBop()) {
                if (this.view.at(n) instanceof LayoutableContainer) {
                    cnt = ((LayoutableContainer)this.view.at(n)).getControllerBop().selectedComponents(res, cnt);
                }
                res[cnt++] = this.view.at(n);
            }
            ++n;
        }
        return cnt;
    }

    public LayoutableComponent[] selectedComponents() {
        int cnt = this.countSelectedComponents(0);
        LayoutableComponent[] res = new LayoutableComponent[cnt];
        this.selectedComponents(res, 0);
        return res;
    }

    public LayoutableComponent[] selectedTopLevelComponents() {
        int init = 0;
        int n = 0;
        while (n < this.view.componentCountBop()) {
            if (this.view.at(n).isSelectedBop()) {
                ++init;
            }
            ++n;
        }
        LayoutableComponent[] res = new LayoutableComponent[init];
        int cnt = 0;
        int n2 = 0;
        while (n2 < this.view.componentCountBop()) {
            if (this.view.at(n2).isSelectedBop()) {
                res[cnt++] = this.view.at(n2);
            }
            ++n2;
        }
        return res;
    }

    public LayoutableComponent[] selectedInnerComponents() {
        LayoutableComponent[] all = this.selectedComponents();
        int cnt = 0;
        int n = 0;
        while (n < all.length) {
            if (!(all[n] instanceof LayoutableContainer)) {
                ++cnt;
            }
            ++n;
        }
        LayoutableComponent[] res = new LayoutableComponent[cnt];
        cnt = 0;
        int n2 = 0;
        while (n2 < res.length) {
            if (!(all[n2] instanceof LayoutableContainer)) {
                res[cnt++] = this.view.at(n2);
            }
            ++n2;
        }
        return res;
    }

    public void snapToGrid() {
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            sel[n].setBoundsBop(this.snapTo(r.x, this.grid.x), this.snapTo(r.y, this.grid.y), this.snapTo(r.width + this.grid.x / 2, this.grid.x), this.snapTo(r.height + this.grid.y / 2, this.grid.y));
            ++n;
        }
    }

    public void alignLeftMost(UndoTracker undo) {
        undo.setMark();
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int minX = 4000;
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            minX = Math.min(r.x, minX);
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            sel[n2].getBoundsBop(r);
            Rectangle old = new Rectangle(r);
            r.x = minX;
            undo.addUndoAction(new MoveUndoAction(sel[n2], old, new Rectangle(r), sel[n2].getParentBop(), sel[n2].getParentBop()));
            sel[n2].setBoundsBop(r.x, r.y, r.width, r.height);
            ++n2;
        }
    }

    public void alignTopMost(UndoTracker undo) {
        undo.setMark();
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int minY = 4000;
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            minY = Math.min(r.y, minY);
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            sel[n2].getBoundsBop(r);
            Rectangle old = new Rectangle(r);
            r.y = minY;
            undo.addUndoAction(new MoveUndoAction(sel[n2], old, new Rectangle(r), sel[n2].getParentBop(), sel[n2].getParentBop()));
            sel[n2].setBoundsBop(r.x, r.y, r.width, r.height);
            ++n2;
        }
    }

    public void alignBottomMost(UndoTracker undo) {
        undo.setMark();
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int maxY = 0;
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            maxY = Math.max(r.y + r.height, maxY);
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            sel[n2].getBoundsBop(r);
            Rectangle old = new Rectangle(r);
            r.y = maxY - r.height;
            undo.addUndoAction(new MoveUndoAction(sel[n2], old, new Rectangle(r), sel[n2].getParentBop(), sel[n2].getParentBop()));
            sel[n2].setBoundsBop(r.x, r.y, r.width, r.height);
            ++n2;
        }
    }

    public void alignSize(int direction, UndoTracker undo) {
        undo.setMark();
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int max = 0;
        if (direction == 0 || direction == 2) {
            max = 999999;
        }
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            switch (direction) {
                case 0: {
                    max = Math.min(r.y, max);
                    break;
                }
                case 2: {
                    max = Math.min(r.x, max);
                    break;
                }
                case 3: {
                    max = Math.max(r.x + r.width, max);
                    break;
                }
                case 1: {
                    max = Math.max(r.y + r.height, max);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            sel[n2].getBoundsBop(r);
            Rectangle old = new Rectangle(r);
            switch (direction) {
                case 0: {
                    int actBot = r.y + r.height;
                    r.y = max;
                    r.height = actBot - r.y;
                    break;
                }
                case 2: {
                    int actRight = r.x + r.width;
                    r.x = max;
                    r.width = actRight - r.x;
                    break;
                }
                case 3: {
                    r.width = max - r.x;
                    break;
                }
                case 1: {
                    r.height = max - r.y;
                }
            }
            undo.addUndoAction(new MoveUndoAction(sel[n2], old, new Rectangle(r), sel[n2].getParentBop(), sel[n2].getParentBop()));
            sel[n2].setBoundsBop(r.x, r.y, r.width, r.height);
            ++n2;
        }
    }

    public void alignCenter(boolean horzIfTrue, UndoTracker undo) {
        undo.setMark();
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int maxOrg = 0;
        int maxWidth = 0;
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            if (horzIfTrue && r.width > maxWidth) {
                maxWidth = r.width;
                maxOrg = r.x;
            } else if (!horzIfTrue && r.height > maxWidth) {
                maxWidth = r.height;
                maxOrg = r.y;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            sel[n2].getBoundsBop(r);
            Rectangle old = new Rectangle(r);
            if (horzIfTrue) {
                r.x = (maxWidth - r.width) / 2 + maxOrg;
            } else {
                r.y = (maxWidth - r.height) / 2 + maxOrg;
            }
            sel[n2].setBoundsBop(r.x, r.y, r.width, r.height);
            undo.addUndoAction(new MoveUndoAction(sel[n2], old, new Rectangle(r), sel[n2].getParentBop(), sel[n2].getParentBop()));
            ++n2;
        }
    }

    public void alignRightMost(UndoTracker undo) {
        undo.setMark();
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        Rectangle r = new Rectangle();
        int maxX = 0;
        int n = 0;
        while (n < sel.length) {
            sel[n].getBoundsBop(r);
            maxX = Math.max(r.x + r.width, maxX);
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            sel[n2].getBoundsBop(r);
            Rectangle old = new Rectangle(r);
            r.x = maxX - r.width;
            undo.addUndoAction(new MoveUndoAction(sel[n2], old, new Rectangle(r), sel[n2].getParentBop(), sel[n2].getParentBop()));
            sel[n2].setBoundsBop(r.x, r.y, r.width, r.height);
            ++n2;
        }
    }

    public void toFront(LayoutableComponent lc) {
        Rectangle r = new Rectangle();
        lc.getBoundsBop(r);
        this.view.remLayComponentBop(lc);
        this.view.addLayComponentBop(0, 0, lc);
        lc.setBoundsBop(r.x, r.y, r.width, r.height);
    }

    public void selectedToFront() {
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        int n = 0;
        while (n < sel.length) {
            this.toFront(sel[n]);
            ++n;
        }
    }

    public void selectedToBack() {
        int n = 0;
        while (n < this.view.componentCountBop()) {
            if (!this.view.at(n).isSelectedBop()) {
                Rectangle r = new Rectangle();
                LayoutableComponent lc = this.view.at(n);
                lc.getBoundsBop(r);
                this.view.remLayComponentBop(lc);
                this.view.addLayComponentBop(0, 0, lc);
                lc.setBoundsBop(r.x, r.y, r.width, r.height);
            }
            ++n;
        }
    }

    public void pasteClipboard(LayoutableContainer cont) {
        this.deselect();
        int n = 0;
        while (n < clipBoard.size()) {
            LayoutableComponent lc = (LayoutableComponent)clipBoard.at(n);
            lc = lc.createCloneBop();
            Rectangle r = (Rectangle)clipBoardRects.at(n);
            cont.addLayComponentBop(0, 0, lc);
            this.setSelected(lc, true);
            Tracer.This.println("pasting " + lc + "   " + r);
            lc.setBoundsBop(r.x, r.y, r.width, r.height);
            ++n;
        }
    }

    public void deleteSelected() {
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        this.view.getUndoTracker().setMark();
        int n = 0;
        while (n < sel.length) {
            if (!(sel[n] instanceof LayoutableContainer) || !((LayoutableContainer)sel[n]).getControllerBop().isActiveController()) {
                Rectangle r = new Rectangle();
                sel[n].getBoundsBop(r);
                this.view.getUndoTracker().addUndoAction(new AddDelAction(sel[n], r, this.view, true));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < sel.length) {
            if (!(sel[n2] instanceof LayoutableContainer) || !((LayoutableContainer)sel[n2]).getControllerBop().isActiveController()) {
                this.view.remLayComponentBop(sel[n2]);
            }
            ++n2;
        }
    }

    public void cloneSelected() {
        clipBoard.setSize(0);
        clipBoardRects.setSize(0);
        LayoutableComponent[] sel = this.selectedTopLevelComponents();
        int n = 0;
        while (n < sel.length) {
            Rectangle r = new Rectangle();
            sel[n].getBoundsBop(r);
            clipBoardRects.add(r);
            LayoutableComponent newComp = sel[n].createCloneBop();
            if (newComp != null) {
                clipBoard.add(newComp);
            }
            Tracer.This.println("copied " + sel[n] + " " + sel[n].getWrappedBop());
            ++n;
        }
    }

    public void menuAction(Component source, int x, int y) {
        if (this.isTop()) {
            this.binder().notifyTargets(new Object[]{source, new Point(x, y)});
        } else {
            this.view.getParentBop().getControllerBop().menuAction(source, x, y);
        }
    }

    public void remove() {
    }

    public void unWrap() {
    }

    public void wrap() {
    }

    public void group() {
    }

    public void ungroup() {
    }
}

