/*
 * Decompiled with CFR 0.152.
 */
package layedit.swing;

import JCollections.JSet;
import JCollections.JUnsafeTable;
import Jxe.DocumentStream;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.runtime.ITypeMapper;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import layedit.FormInfo;
import layedit.IGUIPersistence;
import layedit.LayoutableComponent;
import layedit.LayoutableContainer;
import layedit.swing.BopComponent;
import layedit.swing.CodeGenerator;
import layedit.swing.CompAttributes;

public class SwingPersistance
implements IGUIPersistence {
    FormInfo info;
    LayoutableContainer root;
    String source;
    ITypeMapper mapper;
    JSet eventSets;
    public static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);

    public static void buildActionMapToESetDescr(Class clazz, Hashtable actionMap) {
        try {
            BeanInfo info = Introspector.getBeanInfo(clazz);
            Tracer.This.println("GETTING EVENTMETHODS:" + clazz.getName() + "--------------------------");
            EventSetDescriptor[] evsd = info.getEventSetDescriptors();
            int n = 0;
            while (n < evsd.length) {
                MethodDescriptor[] m = evsd[n].getListenerMethodDescriptors();
                Tracer.This.println("DESCRIPTOR:" + evsd[n].getListenerType().getName());
                int i = 0;
                while (i < m.length) {
                    actionMap.put(clazz.getName() + m[i].getName(), evsd[n].getListenerType());
                    Tracer.This.println("PUT ACTION:" + clazz.getName() + m[i].getName());
                    ++i;
                }
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SwingPersistance(ITypeMapper mapper) {
        this.mapper = mapper;
    }

    public void writeForm(OutputStream out, LayoutableContainer topCont, FormInfo info) {
        this.info = info;
        this.root = topCont;
        this.eventSets = new JSet(13);
        this.writeXML(new PrintStream(out), topCont);
        try {
            Tracer.This.println("creating EventRedirector in " + info.getTargetDir() + info.getFormName() + ".java");
            String pakkage = "";
            String fullFileName = info.getTargetDir() + File.separator + info.getFormName() + "GUI.java";
            try {
                pakkage = DocumentStream.ScanPackage(new File(info.getTargetDir() + File.separator + info.getFormName() + ".java"));
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            try {
                if (pakkage == null || pakkage.trim().length() == 0) {
                    pakkage = DocumentStream.ScanPackage(new File(fullFileName));
                }
            }
            catch (Exception th) {
                th.printStackTrace();
            }
            info.setPack(pakkage);
            FileOutputStream fout = new FileOutputStream(fullFileName);
            CodeGenerator.This().writeForm(fout, topCont, info);
            fout.close();
        }
        catch (Exception th) {
            th.printStackTrace();
            ConfirmDiag.Msg(null, "Error generating Redirector class");
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void writeXML(PrintStream p, LayoutableContainer comp) {
        p.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"yes\"?>");
        this.writeXML(p, comp, 0, null);
    }

    protected void printTabs(PrintStream p, int hl) {
        int n = 0;
        while (n < hl) {
            p.print("\t");
            ++n;
        }
    }

    void writeAttribute(PrintStream p, String key, Object value, int parentDepth) {
        if (key == null) {
            return;
        }
        this.printTabs(p, parentDepth + 1);
        p.print(key);
        p.print("=");
        p.print("\"");
        p.print(NCStringUtilities.EscapeForHtml(this.mapper.createString(value)));
        p.println("\"");
    }

    void writeTagStart(PrintStream p, String name, int depth) {
        this.printTabs(p, depth);
        p.print("<" + name);
    }

    void defaultWriteAtts(PrintStream p, LayoutableComponent comp, int depth, String layout) {
        CompAttributes att = (CompAttributes)comp.getAssocObject();
        Rectangle rect = ((Component)((Object)comp)).getBounds();
        Rectangle rect1 = ((Component)((Object)comp)).getBounds();
        if (att.layoutString == null) {
            if (!att.maxBounds.equals(zeroRect)) {
                rect1 = att.maxBounds;
            } else {
                rect1 = rect;
                Tracer.This.println("***** maxrect == ZERO ******" + zeroRect);
            }
            this.writeAttribute(p, "layout", this.mapper.createString(rect), depth);
            this.writeAttribute(p, "maxLayout", this.mapper.createString(rect1), depth);
        } else if (att != null) {
            this.writeAttribute(p, "layout", att.layoutString, depth);
        }
        if (att != null) {
            String name = att.name;
            if (name != null && name.length() > 0) {
                this.writeAttribute(p, "id", name, depth);
            }
            JUnsafeTable modi = att.modifiedAttributes;
            Tracer.This.println("modi:" + modi);
            Enumeration en = modi.keys();
            while (en.hasMoreElements()) {
                String s = en.nextElement().toString();
                if ("events".equals(s)) continue;
                this.writeAttribute(p, s, modi.get(s), depth);
            }
            en = att.getEvents().enumerate();
            StringBuffer res = new StringBuffer(50);
            while (en.hasMoreElements()) {
                res.append(en.nextElement() + ",");
            }
            if (res.length() > 0) {
                this.writeAttribute(p, "events", res.toString().substring(0, res.length() - 1), depth);
                Hashtable actionMap = new Hashtable(37);
                SwingPersistance.buildActionMapToESetDescr(comp.getPropertyTargetBop().getClass(), actionMap);
                JSet eventsAsString = att.getEvents();
                String clName = comp.getPropertyTargetBop().getClass().getName();
                Enumeration enumeration = eventsAsString.enumerate();
                while (enumeration.hasMoreElements()) {
                    String actionMethodName = enumeration.nextElement().toString();
                    Class esd = (Class)actionMap.get(clName + actionMethodName);
                    if (esd != null) {
                        Tracer.This.println("EVENTSET:" + actionMethodName + " " + esd.getName() + " ");
                        this.eventSets.add(esd);
                        continue;
                    }
                    Tracer.This.println("EVENTSET CAN'T find:" + actionMethodName);
                }
            }
        }
    }

    public void expandEventSet() {
        Enumeration classes = null;
        Vector newComers = new Vector(13);
        do {
            this.eventSets.addAll(newComers.elements());
            newComers.setSize(0);
            classes = this.eventSets.enumerate();
            while (classes.hasMoreElements()) {
                Class act = (Class)classes.nextElement();
                Class<?>[] interfaces = act.getInterfaces();
                int n = 0;
                while (interfaces != null && n < interfaces.length) {
                    if (!this.eventSets.contains(interfaces[n])) {
                        newComers.addElement(interfaces[n]);
                    }
                    ++n;
                }
            }
        } while (newComers.size() > 0);
    }

    public void generateRedirector(String pakkage, String formName, PrintStream pout) {
    }

    public void writeXML(PrintStream p, Object cmp, int depth, String layoutString) {
        BopComponent comp = (BopComponent)cmp;
        if (comp instanceof LayoutableContainer) {
            String endName = "";
            CompAttributes att = (CompAttributes)comp.getAssocObject();
            if (comp == this.root) {
                endName = "TARGET";
                this.writeTagStart(p, "TARGET", depth);
                if (this.source != null) {
                    this.writeAttribute(p, "source", this.source, depth);
                }
            } else {
                this.writeTagStart(p, att.instantiationName, depth);
                p.println();
                endName = att.instantiationName;
                this.defaultWriteAtts(p, comp, depth, layoutString);
            }
            this.printTabs(p, depth);
            p.println(">");
            this.writeTagStart(p, "ScalingLayout", depth + 1);
            Rectangle rect = comp.getBounds();
            Rectangle rect1 = comp.getBounds();
            if (att != null && !att.maxBounds.equals(zeroRect)) {
                rect1 = att.maxBounds;
            } else {
                rect1 = rect;
                Tracer.This.println("***** maxrect == ZERO SCALINGLAYOUT******" + zeroRect);
            }
            if (att != null && att.maxBounds == att.minBounds) {
                Tracer.This.println("***** FATAL FATAL FATAL FATAL FATAL FATAL  maxrect == minrect ******" + zeroRect);
            }
            p.println();
            this.writeAttribute(p, "layout", rect.width + "," + rect.height + "," + rect1.width + "," + rect1.height, depth + 1);
            this.printTabs(p, depth + 1);
            p.println("/>");
            LayoutableContainer bc = (LayoutableContainer)((Object)comp);
            int N = bc.serialCountBop();
            int n = 0;
            while (n < N) {
                this.writeXML(p, bc.serialAt(n), depth + 1, layoutString);
                ++n;
            }
            this.printTabs(p, depth);
            p.println("</" + endName + ">");
        } else if (comp instanceof LayoutableComponent) {
            BopComponent bc = comp;
            CompAttributes att = (CompAttributes)comp.getAssocObject();
            if (att.instantiationName.startsWith("JXEBean")) {
                this.writeTagStart(p, "JXEBean", depth);
                p.println();
                if (att.modifiedAttributes.get("beanname") != null) {
                    att.modifiedAttributes.remove("beanname");
                }
                this.writeAttribute(p, "beanname", att.beanName, depth);
            } else {
                this.writeTagStart(p, att.instantiationName, depth);
                p.println();
            }
            this.defaultWriteAtts(p, bc, depth, null);
            this.printTabs(p, depth);
            p.println("/>");
        }
    }
}

