/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.beans.simpleresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import netcomputing.beans.NCClassloader;

public class SimpleResourceConnection
extends URLConnection {
    private static boolean debug = false;
    private Object resource;
    private String cookie;
    private String name;
    private final String prefix = "SIMPLE";
    private final int prefixLength = "SIMPLE".length();

    protected SimpleResourceConnection(URL url) throws MalformedURLException, IOException {
        super(url);
        this.debug("SimpleResourceConnection(" + url + ")");
        String file2 = url.getFile();
        if (file2.startsWith("/")) {
            file2 = file2.substring(1);
        }
        if (!file2.startsWith("SIMPLE")) {
            throw new MalformedURLException("SimpleResource file should start with /SIMPLE");
        }
        this.cookie = file2.substring(this.prefixLength, file2.indexOf("/+/"));
        this.name = file2.substring(file2.indexOf("/+/") + 3);
        this.debug(" cookie: " + this.cookie);
        this.debug(" name: " + this.name);
    }

    public void connect() throws IOException {
        this.debug("Looking for " + this.cookie + ", " + this.name + " in SimpleResourceLoader");
        URL o = NCClassloader.This().getResource(this.name);
        if (o == null) {
            this.debug("Invalid resource name");
            this.resource = null;
            return;
        }
        this.debug("Found resource " + o);
        this.resource = o;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return NCClassloader.This().getResourceAsStream(this.name);
    }

    private void debug(String msg) {
        System.err.println(msg);
    }
}

