/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections;

import java.util.Enumeration;
import java.util.Vector;
import netcomputing.collections.INCCollection;
import netcomputing.collections.INCEnumerateable;
import netcomputing.collections.INCMappingCollection;
import netcomputing.collections.NCBasicCollection;
import netcomputing.collections.NCComparator;
import netcomputing.collections.NCHashtable;
import netcomputing.collections.NotSupportedException;

public class NCSet
extends NCBasicCollection
implements INCCollection,
Cloneable {
    public INCMappingCollection ht;

    public NCSet(INCMappingCollection ht) {
        this.ht = ht;
    }

    public NCSet(int initialSize) {
        this(new NCHashtable(initialSize));
    }

    public NCSet(int initialSize, NCComparator comp) {
        this.ht = new NCHashtable(initialSize, comp);
    }

    public int size() {
        return this.ht.size();
    }

    public INCCollection add(Object o) {
        this.ht.put(o, o);
        return this;
    }

    public void addAll(Enumeration e) {
        while (e.hasMoreElements()) {
            this.add(e.nextElement());
        }
    }

    public void addAll(Vector v) {
        this.addAll(v.elements());
    }

    public Object rem(Object o) {
        Object tmp = this.ht.get(o);
        this.ht.rem(o);
        return tmp == null ? null : tmp;
    }

    public void remAll() {
        this.ht.remAll();
    }

    public Enumeration enumerate() {
        return this.ht.enumerateKeys();
    }

    public boolean equals(Object o) {
        Enumeration e;
        if (o instanceof Enumeration) {
            e = (Enumeration)o;
        } else if (o instanceof INCEnumerateable) {
            e = ((INCEnumerateable)o).enumerate();
        } else {
            return false;
        }
        boolean result = true;
        while (e.hasMoreElements()) {
            if (this.contains(e.nextElement())) continue;
            result = false;
            break;
        }
        return result;
    }

    public Object find(Object what) {
        Object tmp = this.ht.get(what);
        if (tmp != null) {
            return what;
        }
        return null;
    }

    public INCEnumerateable copyShallow() {
        try {
            return (INCEnumerateable)this.clone();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public INCEnumerateable copyDeep() {
        NCSet result = (NCSet)this.copyShallow();
        result.ht = (INCMappingCollection)((NCBasicCollection)((Object)this.ht)).copyDeep();
        return result;
    }

    public NCComparator getComparator() {
        if (!(this.ht instanceof NCBasicCollection)) {
            throw new NotSupportedException("Can't use a Comparator in NCSet");
        }
        return ((NCBasicCollection)((Object)this.ht)).getComparator();
    }

    public void setComparator(NCComparator comparator) {
        if (!(this.ht instanceof NCBasicCollection)) {
            throw new NotSupportedException("Can't use a Comparator in NCSet");
        }
        ((NCBasicCollection)((Object)this.ht)).setComparator(comparator);
    }
}

