/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.collections.adaptors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import netcomputing.collections.adaptors.NCUnsafeTableEntry;
import netcomputing.collections.adaptors.NCUnsafeTableEnumerator;

public class NCUnsafeTable
extends Dictionary
implements Cloneable,
Serializable {
    private transient NCUnsafeTableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    static final long serialVersionUID = 7162625831330845168L;

    public NCUnsafeTable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new NCUnsafeTableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public NCUnsafeTable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public NCUnsafeTable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new NCUnsafeTableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new NCUnsafeTableEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        NCUnsafeTableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            NCUnsafeTableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        NCUnsafeTableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        NCUnsafeTableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(Object key) {
        NCUnsafeTableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        NCUnsafeTableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        NCUnsafeTableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        NCUnsafeTableEntry[] newTable = new NCUnsafeTableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            NCUnsafeTableEntry old = oldTable[i];
            while (old != null) {
                NCUnsafeTableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        NCUnsafeTableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        NCUnsafeTableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        NCUnsafeTableEntry e2 = new NCUnsafeTableEntry();
        e2.hash = hash;
        e2.key = key;
        e2.value = value;
        e2.next = tab[index];
        tab[index] = e2;
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        NCUnsafeTableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        NCUnsafeTableEntry e = tab[index];
        NCUnsafeTableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        NCUnsafeTableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            NCUnsafeTable t = (NCUnsafeTable)super.clone();
            t.table = new NCUnsafeTableEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                NCUnsafeTableEntry nCUnsafeTableEntry = t.table[i] = this.table[i] != null ? (NCUnsafeTableEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.count);
        int index = this.table.length - 1;
        while (index >= 0) {
            NCUnsafeTableEntry entry = this.table[index];
            while (entry != null) {
                s.writeObject(entry.key);
                s.writeObject(entry.value);
                entry = entry.next;
            }
            --index;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int origlength = s.readInt();
        int elements = s.readInt();
        int length = (int)((float)elements * this.loadFactor) + elements / 20 + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        if (origlength > 0 && length > origlength) {
            length = origlength;
        }
        this.table = new NCUnsafeTableEntry[length];
        this.count = 0;
        while (elements > 0) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.put(key, value);
            --elements;
        }
    }
}

