/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.tools;

import JWVFile.VFile;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Color;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import netcomputing.tools.MissingApi;

public class Platforms {
    public static boolean USE_NATIVE = false;
    static boolean isInit = false;
    public static int WINDOWS = 1;
    public static int LINUX = 2;
    public static int SOLARIS = 4;
    public static int REALLYLINUX = 8;
    public static int OS2 = 16;
    public static int OSX = 32;
    public static int SUNVM = 4;
    public static int JVIEW = 8;
    public static int JDK12 = 1;
    public static int JDK13 = 2;
    public static int JDK14 = 32;
    public static int IBMVM = 16;
    public static int VM = 1;
    public static int OS = 1;
    public static int JDK = 0;

    public static boolean IsJDK12() {
        return (JDK & JDK12) != 0;
    }

    public static boolean IsJDK13() {
        return (JDK & JDK13) != 0;
    }

    public static boolean IsJDK14() {
        return (JDK & JDK14) != 0;
    }

    public static boolean IsMSVM() {
        return VM == JVIEW;
    }

    public static boolean IsOSX() {
        return (OS & OSX) != 0;
    }

    public static boolean IsLinux() {
        return (OS & LINUX) != 0;
    }

    public static boolean IsBeta() {
        return System.getProperty("beta", "").equals("on");
    }

    public static void WinToFront(Window w) {
        try {
            if (Platforms.IsMSVM()) {
                Tracer.This.println("ShowWindowNoActivate");
                MissingApi.ShowWindowNoActivate(w);
            } else if (Platforms.IsWindows() && !Platforms.IsOS2()) {
                if (w instanceof Frame) {
                    Runtime.getRuntime().exec("missingapi N" + ((Frame)w).getTitle());
                }
            } else {
                w.toFront();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean IsReallyLinux() {
        return (OS & REALLYLINUX) != 0;
    }

    public static boolean IsWindows() {
        return (OS & WINDOWS) != 0;
    }

    public static boolean IsIBMVM() {
        return (VM & IBMVM) != 0;
    }

    public static boolean IsSolaris() {
        return (OS & SOLARIS) != 0;
    }

    public static boolean IsOS2() {
        return (OS & OS2) != 0;
    }

    public static boolean IsSunVM() {
        return (VM & SUNVM) != 0;
    }

    public static boolean IsJDK12(String jdkHome) {
        File f = new File(jdkHome + File.separator + "lib" + File.separator + "tools.jar");
        return f.exists();
    }

    public static String GetToolsPath(String jdkHome) {
        File f = new File(jdkHome + File.separator + "lib" + File.separator + "tools.jar");
        if (f.exists()) {
            return Platforms.GetClassesZip(jdkHome) + File.pathSeparator + jdkHome + File.separator + "lib" + File.separator + "tools.jar";
        }
        return Platforms.GetClassesZip(jdkHome);
    }

    public static String GetToolsJar(String jdkHome) {
        File f = new File(jdkHome + File.separator + "lib" + File.separator + "tools.jar");
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return Platforms.GetClassesZip(jdkHome);
    }

    public static String GetClassesZip(String jdkHome) {
        File f = new File("" + jdkHome + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar");
        if (f.exists()) {
            return VFile.GetOSCapitalization(f.getAbsolutePath());
        }
        return "" + jdkHome + File.separator + "lib" + File.separator + "classes.zip";
    }

    public static Color ChoiceColor() {
        if (OS == LINUX) {
            return SystemColor.control;
        }
        return Color.white;
    }

    public static void ensureRepaintFinished(JComponent j) {
        try {
            if (!Platforms.IsOSX() && EditApp.App != null && !EditApp.App.isInitalizing) {
                RepaintManager rp = RepaintManager.currentManager(j);
                rp.paintDirtyRegions();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void CheckPlatform() {
        String os = System.getProperty("os.name").toLowerCase();
        String vm = System.getProperty("java.vendor").toLowerCase();
        VFile f = new VFile("#staticdata/os.conf");
        if (f.exists() && f.canRead()) {
            try {
                Properties p = new Properties();
                FileInputStream in = new FileInputStream(f);
                p.load(in);
                in.close();
                os = p.getProperty("os", os);
                vm = p.getProperty("vendor", vm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (os.indexOf("os/2") >= 0) {
            Tracer.This.println("DETECTED OS/2 PLATFORM");
            OS = WINDOWS | OS2;
        } else if (os.indexOf("os x") >= 0) {
            Tracer.This.println("DETECTED MAC OS X PLATFORM");
            OS = LINUX | OSX;
        } else if (os.indexOf("windows") >= 0) {
            Tracer.This.println("DETECTED WINDOWS PLATFORM");
            OS = WINDOWS;
        } else {
            Tracer.This.println("DETECTED UNIX PLATFORM");
            OS = LINUX;
            if (os.indexOf("linux") >= 0) {
                Tracer.This.println("DETECTED LINUX PLATFORM");
                OS |= REALLYLINUX;
            } else if (os.indexOf("solaris") >= 0) {
                Tracer.This.println("DETECTED SOLARIS PLATFORM");
                OS |= SOLARIS;
            }
        }
        if (vm.indexOf("icrosoft") >= 0) {
            Tracer.This.println("DETECTED MSVM");
            VM = JVIEW;
        } else if (vm.indexOf("ibm") >= 0) {
            Tracer.This.println("DETECTED IBMVM");
            VM = SUNVM | IBMVM;
        } else {
            Tracer.This.println("DETECTED SUNVM");
            VM = SUNVM;
        }
        String vers = System.getProperty("java.version");
        if (vers != null && vers.startsWith("1.2")) {
            Tracer.This.println("DETECTED RUN IN 1.2 VM");
            JDK |= JDK12;
        }
        if (vers != null && vers.startsWith("1.3")) {
            Tracer.This.println("DETECTED RUN IN 1.3 VM");
            JDK |= JDK13 + JDK12;
        }
        if (vers != null && vers.startsWith("1.4")) {
            Tracer.This.println("DETECTED RUN IN 1.4 VM");
            JDK |= JDK13 + JDK12 + JDK14;
        }
    }
}

