/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.tools;

import de.netcomputing.util.Tracer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import netcomputing.tools.MyBA;

public class PropWriter {
    Hashtable entries = new Hashtable();
    Hashtable doubles = new Hashtable();
    String prefix = "";

    public DataOutputStream createStream(Object o) {
        String s = o.getClass().getName();
        int i = s.lastIndexOf(".");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        return this.createStream(s);
    }

    public DataOutputStream createStream(String name) {
        String id;
        MyBA out = new MyBA();
        String string = id = this.prefix.length() == 0 ? name : this.prefix + "." + name;
        if (this.entries.get(id) != null) {
            this.doubles.put(id, out);
        }
        this.entries.put(id, out);
        return new DataOutputStream(out);
    }

    public DataInputStream getStream(Object o) {
        String s = o.getClass().getName();
        int i = s.lastIndexOf(".");
        if (i >= 0) {
            s = s.substring(i + 1);
        }
        return this.getStream(s);
    }

    public boolean containsEntry(String name) {
        String id = this.prefix.length() == 0 ? name : this.prefix + "." + name;
        return this.entries.get(id) != null;
    }

    public DataInputStream getStream(String name) {
        String id = this.prefix.length() == 0 ? name : this.prefix + "." + name;
        Object o = this.entries.get(id);
        byte[] b = (byte[])(o instanceof byte[] || o == null ? o : (Object)((MyBA)o).getBuf());
        if (b == null) {
            b = new byte[]{};
        }
        return new DataInputStream(new ByteArrayInputStream(b));
    }

    public void mergeBeforeSave(PropWriter old) {
        Enumeration en = old.entries.keys();
        while (en.hasMoreElements()) {
            MyBA outBuf;
            String key = en.nextElement().toString();
            if (key.startsWith("tmp")) continue;
            if (!this.entries.containsKey(key)) {
                this.entries.put(key, new byte[0]);
            }
            if (this.entries.get(key) instanceof byte[]) {
                byte[] b = (byte[])this.entries.get(key);
                if (b != null && b.length != 0) continue;
                Tracer.This.println("PROPWRITER MERGE:" + key);
                if (old.entries.get(key) instanceof byte[]) {
                    this.entries.put(key, new MyBA((byte[])old.entries.get(key)));
                    continue;
                }
                this.entries.put(key, (MyBA)old.entries.get(key));
                continue;
            }
            if (!(this.entries.get(key) instanceof MyBA) || (outBuf = (MyBA)this.entries.get(key)) != null && outBuf.getBuf().length != 0) continue;
            Tracer.This.println("PROPWRITER MERGE:" + key);
            if (old.entries.get(key) instanceof byte[]) {
                this.entries.put(key, new MyBA((byte[])old.entries.get(key)));
                continue;
            }
            this.entries.put(key, (MyBA)old.entries.get(key));
        }
    }

    public PropWriter copy(String prefix) {
        PropWriter result = new PropWriter();
        result.entries = this.entries;
        result.prefix = this.prefix.length() > 0 ? this.prefix + "." + prefix : prefix;
        return result;
    }

    public PropWriter copyAbsolute(String prefix) {
        PropWriter result = new PropWriter();
        result.entries = this.entries;
        result.prefix = prefix;
        return result;
    }

    public void save(String file2) throws Exception {
        Tracer.This.println("PROPWRITER SAVE:" + file2);
        FileOutputStream fout = new FileOutputStream(file2);
        DataOutputStream out = new DataOutputStream(fout);
        Enumeration en = this.entries.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            MyBA bout = (MyBA)this.entries.get(key);
            byte[] b = bout.getBuf();
            int count = bout.getCount();
            if (count <= 0) continue;
            if (this.doubles.get(key) != null) {
                Tracer.This.println("---------------- DOUBLED STREAM:" + key);
            }
            out.writeInt(count);
            out.write(b, 0, count);
            out.writeUTF(key);
            Tracer.This.println("PROP SAVED:" + key + " count:" + count);
        }
        fout.close();
    }

    public void load(String file2) throws Exception {
        Tracer.This.println("PROPWRITE LOAD:" + file2);
        FileInputStream fout = new FileInputStream(file2);
        DataInputStream out = new DataInputStream(fout);
        int count = 0;
        try {
            while (true) {
                count = out.readInt();
                byte[] b = new byte[count];
                out.read(b, 0, count);
                String key = out.readUTF();
                this.entries.put(key, b);
                Tracer.This.println("PROP LOADED:" + key + " count:" + count);
            }
        }
        catch (EOFException ex) {
            fout.close();
            return;
        }
    }
}

