/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import JCollections.JArray;
import JCollections.JSet;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.AJRunDebug;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.debugger.DebuggerConnect;
import de.netcomputing.anyj.debugger.DebuggerMainPanel;
import de.netcomputing.anyj.debugger.communication.BreakPoint;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IClassCreator;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import jxeplugins.IJEBreakpointListener;
import jxeplugins.JEBasicPlugin;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.INCPrintOut;
import netcomputing.tools.Platforms;
import netcomputing.tools.PropWriter;
import plugins.tools.ToolExec;

public class DebuggerPlugin
extends JEBasicPlugin
implements IJEBreakpointListener {
    private static DebuggerPlugin This;
    AJRunDebug options;
    JSet breakpoints = new JSet(23);
    HashMap breakpointHash = new HashMap(23);
    JSet listeners = new JSet(11);
    String nextTerminatedView = "Edit";
    DebuggerMainPanel dbgMain = new DebuggerMainPanel();
    public static boolean hasWarned;
    public static String javaVersion;

    public static DebuggerPlugin This() {
        return This;
    }

    public void addProperties(EditApp app) {
    }

    public void init(EditApp app) {
        super.init(app);
        This = this;
        this.addBreakpointListener(this);
        this.getConfigPanel();
        this.options.getRunBtn().addTarget(this, "actionRun");
        this.options.getExecBtn().addTarget(this, "actionExec");
        this.options.getChkBox().addTarget(this, "actionCompileCP");
        this.addBreakpointListener(DebuggerMainPanel.This());
        JEBatchHostFrame.This().addPanel("Debugger", this.dbgMain, false, NCApplication.GetImage("/images/menus/Debug (Continue).gif"));
    }

    public String getName() {
        return "Debugger11Plugin";
    }

    void validateStates() {
        this.options.getClasspath().setEnabled(!this.options.getChkBox().isPressed());
    }

    public Object actionCompileCP(Object arg, Object sen) {
        this.validateStates();
        return null;
    }

    public Object actionEditCP(Object arg, Object sen) {
        String res = AJDirSelector.EditPathModal((Frame)this.options.getFrame(), this.options.getClasspath().getText(), "Path Editor");
        if (res != null) {
            this.options.getClasspath().setText(res);
        }
        return null;
    }

    public Object actionEditSP(Object arg, Object sen) {
        String res = AJDirSelector.EditPathModal((Frame)this.options.getFrame(), this.getSourcepath(), "Path Editor");
        if (res != null) {
            this.setSourcepath(res);
        }
        return null;
    }

    public void appExiting() {
    }

    public void storeGlobalProperty(PropWriter pw) throws Exception {
        DataOutputStream dos = pw.createStream("DebuggerConnectDefaults");
        HashMap map = DebuggerConnect.defVals;
        Iterator it = map.keySet().iterator();
        dos.writeInt(map.size());
        while (it.hasNext()) {
            String key = (String)it.next();
            dos.writeUTF(key);
            dos.writeUTF((String)map.get(key));
        }
    }

    public void loadGlobalProperty(PropWriter pw) throws Exception {
        DataInputStream dis = pw.getStream("DebuggerConnectDefaults");
        int siz = dis.readInt();
        int n = 0;
        while (n < siz) {
            String key = dis.readUTF();
            String val = dis.readUTF();
            DebuggerConnect.defVals.put(key, val);
            ++n;
        }
    }

    public void storeProperty(PropWriter pw) throws Exception {
        this.getConfigPanel();
        this.options.storeProperty(pw);
        Tracer.This.println("SAVING BPS:" + this.breakpoints.size());
        DataOutputStream dos = pw.createStream("breakpoints");
        dos.writeInt(this.breakpoints.size());
        Enumeration en = this.breakpoints.enumerate();
        while (en.hasMoreElements()) {
            BreakPoint bp = (BreakPoint)en.nextElement();
            dos.writeUTF(bp.getFile());
            dos.writeInt(bp.getLine());
            dos.writeBoolean(bp.getEnabled());
        }
    }

    public void loadProperty(PropWriter pw) throws Exception {
        this.getConfigPanel();
        try {
            this.options.loadProperty(pw);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.clearBreakpoints();
        try {
            DataInputStream dis = pw.getStream("breakpoints");
            int siz = dis.readInt();
            int n = 0;
            while (n < siz) {
                String fi = dis.readUTF();
                int line = dis.readInt();
                boolean b = dis.readBoolean();
                BreakPoint bp = this.setBreakpoint(line, new File(fi), true);
                if (bp != null && !b) {
                    EditApp.App.enableDisableBreakpoint(line, new File(fi));
                }
                ++n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
        this.validateStates();
    }

    public String getPropertyPath() {
        return "Workspace.Debug & Run";
    }

    public Component getConfigPanel() {
        if (this.options == null) {
            this.options = new AJRunDebug();
        }
        return this.options;
    }

    public String getWorkingDir() {
        return this.options.getWorkingDirFld().getText();
    }

    public String getClasspath() {
        if (this.options.getChkBox().isPressed()) {
            return EditApp.App.getCompileClasspath();
        }
        String s = this.options.getClasspath().getText().trim();
        boolean i = false;
        return s;
    }

    public String getExecLine() {
        return this.options.getExecLineFld().getText().trim();
    }

    public String getMainClass() {
        return this.options.getMainClassFld().getText();
    }

    public String getDebugLine() {
        return this.options.getDebugLineFld().getText();
    }

    public void setWorkingDir(String s) {
        this.options.getWorkingDirFld().setText(s);
    }

    public void setClasspath(String s) {
        this.options.getClasspath().setText(s);
    }

    public void setSourcepath(String s) {
        AJCompileAndBuild.This.getSourcepathFld().setText(s);
    }

    public String getSourcepath() {
        return AJCompileAndBuild.This.getDebugSourcePath();
    }

    public void setExecLine(String s) {
        this.options.getExecLineFld().setText(s);
    }

    public void setMainClass(String s) {
        this.options.getMainClassFld().setText(s);
    }

    public void setDebugLine(String s) {
        this.options.getDebugLineFld().setText(s);
    }

    public String getGlobalMenuName() {
        return "Debugger";
    }

    public void clearBreakpoints() {
        JArray arr = this.breakpoints.asJArray();
        int n = 0;
        while (n < arr.size()) {
            BreakPoint bp = (BreakPoint)arr.at(n);
            this.fireChange(bp.getLine(), new File(bp.getFile()), false);
            ++n;
        }
    }

    public boolean hasBreakPoint(String file2, int line) {
        return this.breakpointHash.containsKey(file2 + line);
    }

    public BreakPoint getBreakPoint(String file2, int line) {
        return (BreakPoint)this.breakpointHash.get(file2 + line);
    }

    public BreakPoint setBreakpoint(int line, File f, boolean set) {
        if (!f.exists()) {
            return null;
        }
        BreakPoint bp = new BreakPoint(line, f);
        if (set) {
            this.breakpoints.add(bp);
            this.breakpointHash.put(f.getAbsolutePath() + line, bp);
        } else {
            this.breakpoints.rem(bp);
            this.breakpointHash.remove(f.getAbsolutePath() + line);
        }
        this.fireChange(line, f, set);
        return bp;
    }

    public void fireChange(int line, File f, boolean set) {
        Enumeration en = this.listeners.enumerate();
        while (en.hasMoreElements()) {
            if (set) {
                ((IJEBreakpointListener)en.nextElement()).notifyBreakpointAdded(line, f);
                continue;
            }
            ((IJEBreakpointListener)en.nextElement()).notifyBreakpointRemoved(line, f);
        }
    }

    public void fireBPEnableDisable(int line, File f, boolean enabled) {
        Enumeration en = this.listeners.enumerate();
        while (en.hasMoreElements()) {
            ((IJEBreakpointListener)en.nextElement()).notifyBreakpointChanged(line, f, enabled);
        }
    }

    public void addBreakpointListener(IJEBreakpointListener bpl) {
        this.listeners.add(bpl);
    }

    public void removeAllBreakPointsIn(File f) {
    }

    public void notifyBreakpointRemoved(int line, File f) {
        this.dbgMain.removeBreakPoint(new BreakPoint(line, f));
    }

    public void notifyBreakpointAdded(int line, File f) {
        this.dbgMain.addBreakPoint(new BreakPoint(line, f));
    }

    public void notifyBreakpointChanged(int line, File f, boolean enabled) {
    }

    public String getSettingsIconTTip() {
        return "Debug & Run Settings";
    }

    public Image getSettingsIcon() {
        return NCApplication.GetImage("plugin-debugger");
    }

    public String getActionIconTTip() {
        return "Run in Debugger (Ctrl F6)";
    }

    public Image getActionIcon() {
        return NCApplication.GetImage("plugin-rundebug");
    }

    public String getDescription() {
        return "Sun JDK DebugApi based Debugger. Needs >= JDK 1.1.6 installed.";
    }

    public Object actionRun(Object a, Object s) {
        this.runDebugger();
        return null;
    }

    public Object actionSUN(Object a, Object s) {
        String clzip;
        String cp = this.stripCP(false);
        if (cp.indexOf(clzip = Platforms.GetClassesZip((String)this.app.getWorkspaceProperty("Directory.jdkHome"))) < 0 && cp.indexOf("($SystemClasses)") < 0) {
            cp = cp + File.pathSeparator + "($SystemClasses)";
        }
        this.setClasspath(cp);
        if (Platforms.IsJDK12() || Platforms.IsLinux()) {
            this.setExecLine("java");
        } else {
            this.setExecLine("java");
        }
        return null;
    }

    public Object actionExec(Object a, Object s) {
        this.runExec();
        return null;
    }

    public Vector getBreakPointsIn(File f) {
        Vector<BreakPoint> v = new Vector<BreakPoint>(5);
        Enumeration en = this.breakpoints.enumerate();
        while (en.hasMoreElements()) {
            BreakPoint bp = (BreakPoint)en.nextElement();
            if (!f.getAbsolutePath().equals(bp.getFile())) continue;
            v.addElement(bp);
        }
        return v;
    }

    public void redefineAllBreakpoints() {
        Enumeration en = this.breakpoints.enumerate();
        while (en.hasMoreElements()) {
            BreakPoint bp = (BreakPoint)en.nextElement();
            this.dbgMain.removeBreakPoint(bp);
            this.dbgMain.addBreakPoint(bp);
        }
    }

    public void insertDefaults() {
        String cl;
        if (Platforms.IsJDK12("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome")) && this.getExecLine().indexOf("-nojit") >= 0) {
            this.setExecLine(NCStringUtilities.Replace(this.getExecLine(), "-nojit", "-Djava.compiler=none"));
        }
        if ((cl = this.getExecLine().trim()).length() == 0) {
            this.setExecLine("java");
        }
        if (this.getSourcepath().trim().length() == 0) {
            Vector v = this.app.getAllDirs();
            StringBuffer buff = new StringBuffer(100);
            int n = 0;
            while (n < v.size()) {
                String s = v.elementAt(n).toString().trim();
                buff.append(s + File.pathSeparator);
                ++n;
            }
            this.setSourcepath(buff.toString());
        }
    }

    public Object actionAutoSourcePath(Object arg, Object sen) {
        Vector v = this.app.getAllDirs();
        StringBuffer buff = new StringBuffer(100);
        int n = 0;
        while (n < v.size()) {
            String s = v.elementAt(n).toString().trim();
            buff.append(s + File.pathSeparator);
            ++n;
        }
        this.setSourcepath(buff.toString());
        return null;
    }

    public String stripCP(boolean ms) {
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, this.getClasspath());
        StringBuffer res = new StringBuffer(200);
        int n = 0;
        while (n < v.size()) {
            String s = (String)v.elementAt(n);
            s = s.trim();
            String sup = EditApp.App.getTemplateEngine().insertEnvVars(s, null);
            if (sup == null) {
                sup = s;
            }
            sup = sup.toUpperCase();
            boolean append = true;
            Tracer.This.println("**************************************" + sup);
            if (!Platforms.IsLinux()) {
                if (s.endsWith(".exe")) {
                    append = false;
                } else if (ms) {
                    if (!sup.startsWith(("" + System.getProperty("com.ms.windir")).toUpperCase()) && (sup.endsWith("CLASSES.ZIP") || sup.endsWith("CLASSES.JAR") || sup.endsWith("RT.JAR"))) {
                        append = false;
                    }
                } else if (Platforms.IsMSVM() && sup.startsWith(System.getProperty("com.ms.windir").toUpperCase()) && (sup.endsWith("CLASSES.ZIP") || sup.endsWith("CLASSES.JAR") || sup.endsWith("RT.JAR"))) {
                    append = false;
                }
            }
            if (append) {
                res.append(s);
                res.append(File.pathSeparator);
            }
            ++n;
        }
        return res.toString();
    }

    private boolean isJDK12() {
        return Platforms.IsJDK12(EditApp.App.getWorkspaceProperty("Directory.jdkHome").toString());
    }

    public INCPrintOut getOrShowToolEx(String name) {
        MyToolExec toolEx = new MyToolExec(EditApp.App);
        JEBatchHostFrame.This().addPanel("Debug", toolEx, true, NCApplication.GetImage("/images/menus/Debug (Continue).gif"));
        JEBatchHostFrame.This().showTab("Debug");
        return toolEx;
    }

    public void stopExec() {
        ToolExec ex = (ToolExec)JEBatchHostFrame.This().getTabComponent("Run");
        if (ex != null) {
            ex.stopProcess();
        }
    }

    public void runExec() {
        String cpString;
        this.insertDefaults();
        this.app.runPreRunAction();
        MyToolExec toolEx = new MyToolExec(this.app);
        MyToolExec oldTex = (MyToolExec)JEBatchHostFrame.This().getTabComponent("Run");
        Process oldProc = null;
        if (oldTex != null) {
            oldProc = oldTex.getCurrentProc();
        }
        JEBatchHostFrame.This().addPanel("Run", toolEx, true, NCApplication.GetImage("/images/menus/Run Active Main Class.gif"));
        JEBatchHostFrame.This().showTab("Run");
        EditFrame.Host().notifyViewSwitch("Run");
        toolEx.setWdir(EditApp.App.getTemplateEngine().insertEnvVars(this.getWorkingDir(), null));
        String ex = this.getExecLine().trim();
        String anf = "";
        String string = cpString = this.isJDK12() && AJRunDebug.This.useBootCP() ? "-Xbootclasspath:" : "-classpath ";
        if (this.getClasspath().trim().indexOf(" ") >= 0) {
            anf = "\"";
        }
        if (ex.toLowerCase().startsWith("java")) {
            ex = this.app.getWorkspaceProperty("Directory.jdkHome") + File.separator + "bin" + File.separator + ex;
        }
        if (ex.toLowerCase().startsWith("jview")) {
            toolEx.setCommandText(ex + " /cp:p " + anf + this.getClasspath() + anf + " " + this.getMainClass() + " " + this.getDebugLine());
        } else {
            toolEx.setCommandText(ex + " " + cpString + anf + this.getClasspath() + anf + " " + this.getMainClass() + " " + this.getDebugLine());
        }
        if (oldProc != null) {
            this.nextTerminatedView = "Run";
        }
        ((ToolExec)toolEx).startProcess();
        this.app.runPastRunAction();
    }

    public void runRemoteDebugger() {
        JEBatchHostFrame.This().showTab("Debugger");
        this.app.runPreDebugAction();
        this.dbgMain.setSourcePath(this.replaceVars(this.getSourcepath()));
        String debugExec = this.getExecLine().trim();
        if (debugExec.toLowerCase().indexOf("-classic") < 0 && AJRunDebug.This.useClassic() && Platforms.IsWindows()) {
            if (debugExec.startsWith("java ")) {
                debugExec = NCStringUtilities.Replace(debugExec, "java ", "java -classic ");
            } else if (debugExec.startsWith("javaw ")) {
                debugExec = NCStringUtilities.Replace(debugExec, "javaw ", "java -classic ");
            } else if (debugExec.equals("java") || debugExec.equals("javaw")) {
                debugExec = "java -classic ";
            }
        }
        if (AJRunDebug.This.useXIntOnDebug()) {
            debugExec = debugExec + " -Xint";
        }
        this.dbgMain.startRemoteDebugProcess(EditApp.App.getWorkspaceProperty("Directory.jdkHome").toString(), this.replaceVars(this.getWorkingDir()), this.replaceVars(this.replaceVars(debugExec) + " " + "-cp " + this.replaceVars(this.getClasspath())), this.replaceVars(this.getMainClass()), this.replaceVars(this.getDebugLine()));
    }

    public void runDebugger() {
        if (!hasWarned) {
            hasWarned = true;
            try {
                javaVersion = EditApp.App.findJavaVersion();
            }
            catch (Throwable ex) {
                ex.printStackTrace(Tracer.This);
                javaVersion = "";
            }
        }
        if ("1.4.0".equals(javaVersion)) {
            Confirm.ModalMsg(EditApp.App.getMainWindow(), "Warning", new String[]{"JDK 1.4.0 has some serious problems", "in the Debug API implementation.", "Please upgrade your JDK to 1.4.0_01 or higher"});
        }
        JEBatchHostFrame.This().showTab("Debugger");
        this.app.runPreDebugAction();
        this.dbgMain.setSourcePath(this.replaceVars(this.getSourcepath()));
        String debugExec = this.getExecLine().trim();
        if (debugExec.toLowerCase().indexOf("-classic") < 0 && AJRunDebug.This.useClassic() && Platforms.IsWindows()) {
            if (debugExec.startsWith("java ")) {
                debugExec = NCStringUtilities.Replace(debugExec, "java ", "java -classic ");
            } else if (debugExec.startsWith("javaw ")) {
                debugExec = NCStringUtilities.Replace(debugExec, "javaw ", "java -classic ");
            } else if (debugExec.equals("java") || debugExec.equals("javaw")) {
                debugExec = "java -classic ";
            }
        }
        if (AJRunDebug.This.useXIntOnDebug() && debugExec.toLowerCase().indexOf("-classic") < 0) {
            debugExec = debugExec + " -Xint";
        }
        String myCp = File.pathSeparator + System.getProperty("java.class.path", "anyj.jar");
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, myCp);
        myCp = File.pathSeparator;
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.elementAt(i);
            myCp = myCp + new File(s).getAbsolutePath() + File.pathSeparator;
            ++i;
        }
        this.dbgMain.startDebugProcess(EditApp.App.getWorkspaceProperty("Directory.jdkHome").toString(), this.replaceVars(this.getWorkingDir()), this.replaceVars(this.replaceVars(debugExec) + " " + "-cp " + this.replaceVars(this.getClasspath()) + myCp), this.replaceVars("de.netcomputing.anyj.debugger.RemoteInterpreter"), this.replaceVars(this.getMainClass() + " " + this.getDebugLine()));
    }

    String replaceVars(String s) {
        return EditApp.App.getTemplateEngine().insertEnvVars(s, null);
    }

    public void sendAllBreakPoints() {
        Enumeration en = this.breakpoints.enumerate();
        while (en.hasMoreElements()) {
            BreakPoint bp = (BreakPoint)en.nextElement();
            this.dbgMain.addBreakPoint(bp);
        }
    }

    public Object actionOptions(Object a, Object s) {
        this.app.openOptions(this.getPropertyPath());
        return null;
    }

    public void actionRequested(Object selectedObject) {
        this.runDebugger();
    }

    static {
        NCApplication.PutImage("plugin-debugger", "buttons/debugopt.gif");
        NCApplication.PutImage("plugin-rundebug", "buttons/debug.gif");
        hasWarned = false;
        javaVersion = "";
    }

    class MyToolExec
    extends ToolExec {
        public MyToolExec(IClassCreator app) {
            super(app);
        }

        public void init() {
            super.init();
            this.getOptionsBtn().addTarget(DebuggerPlugin.This(), "actionOptions");
            this.getProcessBtn().hide();
            this.getOptionsBtn().setVisible(true);
        }

        public void startProcess() {
            this.setCommandText(EditApp.App.getTemplateEngine().insertEnvVars(this.getCommandText(), null));
            super.startProcess();
        }

        public void frameClosing() {
            super.frameClosing();
            if (this.current != null) {
                this.current.destroy();
            }
            this.current = null;
        }

        public void processTerminated(int ex) {
            super.processTerminated(ex);
            EditFrame.Host().notifyViewSwitch(DebuggerPlugin.this.nextTerminatedView);
            DebuggerPlugin.this.nextTerminatedView = "Edit";
        }
    }
}

