/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import JCollections.JArray;
import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.io.File;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Vector;
import jxeplugins.JEBasicPlugin;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;
import netcomputing.tools.INCExtendedPrintout;
import netcomputing.tools.NCOutOutputStream;

public class InterpreterPlugin
extends JEBasicPlugin {
    public static InterpreterPlugin This;
    TreeInterpreter interpreter;

    public InterpreterPlugin() {
        This = this;
    }

    public void init(EditApp app) {
        super.init(app);
        JEBasicService ser = new JEBasicService("Interpret", "Evaluate Selection", 0){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof TextDocument && ((TextDocument)selection).hasSelection();
            }

            public void doProcess(Object selection, Object selector) {
                new Thread(this, selection){
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        1.access$000(this.this$1).interpret((TextDocument)this.val$selection);
                    }
                }.start();
            }

            static /* synthetic */ InterpreterPlugin access$000(1 x0) {
                return x0.InterpreterPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("Interpret", "Reset Interpreter", 0){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                InterpreterPlugin.this.interpreter = null;
            }
        };
        app.addService(ser);
    }

    public PrintStream getInterpreterOutput() {
        INCExtendedPrintout output = JEBatchHostFrame.This().createOutput("Interpret", false);
        PrintStream p = new PrintStream(new NCOutOutputStream(output));
        return p;
    }

    public String getInterpreterClasspath() {
        String res = System.getProperty("java.class.path");
        String[] jars = new VFile("#userdata/scripts").list();
        int n = 0;
        while (jars != null && n < jars.length) {
            if (jars[n].endsWith(".jar")) {
                res = res + File.pathSeparator + VFile.ResolveName("#userdata/scripts/" + jars[n]);
            }
            ++n;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interpret(String toRun) {
        INCExtendedPrintout output = JEBatchHostFrame.This().createOutput("Interpret");
        if (this.interpreter == null) {
            this.interpreter = new TreeInterpreter(new JavaCCParserFactory());
            this.interpreter.addLibrarySuffix(".java");
            Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, this.getInterpreterClasspath());
            int n = 0;
            while (n < v.size()) {
                Tracer.This.println(v.elementAt(n));
                this.interpreter.addClassPath("" + v.elementAt(n));
                ++n;
            }
        }
        Tracer.This.println(toRun);
        PrintStream oldout = System.out;
        PrintStream olderr = System.err;
        PrintStream p = this.getInterpreterOutput();
        System.setOut(p);
        System.setErr(p);
        try {
            try {
                p.println("==> " + this.interpreter.interpret(new StringReader(toRun), "selection"));
            }
            catch (InterpreterException e) {
                p.println(" *** " + e.getMessage());
                Object var9_8 = null;
                System.setOut(oldout);
                System.setErr(olderr);
                return;
            }
            catch (Throwable e) {
                p.println(e);
                Object var9_9 = null;
                System.setOut(oldout);
                System.setErr(olderr);
                return;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            System.setOut(oldout);
            System.setErr(olderr);
            throw throwable;
        }
        System.setOut(oldout);
        System.setErr(olderr);
    }

    public void interpret(TextDocument doc) {
        String toRun = doc.getSelectionAsString();
        JArray arr = new JArray(20);
        String pack = DocumentStream.ScanImports(doc, arr, true);
        int n = 0;
        while (n < arr.size()) {
            if (arr.at(n).toString().equals("java.lang")) {
                toRun = "import java.lang.*;\n" + toRun;
            } else if (!arr.at(n).equals(pack)) {
                toRun = "import " + arr.at(n) + ";\n" + toRun;
            }
            ++n;
        }
        if (pack != null) {
            toRun = "package " + pack + ";\n" + toRun;
        }
        this.interpret(toRun);
    }
}

