/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import JCollections.DirIterator;
import JCollections.JSet;
import JCollections.JUnsafeTable;
import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.EditCanvas;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJCompilePanel;
import de.netcomputing.anyj.application.FileSet;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Vector;
import jxeplugins.FileSetupEntry;
import jxeplugins.JEBasicPlugin;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.Platforms;
import netcomputing.tools.PropWriter;
import plugins.javac.DependencyFinder;
import plugins.tools.ToolExec;

public class JavacPlugin
extends JEBasicPlugin {
    static int DIRS_AT_ONCE = 20;
    static int MAX_CLINE = 1800;
    public static AJCompileAndBuild options;
    public static AJCompilePanel compilePanel;
    static JavacPlugin This;
    boolean isBusy = false;
    FilenameFilter javaFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".java");
        }
    };

    public static Vector getOptions() {
        return options.getOptions();
    }

    public static Vector getOptions(int compilertype) {
        return options.getOptions(compilertype);
    }

    public static boolean useJVC() {
        return options.useJVC();
    }

    public static JavacPlugin This() {
        return This;
    }

    public void addProperties(EditApp app) {
        if (app.getWorkspaceProperty("File.javac") == null) {
            app.setWorkspaceProperty("File.javac", "Host System path lookup");
        }
    }

    public void showCompileTab() {
        JEBatchHostFrame.This().showTab("Compile");
        JEBatchHostFrame.This().show();
    }

    public void init(EditApp app) {
        AJCompilePanel tcp;
        super.init(app);
        This = this;
        options = new AJCompileAndBuild();
        options.setApplication(EditApp.App);
        compilePanel = tcp = new AJCompilePanel(app);
        JEBatchHostFrame.This().addPanel("Compile", tcp, false, NCApplication.GetImage("/images/props/Compile & Build.gif"));
        JEBasicService ser = new JEBasicService("Compile", "Compile File or Dir", 80){

            public boolean isDynamic() {
                return true;
            }

            public boolean canProcess(Object selection, Object selector) {
                return JWidgetsUtil.IsLongTermQueueEmpty() && (selector instanceof EditCanvas || selection instanceof FileSet || selection instanceof File && (((File)selection).isDirectory() || ((File)selection).getName().endsWith(".java") || ((File)selection).getName().endsWith(".JAVA")));
            }

            public void doProcess(Object selection, Object selector) {
                if (selector instanceof EditCanvas) {
                    try {
                        ((EditCanvas)selector).getDocument().save();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(Tracer.This);
                    }
                    selection = ((EditCanvas)selector).getDocument().getFile();
                }
                if (selection instanceof FileSet) {
                    Object tmp = selection;
                    JWidgetsUtil.AddLongRunningJob(new Runnable(this, tmp){
                        private final /* synthetic */ Object val$tmp;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$tmp = val$tmp;
                        }

                        public void run() {
                            1.access$000(this.this$1).build((FileSet)this.val$tmp);
                        }
                    });
                } else {
                    TextDocument doc = EditApp.App.findOpenFileNamed(((File)selection).getAbsolutePath());
                    if (doc != null && doc.getFile().canWrite()) {
                        try {
                            doc.save();
                        }
                        catch (Exception ex) {
                            Confirm.MsgException(ex);
                        }
                    }
                    JavacPlugin.this.compile((File)selection);
                }
            }

            static /* synthetic */ JavacPlugin access$000(1 x0) {
                return x0.JavacPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("Compile", "Compile Directory Recursive", 80){

            public boolean isDynamic() {
                return true;
            }

            public boolean canProcess(Object selection, Object selector) {
                return JWidgetsUtil.IsLongTermQueueEmpty() && selection instanceof File && ((File)selection).isDirectory();
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    EditApp.App.saveActiveEditors();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JWidgetsUtil.AddLongRunningJob(new Runnable(this, selection){
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        if (!3.access$100(this.this$1).checkForMsg(true)) {
                            3.access$100(this.this$1).buildRec((File)this.val$selection);
                        }
                    }
                });
            }

            static /* synthetic */ JavacPlugin access$100(3 x0) {
                return x0.JavacPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("Compile", "Build Changed Files", 81){

            public boolean isDynamic() {
                return true;
            }

            public boolean canProcess(Object selection, Object selector) {
                return JWidgetsUtil.IsLongTermQueueEmpty();
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    EditApp.App.saveActiveEditors();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JWidgetsUtil.AddLongRunningJob(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!5.access$200(this.this$1).checkForMsg(true)) {
                            5.access$200(this.this$1).build();
                        }
                    }
                });
            }

            static /* synthetic */ JavacPlugin access$200(5 x0) {
                return x0.JavacPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("Compile", "Run RMIC", 79){

            public boolean isDynamic() {
                return true;
            }

            public boolean canProcess(Object selection, Object selector) {
                return JWidgetsUtil.IsLongTermQueueEmpty();
            }

            public void doProcess(Object selection, Object selector) {
                JWidgetsUtil.AddLongRunningJob(new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        7.access$300(this.this$1).runRMIC();
                    }
                });
            }

            static /* synthetic */ JavacPlugin access$300(7 x0) {
                return x0.JavacPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("Compile", "Build All Workspace Files", 79){

            public boolean isDynamic() {
                return true;
            }

            public boolean canProcess(Object selection, Object selector) {
                return JWidgetsUtil.IsLongTermQueueEmpty();
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    EditApp.App.saveActiveEditors();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                JWidgetsUtil.AddLongRunningJob(new Runnable(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        if (!9.access$400(this.this$1).checkForMsg(true)) {
                            9.access$400(this.this$1).rebuildAll();
                        }
                    }
                });
            }

            static /* synthetic */ JavacPlugin access$400(9 x0) {
                return x0.JavacPlugin.this;
            }
        };
        app.addService(ser);
    }

    public Image getSettingsIcon() {
        return NCApplication.GetImage("plugin-compileopt");
    }

    public String getSettingsIconTTip() {
        return "Compiler Settings";
    }

    public Image getEditorIcon() {
        return NCApplication.GetImage("javacPlugin-compile");
    }

    public String getName() {
        return "CompilerPlugin";
    }

    public String getEditorIconTTip() {
        return "Save & Compile (F8)";
    }

    public String getDescription() {
        return "This plugin enables you to invoke the javac or the jvc compiler from within AnyJ.";
    }

    public String getGlobalMenuName() {
        return "Compile Panel";
    }

    boolean checkForMsg() {
        return this.checkForMsg(false);
    }

    boolean checkForMsg(boolean b) {
        if (this.isBusy || b && !compilePanel.getProcessBtn().isEnabled()) {
            Confirm.ModalMsg(EditApp.App.getMainWindow(), "Already compiling", new String[]{"There is already a build job running.", "Please wait until this job has terminated,", "or kill the running process using tools", "provided by your Operating System."});
            return true;
        }
        return false;
    }

    public int buildDependent() {
        return 0;
    }

    JSet changedFilesNoOutput() {
        JSet changed = new JSet(100);
        String sp = AJCompileAndBuild.This.getSourcePathAndCompute();
        Vector v = NCFileUtilities.GetPathAsVector(sp);
        int i = 0;
        while (i < v.size()) {
            String s = v.get(i).toString();
            File f = new File(s);
            Vector cont = DirIterator.DirContent(f, ".java", true);
            int ii = 0;
            while (ii < cont.size()) {
                File javaFile = (File)cont.get(ii);
                File clazzFile = new File(javaFile.getParent(), javaFile.getName().substring(0, javaFile.getName().length() - ".java".length()) + ".class");
                if (!clazzFile.exists() || javaFile.lastModified() > clazzFile.lastModified()) {
                    changed.add(javaFile);
                }
                ++ii;
            }
            ++i;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int build() {
        compilePanel.notifyBuildStart();
        if (this.checkForMsg()) {
            return -1;
        }
        try {
            int res;
            this.isBusy = true;
            this.app.runPreBuildAction();
            compilePanel.clear();
            compilePanel.addMessage("[looking for changed files ...");
            compilePanel.addMessage("");
            Vector test = this.app.getDirsToCompile();
            JSet changed = this.changedFiles(test);
            if (changed.size() > DIRS_AT_ONCE) {
                JSet nchanged = new JSet();
                Enumeration en = changed.enumerate();
                while (en.hasMoreElements()) {
                    String fi = en.nextElement().toString();
                    fi = new File(fi).getParent();
                    nchanged.add(fi);
                }
                changed = nchanged;
            }
            if ((res = this.build(changed)) >= 0) {
                if (options.getRMIOnBuild()) {
                    this.runRMIC();
                }
                this.app.runPastBuildAction();
            }
            int n = res;
            Object var7_8 = null;
            this.isBusy = false;
            return n;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.isBusy = false;
            throw throwable;
        }
    }

    public int runRMIC() {
        Vector files = options.getRMIFileSet();
        String outputDir = options.getRMIOutput().trim();
        StringBuffer cline = new StringBuffer(1000);
        String jdk = (String)EditApp.App.getWorkspaceProperty("Directory.jdkHome") + "";
        outputDir = EditApp.App.getTemplateEngine().insertEnvVars(outputDir, null);
        if (outputDir.length() == 0) {
            outputDir = VFile.ResolveName("#actproject/rmic_out");
        }
        File outFile = new File(outputDir);
        if (Platforms.IsWindows()) {
            cline.append(jdk + File.separator + "bin" + File.separator + "rmic.exe -classpath " + EditApp.App.getCompileClasspath() + (AJCompileAndBuild.This.isOutputDirEnabled() ? " -d " + outputDir : "") + (options.getRMINoWarn() ? " -nowarn" : "") + (options.getRMIDebug() ? " -g" : "") + " -v1.2");
        } else {
            cline.append(jdk + File.separator + "bin" + File.separator + "rmic -classpath " + EditApp.App.getCompileClasspath() + (AJCompileAndBuild.This.isOutputDirEnabled() ? " -d " + outputDir : "") + (options.getRMINoWarn() ? " -nowarn" : "") + (options.getRMIDebug() ? " -g" : ""));
        }
        try {
            outFile.mkdirs();
            int n = 0;
            while (n < files.size()) {
                String clazz = ((ListItem)files.elementAt(n)).getDisplayString();
                cline.append(" " + clazz);
                ++n;
            }
            ToolExec toolEx = new ToolExec(EditApp.App);
            JEBatchHostFrame.This().addPanel("RMIC", toolEx, true);
            JEBatchHostFrame.This().showTab("RMIC");
            if (files.size() == 0) {
                JEBatchHostFrame.This().createOutput("RMIC").printLine("Please setup up Remote Classes in Preferences, RMI");
            } else {
                toolEx.setCommandText(cline.toString());
                toolEx.setWdir(VFile.ResolveName("#actproject"));
                toolEx.startProcess();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.ModalMsg("Error during RMIC compiling", ex.getMessage());
            return -1;
        }
        return 0;
    }

    void createDirs(JUnsafeTable packMap) {
        Enumeration allPacks = packMap.keys();
        String odir = EditApp.App.getTemplateEngine().insertEnvVars(options.getOutputDir(), null);
        while (allPacks.hasMoreElements()) {
            String p = (String)allPacks.nextElement();
            try {
                new File(odir + File.separator + p.replace('.', File.separatorChar)).mkdirs();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    int buildInBestPackOrder(JSet changed, String base) {
        int tmpresult;
        if (AJCompileAndBuild.This.getUseTmpFile()) {
            return this.build(base, changed, false, true);
        }
        if (base == null) {
            base = this.calcBase(changed.enumerate());
        }
        JSet dirs = new JSet(100);
        Vector v = options.getExcludeDirs();
        int maxDirLen = 0;
        compilePanel.addMessage("[collecting dirs ...");
        Enumeration en = changed.enumerate();
        while (en.hasMoreElements()) {
            String compiled;
            String checkExcl = compiled = en.nextElement().toString();
            boolean ex = false;
            if (compiled.endsWith(".java")) {
                checkExcl = VFile.ExtractDir(compiled);
            }
            while (checkExcl.endsWith(File.pathSeparator)) {
                checkExcl = checkExcl.substring(0, checkExcl.length() - 1);
            }
            int n = 0;
            while (n < v.size()) {
                if (checkExcl.endsWith((String)v.elementAt(n))) {
                    ex = true;
                    break;
                }
                ++n;
            }
            if (ex) continue;
            if (maxDirLen < compiled.length() - base.length() + 1) {
                maxDirLen = compiled.length() - base.length() + 1;
            }
            dirs.add(compiled);
        }
        compilePanel.addMessage("analyzing dependencies pass 1 ...");
        DependencyFinder dpf = new DependencyFinder(this.getOutputDir());
        JUnsafeTable dependMap = new JUnsafeTable(dirs.size() * 2);
        Enumeration dirsEn = dirs.enumerate();
        while (dirsEn.hasMoreElements()) {
            String dir = dirsEn.nextElement().toString();
            dpf.calcPackDependenceFromSource(dir, dependMap, false);
        }
        compilePanel.addMessage("creating packages in outputdir ...");
        this.createDirs(dependMap);
        compilePanel.addMessage("analyzing dependencies pass 2 ...");
        dpf.expandPackDependendMap(dependMap);
        int result = 0;
        JSet dirsToCompile = new JSet(20);
        JSet packToCompile = new JSet(20);
        boolean notFirst = true;
        compilePanel.addMessage("compiling ...");
        while (dirs.size() > 0) {
            Tracer.This.println("DEPENDMAP.SIZE:" + dependMap.size());
            Tracer.This.println("DIRS.SIZE:" + dirs.size());
            Tracer.This.println("DIRSTOCOMPILE.SIZE:" + dirsToCompile.size());
            if (dirs.size() + dirsToCompile.size() < MAX_CLINE / maxDirLen) {
                dirsToCompile.addAll(dirs);
                break;
            }
            String pack = dpf.findIslandPackage(dependMap);
            if (pack == null) {
                dirsToCompile.addAll(dirs);
                break;
            }
            JUnsafeTable tab = (JUnsafeTable)dependMap.get(pack);
            packToCompile.add(pack);
            en = ((JUnsafeTable)tab.clone()).keys();
            while (en.hasMoreElements()) {
                String p = (String)en.nextElement();
                packToCompile.add(p);
                dpf.removePack(p, dependMap);
            }
            dpf.removePack(pack, dependMap);
            JSet res = this.findDirsFromPackList(packToCompile, dirs, base);
            if (dirsToCompile.size() + res.size() < MAX_CLINE / maxDirLen) {
                dirsToCompile.addAll(res);
                continue;
            }
            int tmpresult2 = this.build(base, dirsToCompile, false, notFirst);
            if (tmpresult2 != 0) {
                result = tmpresult2;
            }
            dirsToCompile.clear();
            dirsToCompile.addAll(res);
            notFirst = false;
        }
        if (dirsToCompile.size() > 0 && (tmpresult = this.build(base, dirsToCompile, false, notFirst)) != 0) {
            result = tmpresult;
        }
        return result;
    }

    JSet findDirsFromPackList(JSet packages, JSet dirs, String base) {
        JSet res = new JSet(20);
        Enumeration enP = packages.enumerate();
        while (enP.hasMoreElements()) {
            String actPack = (String)enP.nextElement();
            Enumeration enDirs = dirs.enumerate();
            while (enDirs.hasMoreElements()) {
                String actP;
                String actDir = (String)enDirs.nextElement();
                if (!actDir.endsWith(actP = File.separator + actPack.replace('.', File.separatorChar))) continue;
                Tracer.This.println("ADDED ****" + actDir);
                res.add(actDir);
                dirs.rem(actDir);
            }
        }
        return res;
    }

    public int build(JSet changed) {
        return this.build(null, changed, true, true);
    }

    String calcBase(Enumeration files) {
        String base = NCStringUtilities.LongestCommonStart(files);
        while (!base.endsWith(File.separator) && base.length() > 0) {
            base = base.substring(0, base.length() - 1);
        }
        if (!new File(base).isDirectory()) {
            base = "";
        }
        return base;
    }

    public int build(String base, JSet changed, boolean tryDepAnalysis, boolean doClear) {
        if (this.getClasspath().trim().length() == 0) {
            compilePanel.addMessage("FATAL: Classpath is not set, (check Preferences,Paths))");
            return -1;
        }
        Enumeration en = changed.enumerate();
        StringBuffer toCompile = new StringBuffer(5000);
        compilePanel.setDoClear(doClear);
        Vector v = options.getExcludeDirs();
        if (base == null) {
            base = this.calcBase(changed.enumerate());
        }
        Tracer.This.println("---------------------------" + base);
        options.setWdir(base);
        while (en.hasMoreElements()) {
            String compiled;
            String checkExcl = compiled = en.nextElement().toString();
            boolean ex = false;
            if (compiled.endsWith(".java")) {
                checkExcl = VFile.ExtractDir(compiled);
            }
            while (checkExcl.endsWith(File.pathSeparator)) {
                checkExcl = checkExcl.substring(0, checkExcl.length() - 1);
            }
            int n = 0;
            while (n < v.size()) {
                if (checkExcl.endsWith((String)v.elementAt(n))) {
                    ex = true;
                    break;
                }
                ++n;
            }
            if (ex) continue;
            String compiled0 = compiled;
            File fileToCompile = new File(compiled0);
            if ((compiled = compiled.substring(base.length())).length() == 0 || compiled.equals(File.separator)) {
                compiled = ".";
            }
            while (compiled.startsWith(File.separator)) {
                compiled = compiled.substring(File.separator.length());
            }
            if (fileToCompile.isDirectory()) {
                compiled = this.expandDirForJavac(base, compiled);
            } else if (compiled.indexOf(32) >= 0) {
                compiled = "\"" + compiled + "\"";
            }
            if (AJCompileAndBuild.This.getUseTmpFile()) {
                if (fileToCompile.isDirectory()) {
                    String[] res = fileToCompile.list(this.javaFilter);
                    if (res != null && res.length > 0) {
                        int n2 = 0;
                        while (n2 < res.length) {
                            toCompile.append(fileToCompile.getAbsolutePath() + File.separator + res[n2] + "\n");
                            ++n2;
                        }
                    }
                } else {
                    toCompile.append(fileToCompile.getAbsolutePath() + "\n");
                }
            } else {
                toCompile.append(compiled + " ");
            }
            if (AJCompileAndBuild.This.getUseTmpFile() || toCompile.length() <= MAX_CLINE || !Platforms.IsWindows()) continue;
            if (tryDepAnalysis) {
                compilePanel.addMessage("commandline length overflow, performing dependency check to separate compiling .. ");
                return this.buildInBestPackOrder(changed, base);
            }
            Tracer.This.println("************************************ bestPackorder cancelled, FLAT BUILD ********************************");
            compilePanel.setCommandText(toCompile.toString().trim());
            compilePanel.process();
            while (compilePanel.getCurrent() != null) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            toCompile.setLength(0);
            compilePanel.setDoClear(false);
        }
        String c = toCompile.toString().trim();
        if (c.length() == 0) {
            compilePanel.addMessage("[project is up to date !");
            compilePanel.setDoClear(true);
            return 0;
        }
        compilePanel.setCommandText(c);
        compilePanel.process();
        while (compilePanel.getCurrent() != null) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        compilePanel.notifyBuildEnd();
        compilePanel.setDoClear(true);
        return 1;
    }

    public void setClasspath(String s) {
        options.setClasspath(s);
    }

    public String getClasspath() {
        if (options != null) {
            return options.getClasspathTxt().getText();
        }
        return null;
    }

    public void setOutputDir(String dir) {
        options.getOutputTxt().setText(dir);
    }

    public String getOutputDir() {
        if (options != null) {
            return options.getOutputTxt().getText();
        }
        return null;
    }

    public void setOptions(boolean debug, boolean nowarn, boolean optimize, boolean dependent, boolean enableOut) {
        options.setOptions(debug, nowarn, optimize, dependent, enableOut);
    }

    public void buildRec(Object selectedObject) {
        compilePanel.notifyBuildStart();
        File fi = (File)selectedObject;
        Vector cont = DirIterator.DirContent(fi, ".java", true);
        JSet set = new JSet(cont.size() / 10);
        int n = 0;
        while (n < cont.size()) {
            set.add(((File)cont.elementAt(n)).getParent());
            ++n;
        }
        this.build(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(Object selectedObject) {
        if (this.getClasspath().trim().length() == 0) {
            compilePanel.addMessage("FATAL: Classpath is not set, (check Preferences,Paths))");
            return;
        }
        compilePanel.notifyBuildStart();
        if (this.checkForMsg(true)) {
            return;
        }
        try {
            this.isBusy = true;
            String fileToCompile = null;
            if (selectedObject instanceof TextDocument) {
                try {
                    ((TextDocument)selectedObject).save();
                }
                catch (Exception e) {
                    ConfirmDiag.Msg(null, "Unable to save " + ((TextDocument)selectedObject).getFile());
                }
                fileToCompile = ((TextDocument)selectedObject).getFile().getAbsolutePath();
            } else if (selectedObject instanceof File) {
                fileToCompile = ((File)selectedObject).getAbsolutePath();
            }
            if (fileToCompile != null) {
                File toComp = new File(fileToCompile);
                if (toComp.isDirectory()) {
                    fileToCompile = this.expandDirForJavac("", fileToCompile);
                }
                compilePanel.setCommandText(fileToCompile);
                compilePanel.process();
            }
            Object var5_5 = null;
            this.isBusy = false;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.isBusy = false;
            throw throwable;
        }
    }

    String expandDirForJavac(String base, String dir) {
        String[] cont = new File(base + File.separator + dir).list();
        StringBuffer result = new StringBuffer(2000);
        int n = 0;
        while (cont != null && n < cont.length) {
            if (cont[n].endsWith(".java")) {
                result.append(dir + File.separator + cont[n] + " ");
            }
            ++n;
        }
        return result.toString();
    }

    public void actionRequested(Object arg) {
        this.compile(arg);
    }

    public String getPropertyPath() {
        return "Workspace.Compile & Build";
    }

    public Component getConfigPanel() {
        return options;
    }

    public int rebuildAllClean() {
        compilePanel.notifyBuildStart();
        compilePanel.addMessage("deleting classfiles ...");
        if (AJCompileAndBuild.This.isOutputDirEnabled()) {
            File outDir = new File(EditApp.App.getTemplateEngine().insertEnvVars(this.getOutputDir(), null));
            outDir.mkdirs();
            Vector v = DirIterator.DirContent(outDir, ".class");
            int n = 0;
            while (n < v.size()) {
                try {
                    ((File)v.elementAt(n)).delete();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++n;
            }
        } else {
            String sp = AJCompileAndBuild.This.getSourcePathAndCompute();
            Vector v = NCFileUtilities.GetPathAsVector(sp);
            int i = 0;
            while (i < v.size()) {
                String s = v.get(i).toString();
                File f = new File(s);
                Vector cont = DirIterator.DirContent(f, ".class", true);
                int ii = 0;
                while (ii < cont.size()) {
                    try {
                        ((File)cont.elementAt(ii)).delete();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++ii;
                }
                ++i;
            }
        }
        return this.rebuildAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rebuildAll() {
        compilePanel.notifyBuildStart();
        if (this.checkForMsg()) {
            return -1;
        }
        this.isBusy = true;
        try {
            this.app.runPreBuildAction();
            Vector dirs = this.app.getDirsToCompile();
            JSet result = new JSet(20);
            compilePanel.clear();
            compilePanel.addMessage("[collecting files ...");
            int n = 0;
            while (n < dirs.size()) {
                String s = (String)dirs.elementAt(n);
                File f = new File(s);
                if (f.isDirectory()) {
                    Vector files = new Vector(2000);
                    this.dirContent(f, files, ".java");
                    int nn = 0;
                    while (nn < files.size()) {
                        File fi = (File)files.elementAt(nn);
                        result.add(new File(VFile.ExtractDir(fi.getAbsolutePath())));
                        ++nn;
                    }
                }
                ++n;
            }
            int res = this.buildInBestPackOrder(result, null);
            this.app.runPastBuildAction();
            int n2 = res;
            Object var10_11 = null;
            this.isBusy = false;
            return n2;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.isBusy = false;
            throw throwable;
        }
    }

    public void dirContent(File root, Vector result, String ending) {
        FileSetupEntry fse = EditApp.App.getOptionsFor(root.getAbsolutePath());
        if (fse != null && !fse.checkForChanges) {
            return;
        }
        String[] dir = root.list();
        int n = 0;
        while (dir != null && n < dir.length) {
            File cur = new File(root, dir[n]);
            if (cur.isDirectory()) {
                this.dirContent(cur, result, ending);
            } else if (dir[n].toLowerCase().endsWith(ending)) {
                result.add(cur);
            }
            ++n;
        }
    }

    public JSet changedFiles(Vector dirs) {
        if (!AJCompileAndBuild.This.isOutputDirEnabled()) {
            return this.changedFilesNoOutput();
        }
        JSet result = new JSet(11);
        String out = EditApp.App.getTemplateEngine().insertEnvVars(options.getOutputDir(), null);
        String wspace = EditApp.App.getTemplateEngine().insertEnvVars(options.getWdir(), null);
        int n = 0;
        while (n < dirs.size()) {
            String s = (String)dirs.elementAt(n);
            File f = new File(s);
            String usePre = null;
            if (!(!options.useOutputDir() || (usePre = out).length() > 1 && !Platforms.IsLinux() && usePre.charAt(1) == ':' || Platforms.IsLinux() && usePre.startsWith("/"))) {
                usePre = wspace + File.separator + usePre;
            }
            if (f.isDirectory()) {
                Vector files = new Vector(2000);
                this.dirContent(f, files, ".java");
                int nn = 0;
                while (nn < files.size()) {
                    File fi = (File)files.elementAt(nn);
                    if (!fi.isDirectory() && fi.getName().indexOf("_jsp_") < 0) {
                        long time = fi.lastModified();
                        File classFile = null;
                        if (usePre == null) {
                            classFile = new File(fi.getAbsolutePath().substring(0, fi.getAbsolutePath().length() - 4) + "class");
                        } else {
                            String pack = DocumentStream.ScanPackage(fi);
                            pack = pack.replace('.', File.separatorChar);
                            classFile = new File(usePre + File.separator + pack + File.separator + VFile.NameWithoutExtension(fi.getAbsolutePath()) + ".class");
                        }
                        long time1 = classFile.lastModified();
                        if (time > time1 || !classFile.exists()) {
                            result.add(fi.getAbsolutePath());
                        }
                    }
                    ++nn;
                }
            }
            ++n;
        }
        return result;
    }

    boolean isRessource(File f) {
        return f.getName().endsWith(".gml") || f.getName().endsWith(".gif");
    }

    public void storeProperty(PropWriter pw) throws Exception {
        options.storeProperty(pw);
    }

    public void loadProperty(PropWriter pw) throws Exception {
        options.loadProperty(pw);
    }

    static {
        NCApplication.PutImage("javacPlugin-compile", "buttons/compile.gif");
        NCApplication.PutImage("plugin-compileopt", "buttons/compileopt.gif");
    }
}

