/*
 * Decompiled with CFR 0.152.
 */
package plugins.vcontrolui;

import JCollections.JSet;
import JCollections.JUnsafeArray;
import JWVFile.VFile;
import Jxe.EditPanel;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.anyj.jwidgets.JIBPanel;
import de.netcomputing.anyj.jwidgets.JSplitLayout;
import de.netcomputing.anyj.jwidgets.JWArrayTableModel;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.NCTableView;
import editapp.EditApp;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTextField;
import plugins.vcontrolui.DiffTableModel;
import versioncontrol.FileDiffEntry;
import versioncontrol.VersionControl;

public class ChangeBrowserPanel
extends NCPanel {
    public static EditApp App;
    public static VersionControl vcontrol;
    NCTableView tableView;
    NCButton copyBtn;
    NCButton diffBtn;
    NCButton searchBtn;
    NCButton searchDirBtn;
    NCButton selFileBtn;
    NCButton showBtn;
    NCButton nowBtn;
    NCCheckBox chkBox;
    public JTextField maxDateTxt;
    public JTextField fileTxt;
    public JTextField txtFld;
    public JTextField rollbackFileTxt;
    public JTextField minDateTxt;
    JLabel headLabel;
    EditPanel editPanel;
    JUnsafeArray diffs;

    public void init() {
        super.init();
        JSplitLayout jsl = new JSplitLayout(200);
        this.setLayout(jsl);
        jsl.fixed = 1;
        this.setBackground(JWColor.For("background"));
        JIBPanel jp = new JIBPanel(){

            public String getJIBName() {
                return "ChangeBrowser.jib";
            }

            public void init() {
                super.init();
                this.setBackground(JWColor.For("background"));
                ChangeBrowserPanel.this.tableView = (NCTableView)this.getComponent("tableView");
                ChangeBrowserPanel.this.copyBtn = (NCButton)this.getComponent("copyBtn");
                ChangeBrowserPanel.this.diffBtn = (NCButton)this.getComponent("diffBtn");
                ChangeBrowserPanel.this.searchBtn = (NCButton)this.getComponent("searchBtn");
                ChangeBrowserPanel.this.selFileBtn = (NCButton)this.getComponent("selFileBtn");
                ChangeBrowserPanel.this.searchDirBtn = (NCButton)this.getComponent("searchDirBtn");
                ChangeBrowserPanel.this.showBtn = (NCButton)this.getComponent("showBtn");
                ChangeBrowserPanel.this.nowBtn = (NCButton)this.getComponent("nowBtn");
                ChangeBrowserPanel.this.maxDateTxt = (JTextField)this.getComponent("maxDateTxt");
                ChangeBrowserPanel.this.fileTxt = (JTextField)this.getComponent("fileTxt");
                ChangeBrowserPanel.this.rollbackFileTxt = (JTextField)this.getComponent("rollbackFileTxt");
                ChangeBrowserPanel.this.txtFld = (JTextField)this.getComponent("txtFld");
                ChangeBrowserPanel.this.minDateTxt = (JTextField)this.getComponent("minDateTxt");
                ChangeBrowserPanel.this.headLabel = (JLabel)this.getComponent("headLabel");
                ChangeBrowserPanel.this.chkBox = (NCCheckBox)this.getComponent("chkBox");
                ChangeBrowserPanel.this.chkBox.setPressed(true);
            }
        };
        this.add("top", jp);
        jp.init(App);
        jp = new JIBPanel(){

            public String getJIBName() {
                return "ChangeBrowserBottom.jib";
            }

            public void init() {
                super.init();
                ChangeBrowserPanel.this.headLabel = (JLabel)this.getComponent("awtLabel");
                ChangeBrowserPanel.this.editPanel = (EditPanel)this.getComponent("editB");
            }
        };
        this.add("bottom", jp);
        jp.init(App);
        this.diffs = new JUnsafeArray();
        this.tableView.setFlags(NCTableView.ROWSELECTABLE | NCTableView.ROWMULTI | NCTableView.COLPRESSABLE | NCTableView.COLMOVABLE | NCTableView.COLSIZEABLE);
        DiffTableModel model = new DiffTableModel();
        model.init(this.diffs, 0L, System.currentTimeMillis(), null, this.chkBox.isPressed() ? 0 : -1);
        this.tableView.setModel(model);
        this.tableView.binderRowSelection().addTarget(this, "actionTableSelect");
        this.searchBtn.addTarget(this, "actionSearch");
        this.selFileBtn.addTarget(this, "actionSelFile");
        this.searchDirBtn.addTarget(this, "actionSearchDir");
        this.nowBtn.addTarget(this, "actionNow");
        this.showBtn.addTarget(this, "actionShowFile");
        this.diffBtn.addTarget(this, "actionShowDiff");
        this.copyBtn.addTarget(this, "actionCopy");
        this.minDateTxt.setText("");
        this.maxDateTxt.setText("");
        this.txtFld.setText("");
        this.rollbackFileTxt.setText("");
        this.fileTxt.setText("");
        this.tableView.binderColSelection().addTarget(this, "actionColSelChanged");
        this.editPanel.getDocument().setReadOnly(true);
        this.adjustState();
        this.setName("hidChangeBrowser");
    }

    void adjustState() {
        this.showBtn.setEnabled(this.tableView.getRowSelection() >= 0);
        this.copyBtn.setEnabled(this.tableView.getRowSelection() >= 0);
        this.diffBtn.setEnabled(this.tableView.getRowSelection() >= 0);
    }

    void readConstraints(long[] minmax, String[] comment) {
        String s = this.minDateTxt.getText();
        DateFormat df = DateFormat.getDateTimeInstance();
        df.setLenient(true);
        try {
            minmax[0] = df.parse(s).getTime();
        }
        catch (Exception e) {
            minmax[0] = 0L;
        }
        this.minDateTxt.setText(df.format(new Date(minmax[0])));
        s = this.maxDateTxt.getText();
        try {
            minmax[1] = df.parse(s).getTime();
        }
        catch (Exception e) {
            minmax[1] = System.currentTimeMillis();
        }
        this.maxDateTxt.setText(df.format(new Date(minmax[1])));
        comment[0] = this.txtFld.getText().trim();
    }

    public void setFileAndSearch(File fi) {
        this.fileTxt.setText(fi.getAbsolutePath());
        this.actionSearch(null, this);
    }

    public String getCurrentBase() {
        return VFile.ExtractDir(this.fileTxt.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object actionCopy(Object arg, Object sen) {
        File f;
        block16: {
            this.cursorWait();
            String s = this.rollbackFileTxt.getText();
            f = new File(s);
            if (f.exists() && f.isDirectory()) break block16;
            ConfirmDiag.Msg((Window)((Frame)this.getFrame()), "The specified file is not an existing Dir");
            Object var5_5 = null;
            Object var20_7 = null;
            this.cursorDefault();
            return var5_5;
        }
        try {
            int[] sel = this.tableView.getRowSelections();
            JSet dbls = new JSet(sel.length);
            boolean doubles = false;
            int n = 0;
            while (n < sel.length && !doubles) {
                Object[] line = (Object[])((DiffTableModel)this.tableView.getModel()).lines.at(sel[n]);
                if (line != null) {
                    sel[n] = this.diffs.indexOf(line[5]);
                    if (sel[n] >= 0) {
                        if (dbls.find(((FileDiffEntry)line[5]).fileName) != null) {
                            doubles = true;
                            break;
                        }
                        dbls.add(((FileDiffEntry)line[5]).fileName);
                    }
                }
                ++n;
            }
            File toWrite = null;
            if (doubles) {
                ConfirmDiag.Msg((Window)((Frame)this.getFrame()), "There are some files selected twice");
            } else {
                VersionControl vc = vcontrol;
                boolean alreadyThere = false;
                int n2 = 0;
                while (n2 < sel.length) {
                    TextDocument doc = vc.restoreDocument(this.diffs, sel[n2], this.getCurrentBase());
                    String fName = ((FileDiffEntry)this.diffs.at((int)sel[n2])).fileName;
                    if (fName.length() >= 2 && fName.charAt(1) == ':') {
                        fName = fName.substring(2);
                    }
                    fName = vc.normalizeDir(fName);
                    String target = null;
                    target = VFile.StripDoubleSeps(f.getAbsolutePath() + File.separator + fName, File.separatorChar).toString();
                    VFile.ExtractDir(target);
                    String dir = target.substring(0, target.lastIndexOf(File.separator));
                    File dirFile = new File(dir);
                    try {
                        dirFile.mkdirs();
                        toWrite = new File(target);
                        if (!toWrite.exists()) {
                            doc.coreSave(toWrite);
                        } else {
                            alreadyThere = true;
                        }
                    }
                    catch (Exception e) {
                        ConfirmDiag.Msg((Window)((Frame)this.getFrame()), "failed to write " + toWrite.getAbsolutePath());
                        e.printStackTrace();
                    }
                    ++n2;
                }
                if (alreadyThere) {
                    ConfirmDiag.Msg((Window)((Frame)this.getFrame()), "Some files weren't copied, because a file with same name was already existing");
                }
            }
            Object var20_8 = null;
        }
        catch (Throwable throwable) {
            Object var20_9 = null;
            this.cursorDefault();
            throw throwable;
        }
        this.cursorDefault();
        return null;
    }

    public Object actionSearchDir(Object arg, Object sen) {
        File f = new File(this.fileTxt.getText());
        if (f.isDirectory()) {
            return this.actionSearch(null, null);
        }
        if (!f.exists()) {
            return null;
        }
        try {
            this.fileTxt.setText(VFile.ExtractDir(this.fileTxt.getText()));
        }
        catch (Exception e) {
            return null;
        }
        this.actionSearchDir(null, null);
        return null;
    }

    public Object actionNow(Object arg, Object sen) {
        this.maxDateTxt.setText(DateFormat.getDateTimeInstance().format(new Date()));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object actionSearch(Object arg, Object sen) {
        String[] comment;
        long[] minmax;
        block5: {
            Object var6_6;
            try {
                this.cursorWait();
                this.fileTxt.setText(VFile.StripDoubleSeps(this.fileTxt.getText(), File.separatorChar).toString());
                this.tableView.deselectHeaderQuietNoNotify();
                this.tableView.clearRowSelections();
                this.adjustState();
                minmax = new long[]{0L, System.currentTimeMillis()};
                comment = new String[]{""};
                this.readConstraints(minmax, comment);
                final File f = new File(this.fileTxt.getText());
                if (f.exists()) break block5;
                new Thread(new Runnable(){

                    public void run() {
                        ConfirmDiag.Msg((Window)((Frame)ChangeBrowserPanel.this.getFrame()), "Unable to open File " + f.getAbsolutePath());
                    }
                }).start();
                var6_6 = null;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.cursorDefault();
                throw throwable;
            }
            this.cursorDefault();
            return var6_6;
        }
        VersionControl vc = vcontrol;
        try {
            this.diffs = vc.historyFor(this.fileTxt.getText());
        }
        catch (Exception e) {
            ConfirmDiag.Msg((Window)((Frame)this.getFrame()), "No changes available for this file");
            e.printStackTrace();
        }
        ((DiffTableModel)this.tableView.getModel()).init(this.diffs, minmax[0], minmax[1], comment[0], this.chkBox.isPressed() ? 0 : -1);
        JWidgetsUtil.AddJob(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ChangeBrowserPanel.this.tableView.fitColumnsToView(500);
                ChangeBrowserPanel.this.tableView.repaint();
            }
        });
        Object var9_9 = null;
        this.cursorDefault();
        return null;
    }

    public Object actionSelFile(Object arg, Object sen) {
        File f = AJDirSelector.SelectDirModal((Frame)this.getFrame(), null, "Select a Dir or File", null, this.fileTxt.getText(), null);
        if (f != null) {
            this.fileTxt.setText(f.getAbsolutePath());
        }
        return null;
    }

    public Object actionShowFile(Object arg, Object sen) {
        if (this.tableView.getRowSelection() >= 0) {
            VersionControl vc = vcontrol;
            int sel = this.tableView.getRowSelection();
            if (sel < 0) {
                return null;
            }
            Object[] line = (Object[])((DiffTableModel)this.tableView.getModel()).lines.at(sel);
            sel = this.diffs.indexOf(line[5]);
            TextDocument doc = vc.restoreDocument(this.diffs, sel, this.getCurrentBase());
            this.editPanel.setDocument(doc);
            this.editPanel.forceComponentRepaint();
            this.headLabel.setText("File " + line[0].toString() + " at " + line[1].toString() + ", " + line[2].toString());
        }
        return null;
    }

    public Object actionTableSelect(Object arg, Object sen) {
        this.adjustState();
        return null;
    }

    public Object actionShowDiff(Object arg, Object sen) {
        int sel = this.tableView.getRowSelection();
        if (sel < 0) {
            return null;
        }
        Object[] line = (Object[])((DiffTableModel)this.tableView.getModel()).lines.at(sel);
        VersionControl vc = vcontrol;
        sel = this.diffs.indexOf(line[5]);
        TextDocument doc = vc.restoreDocument(this.diffs, sel, this.getCurrentBase());
        TextDocument curr = new TextDocument();
        curr.init(null);
        String currFile = ((FileDiffEntry)line[5]).fileName;
        currFile = vc.normalizeDir(currFile);
        currFile = this.getCurrentBase() + File.separator + VFile.NameWithExtension(currFile);
        curr.coreLoad(new File(currFile));
        this.openSimpleFileDiff("Differences to " + line[0].toString() + " " + line[1].toString(), line[0].toString() + " at " + line[1].toString() + ", " + line[2].toString(), curr.getFile().getAbsolutePath(), doc, curr);
        return null;
    }

    public Object actionColSelChanged(Object arg, Object sen) {
        int a = this.tableView.getColSelection();
        if (a >= 0) {
            ((JWArrayTableModel)this.tableView.getModel()).sortBy(a);
        }
        return null;
    }

    public void openSimpleFileDiff(String title, String titleA, String titleB, TextDocument a, TextDocument b) {
        EditApp.App.openSimpleFileDiff(title, titleA, titleB, a, b);
    }

    static {
        vcontrol = new VersionControl();
    }
}

