/*
 * Decompiled with CFR 0.152.
 */
package plugins.vcontrolui;

import Jxe.AttributedTextLine;
import Jxe.EditPanel;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.JIBPanel;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.util.Tracer;
import java.awt.Window;
import javax.swing.JLabel;
import plugins.vcontrolui.ChangeBrowserPanel;

public class SimpleFileDiffPanel
extends JIBPanel {
    protected EditPanel editB;
    protected EditPanel editA;
    protected JLabel doLabel;
    protected JLabel upLabel;
    protected NCButton nextBtn;
    protected NCButton prevBtn;
    protected int[][] currDiff;
    boolean ignoreNext = false;

    public void init() {
        super.init();
        this.editB = (EditPanel)this.getComponent("editB");
        this.editA = (EditPanel)this.getComponent("editA");
        this.doLabel = (JLabel)this.getComponent("doLabel");
        this.upLabel = (JLabel)this.getComponent("upLabel");
        this.nextBtn = (NCButton)this.getComponent("nextBtn");
        this.prevBtn = (NCButton)this.getComponent("prevBtn");
        this.editA.getDocument().setReadOnly(true);
        this.editB.getDocument().setReadOnly(true);
        this.editA.addTarget(this, "actionEditACMove");
        this.editB.addTarget(this, "actionEditBCMove");
        if (this.nextBtn != null) {
            this.nextBtn.addTarget(this, "actionNext");
        }
        if (this.prevBtn != null) {
            this.prevBtn.addTarget(this, "actionPrev");
            this.prevBtn.setVisible(false);
        }
        this.setName("hidFileDiff");
    }

    public String getJIBName() {
        return "simplefilediff.jib";
    }

    public void setDocuments(TextDocument a, TextDocument b, String titleA, String titleB) {
        this.editA.setDocument(a);
        this.editB.setDocument(b);
        a.setReadOnly(true);
        b.setReadOnly(true);
        this.upLabel.setText(titleA);
        this.doLabel.setText(titleB);
        this.currDiff = null;
        this.compare();
    }

    public void compare() {
        TextDocument docA = this.editA.getDocument();
        TextDocument docB = this.editB.getDocument();
        int[][] diff = docA.diffTo(docB);
        int n = 0;
        while (n < docA.size()) {
            docA.setLineStyle(10, n, false);
            ++n;
        }
        int n2 = 0;
        while (n2 < docB.size()) {
            docB.setLineStyle(10, n2, false);
            ++n2;
        }
        int n3 = 0;
        while (n3 < diff.length) {
            docA.setLineStyle(0, diff[n3][0], false);
            ++n3;
        }
        this.editA.forceComponentRepaint();
        int n4 = 0;
        while (n4 < diff.length) {
            docB.setLineStyle(0, diff[n4][1], false);
            ++n4;
        }
        this.editB.forceComponentRepaint();
        int n5 = 0;
        while (n5 < diff.length) {
            Tracer.This.println(diff[n5][0] + " " + diff[n5][1]);
            ++n5;
        }
        this.currDiff = diff;
    }

    public Object actionNext(Object arg, Object sen) {
        TextDocument a = this.editA.getDocument();
        TextDocument b = this.editB.getDocument();
        int ya = a.cY() + 1;
        int yb = b.cY() + 1;
        if (ya < a.size() && yb < b.size()) {
            AttributedTextLine li = a.lineAt(ya);
            while (li.size() > 0 && li.styleAt(0) == '\n') {
                li = a.lineAt(++ya);
            }
            li = a.lineAt(yb);
            while (li.size() > 0 && li.styleAt(0) == '\n') {
                li = a.lineAt(++yb);
            }
        } else {
            yb = 0;
            ya = 0;
        }
        while (ya < a.size() && yb < b.size()) {
            AttributedTextLine la = a.lineAt(ya);
            if (la.size() > 0 && la.styleAt(0) == '\n') {
                a.moveCursorAbs(a.cX(), ya);
                this.actionEditACMove(null, null);
                return null;
            }
            AttributedTextLine lb = b.lineAt(yb);
            if (lb.size() > 0 && lb.styleAt(0) == '\n') {
                b.moveCursorAbs(b.cX(), yb);
                this.actionEditBCMove(null, null);
                return null;
            }
            ++ya;
            ++yb;
        }
        return null;
    }

    public Object actionPrev(Object arg, Object sen) {
        return null;
    }

    public Object actionEditACMove(Object arg, Object sen) {
        if (this.currDiff != null && !this.ignoreNext) {
            int cy = this.editA.getDocument().cY();
            int max = 0;
            int maxB = 0;
            int n = 0;
            while (n < this.currDiff.length) {
                if (this.currDiff[n][0] <= cy && max < this.currDiff[n][0]) {
                    max = this.currDiff[n][0];
                    maxB = this.currDiff[n][1];
                }
                ++n;
            }
            this.ignoreNext = true;
            if (this.editB.getDocument().cY() != maxB) {
                this.editB.getDocument().moveCursorAbs(this.editB.getDocument().cX(), maxB);
            }
        }
        this.ignoreNext = false;
        return null;
    }

    public void frameClosing() {
        ChangeBrowserPanel.App.dropFrame((Window)this.getFrame());
    }

    public Object actionEditBCMove(Object arg, Object sen) {
        if (this.currDiff != null && !this.ignoreNext) {
            int cy = this.editB.getDocument().cY();
            int max = 0;
            int maxA = 0;
            int n = 0;
            while (n < this.currDiff.length) {
                if (this.currDiff[n][1] <= cy && max < this.currDiff[n][1]) {
                    max = this.currDiff[n][1];
                    maxA = this.currDiff[n][0];
                }
                ++n;
            }
            this.ignoreNext = true;
            if (this.editA.getDocument().cY() != maxA) {
                this.editA.getDocument().moveCursorAbs(this.editA.getDocument().cX(), maxA);
            }
        }
        this.ignoreNext = false;
        return null;
    }
}

