/*
 * Decompiled with CFR 0.152.
 */
package util;

import de.netcomputing.util.Tracer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import util.AttributeInfo;
import util.ConstantPoolInfo;
import util.FieldInfo;
import util.MethodInfo;

public class ClassFile {
    int magic;
    short majorVersion;
    short minorVersion;
    ConstantPoolInfo[] constantPool;
    public short accessFlags;
    public ConstantPoolInfo thisClass;
    public ConstantPoolInfo superClass;
    public ConstantPoolInfo[] interfaces;
    public FieldInfo[] fields;
    public MethodInfo[] methods;
    public AttributeInfo[] attributes;
    public boolean isValidClass = false;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_THREADSAFE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public boolean debug = false;
    public boolean dumpConstants = false;

    public static String ScanPackage(String file2) throws IOException {
        ClassFile cf = new ClassFile();
        FileInputStream in = new FileInputStream(file2);
        cf.read(in);
        return cf.getClassName();
    }

    public int readShort(DataInputStream di) throws IOException {
        int i = di.readShort();
        if (i < 0) {
            i += 65536 - i;
        }
        return i;
    }

    public boolean read(InputStream in) throws IOException {
        int i;
        DataInputStream di = new DataInputStream(in);
        this.magic = di.readInt();
        if (this.magic != -889275714) {
            return false;
        }
        this.majorVersion = di.readShort();
        this.minorVersion = di.readShort();
        short count = di.readShort();
        this.constantPool = new ConstantPoolInfo[count];
        if (this.debug) {
            Tracer.This.println("read(): Read header...");
        }
        this.constantPool[0] = new ConstantPoolInfo();
        int i2 = 1;
        while (i2 < this.constantPool.length) {
            this.constantPool[i2] = new ConstantPoolInfo();
            if (!this.constantPool[i2].read(di)) {
                return false;
            }
            if (this.constantPool[i2].type == 5 || this.constantPool[i2].type == 6) {
                ++i2;
            }
            ++i2;
        }
        int i3 = 1;
        while (i3 < this.constantPool.length) {
            if (this.constantPool[i3] != null) {
                if (this.constantPool[i3].index1 > 0) {
                    this.constantPool[i3].arg1 = this.constantPool[this.constantPool[i3].index1];
                }
                if (this.constantPool[i3].index2 > 0) {
                    this.constantPool[i3].arg2 = this.constantPool[this.constantPool[i3].index2];
                }
            }
            ++i3;
        }
        if (this.dumpConstants) {
            i = 1;
            while (i < this.constantPool.length) {
                Tracer.This.println("C" + i + " - " + this.constantPool[i]);
                ++i;
            }
        }
        this.accessFlags = di.readShort();
        this.thisClass = this.constantPool[this.readShort(di)];
        this.superClass = this.constantPool[this.readShort(di)];
        if (this.debug) {
            Tracer.This.println("read(): Read class info...");
        }
        if ((count = di.readShort()) != 0) {
            if (this.debug) {
                Tracer.This.println("Class implements " + count + " interfaces.");
            }
            this.interfaces = new ConstantPoolInfo[count];
            i = 0;
            while (i < count) {
                short iindex = di.readShort();
                if (iindex < 1 || iindex > this.constantPool.length - 1) {
                    return false;
                }
                this.interfaces[i] = this.constantPool[iindex];
                if (this.debug) {
                    Tracer.This.println("I" + i + ": " + this.interfaces[i]);
                }
                ++i;
            }
        }
        if (this.debug) {
            Tracer.This.println("read(): Read interface info...");
        }
        count = di.readShort();
        if (this.debug) {
            Tracer.This.println("This class has " + count + " fields.");
        }
        if (count != 0) {
            this.fields = new FieldInfo[count];
            i = 0;
            while (i < count) {
                this.fields[i] = new FieldInfo();
                if (!this.fields[i].read(di, this.constantPool)) {
                    return false;
                }
                if (this.debug) {
                    Tracer.This.println("F" + i + ": " + this.fields[i].toString(this.constantPool));
                }
                ++i;
            }
        }
        if (this.debug) {
            Tracer.This.println("read(): Read field info...");
        }
        if ((count = di.readShort()) != 0) {
            this.methods = new MethodInfo[count];
            i = 0;
            while (i < count) {
                this.methods[i] = new MethodInfo();
                if (!this.methods[i].read(di, this.constantPool)) {
                    return false;
                }
                if (this.debug) {
                    Tracer.This.println("M" + i + ": " + this.methods[i].toString());
                }
                ++i;
            }
        }
        if (this.debug) {
            Tracer.This.println("read(): Read method info...");
        }
        if ((count = di.readShort()) != 0) {
            this.attributes = new AttributeInfo[count];
            i = 0;
            while (i < count) {
                this.attributes[i] = new AttributeInfo();
                if (!this.attributes[i].read(di, this.constantPool)) {
                    return false;
                }
                ++i;
            }
        }
        if (this.debug) {
            Tracer.This.println("read(): Read attribute info...");
            Tracer.This.println("done.");
        }
        this.isValidClass = true;
        return true;
    }

    public void write(OutputStream out) throws IOException, Exception {
        int i;
        DataOutputStream dos = new DataOutputStream(out);
        if (!this.isValidClass) {
            throw new Exception("ClassFile::write() - Invalid Class");
        }
        dos.writeInt(this.magic);
        dos.writeShort(this.majorVersion);
        dos.writeShort(this.minorVersion);
        dos.writeShort(this.constantPool.length);
        int i2 = 1;
        while (i2 < this.constantPool.length) {
            if (this.constantPool[i2] != null) {
                this.constantPool[i2].write(dos, this.constantPool);
            }
            ++i2;
        }
        dos.writeShort(this.accessFlags);
        dos.writeShort(ConstantPoolInfo.indexOf(this.thisClass, this.constantPool));
        dos.writeShort(ConstantPoolInfo.indexOf(this.superClass, this.constantPool));
        if (this.interfaces == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.interfaces.length);
            i = 0;
            while (i < this.interfaces.length) {
                dos.writeShort(ConstantPoolInfo.indexOf(this.interfaces[i], this.constantPool));
                ++i;
            }
        }
        if (this.fields == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.fields.length);
            i = 0;
            while (i < this.fields.length) {
                this.fields[i].write(dos, this.constantPool);
                ++i;
            }
        }
        if (this.methods == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.methods.length);
            i = 0;
            while (i < this.methods.length) {
                this.methods[i].write(dos, this.constantPool);
                ++i;
            }
        }
        if (this.attributes == null) {
            dos.writeShort(0);
        } else {
            dos.writeShort(this.attributes.length);
            i = 0;
            while (i < this.attributes.length) {
                this.attributes[i].write(dos, this.constantPool);
                ++i;
            }
        }
    }

    public static String accessString(short flags) {
        StringBuffer x = new StringBuffer();
        if ((flags & 1) != 0) {
            x.append("public ");
        }
        if ((flags & 2) != 0) {
            x.append("private ");
        }
        if ((flags & 4) != 0) {
            x.append("protected ");
        }
        if ((flags & 8) != 0) {
            x.append("static ");
        }
        if ((flags & 0x10) != 0) {
            x.append("final ");
        }
        if ((flags & 0x20) != 0) {
            x.append("synchronized ");
        }
        if ((flags & 0x40) != 0) {
            x.append("threadsafe ");
        }
        if ((flags & 0x80) != 0) {
            x.append("transient ");
        }
        if ((flags & 0x100) != 0) {
            x.append("native ");
        }
        if ((flags & 0x200) != 0) {
            x.append("interface ");
        }
        if ((flags & 0x400) != 0) {
            x.append("abstract ");
        }
        return x.toString();
    }

    public static String typeString(String typeString, String varName) {
        int isArray = 0;
        int ndx = 0;
        StringBuffer x = new StringBuffer();
        while (typeString.charAt(ndx) == '[') {
            ++isArray;
            ++ndx;
        }
        switch (typeString.charAt(ndx)) {
            case 'B': {
                x.append("byte");
                break;
            }
            case 'C': {
                x.append("char");
                break;
            }
            case 'D': {
                x.append("double");
                break;
            }
            case 'F': {
                x.append("float");
                break;
            }
            case 'I': {
                x.append("int");
                break;
            }
            case 'J': {
                x.append("long");
                break;
            }
            case 'L': {
                int i = ndx + 1;
                while (i < typeString.indexOf(59)) {
                    if (typeString.charAt(i) != '/') {
                        x.append(typeString.charAt(i));
                    } else {
                        x.append('.');
                    }
                    ++i;
                }
                x.append(" ");
                break;
            }
            case 'V': {
                x.append("void");
                break;
            }
            case 'S': {
                x.append("short");
                break;
            }
            case 'Z': {
                x.append("boolean");
            }
        }
        x.append(varName);
        while (isArray > 0) {
            x.append("[]");
            --isArray;
        }
        return x.toString();
    }

    public static String nextSig(String sig) {
        int ndx = 0;
        while (sig.charAt(ndx) == '[') {
            ++ndx;
        }
        if (sig.charAt(ndx) == 'L') {
            while (sig.charAt(ndx) != ';') {
                ++ndx;
            }
        }
        String x = sig.substring(++ndx);
        return x;
    }

    public String printClassName(String s) {
        if (s.charAt(0) == '[') {
            return ClassFile.typeString(s, "");
        }
        StringBuffer x = new StringBuffer();
        int j = 0;
        while (j < s.length()) {
            if (s.charAt(j) == '/') {
                x.append('.');
            } else {
                x.append(s.charAt(j));
            }
            ++j;
        }
        return x.toString();
    }

    public Vector getImports() {
        Vector<String> res = new Vector<String>(20);
        int i = 1;
        while (i < this.constantPool.length) {
            String s;
            if (this.constantPool[i] != null && this.constantPool[i] != this.thisClass && this.constantPool[i] != this.superClass && this.constantPool[i].type == 7 && (s = this.constantPool[i].arg1.strValue).charAt(0) != '[') {
                s = this.printClassName(this.constantPool[i].arg1.strValue);
                res.addElement(this.printClassName(s));
            }
            ++i;
        }
        return res;
    }

    public String getClassName() {
        return this.printClassName(this.thisClass.arg1.strValue);
    }

    public String toString() {
        return "Class File (Version " + this.majorVersion + "." + this.minorVersion + ") for class " + this.thisClass.arg1;
    }

    public void display(PrintStream ps) throws Exception {
        String packageName = null;
        if (!this.isValidClass) {
            ps.println("Not a valid class");
        }
        String myClassName = this.printClassName(this.thisClass.arg1.strValue);
        String mySuperClassName = this.printClassName(this.superClass.arg1.strValue);
        if (myClassName.indexOf(46) > 0) {
            packageName = myClassName.substring(0, myClassName.lastIndexOf(46));
            myClassName = myClassName.substring(myClassName.lastIndexOf(46) + 1);
            ps.println("package " + packageName + "\n");
        }
        int i = 1;
        while (i < this.constantPool.length) {
            String s;
            if (this.constantPool[i] != null && this.constantPool[i] != this.thisClass && this.constantPool[i] != this.superClass && this.constantPool[i].type == 7 && (s = this.constantPool[i].arg1.strValue).charAt(0) != '[') {
                s = this.printClassName(this.constantPool[i].arg1.strValue);
                if (packageName == null || !s.startsWith(packageName)) {
                    ps.println("import " + this.printClassName(s) + ";");
                }
            }
            ++i;
        }
        ps.println();
        ps.println("/*");
        if (this.attributes != null) {
            ps.println(" * This class has " + this.attributes.length + " optional class attributes.");
            ps.println(" * These attributes are: ");
            i = 0;
            while (i < this.attributes.length) {
                String attrName = this.attributes[i].name.strValue;
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.attributes[i].data));
                ps.println(" * Attribute " + (i + 1) + " is of type " + this.attributes[i].name);
                if (attrName.compareTo("SourceFile") == 0) {
                    ConstantPoolInfo cpi = null;
                    try {
                        cpi = this.constantPool[dis.readShort()];
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    ps.println(" *\tSourceFile : " + cpi);
                } else {
                    ps.println(" *\tTYPE (" + attrName + ")");
                }
                ++i;
            }
        } else {
            ps.println(" * This class has NO optional class attributes.");
        }
        ps.println(" */\n");
        ps.print(ClassFile.accessString(this.accessFlags) + "class " + myClassName + " extends " + mySuperClassName);
        if (this.interfaces != null) {
            ps.print(" implements ");
            i = 0;
            while (i < this.interfaces.length - 1) {
                ps.print(this.interfaces[i].arg1.strValue + ", ");
                ++i;
            }
            ps.print(this.interfaces[this.interfaces.length - 1].arg1.strValue);
        }
        ps.println(" {\n");
        if (this.fields != null) {
            ps.println("/* Instance Variables */");
            i = 0;
            while (i < this.fields.length) {
                ps.println("    " + this.fields[i].toString(this.constantPool) + ";");
                ++i;
            }
        }
        if (this.methods != null) {
            ps.println("\n/* Methods */");
            i = 0;
            while (i < this.methods.length) {
                ps.println("    " + this.methods[i].toString(myClassName));
                ++i;
            }
        }
        ps.println("\n}");
    }

    public ConstantPoolInfo getConstantRef(short index) {
        return this.constantPool[index];
    }

    public short addConstantPoolItem(ConstantPoolInfo item) throws Exception {
        ConstantPoolInfo cp = item.inPool(this.constantPool);
        if (cp != null) {
            return ConstantPoolInfo.indexOf(cp, this.constantPool);
        }
        ConstantPoolInfo[] newConstantPool = new ConstantPoolInfo[this.constantPool.length + 1];
        int i = 1;
        while (i < this.constantPool.length) {
            newConstantPool[i] = this.constantPool[i];
            ++i;
        }
        newConstantPool[this.constantPool.length] = item;
        this.constantPool = newConstantPool;
        return ConstantPoolInfo.indexOf(item, this.constantPool);
    }

    /*
     * Unable to fully structure code
     */
    public void addConstantPoolItems(ConstantPoolInfo[] items) {
        delete = new boolean[items.length];
        j = 0;
        while (j < items.length) {
            if (items[j].type == 1 || items[j].type == 2 || items[j].type == 3 || items[j].type == 5 || items[j].type == 4 || items[j].type == 6) {
                delete[j] = false;
                newArg = items[j].inPool(this.constantPool);
                if (newArg != null) {
                    delete[j] = true;
                    i = 0;
                    while (i < items.length) {
                        if (items[i].arg1 == items[j]) {
                            items[i].arg1 = newArg;
                        }
                        if (items[i].arg2 == items[j]) {
                            items[i].arg2 = newArg;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        j = 0;
        while (j < items.length) {
            if (items[j].type == 7 || items[j].type == 9 || items[j].type == 10 || items[j].type == 8 || items[j].type == 11 || items[j].type == 12) {
                delete[j] = false;
                newArg = items[j].inPool(this.constantPool);
                if (newArg != null) {
                    delete[j] = true;
                    i = 0;
                    while (i < items.length) {
                        if (items[i].arg1 == items[j]) {
                            items[i].arg1 = newArg;
                        }
                        if (items[i].arg2 == items[j]) {
                            items[i].arg2 = newArg;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        count = 0;
        i = 0;
        while (i < items.length) {
            if (!delete[i]) {
                ++count;
            }
            ++i;
        }
        newConstantPool = new ConstantPoolInfo[this.constantPool.length + count];
        i = 1;
        while (i < this.constantPool.length) {
            newConstantPool[i] = this.constantPool[i];
            ++i;
        }
        ndx = 0;
        i = this.constantPool.length;
        ** GOTO lbl58
        {
            ++ndx;
            do {
                if (delete[ndx]) continue block6;
                newConstantPool[i] = items[ndx];
                ++ndx;
                ++i;
lbl58:
                // 2 sources

            } while (i < newConstantPool.length);
        }
        this.constantPool = newConstantPool;
    }

    public void addAttribute(AttributeInfo newAttribute) {
        if (this.attributes == null) {
            this.attributes = new AttributeInfo[1];
            this.attributes[0] = newAttribute;
        } else {
            AttributeInfo[] newAttrList = new AttributeInfo[1 + this.attributes.length];
            int i = 0;
            while (i < this.attributes.length) {
                newAttrList[i] = this.attributes[i];
                ++i;
            }
            newAttrList[this.attributes.length] = newAttribute;
            this.attributes = newAttrList;
        }
    }

    public AttributeInfo getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (name.compareTo(this.attributes[i].name.toString()) == 0) {
                return this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public ConstantPoolInfo getConstantPoolItem(short index) throws Exception {
        if (index <= 0 || index > this.constantPool.length - 1) {
            return null;
        }
        ConstantPoolInfo cp = this.constantPool[index];
        if (cp.arg1 != null) {
            cp.index1 = ConstantPoolInfo.indexOf(cp.arg1, this.constantPool);
        }
        if (cp.arg2 != null) {
            cp.index2 = ConstantPoolInfo.indexOf(cp.arg2, this.constantPool);
        }
        return cp;
    }

    public void mapClass(String oldClass, String newClass) {
        if (this.debug) {
            Tracer.This.println("Mapping class name " + oldClass + " ==> " + newClass + " for class " + this.thisClass.arg1);
        }
        int i = 0;
        while (i < this.constantPool.length) {
            String cname;
            if (this.constantPool[i].type == 7 && (cname = this.constantPool[i].arg1.strValue).compareTo(oldClass) == 0) {
                if (this.debug) {
                    Tracer.This.println("REPLACING " + cname + " with " + newClass);
                }
                this.constantPool[i].arg1.strValue = newClass;
            }
            ++i;
        }
    }

    public void mapPackage(String oldPackage, String newPackage) {
        int i = 0;
        while (i < this.constantPool.length) {
            String cname;
            if (this.constantPool[i].type == 7 && (cname = this.constantPool[i].arg1.strValue).startsWith(oldPackage)) {
                this.constantPool[i].arg1.strValue = newPackage + cname.substring(cname.lastIndexOf(47));
            }
            ++i;
        }
    }

    public void deleteMethod(String name, String signature) {
        int i = 0;
        while (i < this.constantPool.length) {
            if (this.constantPool[i].type == 7) {
                // empty if block
            }
            ++i;
        }
    }
}

