/******************************************************
 * File: NCFontChooserBean.java
 * created 24-Feb-00 1:09:25 PM by ruedi
 */
package de.netcomputing.examplebeans.fontchooser;
import java.util.*;
import de.netcomputing.examplebeans.labelslider.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;                                                            
import java.awt.*;
import de.netcomputing.runtime.*;

/**
* This class implements a FontChooser Bean as an example on how to create
* visual Java Beans using AnyJ. The Bean fires a NCFontChooserEvent if the  
* selected Font changes. 
* 
*/
public class NCFontChooserBean extends JPanel
{
	//$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
	NCLabeledSlider slider;
	JToggleButton italicBtn;
	JToggleButton boldButton;
	JComboBox fontsBox;
	//$$$endVars    -----------------------------------------------------------
	
	String mySampleProperty = "Sample";
	
	public NCFontChooserBean()
	{
		initGui();
	}

	public void initGui()
	{
		new NCFontChooserBeanGUI().createGui( this );
		String fonts[] = Toolkit.getDefaultToolkit().getFontList();
		for ( int n = 0; n < fonts.length; n++ )
			fontsBox.addItem( fonts[n] );
	}

	Vector fontListeners = new Vector( 7 );
	public void addNCFontChooserListener( NCFontChooserListener l )
	{
		fontListeners.addElement( l ); 
	}
	
	public void removeNCFontChooserListener( NCFontChooserListener l )
	{
		fontListeners.removeElement( l );
	}
	
	public void fireNCFontChooserEvent()
	{
		NCFontChooserEvent e = new NCFontChooserEvent( this );
		for ( int n = 0; n < fontListeners.size(); n++ )
			((NCFontChooserListener)fontListeners.elementAt(n)).fontChanged( e );
	}
	
	/**
	* locate and load the image, replace code below to avoid the need of
	* a runtime library (ApplicationHelper)
	*/
	public Image getImageForBuilder( String imageName, String packageAsPath )
	{
		// load via classpath from de.netcomputing.examplebeans.fontchooser/images/imageName.gif
		// resp. /images/imageName.gif (2cnd lookup)
		return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
		
	}

	public void setMySampleProperty( String mySampleProperty )
	{
		this.mySampleProperty = mySampleProperty;
	}
	public String getMySampleProperty()
	{
		return mySampleProperty;
	}
		
    public Font getSelectedFont()
	{
		return new Font( 
			""+fontsBox.getSelectedItem(), 
			(boldButton.isSelected() ? Font.BOLD : Font.PLAIN) | (italicBtn.isSelected() ? Font.ITALIC : Font.PLAIN),
			slider.getValue()
		);
	}
	
	public void setSelectedFont( Font f )
	{
		fontsBox.setSelectedItem( f.getName() );
		boldButton.setSelected( f.isBold() );
		italicBtn.setSelected( f.isItalic() );
		slider.setValue( f.getSize() );
	}
	
	//$$$actions

	public void slider_stateChanged( ChangeEvent var0 )
	{
		fireNCFontChooserEvent();
	}

	public void fontsBox_itemStateChanged( ItemEvent var0 )
	{
		fireNCFontChooserEvent();
	}

	public void italicBtn_actionPerformed( ActionEvent var0 )
	{
		fireNCFontChooserEvent();
	}

	public void boldButton_actionPerformed( ActionEvent var0 )
	{
		fireNCFontChooserEvent();
	}

}
