/******************************************************
* File: FileChooserBean.java
* created 04.06.2001 11:16:19 by Ruediger Moeller
*/
package de.netcomputing.sample.filechooser;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;                                                            
import java.awt.*;
import de.netcomputing.runtime.*;
import javax.swing.filechooser.FileFilter;

public class FileChooserBean extends JPanel
{
	//$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
	JButton chooseFileBtn;
	JTextField fileTextField;
	//$$$endVars    -----------------------------------------------------------
	
	String  chooserTitle;
	String approveTitle;
	FileFilter filter;
	boolean acceptFiles = true;
	boolean acceptDirs  = true;
	
	
	public FileChooserBean()
	{
		initGui();
	}
	
	public void initGui()
	{
		new FileChooserBeanGUI().createGui( this );
	}
	
	/**
	 * Note: Due to a bug in the JDK 1.3 (DocumentEvent is not a subclass of EventObject)
	 * the DocumentListener's methods are not recognized as valid event handlers
	 * as specified by the Java Beans Documentation. Therefore these eventhandlers can't be
	 * added from withing our beans-based GUIBuilder.
	 */
	public void addDocumentListener( DocumentListener dl )
	{
		fileTextField.getDocument().addDocumentListener( dl ); 
	}
	
	/**
	 * Note: Due to a bug in the JDK 1.3 (DocumentEvent is not a subclass of EventObject)
	 * the DocumentListener's methods are not recognized as valid event handlers
	 * as specified by the Java Beans Documentation. Therefore these eventhandlers can't be
	 * added from within our beans-based GUIBuilder.
	 */
	public void removeDocumentListener( DocumentListener dl )
	{
		fileTextField.getDocument().removeDocumentListener( dl ); 
	}

	public void setToolTipText( String text )
	{
		super.setToolTipText( text );
	    fileTextField.setToolTipText( text );
	}
	

	public void setAcceptFiles( boolean acceptFiles )
	{
		this.acceptFiles = acceptFiles;
	}
	public boolean getAcceptFiles()
	{
		return acceptFiles;
	}

	public void setAcceptDirs( boolean acceptDirs )
	{
		this.acceptDirs = acceptDirs;
	}
	public boolean getAcceptDirs()
	{
		return acceptDirs;
	}
		
	/**
	 * set a javax.swing.filechooser.FileFilter which should be applied to the JFileChooser
	 */
	public void setFilter( FileFilter filter )
	{
		this.filter = filter;
	}
	public FileFilter getFilter()
	{
		return filter;
	}
	
	/**
	 * set the title of the approvebutton of the JFileChooser
	 */
	public void setApproveTitle( String approveTitle )
	{
		this.approveTitle = approveTitle;
	}
	/**
	* get the title of the approvebutton of the JFileChooser
	*/
	public String getApproveTitle()
	{
		return approveTitle;
	}

	/**
	 * set the title of the JFileChooser
	 */
	public void setChooserTitle( String chooserTitle )
	{
		this.chooserTitle = chooserTitle;
	}
	
	/**
	* get the title of the JFileChooser (null == default)
	*/
	public String getChooserTitle()
	{
		return chooserTitle;
	}
	
	/**
	* locate and load the image, replace code below to avoid the need of
	* a runtime library (ApplicationHelper)
	*/
	public Image getImageForBuilder( String imageName, String packageAsPath )
	{
		// load via classpath from de.netcomputing.sample.filechooser/images/imageName.gif
		// resp. /images/imageName.gif (2cnd lookup)
		return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
	
	}
	
	public String getText()
	{
		return fileTextField.getText(); 
	}

	public void setText( String fileOrDir )
	{
		fileTextField.setText( fileOrDir ); 
	}
	
	/**
	 * Testing only
	 */
	public static void main( String[] args )
	{
		ApplicationHelper.Singleton().createFrameOn( new FileChooserBean() ).show();
	}

	//$$$actions
	
	public void chooseFileBtn_actionPerformed( ActionEvent var0 )
	{
		JFileChooser fc = new JFileChooser( fileTextField.getText() );
		if ( getAcceptDirs() && getAcceptFiles() )
			fc.setFileSelectionMode( JFileChooser.FILES_AND_DIRECTORIES );
		else if ( getAcceptDirs() && ! getAcceptFiles() )
			fc.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );
		else if ( ! getAcceptDirs() && getAcceptFiles() )
			fc.setFileSelectionMode( JFileChooser.FILES_ONLY );
		
		fc.setDialogTitle( getChooserTitle() );
		if ( filter != null )
			fc.setFileFilter( filter );
		int result = fc.showDialog( this, getApproveTitle() );
		if ( result == JFileChooser.APPROVE_OPTION )
		{
			 fileTextField.setText( fc.getSelectedFile().getAbsolutePath() );
		}
	}

}