/******************************************************
 * File: ($tplname).java
 * created ($date) by ($user.name)
 */
($packageStatement)

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;
import de.netcomputing.runtime.*;

/**
* The Panel of a main frame.
* The Panel contains a Menu and a Toolbar.
* The frame is constructed in the main-method below.
*/
public class ($tplname) extends JPanel implements WindowListener
{
	//$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
	JMenuBar menuBar;
	JToolBar toolBar;
	//$$$endVars    -----------------------------------------------------------
	
	public ($tplname)()
	{
		initGui();
	}

	public void initGui()
	{
		new ($tplname)GUI().createGui( this );
		initMenu();
	}

	/**
	* locate and load the image, replace code below to avoid the need of
	* a runtime library (ApplicationHelper)
	*/
	public Image getImageForBuilder( String imageName, String packageAsPath )
	{
		// load via classpath from ($package)/images/imageName.gif
		// resp. /images/imageName.gif (2cnd lookup)
		return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
		
	}

	public JFrame getFrame()
	{
		return (JFrame)getTopLevelAncestor();
	}
	
	void initMenu()
	{
		ApplicationHelper app = ApplicationHelper.Singleton();
		
		JMenu file = app.createMenu( "File", 'F' );
		JMenu edit = app.createMenu( "Edit", 'E' );
		JMenu help = app.createMenu( "Help", 'H' );
		
		file.add( app.createMenuItem( this, "New", 'N', "menuNew" ) );
		file.add( app.createMenuItem( this, "Open", 'O', "menuOpen" ) );
		file.add( app.createMenuItem( this, "Save", 'S', "menuSave" ) );
		file.add( app.createMenuItem( this, "Save As", 'A', "menuSaveAs" ) );
		file.addSeparator();
		file.add( app.createMenuItem( this, "Print", 'P', "menuPrint" ) );
		file.add( app.createMenuItem( this, "Print Setup", 'U', "menuPrintSetup" ) );
		file.addSeparator();
		file.add( app.createMenuItem( this, "Quit" , 'Q', "menuQuit" ) );

		edit.add( app.createMenuItem( this, "Undo", 'U', "menuUndo" ) );
		edit.add( app.createMenuItem( this, "Redo", 'R', "menuRedo" ) );
		edit.addSeparator();
		edit.add( app.createMenuItem( this, "Cut", 'U', "menuCut" ) );
		edit.add( app.createMenuItem( this, "Copy", 'C', "menuCopy" ) );
		edit.add( app.createMenuItem( this, "Paste", 'P', "menuPaste" ) );
		edit.addSeparator();
		edit.add( app.createMenuItem( this, "Preferences", 'r', "menuPreferences" ) );
		
		help.add( app.createMenuItem( this, "About", 'r', "menuAbout" ) );
		menuBar.add( file );
		menuBar.add( edit );
		menuBar.add( help );
		
		toolBar.add( app.createToolbarAction( this, "Open new Document", "menuNew", "New.gif" ) );
		toolBar.add( app.createToolbarAction( this, "Open a Document", "menuOpen", "Open.gif" ) );
		toolBar.add( app.createToolbarAction( this, "Save current Document", "menuSave", "Save.gif" ) );
		toolBar.addSeparator();
		toolBar.add( app.createToolbarAction( this, "Cut", "menuCut", "Cut.gif" ) );
		toolBar.add( app.createToolbarAction( this, "Copy", "menuCopy", "Copy.gif" ) );
		toolBar.add( app.createToolbarAction( this, "Paste", "menuPaste", "Paste.gif" ) );
		toolBar.addSeparator();
		toolBar.add( app.createToolbarAction( this, "Print", "menuPrint", "Print.gif" ) );
		toolBar.add( app.createToolbarAction( this, "About", "menuAbout", "Inform.gif" ) );

	}

	/**** 
		Example for an actionhandler "app.createMenuItem( this, "New", 'N', "menuNew" )" (see initMenu)
	*/
	public void menuNew( ActionEvent e )
	{
		//..handler code
	}

	// WindowListener interface (to listen events sent from the JFrame) (see main method below)

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowOpened( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowIconified( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowDeiconified( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowDeactivated( WindowEvent e )
	{
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowClosing( WindowEvent e )
	{
		System.exit( 0 );
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowClosed( WindowEvent e )
	{
		
	}

	/**
	* this panel acts as a windowlistener of the main frame
	*/
	public void windowActivated( WindowEvent e )
	{
	}

	
	//$$$actions ------------------ do not delete, generated marker, eventhandlers are generated below


	/**
	* Note that it is possible to access the Frame using '(JFrame)getTopLevelAncestor()' 
	*/
	public static void main( String arg[] )
	{
		/*try {
		UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch ( Exception e ) { e.printStackTrace(); }*/
		JFrame frame = new JFrame();
		($tplname) panel = new ($tplname)();
		frame.getContentPane().add( "Center" , panel );
		frame.addWindowListener( panel );
		frame.pack();
		frame.setBounds( 0, 0, 700, 550 );
		frame.setVisible( true );
	}


}
