/******************************************************
 * File: CheckIn.java
 * created 09.01.2002 14:47:49 by moelrue
 */
package harvestgui;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;                                                            
import java.awt.*;
import de.netcomputing.runtime.*;

public class CheckIn extends JPanel
{

    public static void CenterWindow( Window f, Window parent )
    {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();//parent.getSize();
        Dimension fd  = f.getSize();
        Point org = new Point(0,0);//parent.getLocationOnScreen();
        f.setBounds( org.x+(screen.width - fd.width)/2, org.y+(screen.height - fd.height)/2, fd.width, fd.height );
    }
    
    public static CheckIn ShowCheckInPanel( Frame parent, String project, String pack, String file )
    {
        return ShowCheckInPanel( parent, project, pack, file, true );
    }

    public static CheckIn ShowCheckInPanel( Frame parent, String project, String pack, String file, boolean checkInOrRemove )
    {
        CheckIn ci = new CheckIn();
        JDialog dlg = new JDialog( parent );
        dlg.getContentPane().add( ci );
        if ( ! checkInOrRemove )
            ci.fileLabel.setText( "Remove: "+ file );
        else
            ci.fileLabel.setText( "Check In: "+ file );
        ci.packageTxt.setText( pack );
        ci.projectTxt.setText( project );
        ci.commentTxt.setEnabled( checkInOrRemove );
        if ( ! checkInOrRemove )
        {
            ci.commentTxt.setBackground( ci.getBackground() );
            ci.checkInBtn.setText( "Remove" );
        }
        dlg.setModal( true );
        dlg.pack();
        ((JDialog)dlg).getRootPane().setDefaultButton( ci.checkInBtn );
        CenterWindow( dlg, parent );
        dlg.show();
        if ( ci.result )
            return ci;
        return null;
    }
    
    //$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
    JButton checkInBtn;
    JTextField projectTxt;
    JTextField packageTxt;
    JLabel fileLabel;
    JButton cnacelBtn;
    JEditorPane commentTxt;
    //$$$endVars    -----------------------------------------------------------
    
    boolean result;
    
    public CheckIn()
    {
        initGui();
    }

    public void initGui()
    {
        new CheckInGUI().createGui( this );
    }
    
    /**
    * locate and load the image, replace code below to avoid the need of
    * a runtime library (ApplicationHelper)
    */
    public Image getImageForBuilder( String imageName, String packageAsPath )
    {
        // load via classpath from harvestgui/images/imageName.gif
        // resp. /images/imageName.gif (2cnd lookup)
        return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
        
    }
    
    public String getProject()
    {
        return projectTxt.getText(); 
    }
    
    public String getComment()
    {
        return commentTxt.getText(); 
    }
    
    public String getPackage()
    {
        return packageTxt.getText(); 
    }
    
    //$$$actions

    public void cnacelBtn_actionPerformed( ActionEvent var0 )
    {
        ((Window)getTopLevelAncestor()).dispose();
    }

    public void checkInBtn_actionPerformed( ActionEvent var0 )
    {
        result = true;
        ((Window)getTopLevelAncestor()).dispose();
    }

}
