/******************************************************
 * File: CheckOut.java
 * created 09.01.2002 17:26:18 by moelrue
 */
package harvestgui;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;                                                            
import java.awt.*;
import de.netcomputing.runtime.*;

public class CheckOut extends JPanel
{
    public static CheckOut ShowCheckOutPanel( Frame parent, String title, String project, String pack, String file )
    {
        CheckOut ci = new CheckOut();
        JDialog dlg = new JDialog( parent );
        dlg.getContentPane().add( ci );
        ci.fileLabel.setText( title+": "+ file );
        ci.packageTxt.setText( pack );
        ci.projectTxt.setText( project );
        dlg.pack();
        ((JDialog)dlg).getRootPane().setDefaultButton( ci.checkInBtn );
        CheckIn.CenterWindow( dlg, parent );
        dlg.setModal( true );
        dlg.show();
        //ci.checkInBtn.requestFocusInWindow();
        if ( ci.result )
            return ci;
        return null;
    }

    //$$$vars 		------- GENERATED CODE, DO NOT EDIT THIS SECTION ----------
    JTextField packageTxt;
    JTextField projectTxt;
    JLabel fileLabel;
    JButton cnacelBtn;
    JButton checkInBtn;
    //$$$endVars    -----------------------------------------------------------
    
    boolean result;
    
    public CheckOut()
    {
        initGui();
    }

    public void initGui()
    {
        new CheckOutGUI().createGui( this );
    }
    
    /**
    * locate and load the image, replace code below to avoid the need of
    * a runtime library (ApplicationHelper)
    */
    public Image getImageForBuilder( String imageName, String packageAsPath )
    {
        // load via classpath from harvestgui/images/imageName.gif
        // resp. /images/imageName.gif (2cnd lookup)
        return ApplicationHelper.Singleton().getImage( getClass(), "images/"+imageName );
        
    }
    
    public String getProject()
    {
        return projectTxt.getText(); 
    }
    
    public String getPackage()
    {
        return packageTxt.getText(); 
    }
    
    //$$$actions

    public void cnacelBtn_actionPerformed( ActionEvent var0 )
    {
        ((Window)getTopLevelAncestor()).dispose();
    }

    public void checkInBtn_actionPerformed( ActionEvent var0 )
    {
        result = true;
        ((Window)getTopLevelAncestor()).dispose();
    }

}
