/******************************************************
 * File: CCCCheckIn.java
 * created 04.03.2002 11:50:20 by moelrue
 */
package harvestgui.scripts;
import de.netcomputing.anyj.scripting.*;
import harvestgui.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class CCCCheckIn extends AJExternalService
{ 
    boolean release = false; // browse
    boolean add     = false; // browse

    public CCCCheckIn() {
        this( false );
    }
    
    public CCCCheckIn( boolean release ) {
        this( release, false );
    }
    
    public CCCCheckIn( boolean release, boolean _add ) {
        this.release = release;
        this.category = category;
        add = _add;
    }
    
    public CCCCheckIn( String menuName ) {
        super( menuName );
    }
    
    static boolean IsRunning;
    
    public boolean canProcessSelection( Object selection )
    {
        
        if( selection != null )
        {
            if ( selection instanceof File && ! IsRunning && ( !add || !((File)selection).isDirectory()) )
            {
                File cur = (File)selection;
                String curS = cur.getAbsolutePath();
                if ( curS.toLowerCase().startsWith( (""+AnyJAPI.This().getEnvironment().get("ccch_localroot")).toLowerCase() ) )
                {
                    return true;  
                }
            }
        }
        return false;
    }
    
    Object lastSel;
    String outName = "";
    public void doProcess( Object selection )
    {
        IsRunning = true;
        lastSel = selection;
        (new Thread() { public void run() {
                    try {
                        String pack = CCCGet.pack;
                        outName = "";
                        // check the environment is set up
                        Hashtable ht = AnyJAPI.This().getEnvironment();
                        if ( ht.get( "ccch_user" ) == null ||
                            ht.get( "ccch_pwd" ) == null ||
                            ht.get( "ccch_repository" ) == null ||
                            ht.get( "ccch_project" ) == null ||
                            ht.get( "ccch_localroot" ) == null )
                        {
                            JOptionPane.showMessageDialog( AnyJAPI.This().getMainWindow(), new String[] {
                                    "Please specify:",
                                    "ccch_user (e.g. moelrue)",
                                    "ccch_pwd (e.g. tryst)",
                                    "ccch_repository (e.g. xeomoon/XE)",
                                    "ccch_project (e.g. XAPI)",
                                    "ccch_localroot  (e.g. d:\\work\\dev\\cccharvest)",
                                    "in AnyJ's user environment"
                                });
                        } else {
                            File dir = (File)lastSel;
                            String fiName;
                            if ( dir.isDirectory() )
                            {
                                fiName = "*";
                            }
                            else
                            {
                                fiName = dir.getName();
                                dir = dir.getParentFile();
                            }
                            try {
                                dir = dir.getCanonicalFile();
                            } catch ( Exception ex ) {
                                ex.printStackTrace();
                            }
                            String reposRoot = dir.getAbsolutePath().substring((""+AnyJAPI.This().getEnvironment().get("ccch_localroot")).length());
                            String cline = "";
                            outName = "CCC CHECKIN";
                            String proj = CCCGet.proj;
                            if ( proj == null )
                                proj = (String)AnyJAPI.This().getEnvironment().get("ccch_project");
                            String[] projPack = CCCGet.FindAJHarvestSigFile( dir );
                            if ( projPack != null )
                            {
                                proj = projPack[0];
                                pack = projPack[1];
                            }
                            String comment = "";
                            if ( ! release )
                            {
                                CheckIn res = CheckIn.ShowCheckInPanel( 
                                    AnyJAPI.This().getMainWindow(), 
                                    proj,
                                    pack,
                                    fiName
                                );
                                comment = res.getComment().trim();
                                proj = res.getProject().trim();
                                if ( res == null )
                                {
                                    IsRunning = false;
                                    return;
                                }
                                else
                                    pack = res.getPackage();
                            } else // release command
                            {
                                // do nothing
                            }
                            CCCGet.pack = pack;
                            CCCGet.proj = proj;
                            CCCTool.LogReader reader = new CCCTool.LogReader();
                            if ( ! release )
                            {
                                String ifOpt = "";
                                if ( add )
                                    ifOpt = "-if no ";
                                cline = 
                                "hci -ur "+ifOpt+"-vp "+reposRoot+
                                " -cp "+dir.getAbsolutePath()+
                                " -op pc "+
                                " -b "+AnyJAPI.This().getEnvironment().get("ccch_repository") +
                                " -usr "+AnyJAPI.This().getEnvironment().get("ccch_user")+
                                " -pw " +AnyJAPI.This().getEnvironment().get("ccch_pwd")+
                                " -o " +dir.getAbsolutePath()+File.separator+"hco.log" +
                                " -en "+proj+" -st \"Implementation Phase\" -pn \"Check In\"" 
                                +" -p "+pack+" -s "+fiName+" -de \""+comment+"\" ";//+dir.getAbsolutePath()+File.separator+fiName;
                                AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( "" );
                                AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( cline );
                                
                                
                                reader.setFileName(dir.getAbsolutePath()+ File.separator+"hco.log" );
                                reader.setRunning( true);
                                reader.setPanelName(  outName );
                                reader.start();
                                
                                AnyJAPI.This().executeExternalProcess( outName, File.separator, cline );
                            } else {
                                outName = "CCC RELEASE";
                                cline = 
                                "hci -ro -vp "+reposRoot/*"\\XAPI\\src\\java\\XgenPi\\de\\exchange\\xgen\\"*/+" -cp "+dir.getAbsolutePath()+
                                " -b "+AnyJAPI.This().getEnvironment().get("ccch_repository") +
                                " -usr "+AnyJAPI.This().getEnvironment().get("ccch_user")+
                                " -pw " +AnyJAPI.This().getEnvironment().get("ccch_pwd")+
                                " -o "+dir.getAbsolutePath()+File.separator+"hco.log" +
                                " -en "+proj+" -st \"Implementation Phase\" -pn \"Check In\""
                                +" -p "+pack+" -s "+fiName;
                                AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( "" );
                                AnyJAPI.This().getOrCreateOutputPanel( outName ).printLine( cline );
                                
                                reader.setFileName(dir.getAbsolutePath()+ File.separator+"hco.log" );
                                reader.setRunning( true);
                                reader.setPanelName(  outName );
                                reader.start();
                                
                                AnyJAPI.This().executeExternalProcess( outName, File.separator, cline );
                            }
                            AnyJAPI.This().updateFileTree();
                            reader.setRunning( false);
                        }
                    } finally {
                        IsRunning = false;
                    }
                }
            
            }).start();
    }

}