/******************************************************
 * File: EJBClient.java
 * created 25.05.2002 14:48:54 by ruedi
 */
package sample;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import sample.ejb.MainSessionHome;
import sample.ejb.MainSessionRemote;

public class EJBClient
{

	public static void main( String[] args ) {
		try {
			Properties props = new Properties();
			props.put( Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory" );
			Context context = new InitialContext(props);
			
			MainSessionHome home = (MainSessionHome) PortableRemoteObject.narrow( 
				context.lookup( "MainSessionRemote" ),
				MainSessionHome.class
			);
			
			MainSessionRemote mainSess = home.create();
			System.out.println( mainSess.getHello( 10 ) );
			
			System.out.println( mainSess.doubleString( "EJB Test" ) );
			
			mainSess.remove();
		}
		catch ( Exception ex ) {
			ex.printStackTrace();
		}
	}

}
