/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.utility.JavaNames;
import bluej.views.CallableView;
import bluej.views.LabelPrintWriter;
import bluej.views.MethodView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MethodDialog
extends CallDialog {
    private boolean okCalled;
    private boolean rawObject;
    private static final String appName = Config.getApplicationName();
    static final String wCallRoutineTitle = appName + ":  " + Config.getString("pkgmgr.methodCall.titleCall");
    static final String commentSlash = "   ";
    private String methodName;
    private MethodView method;
    private Map<String, GenTypeParameter> typeParameterMap;
    private JLabel callLabel;

    public MethodDialog(JFrame parentFrame, ObjectBenchInterface ob, CallHistory callHistory, String instanceName, MethodView method, Map<String, GenTypeParameter> typeMap) {
        super(parentFrame, ob, "");
        this.history = callHistory;
        this.methodName = method.getName();
        this.method = method;
        this.makeDialog(method.getClassName(), instanceName);
        this.setInstanceInfo(instanceName, typeMap);
    }

    @Override
    public void doOk() {
        if (!this.okCalled) {
            if (!this.parameterFieldsOk()) {
                this.setErrorMessage(emptyFieldMsg);
            } else if (!this.typeParameterFieldsOk()) {
                this.setErrorMessage(emptyTypeFieldMsg);
            } else {
                this.setWaitCursor(true);
                this.okButton.requestFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MethodDialog.this.callWatcher(0);
                    }
                });
                this.okCalled = true;
            }
        }
    }

    public void setInstanceInfo(String instanceName, Map<String, GenTypeParameter> typeParams) {
        this.typeParameterMap = typeParams;
        this.rawObject = instanceName != null && typeParams == null;
        this.createDescription();
        this.setErrorMessage("");
        this.clearParameters();
        this.startObjectBenchListening();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (MethodDialog.this.typeParameterList != null) {
                    MethodDialog.this.typeParameterList.getParameter(0).getEditor().getEditorComponent().requestFocusInWindow();
                } else if (MethodDialog.this.parameterList != null) {
                    MethodDialog.this.parameterList.getParameter(0).getEditor().getEditorComponent().requestFocusInWindow();
                }
            }
        });
    }

    private void createDescription() {
        LabelPrintWriter writer = new LabelPrintWriter();
        this.method.print(writer, this.typeParameterMap, 0);
        this.setDescription(writer.getLabel());
        this.setVisible(true);
    }

    @Override
    protected void makeDialogInternal(String className, String instanceName, JPanel centerPanel) {
        this.makeCallDialog(className, instanceName, this.method, centerPanel);
    }

    private void makeCallDialog(String className, String instanceName, CallableView method, JPanel panel) {
        this.setTitle(wCallRoutineTitle);
        MethodView methView = (MethodView)method;
        JPanel tmpPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            tmpPanel.setOpaque(false);
        }
        GridBagLayout gridBag = new GridBagLayout();
        tmpPanel.setLayout(gridBag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = INSETS;
        this.callLabel = new JLabel("", 4);
        if (method.isStatic()) {
            this.setCallLabel(className);
        } else {
            this.setCallLabel(instanceName);
        }
        if (methView.isMain()) {
            this.defaultParamValue = "{ }";
        }
        this.setPreferredHeight(this.callLabel, this.getComboBoxHeight());
        constraints.anchor = 18;
        gridBag.setConstraints(this.callLabel, constraints);
        tmpPanel.add(this.callLabel);
        JPanel parameterPanel = this.createParameterPanel();
        if (!Config.isRaspberryPi()) {
            parameterPanel.setOpaque(false);
        }
        ++constraints.gridy;
        tmpPanel.add((Component)parameterPanel, constraints);
        tmpPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tmpPanel.setAlignmentX(0.0f);
        panel.add(tmpPanel);
    }

    public void setCallLabel(String instanceName) {
        this.callLabel.setText(JavaNames.stripPrefix(instanceName) + "." + this.methodName);
    }

    @Override
    public void setEnabled(boolean state) {
        this.okButton.setEnabled(state);
        super.setEnabled(state);
        if (state) {
            this.okCalled = false;
        }
    }

    @Override
    protected CallableView getCallableView() {
        return this.method;
    }

    @Override
    protected boolean targetIsRaw() {
        return this.rawObject;
    }

    @Override
    protected Map<String, GenTypeParameter> getTargetTypeArgs() {
        return this.typeParameterMap;
    }
}

