/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.utility.DialogManager;
import bluej.utility.EscapeDialog;
import bluej.utility.JavaNames;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;

class NewClassDialog
extends EscapeDialog {
    private JTextField textFld;
    ButtonGroup templateButtons;
    private String newClassName = "";
    private boolean ok;
    private static List<String> windowsRestrictedWords;

    public NewClassDialog(JFrame parent, boolean isJavaMEpackage) {
        super(parent, Config.getString("pkgmgr.newClass.title"), true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent E) {
                NewClassDialog.this.ok = false;
                NewClassDialog.this.setVisible(false);
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BlueJTheme.dialogBorder);
        JLabel newclassTag = new JLabel(Config.getString("pkgmgr.newClass.label"));
        newclassTag.setAlignmentX(0.0f);
        this.textFld = new JTextField(24);
        this.textFld.setAlignmentX(0.0f);
        mainPanel.add(newclassTag);
        mainPanel.add(this.textFld);
        mainPanel.add(Box.createVerticalStrut(5));
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new BoxLayout(choicePanel, 1));
        choicePanel.setAlignmentX(0.0f);
        CompoundBorder b = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Config.getString("pkgmgr.newClass.classType")), BorderFactory.createEmptyBorder(0, 10, 0, 10));
        choicePanel.setBorder(b);
        this.addClassTypeButtons(choicePanel, isJavaMEpackage);
        choicePanel.setMaximumSize(new Dimension(this.textFld.getMaximumSize().width, choicePanel.getMaximumSize().height));
        choicePanel.setPreferredSize(new Dimension(this.textFld.getPreferredSize().width, choicePanel.getPreferredSize().height));
        mainPanel.add(choicePanel);
        mainPanel.add(Box.createVerticalStrut(17));
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setAlignmentX(0.0f);
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewClassDialog.this.doOK();
            }
        });
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewClassDialog.this.doCancel();
            }
        });
        DialogManager.addOKCancelButtons(buttonPanel, okButton, cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add(buttonPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        DialogManager.centreDialog(this);
    }

    private void addClassTypeButtons(JPanel panel, boolean isJavaMEpackage) {
        String templateSuffix = ".tmpl";
        int suffixLength = templateSuffix.length();
        String templateString = Config.getPropString("bluej.classTemplates");
        StringTokenizer t = new StringTokenizer(templateString);
        ArrayList<String> templates = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            templates.add(t.nextToken());
        }
        File templateDir = Config.getClassTemplateDir();
        if (!templateDir.exists()) {
            DialogManager.showError(this, "error-no-templates");
        } else {
            String[] files = templateDir.list();
            for (int i = 0; i < files.length; ++i) {
                String template;
                if (!files[i].endsWith(templateSuffix) || templates.contains(template = files[i].substring(0, files[i].length() - suffixLength))) continue;
                templates.add(template);
            }
        }
        if (isJavaMEpackage) {
            templates.remove("enum");
            templates.remove("unittest");
            templates.remove("appletj");
        } else {
            templates.remove("midlet");
        }
        JRadioButton previousButton = null;
        this.templateButtons = new ButtonGroup();
        for (String template : templates) {
            String label = Config.getString("pkgmgr.newClass." + template, template);
            JRadioButton button = new JRadioButton(label, previousButton == null);
            button.setActionCommand(template);
            this.templateButtons.add(button);
            panel.add(button);
            previousButton = button;
        }
    }

    public boolean display() {
        this.ok = false;
        this.textFld.requestFocus();
        this.setVisible(true);
        return this.ok;
    }

    public String getClassName() {
        return this.newClassName;
    }

    public String getTemplateName() {
        return this.templateButtons.getSelection().getActionCommand();
    }

    public void doOK() {
        this.newClassName = this.textFld.getText().trim();
        this.initialiseRestrictedWordList();
        if (JavaNames.isIdentifier(this.newClassName) && !this.isWindowsRestrictedWord(this.newClassName)) {
            this.ok = true;
            this.setVisible(false);
        } else {
            if (this.isWindowsRestrictedWord(this.newClassName)) {
                DialogManager.showError((JFrame)this.getParent(), "windows-reserved-class-name");
            } else {
                DialogManager.showError((JFrame)this.getParent(), "invalid-class-name");
            }
            this.textFld.selectAll();
            this.textFld.requestFocus();
        }
    }

    public void doCancel() {
        this.ok = false;
        this.setVisible(false);
    }

    private boolean isWindowsRestrictedWord(String fileName) {
        return windowsRestrictedWords.contains(fileName.toUpperCase());
    }

    private void initialiseRestrictedWordList() {
        if (windowsRestrictedWords == null) {
            windowsRestrictedWords = new ArrayList<String>();
            windowsRestrictedWords.add("CON");
            windowsRestrictedWords.add("PRN");
            windowsRestrictedWords.add("AUX");
            windowsRestrictedWords.add("NUL");
            windowsRestrictedWords.add("COM1");
            windowsRestrictedWords.add("COM2");
            windowsRestrictedWords.add("COM3");
            windowsRestrictedWords.add("COM4");
            windowsRestrictedWords.add("COM5");
            windowsRestrictedWords.add("COM6");
            windowsRestrictedWords.add("COM7");
            windowsRestrictedWords.add("COM8");
            windowsRestrictedWords.add("COM9");
            windowsRestrictedWords.add("LPT1");
            windowsRestrictedWords.add("LPT2");
            windowsRestrictedWords.add("LPT3");
            windowsRestrictedWords.add("LPT4");
            windowsRestrictedWords.add("LPT5");
            windowsRestrictedWords.add("LPT6");
            windowsRestrictedWords.add("LPT7");
            windowsRestrictedWords.add("LPT8");
            windowsRestrictedWords.add("LPT9");
        }
    }
}

