/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.BaseGradientPainter;
import org.jvnet.substance.painter.noise.MedianBeakFilter;
import org.jvnet.substance.painter.noise.NoiseFactory;
import org.jvnet.substance.utils.PerlinNoiseGenerator;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class NoiseGradientPainter
extends BaseGradientPainter {
    protected static PerlinNoiseGenerator noiseGenerator = new PerlinNoiseGenerator();

    public String getDisplayName() {
        return "Noise";
    }

    public BufferedImage getContourBackground(int width, int height, Shape contour, boolean isDark, ColorScheme colorScheme1, ColorScheme colorScheme2, int cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        BufferedImage mixResult = this.getMixContourBackground(width, height, contour, isDark, colorScheme1, colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
        if (mixResult != null) {
            return mixResult;
        }
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ColorScheme interpolationScheme1 = colorScheme1;
        ColorScheme interpolationScheme2 = useCyclePosAsInterpolation ? colorScheme2 : colorScheme1;
        double cycleCoef = 1.0 - (double)cyclePos / 10.0;
        Color topBorderColor = SubstanceColorUtilities.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color midBorderColor = SubstanceColorUtilities.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        Color bottomBorderColor = SubstanceColorUtilities.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef);
        MedianBeakFilter mazeFilter = new MedianBeakFilter();
        graphics.setClip(contour);
        graphics.drawImage((Image)NoiseFactory.getNoiseImage(interpolationScheme1, interpolationScheme2, cycleCoef, width, height, 0.1, 0.1, true, mazeFilter, false), 0, 0, null);
        graphics.setStroke(new BasicStroke(1.3f, 1, 1));
        GradientPaint gradientBorderTop = new GradientPaint(0.0f, 0.0f, topBorderColor, 0.0f, height / 2, midBorderColor);
        graphics.setPaint(gradientBorderTop);
        graphics.setClip(0, 0, width, height / 2);
        graphics.draw(contour);
        GradientPaint gradientBorderBottom = new GradientPaint(0.0f, height / 2, midBorderColor, 0.0f, height - 2, bottomBorderColor);
        graphics.setPaint(gradientBorderBottom);
        graphics.setClip(0, height / 2, width, 1 + height / 2);
        graphics.draw(contour);
        return image;
    }
}

