/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import net.beeger.squareness.SquarenessLookAndFeel;

public abstract class SquarenessTitlePane
extends JComponent {
    private Icon _maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
    private Icon _minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
    private JButton _closeButton = new FrameButton();
    private JButton _maxButton;
    private JButton _iconifyButton;
    private JLabel _titleLabel;
    private boolean _lastCloseable;
    private boolean _lastIconifiable;
    private boolean _lastMaximized;
    private boolean _lastMaximizable;
    private Font _lastFont;
    private String _lastTitle;
    private boolean _firstUpdate = true;

    public SquarenessTitlePane() {
        this._closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this._closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SquarenessTitlePane.this.close();
            }
        });
        this._maxButton = new FrameButton();
        this._maxButton.setIcon(this._maximizeIcon);
        this._maxButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                if (SquarenessTitlePane.this.isMaximized()) {
                    SquarenessTitlePane.this.restore();
                } else {
                    SquarenessTitlePane.this.maximize();
                }
            }
        });
        this._iconifyButton = new FrameButton();
        this._iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this._iconifyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SquarenessTitlePane.this.iconify();
            }
        });
        this.add(this._iconifyButton);
        this.add(this._maxButton);
        this.add(this._closeButton);
        this._titleLabel = new JLabel();
        this._titleLabel.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
        this._titleLabel.setForeground(SquarenessLookAndFeel.getCurrentSquarenessTheme().getTextColor());
        this.add(this._titleLabel);
        this.setLayout(new SquarenessTitlePaneLayout());
        this.setBackground(SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
    }

    protected void update() {
        boolean closeable = this.isClosable();
        boolean iconifiable = this.isIconifiable();
        boolean maximized = this.isMaximized();
        boolean maximizable = this.isMaximizable();
        Font font = UIManager.getFont("InternalFrame.titleFont", this.getLocale());
        String title = this.getTitle();
        if (this._firstUpdate || this._lastCloseable != closeable) {
            this._closeButton.setEnabled(closeable);
        }
        if (this._firstUpdate || this._lastIconifiable != iconifiable) {
            this._iconifyButton.setEnabled(iconifiable);
        }
        if (this._firstUpdate || this._lastMaximized != maximized) {
            this._maxButton.setIcon(maximized ? this._minimizeIcon : this._maximizeIcon);
        }
        if (this._firstUpdate || this._lastMaximizable != maximizable) {
            this._maxButton.setEnabled(maximizable);
        }
        if (this._firstUpdate || !font.equals(this._lastFont)) {
            this._titleLabel.setFont(font);
        }
        if (this._firstUpdate || title == null && this._lastTitle != null || title != null && !title.equals(this._lastTitle)) {
            this._titleLabel.setText(title);
        }
        this._lastCloseable = closeable;
        this._lastIconifiable = iconifiable;
        this._lastMaximized = maximized;
        this._lastMaximizable = maximizable;
        this._lastFont = font;
        this._lastTitle = title;
        this._firstUpdate = false;
    }

    public abstract boolean isLeftToRight();

    protected abstract boolean isIconifiable();

    protected abstract boolean isMaximizable();

    protected abstract boolean isClosable();

    protected abstract void close();

    protected abstract void iconify();

    protected abstract void maximize();

    protected abstract void restore();

    protected abstract boolean isMaximized();

    protected abstract boolean isIconified();

    protected abstract String getTitle();

    protected static class FrameButton
    extends JButton {
        public FrameButton() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setOpaque(true);
            this.setFocusPainted(false);
        }

        public boolean isFocusable() {
            return false;
        }
    }

    protected class SquarenessTitlePaneLayout
    implements LayoutManager {
        protected SquarenessTitlePaneLayout() {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(SquarenessTitlePane.this._closeButton.getIcon().getIconWidth() + 60, SquarenessTitlePane.this._closeButton.getIcon().getIconHeight() + 2);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.minimumLayoutSize(parent);
        }

        public void layoutContainer(Container container) {
            boolean leftToRight = SquarenessTitlePane.this.isLeftToRight();
            int width = SquarenessTitlePane.this.getWidth();
            int height = SquarenessTitlePane.this.getHeight();
            int buttonHeight = SquarenessTitlePane.this._closeButton.getIcon().getIconHeight();
            int buttonWidth = SquarenessTitlePane.this._closeButton.getIcon().getIconWidth();
            int y = height - buttonHeight >> 1;
            int x = leftToRight ? width - buttonWidth - 2 : 2;
            SquarenessTitlePane.this._closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            SquarenessTitlePane.this._maxButton.setBounds(x += leftToRight ? -(buttonWidth + 2) : buttonWidth + 2, y, buttonWidth, buttonHeight);
            SquarenessTitlePane.this._iconifyButton.setBounds(x += leftToRight ? -(buttonWidth + 2) : buttonWidth + 2, y, buttonWidth, buttonHeight);
            int maxX = leftToRight ? x - 2 : width - 2;
            x = leftToRight ? 2 : x + 2;
            SquarenessTitlePane.this._titleLabel.setBounds(x, y, maxX - x, buttonHeight);
        }
    }
}

