/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableCursor
extends Canvas {
    Table table;
    TableItem row = null;
    TableColumn column = null;
    Listener tableListener;
    Listener resizeListener;
    Listener disposeItemListener;
    Listener disposeColumnListener;
    static final int BACKGROUND = 27;
    static final int FOREGROUND = 26;

    public TableCursor(Table table, int n2) {
        super(table, n2);
        ScrollBar scrollBar;
        this.table = table;
        this.setBackground(null);
        this.setForeground(null);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        TableCursor.this.dispose(event);
                        break;
                    }
                    case 15: 
                    case 16: {
                        TableCursor.this.redraw();
                        break;
                    }
                    case 1: {
                        TableCursor.this.keyDown(event);
                        break;
                    }
                    case 9: {
                        TableCursor.this.paint(event);
                        break;
                    }
                    case 31: {
                        TableCursor.this.traverse(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 15, 16, 1, 9, 31};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.addListener(nArray[i2], listener);
        }
        this.tableListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 3: {
                        TableCursor.this.tableMouseDown(event);
                        break;
                    }
                    case 15: {
                        TableCursor.this.tableFocusIn(event);
                    }
                }
            }
        };
        this.table.addListener(15, this.tableListener);
        this.table.addListener(3, this.tableListener);
        this.disposeItemListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.row = null;
                TableCursor.this.column = null;
                TableCursor.this._resize();
            }
        };
        this.disposeColumnListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this.row = null;
                TableCursor.this.column = null;
                TableCursor.this._resize();
            }
        };
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TableCursor.this._resize();
            }
        };
        ScrollBar scrollBar2 = this.table.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.addListener(13, this.resizeListener);
        }
        if ((scrollBar = this.table.getVerticalBar()) != null) {
            scrollBar.addListener(13, this.resizeListener);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void dispose(Event event) {
        ScrollBar scrollBar;
        ScrollBar scrollBar2;
        this.table.removeListener(15, this.tableListener);
        this.table.removeListener(3, this.tableListener);
        if (this.column != null) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (this.row != null) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if ((scrollBar2 = this.table.getHorizontalBar()) != null) {
            scrollBar2.removeListener(13, this.resizeListener);
        }
        if ((scrollBar = this.table.getVerticalBar()) != null) {
            scrollBar.removeListener(13, this.resizeListener);
        }
    }

    void keyDown(Event event) {
        if (this.row == null) {
            return;
        }
        switch (event.character) {
            case '\r': {
                this.notifyListeners(14, new Event());
                return;
            }
        }
        int n2 = this.table.indexOf(this.row);
        int n3 = this.column == null ? 0 : this.table.indexOf(this.column);
        switch (event.keyCode) {
            case 0x1000001: {
                this.setRowColumn(Math.max(0, n2 - 1), n3, true);
                break;
            }
            case 0x1000002: {
                this.setRowColumn(Math.min(n2 + 1, this.table.getItemCount() - 1), n3, true);
                break;
            }
            case 0x1000003: 
            case 0x1000004: {
                int n4;
                int n5;
                int n6 = this.table.getColumnCount();
                if (n6 == 0) break;
                int[] nArray = this.table.getColumnOrder();
                for (n5 = 0; n5 < nArray.length && nArray[n5] != n3; ++n5) {
                }
                if (n5 == nArray.length) {
                    n5 = 0;
                }
                int n7 = n4 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                if (event.keyCode == n4) {
                    this.setRowColumn(n2, nArray[Math.max(0, n5 - 1)], true);
                    break;
                }
                this.setRowColumn(n2, nArray[Math.min(n6 - 1, n5 + 1)], true);
                break;
            }
            case 0x1000007: {
                this.setRowColumn(0, n3, true);
                break;
            }
            case 0x1000008: {
                int n8 = this.table.getItemCount() - 1;
                this.setRowColumn(n8, n3, true);
                break;
            }
            case 0x1000005: {
                int n9 = this.table.getTopIndex();
                if (n9 == n2) {
                    Rectangle rectangle = this.table.getClientArea();
                    TableItem tableItem = this.table.getItem(n9);
                    Rectangle rectangle2 = tableItem.getBounds(0);
                    rectangle.height -= rectangle2.y;
                    int n10 = this.table.getItemHeight();
                    int n11 = Math.max(1, rectangle.height / n10);
                    n9 = Math.max(0, n9 - n11 + 1);
                }
                this.setRowColumn(n9, n3, true);
                break;
            }
            case 0x1000006: {
                int n12 = this.table.getTopIndex();
                Rectangle rectangle = this.table.getClientArea();
                TableItem tableItem = this.table.getItem(n12);
                Rectangle rectangle3 = tableItem.getBounds(0);
                rectangle.height -= rectangle3.y;
                int n13 = this.table.getItemHeight();
                int n14 = Math.max(1, rectangle.height / n13);
                int n15 = this.table.getItemCount() - 1;
                n12 = Math.min(n15, n12 + n14 - 1);
                if (n12 == n2) {
                    n12 = Math.min(n15, n12 + n14 - 1);
                }
                this.setRowColumn(n12, n3, true);
                break;
            }
        }
    }

    void paint(Event event) {
        Object object;
        if (this.row == null) {
            return;
        }
        int n2 = this.column == null ? 0 : this.table.indexOf(this.column);
        GC gC = event.gc;
        Display display = this.getDisplay();
        gC.setBackground(this.getBackground());
        gC.setForeground(this.getForeground());
        gC.fillRectangle(event.x, event.y, event.width, event.height);
        int n3 = 0;
        Point point = this.getSize();
        Image image = this.row.getImage(n2);
        if (image != null) {
            object = image.getBounds();
            int n4 = (point.y - ((Rectangle)object).height) / 2;
            gC.drawImage(image, n3, n4);
            n3 += ((Rectangle)object).width;
        }
        if ((object = this.row.getText(n2)) != "") {
            int n5;
            Rectangle rectangle = this.row.getBounds(n2);
            Point point2 = gC.stringExtent((String)object);
            String string = SWT.getPlatform();
            if ("win32".equals(string)) {
                if (this.table.getColumnCount() == 0 || n2 == 0) {
                    n3 += 2;
                } else {
                    n5 = this.column.getAlignment();
                    switch (n5) {
                        case 16384: {
                            n3 += 6;
                            break;
                        }
                        case 131072: {
                            n3 = rectangle.width - point2.x - 6;
                            break;
                        }
                        case 0x1000000: {
                            n3 += (rectangle.width - n3 - point2.x) / 2;
                        }
                    }
                }
            } else if (this.table.getColumnCount() == 0) {
                n3 += 5;
            } else {
                n5 = this.column.getAlignment();
                switch (n5) {
                    case 16384: {
                        n3 += 5;
                        break;
                    }
                    case 131072: {
                        n3 = rectangle.width - point2.x - 2;
                        break;
                    }
                    case 0x1000000: {
                        n3 += (rectangle.width - n3 - point2.x) / 2 + 2;
                    }
                }
            }
            n5 = (point.y - point2.y) / 2;
            gC.drawString((String)object, n3, n5);
        }
        if (this.isFocusControl()) {
            gC.setBackground(display.getSystemColor(2));
            gC.setForeground(display.getSystemColor(1));
            gC.drawFocus(0, 0, point.x, point.y);
        }
    }

    void tableFocusIn(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.isVisible()) {
            this.setFocus();
        }
    }

    void tableMouseDown(Event event) {
        int n2;
        if (this.isDisposed() || !this.isVisible()) {
            return;
        }
        Point point = new Point(event.x, event.y);
        int n3 = this.table.getLinesVisible() ? this.table.getGridLineWidth() : 0;
        TableItem tableItem = this.table.getItem(point);
        if ((this.table.getStyle() & 0x10000) != 0) {
            if (tableItem == null) {
                return;
            }
        } else {
            int n4 = tableItem != null ? this.table.indexOf(tableItem) : this.table.getTopIndex();
            n2 = this.table.getItemCount();
            Rectangle rectangle = this.table.getClientArea();
            for (int i2 = n4; i2 < n2; ++i2) {
                TableItem tableItem2 = this.table.getItem(i2);
                Rectangle rectangle2 = tableItem2.getBounds(0);
                if (point.y >= rectangle2.y && point.y < rectangle2.y + rectangle2.height + n3) {
                    tableItem = tableItem2;
                    break;
                }
                if (rectangle2.y <= rectangle.y + rectangle.height) continue;
                return;
            }
            if (tableItem == null) {
                return;
            }
        }
        TableColumn tableColumn = null;
        n2 = this.table.getColumnCount();
        if (n2 > 0) {
            for (int i3 = 0; i3 < n2; ++i3) {
                Rectangle rectangle = tableItem.getBounds(i3);
                rectangle.width += n3;
                rectangle.height += n3;
                if (!rectangle.contains(point)) continue;
                tableColumn = this.table.getColumn(i3);
                break;
            }
            if (tableColumn == null) {
                tableColumn = this.table.getColumn(0);
            }
        }
        this.setRowColumn(tableItem, tableColumn, true);
        this.setFocus();
    }

    void traverse(Event event) {
        switch (event.detail) {
            case 4: 
            case 32: 
            case 64: {
                event.doit = false;
                return;
            }
        }
        event.doit = true;
    }

    void setRowColumn(int n2, int n3, boolean bl) {
        TableItem tableItem = n2 == -1 ? null : this.table.getItem(n2);
        TableColumn tableColumn = n3 == -1 || this.table.getColumnCount() == 0 ? null : this.table.getColumn(n3);
        this.setRowColumn(tableItem, tableColumn, bl);
    }

    void setRowColumn(TableItem tableItem, TableColumn tableColumn, boolean bl) {
        if (this.row == tableItem && this.column == tableColumn) {
            return;
        }
        if (this.row != null && this.row != tableItem) {
            this.row.removeListener(12, this.disposeItemListener);
            this.row = null;
        }
        if (this.column != null && this.column != tableColumn) {
            this.column.removeListener(12, this.disposeColumnListener);
            this.column.removeListener(10, this.resizeListener);
            this.column.removeListener(11, this.resizeListener);
            this.column = null;
        }
        if (tableItem != null) {
            if (this.row != tableItem) {
                this.row = tableItem;
                tableItem.addListener(12, this.disposeItemListener);
                this.table.showItem(tableItem);
            }
            if (this.column != tableColumn && tableColumn != null) {
                this.column = tableColumn;
                tableColumn.addListener(12, this.disposeColumnListener);
                tableColumn.addListener(10, this.resizeListener);
                tableColumn.addListener(11, this.resizeListener);
                this.table.showColumn(tableColumn);
            }
            int n2 = tableColumn == null ? 0 : this.table.indexOf(tableColumn);
            this.setBounds(tableItem.getBounds(n2));
            this.redraw();
            if (bl) {
                this.notifyListeners(13, new Event());
            }
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            this._resize();
        }
        super.setVisible(bl);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    void _resize() {
        if (this.row == null) {
            this.setBounds(-200, -200, 0, 0);
        } else {
            int n2 = this.column == null ? 0 : this.table.indexOf(this.column);
            this.setBounds(this.row.getBounds(n2));
        }
    }

    public int getColumn() {
        this.checkWidget();
        return this.column == null ? 0 : this.table.indexOf(this.column);
    }

    public TableItem getRow() {
        this.checkWidget();
        return this.row;
    }

    public void setBackground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(27);
        }
        super.setBackground(color);
        this.redraw();
    }

    public void setForeground(Color color) {
        if (color == null) {
            color = this.getDisplay().getSystemColor(26);
        }
        super.setForeground(color);
        this.redraw();
    }

    public void setSelection(int n2, int n3) {
        int n4;
        this.checkWidget();
        int n5 = this.table.getColumnCount();
        int n6 = n4 = n5 == 0 ? 0 : n5 - 1;
        if (n2 < 0 || n2 >= this.table.getItemCount() || n3 < 0 || n3 > n4) {
            SWT.error(5);
        }
        this.setRowColumn(n2, n3, false);
    }

    public void setSelection(TableItem tableItem, int n2) {
        int n3;
        this.checkWidget();
        int n4 = this.table.getColumnCount();
        int n5 = n3 = n4 == 0 ? 0 : n4 - 1;
        if (tableItem == null || tableItem.isDisposed() || n2 < 0 || n2 > n3) {
            SWT.error(5);
        }
        this.setRowColumn(this.table.indexOf(tableItem), n2, false);
    }
}

