/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TVHITTESTINFO;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeDragAndDropEffect
extends DragAndDropEffect {
    Tree tree;
    int dropIndex;
    int scrollIndex;
    long scrollBeginTime;
    int expandIndex;
    long expandBeginTime;
    TreeItem insertItem;
    boolean insertBefore;
    static final int SCROLL_HYSTERESIS = 200;
    static final int EXPAND_HYSTERESIS = 300;

    TreeDragAndDropEffect(Tree tree) {
        this.tree = tree;
    }

    int checkEffect(int n2) {
        if ((n2 & 1) != 0) {
            n2 = n2 & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n2 & 2) != 0) {
            n2 &= 0xFFFFFFFB;
        }
        return n2;
    }

    Widget getItem(int n2, int n3) {
        Rectangle rectangle;
        Point point = new Point(n2, n3);
        TreeItem treeItem = this.tree.getItem(point = this.tree.toControl(point));
        if (treeItem == null && (rectangle = this.tree.getClientArea()).contains(point)) {
            Point point2;
            for (int i2 = rectangle.x; i2 < rectangle.x + rectangle.width && (treeItem = this.tree.getItem(point2 = new Point(i2, point.y))) == null; ++i2) {
            }
        }
        return treeItem;
    }

    ImageData getDragSourceImage(int n2, int n3) {
        TreeItem[] treeItemArray = this.tree.getSelection();
        if (treeItemArray.length == 0) {
            return null;
        }
        int n4 = OS.SendMessage((int)this.tree.handle, (int)4360, (int)0, (int)0);
        if (n4 != 0) {
            Object object;
            Object object2;
            int n5;
            int n6 = Math.min(treeItemArray.length, 10);
            Rectangle rectangle = treeItemArray[0].getBounds(0);
            for (n5 = 1; n5 < n6; ++n5) {
                rectangle = rectangle.union(treeItemArray[n5].getBounds(0));
            }
            n5 = OS.GetDC((int)0);
            int n7 = OS.CreateCompatibleDC((int)n5);
            int n8 = OS.CreateCompatibleBitmap((int)n5, (int)rectangle.width, (int)rectangle.height);
            int n9 = OS.SelectObject((int)n7, (int)n8);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            int n10 = OS.GetStockObject((int)0);
            OS.FillRect((int)n7, (RECT)rECT, (int)n10);
            for (int i2 = 0; i2 < n6; ++i2) {
                object2 = treeItemArray[i2];
                object = ((TreeItem)object2).getBounds(0);
                int n11 = OS.SendMessage((int)this.tree.handle, (int)4370, (int)0, (int)((TreeItem)object2).handle);
                OS.ImageList_Draw((int)n11, (int)0, (int)n7, (int)(((Rectangle)object).x - rectangle.x), (int)(((Rectangle)object).y - rectangle.y), (int)4);
                OS.ImageList_Destroy((int)n11);
            }
            OS.SelectObject((int)n7, (int)n9);
            OS.DeleteDC((int)n7);
            OS.ReleaseDC((int)0, (int)n5);
            Display display = this.tree.getDisplay();
            object2 = Image.win32_new((Device)display, (int)0, (int)n8);
            object = ((Image)object2).getImageData();
            ((Image)object2).dispose();
            return object;
        }
        return null;
    }

    void showDropTargetEffect(int n2, int n3, int n4) {
        int n5;
        n2 = this.checkEffect(n2);
        int n6 = this.tree.handle;
        Point point = new Point(n3, n4);
        point = this.tree.toControl(point);
        TVHITTESTINFO tVHITTESTINFO = new TVHITTESTINFO();
        tVHITTESTINFO.x = point.x;
        tVHITTESTINFO.y = point.y;
        OS.SendMessage((int)n6, (int)4369, (int)0, (TVHITTESTINFO)tVHITTESTINFO);
        int n7 = tVHITTESTINFO.hItem;
        if ((n2 & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (n7 != -1 && this.scrollIndex == n7 && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                n5 = OS.SendMessage((int)n6, (int)4362, (int)5, (int)0);
                int n8 = OS.SendMessage((int)n6, (int)4362, (int)(n7 == n5 ? 7 : 6), (int)n7);
                boolean bl = true;
                if (n7 == n5) {
                    bl = n8 != 0;
                } else {
                    RECT rECT = new RECT();
                    rECT.left = n8;
                    if (OS.SendMessage((int)n6, (int)4356, (int)1, (RECT)rECT) != 0) {
                        RECT rECT2 = new RECT();
                        OS.GetClientRect((int)n6, (RECT)rECT2);
                        POINT pOINT = new POINT();
                        pOINT.x = rECT.left;
                        pOINT.y = rECT.top;
                        if (OS.PtInRect((RECT)rECT2, (POINT)pOINT)) {
                            pOINT.y = rECT.bottom;
                            if (OS.PtInRect((RECT)rECT2, (POINT)pOINT)) {
                                bl = false;
                            }
                        }
                    }
                }
                if (bl) {
                    OS.SendMessage((int)n6, (int)4372, (int)0, (int)n8);
                    this.tree.redraw();
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 200L;
            this.scrollIndex = n7;
        }
        if ((n2 & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (n7 != -1 && this.expandIndex == n7 && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (OS.SendMessage((int)n6, (int)4362, (int)4, (int)n7) != 0) {
                    TVITEM tVITEM = new TVITEM();
                    tVITEM.hItem = n7;
                    tVITEM.mask = 24;
                    OS.SendMessage((int)n6, (int)OS.TVM_GETITEM, (int)0, (TVITEM)tVITEM);
                    if ((tVITEM.state & 0x20) == 0) {
                        OS.SendMessage((int)n6, (int)4354, (int)2, (int)n7);
                        this.tree.redraw();
                    }
                }
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 300L;
            this.expandIndex = n7;
        }
        if (this.dropIndex != -1 && (this.dropIndex != n7 || (n2 & 1) == 0)) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = this.dropIndex;
            tVITEM.mask = 8;
            tVITEM.stateMask = 8;
            tVITEM.state = 0;
            OS.SendMessage((int)n6, (int)OS.TVM_SETITEM, (int)0, (TVITEM)tVITEM);
            this.dropIndex = -1;
        }
        if (n7 != -1 && n7 != this.dropIndex && (n2 & 1) != 0) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = n7;
            tVITEM.mask = 8;
            tVITEM.stateMask = 8;
            tVITEM.state = 8;
            OS.SendMessage((int)n6, (int)OS.TVM_SETITEM, (int)0, (TVITEM)tVITEM);
            this.dropIndex = n7;
        }
        if ((n2 & 2) != 0 || (n2 & 4) != 0) {
            n5 = (n2 & 2) != 0 ? 1 : 0;
            TreeItem treeItem = (TreeItem)this.tree.getDisplay().findWidget(this.tree.handle, n7);
            if (treeItem != null) {
                if (treeItem != this.insertItem || n5 != this.insertBefore) {
                    this.tree.setInsertMark(treeItem, n5 != 0);
                }
                this.insertItem = treeItem;
                this.insertBefore = n5;
            } else {
                if (this.insertItem != null) {
                    this.tree.setInsertMark(null, false);
                }
                this.insertItem = null;
            }
        } else {
            if (this.insertItem != null) {
                this.tree.setInsertMark(null, false);
            }
            this.insertItem = null;
        }
    }
}

