/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.JPEGVariableSizeSegment;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGQuantizationTable
extends JPEGVariableSizeSegment {
    public static byte[] DefaultLuminanceQTable = new byte[]{-1, -37, 0, 67, 0, 16, 11, 10, 16, 24, 40, 51, 61, 12, 12, 14, 19, 26, 58, 60, 55, 14, 13, 16, 24, 40, 57, 69, 56, 14, 17, 22, 29, 51, 87, 80, 62, 18, 22, 37, 56, 68, 109, 103, 77, 24, 35, 55, 64, 81, 104, 113, 92, 49, 64, 78, 87, 103, 121, 120, 101, 72, 92, 95, 98, 112, 100, 103, 99};
    public static byte[] DefaultChrominanceQTable = new byte[]{-1, -37, 0, 67, 1, 17, 18, 24, 47, 99, 99, 99, 99, 18, 21, 26, 66, 99, 99, 99, 99, 24, 26, 56, 99, 99, 99, 99, 99, 47, 66, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99};

    public JPEGQuantizationTable(byte[] byArray) {
        super(byArray);
    }

    public JPEGQuantizationTable(LEDataInputStream lEDataInputStream) {
        super(lEDataInputStream);
    }

    public static JPEGQuantizationTable defaultChrominanceTable() {
        byte[] byArray = new byte[DefaultChrominanceQTable.length];
        System.arraycopy(DefaultChrominanceQTable, 0, byArray, 0, byArray.length);
        return new JPEGQuantizationTable(byArray);
    }

    public static JPEGQuantizationTable defaultLuminanceTable() {
        byte[] byArray = new byte[DefaultLuminanceQTable.length];
        System.arraycopy(DefaultLuminanceQTable, 0, byArray, 0, byArray.length);
        return new JPEGQuantizationTable(byArray);
    }

    public int[] getQuantizationTablesKeys() {
        int[] nArray = new int[4];
        int n2 = 0;
        int n3 = this.getSegmentLength() - 2;
        int n4 = 4;
        while (n3 > 64) {
            int n5 = this.reference[n4] & 0xF;
            int n6 = (this.reference[n4] & 0xFF) >> 4;
            if (n6 == 0) {
                n4 += 65;
                n3 -= 65;
            } else {
                n4 += 129;
                n3 -= 129;
            }
            if (n2 >= nArray.length) {
                int[] nArray2 = new int[nArray.length + 4];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            nArray[n2] = n5;
            ++n2;
        }
        int[] nArray3 = new int[n2];
        System.arraycopy(nArray, 0, nArray3, 0, n2);
        return nArray3;
    }

    public int[][] getQuantizationTablesValues() {
        Object object;
        int[][] nArrayArray = new int[4][];
        int n2 = 0;
        int n3 = this.getSegmentLength() - 2;
        int n4 = 4;
        while (n3 > 64) {
            int n5;
            object = new int[64];
            int n6 = (this.reference[n4] & 0xFF) >> 4;
            if (n6 == 0) {
                for (n5 = 0; n5 < ((int[])object).length; ++n5) {
                    object[n5] = this.reference[n4 + n5 + 1] & 0xFF;
                }
                n4 += 65;
                n3 -= 65;
            } else {
                for (n5 = 0; n5 < ((int[])object).length; ++n5) {
                    int n7 = (n5 - 1) * 2;
                    object[n5] = (this.reference[n4 + n7 + 1] & 0xFF) * 256 + (this.reference[n4 + n7 + 2] & 0xFF);
                }
                n4 += 129;
                n3 -= 129;
            }
            if (n2 >= nArrayArray.length) {
                int[][] nArrayArray2 = new int[nArrayArray.length + 4][];
                System.arraycopy(nArrayArray, 0, nArrayArray2, 0, nArrayArray.length);
                nArrayArray = nArrayArray2;
            }
            nArrayArray[n2] = object;
            ++n2;
        }
        object = new int[n2][];
        System.arraycopy(nArrayArray, 0, object, 0, n2);
        return object;
    }

    public void scaleBy(int n2) {
        int n3 = n2;
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n3 > 100) {
            n3 = 100;
        }
        n3 = n3 < 50 ? 5000 / n3 : 200 - n3 * 2;
        int n4 = this.getSegmentLength() - 2;
        int n5 = 4;
        while (n4 > 64) {
            int n6;
            int n7;
            int n8 = (this.reference[n5] & 0xFF) >> 4;
            if (n8 == 0) {
                for (n7 = n5 + 1; n7 <= n5 + 64; ++n7) {
                    n6 = ((this.reference[n7] & 0xFF) * n3 + 50) / 100;
                    if (n6 <= 0) {
                        n6 = 1;
                    }
                    if (n6 > 255) {
                        n6 = 255;
                    }
                    this.reference[n7] = (byte)n6;
                }
                n5 += 65;
                n4 -= 65;
                continue;
            }
            for (n7 = n5 + 1; n7 <= n5 + 128; n7 += 2) {
                n6 = (((this.reference[n7] & 0xFF) * 256 + (this.reference[n7 + 1] & 0xFF)) * n3 + 50) / 100;
                if (n6 <= 0) {
                    n6 = 1;
                }
                if (n6 > Short.MAX_VALUE) {
                    n6 = Short.MAX_VALUE;
                }
                this.reference[n7] = (byte)(n6 >> 8);
                this.reference[n7 + 1] = (byte)(n6 & 0xFF);
            }
            n5 += 129;
            n4 -= 129;
        }
    }

    public int signature() {
        return 65499;
    }
}

