/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngLzBlockReader;

public class PngDecodingDataStream {
    PngIdatChunk currentChunk;
    PngChunkReader chunkReader;
    byte currentByte;
    int nextByteIndex;
    int nextBitIndex;
    PngLzBlockReader lzBlockReader;
    int adlerValue;
    static final int PRIME = 65521;
    static final int MAX_BIT = 7;

    PngDecodingDataStream(PngIdatChunk pngIdatChunk, PngChunkReader pngChunkReader) {
        this.currentChunk = pngIdatChunk;
        this.chunkReader = pngChunkReader;
        this.nextByteIndex = 0;
        this.nextBitIndex = 8;
        this.adlerValue = 1;
        this.lzBlockReader = new PngLzBlockReader(this);
        this.readCompressedDataHeader();
        this.lzBlockReader.readNextBlockHeader();
    }

    void assertImageDataAtEnd() {
        this.lzBlockReader.assertCompressedDataAtEnd();
    }

    int getNextIdatBits(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 |= this.getNextIdatBit() << i2;
        }
        return n3;
    }

    byte getNextIdatBit() {
        if (this.nextBitIndex > 7) {
            this.currentByte = this.getNextIdatByte();
            this.nextBitIndex = 0;
        }
        int n2 = 1 << this.nextBitIndex;
        ++this.nextBitIndex;
        return (this.currentByte & n2) > 0 ? (byte)1 : 0;
    }

    private PngIdatChunk getNextChunk() {
        PngChunk pngChunk = this.chunkReader.readNextChunk();
        if (pngChunk == null) {
            this.error();
        }
        if (pngChunk.getChunkType() != 2) {
            this.error();
        }
        return (PngIdatChunk)pngChunk;
    }

    byte getNextIdatByte() {
        if (this.nextByteIndex > this.currentChunk.getLength() - 1) {
            this.currentChunk = this.getNextChunk();
            this.nextByteIndex = 0;
        }
        byte by = this.currentChunk.getDataByteAtOffset(this.nextByteIndex);
        ++this.nextByteIndex;
        this.nextBitIndex = 8;
        return by;
    }

    void updateAdler(byte by) {
        int n2 = this.adlerValue & 0xFFFF;
        int n3 = this.adlerValue >> 16 & 0xFFFF;
        int n4 = by & 0xFF;
        n2 = (n2 + n4) % 65521;
        n3 = (n2 + n3) % 65521;
        this.adlerValue = n3 << 16 | n2;
    }

    byte getNextDecodedByte() {
        byte by = this.lzBlockReader.getNextByte();
        this.updateAdler(by);
        return by;
    }

    void error() {
        SWT.error(40);
    }

    private void readCompressedDataHeader() {
        int n2;
        int n3;
        byte by;
        byte by2 = this.getNextIdatByte();
        int n4 = (by2 & 0xFF) << 8 | (by = this.getNextIdatByte()) & 0xFF;
        if (n4 % 31 != 0) {
            this.error();
        }
        if ((n3 = by2 & 0xF) != 8) {
            this.error();
        }
        if ((n2 = (by2 & 0xF0) >> 4) > 7) {
            this.error();
        }
        int n5 = 1 << n2 + 8;
        this.lzBlockReader.setWindowSize(n5);
        int n6 = by & 0x20;
        if (n6 != 0) {
            this.error();
        }
    }

    void checkAdler() {
        int n2 = (this.getNextIdatByte() & 0xFF) << 24 | (this.getNextIdatByte() & 0xFF) << 16 | (this.getNextIdatByte() & 0xFF) << 8 | this.getNextIdatByte() & 0xFF;
        if (n2 != this.adlerValue) {
            this.error();
        }
    }
}

