/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;

    PngHuffmanTable(int[] nArray) {
        this.initialize(nArray);
        this.generateTable(nArray);
    }

    private void initialize(int[] nArray) {
        int n2;
        this.codeValues = new int[nArray.length];
        for (n2 = 0; n2 < this.codeValues.length; ++n2) {
            this.codeValues[n2] = n2;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        for (n2 = 0; n2 < 15; ++n2) {
            this.codeLengthInfo[n2] = new CodeLengthInfo();
            this.codeLengthInfo[n2].length = n2;
            this.codeLengthInfo[n2].baseIndex = 0;
            this.codeLengthInfo[n2].min = 0xFFFFFFF;
            this.codeLengthInfo[n2].max = -1;
        }
    }

    private void generateTable(int[] nArray) {
        int n2;
        int n3;
        int n4;
        for (int i2 = 0; i2 < nArray.length - 1; ++i2) {
            for (n4 = i2 + 1; n4 < nArray.length; ++n4) {
                if (nArray[n4] >= nArray[i2] && (nArray[n4] != nArray[i2] || this.codeValues[n4] >= this.codeValues[i2])) continue;
                n3 = nArray[n4];
                nArray[n4] = nArray[i2];
                nArray[i2] = n3;
                n3 = this.codeValues[n4];
                this.codeValues[n4] = this.codeValues[i2];
                this.codeValues[i2] = n3;
            }
        }
        int[] nArray2 = new int[nArray.length];
        n4 = 0;
        n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            while (n4 != nArray[n2]) {
                ++n4;
                n3 <<= 1;
            }
            if (n4 == 0) continue;
            nArray2[n2] = n3++;
        }
        n2 = 0;
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            if (n2 != nArray[i3]) {
                n2 = nArray[i3];
                this.codeLengthInfo[n2 - 1].baseIndex = i3;
                this.codeLengthInfo[n2 - 1].min = nArray2[i3];
            }
            if (n2 == 0) continue;
            this.codeLengthInfo[n2 - 1].max = nArray2[i3];
        }
    }

    int getNextValue(PngDecodingDataStream pngDecodingDataStream) {
        int n2;
        int n3 = pngDecodingDataStream.getNextIdatBit();
        for (n2 = 0; n2 < 15 && n3 > this.codeLengthInfo[n2].max; ++n2) {
            n3 = n3 << 1 | pngDecodingDataStream.getNextIdatBit();
        }
        if (n2 >= 15) {
            pngDecodingDataStream.error();
        }
        int n4 = n3 - this.codeLengthInfo[n2].min;
        int n5 = this.codeLengthInfo[n2].baseIndex + n4;
        return this.codeValues[n5];
    }

    class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }
}

