/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CLabel;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

class CSeparator
extends JPanel
implements CLabel {
    protected Label handle;
    protected JSeparator separator;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this.separator;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CSeparator(Label label, int n2) {
        this.handle = label;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = (n2 & 0x100) != 0 ? 2 : 3;
        this.separator = new JSeparator((n2 & 0x100) != 0 ? 0 : 1);
        gridBagLayout.setConstraints(this.separator, gridBagConstraints);
        this.add(this.separator);
        this.init(n2);
    }

    protected void init(int n2) {
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        }
        Utils.installMouseListener(this.separator, this.handle);
        Utils.installKeyListener(this.separator, this.handle);
        Utils.installFocusListener(this.separator, this.handle);
        Utils.installComponentListener(this, this.handle);
    }

    public boolean isOpaque() {
        return this.backgroundImageIcon == null && super.isOpaque();
    }

    protected void paintComponent(Graphics graphics) {
        Utils.paintTiledImage(this, graphics, this.backgroundImageIcon);
        super.paintComponent(graphics);
    }

    public Container getClientArea() {
        return this.separator;
    }

    public int getPreferredWidth() {
        return this.getPreferredSize().width;
    }

    public void setText(String string, int n2) {
    }

    public void setAlignment(int n2) {
    }

    public void setIcon(Icon icon) {
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: {
                this.setOpaque(true);
                this.separator.setOpaque(true);
                break;
            }
            case 1: 
            case 2: {
                this.setOpaque(false);
                this.separator.setOpaque(false);
            }
        }
    }
}

