/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.eclipse.swt.internal.swing.CTreeItemImplementation;
import org.eclipse.swt.widgets.TreeItem;

public interface CTreeItem {
    public TreeNode[] getPath();

    public TreeItemObject getTreeItemObject(int var1);

    public int getChildCount();

    public void setChecked(boolean var1);

    public boolean isChecked();

    public void setGrayed(boolean var1);

    public boolean isGrayed();

    public void insertColumn(int var1);

    public void removeColumn(int var1);

    public TreeItem getTreeItem();

    public void setForeground(Color var1);

    public Color getForeground();

    public void setBackground(Color var1);

    public Color getBackground();

    public void setFont(Font var1);

    public Font getFont();

    public static class Factory {
        private Factory() {
        }

        public static CTreeItem newInstance(TreeItem treeItem, int style) {
            return new CTreeItemImplementation(treeItem, style);
        }
    }

    public static class TreeItemObject {
        protected CTreeItem treeItem;
        protected String text;
        protected Icon icon;
        protected Color background;
        protected Color foreground;
        protected Font font;

        public CTreeItem getTreeItem() {
            return this.treeItem;
        }

        protected TreeItemObject(CTreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text == null ? "" : this.text;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public Color getBackground() {
            return this.background;
        }

        public void setForeground(Color foreground) {
            this.foreground = foreground;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public Font getFont() {
            return this.font;
        }

        public String toString() {
            if (!((CTreeItemImplementation)this.treeItem).handle.isDisposed()) {
                ((CTreeItemImplementation)this.treeItem).handle.getText();
            }
            return this.getText();
        }

        public boolean isChecked() {
            return this.treeItem.isChecked();
        }

        public boolean isGrayed() {
            return this.treeItem.isGrayed();
        }
    }
}

