/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.EXCEPINFO;
import org.eclipse.swt.internal.ole.win32.FUNCDESC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.ITypeInfo;
import org.eclipse.swt.internal.ole.win32.TYPEATTR;
import org.eclipse.swt.internal.ole.win32.VARDESC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleParameterDescription;
import org.eclipse.swt.ole.win32.OlePropertyDescription;
import org.eclipse.swt.ole.win32.Variant;

public final class OleAutomation {
    private IDispatch objIDispatch;
    private String exceptionDescription;
    private ITypeInfo objITypeInfo;

    OleAutomation(IDispatch iDispatch) {
        if (iDispatch == null) {
            OLE.error((int)1011);
        }
        this.objIDispatch = iDispatch;
        this.objIDispatch.AddRef();
        int[] nArray = new int[1];
        int n2 = this.objIDispatch.GetTypeInfo(0, 2048, nArray);
        if (n2 == 0) {
            this.objITypeInfo = new ITypeInfo(nArray[0]);
            this.objITypeInfo.AddRef();
        }
    }

    public OleAutomation(OleClientSite oleClientSite) {
        if (oleClientSite == null) {
            OLE.error((int)1011);
        }
        this.objIDispatch = oleClientSite.getAutomationObject();
        int[] nArray = new int[1];
        int n2 = this.objIDispatch.GetTypeInfo(0, 2048, nArray);
        if (n2 == 0) {
            this.objITypeInfo = new ITypeInfo(nArray[0]);
            this.objITypeInfo.AddRef();
        }
    }

    public void dispose() {
        if (this.objIDispatch != null) {
            this.objIDispatch.Release();
        }
        this.objIDispatch = null;
        if (this.objITypeInfo != null) {
            this.objITypeInfo.Release();
        }
        this.objITypeInfo = null;
    }

    int getAddress() {
        return this.objIDispatch.getAddress();
    }

    public String getHelpFile(int n2) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] stringArray = new String[1];
        int n3 = this.objITypeInfo.GetDocumentation(n2, null, null, null, stringArray);
        if (n3 == 0) {
            return stringArray[0];
        }
        return null;
    }

    public String getDocumentation(int n2) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] stringArray = new String[1];
        int n3 = this.objITypeInfo.GetDocumentation(n2, null, stringArray, null, null);
        if (n3 == 0) {
            return stringArray[0];
        }
        return null;
    }

    public OlePropertyDescription getPropertyDescription(int n2) {
        if (this.objITypeInfo == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n3 = this.objITypeInfo.GetVarDesc(n2, nArray);
        if (n3 != 0) {
            return null;
        }
        VARDESC vARDESC = new VARDESC();
        COM.MoveMemory((VARDESC)vARDESC, (int)nArray[0], (int)36);
        OlePropertyDescription olePropertyDescription = new OlePropertyDescription();
        olePropertyDescription.id = vARDESC.memid;
        olePropertyDescription.name = this.getName(vARDESC.memid);
        olePropertyDescription.type = vARDESC.elemdescVar_tdesc_vt;
        if (olePropertyDescription.type == 26) {
            short[] sArray = new short[1];
            COM.MoveMemory((short[])sArray, (int)(vARDESC.elemdescVar_tdesc_union + 4), (int)2);
            olePropertyDescription.type = sArray[0];
        }
        olePropertyDescription.flags = vARDESC.wVarFlags;
        olePropertyDescription.kind = vARDESC.varkind;
        olePropertyDescription.description = this.getDocumentation(vARDESC.memid);
        olePropertyDescription.helpFile = this.getHelpFile(vARDESC.memid);
        this.objITypeInfo.ReleaseVarDesc(nArray[0]);
        return olePropertyDescription;
    }

    public OleFunctionDescription getFunctionDescription(int n2) {
        if (this.objITypeInfo == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n3 = this.objITypeInfo.GetFuncDesc(n2, nArray);
        if (n3 != 0) {
            return null;
        }
        FUNCDESC fUNCDESC = new FUNCDESC();
        COM.MoveMemory((FUNCDESC)fUNCDESC, (int)nArray[0], (int)50);
        OleFunctionDescription oleFunctionDescription = new OleFunctionDescription();
        oleFunctionDescription.id = fUNCDESC.memid;
        oleFunctionDescription.optionalArgCount = fUNCDESC.cParamsOpt;
        oleFunctionDescription.invokeKind = fUNCDESC.invkind;
        oleFunctionDescription.funcKind = fUNCDESC.funckind;
        oleFunctionDescription.flags = fUNCDESC.wFuncFlags;
        oleFunctionDescription.callingConvention = fUNCDESC.callconv;
        oleFunctionDescription.documentation = this.getDocumentation(fUNCDESC.memid);
        oleFunctionDescription.helpFile = this.getHelpFile(fUNCDESC.memid);
        String[] stringArray = this.getNames(fUNCDESC.memid, fUNCDESC.cParams + 1);
        if (stringArray.length > 0) {
            oleFunctionDescription.name = stringArray[0];
        }
        oleFunctionDescription.args = new OleParameterDescription[fUNCDESC.cParams];
        for (int i2 = 0; i2 < oleFunctionDescription.args.length; ++i2) {
            Object[] objectArray;
            oleFunctionDescription.args[i2] = new OleParameterDescription();
            if (stringArray.length > i2 + 1) {
                oleFunctionDescription.args[i2].name = stringArray[i2 + 1];
            }
            short[] sArray = new short[1];
            COM.MoveMemory((short[])sArray, (int)(fUNCDESC.lprgelemdescParam + i2 * 16 + 4), (int)2);
            if (sArray[0] == 26) {
                objectArray = new int[1];
                COM.MoveMemory((int[])objectArray, (int)(fUNCDESC.lprgelemdescParam + i2 * 16), (int)4);
                short[] sArray2 = new short[1];
                COM.MoveMemory((short[])sArray2, (int)(objectArray[0] + 4), (int)2);
                sArray[0] = (short)(sArray2[0] | 0x4000);
            }
            oleFunctionDescription.args[i2].type = sArray[0];
            objectArray = new short[1];
            COM.MoveMemory((short[])objectArray, (int)(fUNCDESC.lprgelemdescParam + i2 * 16 + 12), (int)2);
            oleFunctionDescription.args[i2].flags = (short)objectArray[0];
        }
        oleFunctionDescription.returnType = fUNCDESC.elemdescFunc_tdesc_vt;
        if (oleFunctionDescription.returnType == 26) {
            short[] sArray = new short[1];
            COM.MoveMemory((short[])sArray, (int)(fUNCDESC.elemdescFunc_tdesc_union + 4), (int)2);
            oleFunctionDescription.returnType = sArray[0];
        }
        this.objITypeInfo.ReleaseFuncDesc(nArray[0]);
        return oleFunctionDescription;
    }

    public TYPEATTR getTypeInfoAttributes() {
        if (this.objITypeInfo == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n2 = this.objITypeInfo.GetTypeAttr(nArray);
        if (n2 != 0) {
            return null;
        }
        TYPEATTR tYPEATTR = new TYPEATTR();
        COM.MoveMemory((TYPEATTR)tYPEATTR, (int)nArray[0], (int)74);
        this.objITypeInfo.ReleaseTypeAttr(nArray[0]);
        return tYPEATTR;
    }

    public String getName(int n2) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] stringArray = new String[1];
        int n3 = this.objITypeInfo.GetDocumentation(n2, stringArray, null, null, null);
        if (n3 == 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getNames(int n2, int n3) {
        if (this.objITypeInfo == null) {
            return new String[0];
        }
        String[] stringArray = new String[n3];
        int[] nArray = new int[1];
        int n4 = this.objITypeInfo.GetNames(n2, stringArray, n3, nArray);
        if (n4 == 0) {
            String[] stringArray2 = new String[nArray[0]];
            System.arraycopy(stringArray, 0, stringArray2, 0, nArray[0]);
            return stringArray2;
        }
        return new String[0];
    }

    public int[] getIDsOfNames(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n2 = this.objIDispatch.GetIDsOfNames(new GUID(), stringArray, stringArray.length, 2048, nArray);
        if (n2 != 0) {
            return null;
        }
        return nArray;
    }

    public String getLastError() {
        return this.exceptionDescription;
    }

    public Variant getProperty(int n2) {
        Variant variant = new Variant();
        int n3 = this.invoke(n2, 2, null, null, variant);
        return n3 == 0 ? variant : null;
    }

    public Variant getProperty(int n2, Variant[] variantArray) {
        Variant variant = new Variant();
        int n3 = this.invoke(n2, 2, variantArray, null, variant);
        return n3 == 0 ? variant : null;
    }

    public Variant getProperty(int n2, Variant[] variantArray, int[] nArray) {
        Variant variant = new Variant();
        int n3 = this.invoke(n2, 2, variantArray, nArray, variant);
        return n3 == 0 ? variant : null;
    }

    public Variant invoke(int n2) {
        Variant variant = new Variant();
        int n3 = this.invoke(n2, 1, null, null, variant);
        return n3 == 0 ? variant : null;
    }

    public Variant invoke(int n2, Variant[] variantArray) {
        Variant variant = new Variant();
        int n3 = this.invoke(n2, 1, variantArray, null, variant);
        return n3 == 0 ? variant : null;
    }

    public Variant invoke(int n2, Variant[] variantArray, int[] nArray) {
        Variant variant = new Variant();
        int n3 = this.invoke(n2, 1, variantArray, nArray, variant);
        return n3 == 0 ? variant : null;
    }

    private int invoke(int n2, int n3, Variant[] variantArray, int[] nArray, Variant variant) {
        int n4;
        int n5;
        if (this.objIDispatch == null) {
            return -2147467259;
        }
        DISPPARAMS dISPPARAMS = new DISPPARAMS();
        if (variantArray != null && variantArray.length > 0) {
            dISPPARAMS.cArgs = variantArray.length;
            dISPPARAMS.rgvarg = OS.GlobalAlloc((int)64, (int)(16 * variantArray.length));
            n5 = 0;
            for (n4 = variantArray.length - 1; n4 >= 0; --n4) {
                variantArray[n4].getData(dISPPARAMS.rgvarg + n5);
                n5 += 16;
            }
        }
        if (nArray != null && nArray.length > 0) {
            dISPPARAMS.cNamedArgs = nArray.length;
            dISPPARAMS.rgdispidNamedArgs = OS.GlobalAlloc((int)64, (int)(4 * nArray.length));
            n5 = 0;
            for (n4 = nArray.length; n4 > 0; --n4) {
                COM.MoveMemory((int)(dISPPARAMS.rgdispidNamedArgs + n5), (int[])new int[]{nArray[n4 - 1]}, (int)4);
                n5 += 4;
            }
        }
        EXCEPINFO eXCEPINFO = new EXCEPINFO();
        int[] nArray2 = new int[1];
        int n6 = 0;
        if (variant != null) {
            n6 = OS.GlobalAlloc((int)64, (int)16);
        }
        int n7 = this.objIDispatch.Invoke(n2, new GUID(), 2048, n3, dISPPARAMS, n6, eXCEPINFO, nArray2);
        if (n6 != 0) {
            variant.setData(n6);
            COM.VariantClear((int)n6);
            OS.GlobalFree((int)n6);
        }
        if (dISPPARAMS.rgdispidNamedArgs != 0) {
            OS.GlobalFree((int)dISPPARAMS.rgdispidNamedArgs);
        }
        if (dISPPARAMS.rgvarg != 0) {
            int n8 = 0;
            int n9 = variantArray.length;
            for (int i2 = 0; i2 < n9; ++i2) {
                COM.VariantClear((int)(dISPPARAMS.rgvarg + n8));
                n8 += 16;
            }
            OS.GlobalFree((int)dISPPARAMS.rgvarg);
        }
        this.manageExcepinfo(n7, eXCEPINFO);
        return n7;
    }

    public void invokeNoReply(int n2) {
        int n3 = this.invoke(n2, 1, null, null, null);
        if (n3 != 0) {
            OLE.error((int)1014, (int)n3);
        }
    }

    public void invokeNoReply(int n2, Variant[] variantArray) {
        int n3 = this.invoke(n2, 1, variantArray, null, null);
        if (n3 != 0) {
            OLE.error((int)1014, (int)n3);
        }
    }

    public void invokeNoReply(int n2, Variant[] variantArray, int[] nArray) {
        int n3 = this.invoke(n2, 1, variantArray, nArray, null);
        if (n3 != 0) {
            OLE.error((int)1014, (int)n3);
        }
    }

    private void manageExcepinfo(int n2, EXCEPINFO eXCEPINFO) {
        if (n2 == 0) {
            this.exceptionDescription = "No Error";
            return;
        }
        if (n2 == -2147352567) {
            if (eXCEPINFO.bstrDescription != 0) {
                int n3 = COM.SysStringByteLen((int)eXCEPINFO.bstrDescription);
                char[] cArray = new char[(n3 + 1) / 2];
                COM.MoveMemory((char[])cArray, (int)eXCEPINFO.bstrDescription, (int)n3);
                this.exceptionDescription = new String(cArray);
            } else {
                this.exceptionDescription = "OLE Automation Error Exception ";
                if (eXCEPINFO.wCode != 0) {
                    this.exceptionDescription = this.exceptionDescription + "code = " + eXCEPINFO.wCode;
                } else if (eXCEPINFO.scode != 0) {
                    this.exceptionDescription = this.exceptionDescription + "code = " + eXCEPINFO.scode;
                }
            }
        } else {
            this.exceptionDescription = "OLE Automation Error HResult : " + n2;
        }
        if (eXCEPINFO.bstrDescription != 0) {
            COM.SysFreeString((int)eXCEPINFO.bstrDescription);
        }
        if (eXCEPINFO.bstrHelpFile != 0) {
            COM.SysFreeString((int)eXCEPINFO.bstrHelpFile);
        }
        if (eXCEPINFO.bstrSource != 0) {
            COM.SysFreeString((int)eXCEPINFO.bstrSource);
        }
    }

    public boolean setProperty(int n2, Variant variant) {
        Variant variant2;
        int n3;
        Variant[] variantArray = new Variant[]{variant};
        int[] nArray = new int[]{-3};
        int n4 = 4;
        if ((variant.getType() & 0x4000) == 16384) {
            n4 = 8;
        }
        return (n3 = this.invoke(n2, n4, variantArray, nArray, variant2 = new Variant())) == 0;
    }

    public boolean setProperty(int n2, Variant[] variantArray) {
        int[] nArray = new int[]{-3};
        int n3 = 4;
        for (int i2 = 0; i2 < variantArray.length; ++i2) {
            if ((variantArray[i2].getType() & 0x4000) != 16384) continue;
            n3 = 8;
        }
        Variant variant = new Variant();
        int n4 = this.invoke(n2, n3, variantArray, nArray, variant);
        return n4 == 0;
    }
}

