/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CComposite;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public class Composite
extends Scrollable {
    Layout layout;
    int font;
    Control[] tabList;
    int layoutCount = 0;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite composite, int n2) {
        super(composite, n2);
    }

    Control[] _getChildren() {
        Component[] componentArray = ((CControl)((Object)this.handle)).getClientArea().getComponents();
        if (componentArray.length == 0) {
            return new Control[0];
        }
        ArrayList<Control> arrayList = new ArrayList<Control>(componentArray.length);
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Control control = this.display.getControl(componentArray[i2]);
            if (control == null || control == this) continue;
            arrayList.add(control);
        }
        return arrayList.toArray(new Control[0]);
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabList.length; ++i2) {
            if (this.tabList[i2].isDisposed()) continue;
            ++n2;
        }
        if (n2 == this.tabList.length) {
            return this.tabList;
        }
        Control[] controlArray = new Control[n2];
        int n3 = 0;
        for (int i3 = 0; i3 < this.tabList.length; ++i3) {
            if (this.tabList[i3].isDisposed()) continue;
            controlArray[n3++] = this.tabList[i3];
        }
        this.tabList = controlArray;
        return this.tabList;
    }

    public void changed(Control[] controlArray) {
        Control control;
        int n2;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean bl = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl2 = bl = composite == this;
                if (bl) break;
                composite = composite.parent;
            }
            if (bl) continue;
            this.error(32);
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout == null || !composite.layout.flushCache(control)) {
                    composite.state |= 0x40;
                }
                control = composite;
                composite = control.parent;
            }
        }
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] controlArray = super.computeTabList();
        if (controlArray.length == 0) {
            return controlArray;
        }
        Control[] controlArray2 = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i2 = 0; i2 < controlArray2.length; ++i2) {
            Control control = controlArray2[i2];
            Control[] controlArray3 = control.computeTabList();
            if (controlArray3.length == 0) continue;
            Control[] controlArray4 = new Control[controlArray.length + controlArray3.length];
            System.arraycopy(controlArray, 0, controlArray4, 0, controlArray.length);
            System.arraycopy(controlArray3, 0, controlArray4, controlArray.length, controlArray3.length);
            controlArray = controlArray4;
        }
        return controlArray;
    }

    public Point computeSize(int n2, int n3, boolean bl) {
        Point point;
        this.checkWidget();
        if (this.layout != null) {
            if (n2 == -1 || n3 == -1) {
                boolean bl2 = (this.state & 0x40) != 0;
                this.state &= 0xFFFFFFBF;
                point = this.layout.computeSize(this, n2, n3, bl |= bl2);
            } else {
                point = new Point(n2, n3);
            }
        } else {
            point = this.minimumSize(n2, n3, bl);
        }
        if (point.x == 0) {
            point.x = 64;
        }
        if (point.y == 0) {
            point.y = 64;
        }
        if (n2 != -1) {
            point.x = n2;
        }
        if (n3 != -1) {
            point.y = n3;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state |= 2;
        if ((this.style & 0x300) == 0) {
            this.state |= 0x100;
        }
    }

    protected Container createHandle() {
        return (Container)((Object)CComposite.Factory.newInstance(this, this.style));
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 || this.parent == null ? this : this.parent.findDeferredControl();
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < this.tabList.length; ++i2) {
            if (this.tabList[i2] != control) continue;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        Control[] controlArray = null;
        int n3 = this.tabList.length - n2;
        if (n3 != 0) {
            controlArray = new Control[n3];
            int n4 = 0;
            for (int i3 = 0; i3 < this.tabList.length; ++i3) {
                if (this.tabList[i3] == control) continue;
                controlArray[n4++] = this.tabList[i3];
            }
        }
        this.tabList = controlArray;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] controlArray = this._getTabList();
        if (controlArray == null) {
            int n2;
            int n3 = 0;
            Control[] controlArray2 = this._getChildren();
            for (n2 = 0; n2 < controlArray2.length; ++n2) {
                if (!controlArray2[n2].isTabGroup()) continue;
                ++n3;
            }
            controlArray = new Control[n3];
            n2 = 0;
            for (int i2 = 0; i2 < controlArray2.length; ++i2) {
                if (!controlArray2[i2].isTabGroup()) continue;
                controlArray[n2++] = controlArray2[i2];
            }
        }
        return controlArray;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    protected boolean isLayoutManaged() {
        return false;
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean bl) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(bl, false);
    }

    public void layout(boolean bl, boolean bl2) {
        this.checkWidget();
        if (this.layout == null && !bl2) {
            return;
        }
        this.markLayout(bl, bl2);
        this.updateLayout(true, bl2);
    }

    public void layout(Control[] controlArray) {
        Control control;
        int n2;
        Composite[] compositeArray;
        int n3;
        this.checkWidget();
        if (controlArray == null) {
            this.error(5);
        }
        for (n3 = 0; n3 < controlArray.length; ++n3) {
            compositeArray = controlArray[n3];
            if (compositeArray == null) {
                this.error(5);
            }
            if (compositeArray.isDisposed()) {
                this.error(5);
            }
            n2 = 0;
            control = compositeArray.parent;
            while (control != null) {
                int n4 = n2 = control == this ? 1 : 0;
                if (n2 != 0) break;
                control = control.parent;
            }
            if (n2 != 0) continue;
            this.error(32);
        }
        n3 = 0;
        compositeArray = new Composite[16];
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            Composite composite = control.parent;
            while (control != this) {
                if (composite.layout != null) {
                    composite.state |= 0x20;
                    if (!composite.layout.flushCache(control)) {
                        composite.state |= 0x40;
                    }
                }
                if (n3 == compositeArray.length) {
                    Composite[] compositeArray2 = new Composite[compositeArray.length + 16];
                    System.arraycopy(compositeArray, 0, compositeArray2, 0, compositeArray.length);
                    compositeArray = compositeArray2;
                }
                int n5 = n3++;
                Composite composite2 = composite;
                compositeArray[n5] = composite2;
                control = composite2;
                composite = control.parent;
            }
        }
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            compositeArray[n2].updateLayout(true, false);
        }
    }

    void markLayout(boolean bl, boolean bl2) {
        if (this.layout != null) {
            this.state |= 0x20;
            if (bl) {
                this.state |= 0x40;
            }
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                controlArray[i2].markLayout(bl, bl2);
            }
        }
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Control[] controlArray = this._getChildren();
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Rectangle rectangle = controlArray[i2].getBounds();
            n4 = Math.max(n4, rectangle.x + rectangle.width);
            n5 = Math.max(n5, rectangle.y + rectangle.height);
        }
        return new Point(n4, n5);
    }

    void releaseChildren(boolean bl) {
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            Control control = controlArray[i2];
            if (control == null || control.isDisposed()) continue;
            control.release(false);
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
        this.handle.repaint();
    }

    public void setBackgroundMode(int n2) {
        this.checkWidget();
        if (this.backgroundMode == n2) {
            return;
        }
        this.backgroundMode = n2;
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].updateBackgroundMode();
        }
        this.handle.repaint();
    }

    public boolean setFocus() {
        Control control;
        int n2;
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.setRadioFocus()) continue;
            return true;
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean bl) {
        if (!bl) {
            if (--this.layoutCount == 0 && ((this.state & 0x80) != 0 || (this.state & 0x20) != 0)) {
                this.updateLayout(true, true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    public void setTabList(Control[] controlArray) {
        this.checkWidget();
        if (controlArray != null) {
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control = controlArray[i2];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] controlArray2 = new Control[controlArray.length];
            System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
            controlArray = controlArray2;
        }
        this.tabList = controlArray;
    }

    boolean setTabGroupFocus() {
        Control control;
        int n2;
        boolean bl;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl2 = bl = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            bl = this.hooksKeys();
            if ((this.style & 0x1000000) != 0) {
                bl = true;
            }
        }
        if (bl && this.setTabItemFocus()) {
            return true;
        }
        Control[] controlArray = this._getChildren();
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.isTabItem() || !control.setRadioFocus()) continue;
            return true;
        }
        for (n2 = 0; n2 < controlArray.length; ++n2) {
            control = controlArray[n2];
            if (!control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                Control control2 = controlArray[i2];
                if (!control2.translateMnemonic(event, control)) continue;
                return true;
            }
        }
        return false;
    }

    void updateBackgroundMode() {
        this.backgroundMode = this.parent.getBackgroundMode();
        super.updateBackgroundMode();
        Control[] controlArray = this._getChildren();
        for (int i2 = 0; i2 < controlArray.length; ++i2) {
            controlArray[i2].updateBackgroundMode();
        }
    }

    void updateLayout(boolean bl, boolean bl2) {
        if (this.isLayoutDeferred()) {
            return;
        }
        if ((this.state & 0x20) != 0) {
            boolean bl3 = (this.state & 0x40) != 0;
            this.state &= 0xFFFFFF9F;
            this.layout.layout(this, bl3);
        }
        if (bl2) {
            Control[] controlArray = this._getChildren();
            for (int i2 = 0; i2 < controlArray.length; ++i2) {
                controlArray[i2].updateLayout(bl, bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 101: {
                if (this.layout != null) break;
                super.processEvent(aWTEvent);
                return;
            }
            default: {
                super.processEvent(aWTEvent);
                return;
            }
        }
        if (this.isDisposed()) {
            super.processEvent(aWTEvent);
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            super.processEvent(aWTEvent);
            return;
        }
        try {
            switch (n2) {
                case 101: {
                    if (this.layout == null) break;
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                    this.handle.repaint();
                }
            }
            super.processEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

