/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    static final String FILTER = "*.*";
    protected static String currentDirectoryPath;

    public FileDialog(Shell shell) {
        this(shell, 32768);
    }

    public FileDialog(Shell shell, int n2) {
        super(shell, n2);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        Object object;
        int n2;
        JFileChooser jFileChooser = new JFileChooser(currentDirectoryPath);
        String string = this.getText();
        if (string != null && string.length() > 0) {
            jFileChooser.setDialogTitle(string);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            jFileChooser.setCurrentDirectory(new File(this.filterPath));
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            jFileChooser.setSelectedFile(new File(jFileChooser.getCurrentDirectory().getAbsolutePath() + "/" + this.fileName));
        }
        this.fileName = "";
        this.fileNames = null;
        String string2 = null;
        jFileChooser.setMultiSelectionEnabled((this.style & 2) != 0);
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            jFileChooser.setAcceptAllFileFilterUsed(false);
            for (n2 = 0; n2 < this.filterExtensions.length; ++n2) {
                object = this.filterExtensions[n2];
                String[] stringArray = this.filterExtensions[n2].split(";");
                Object object2 = this.filterNames == null || n2 >= this.filterNames.length ? object : this.filterNames[n2];
                jFileChooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File f2) {
                        if (f2.isDirectory()) {
                            return true;
                        }
                        int i2 = 0;
                        while (i2 < filters.length) {
                            String regExp;
                            String filterExtension = filters[i2].trim();
                            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                                filterExtension = Pattern.compile("\\E").matcher(filterExtension).replaceAll("\\\\E");
                                filterExtension = Pattern.compile("\\Q").matcher(filterExtension).replaceAll("\\\\Q");
                                filterExtension = Pattern.compile("?").matcher(filterExtension).replaceAll("\\E.\\Q");
                                filterExtension = Pattern.compile("*").matcher(filterExtension).replaceAll("\\E.*\\Q");
                                regExp = "\\Q" + filterExtension;
                            } else {
                                regExp = "\\Q" + filterExtension.replace("\\E", "\\\\E").replace("\\Q", "\\\\Q").replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
                            }
                            Pattern pattern = Pattern.compile(regExp.toString());
                            Matcher m2 = pattern.matcher(f2.getName());
                            if (m2.matches()) {
                                return true;
                            }
                            ++i2;
                        }
                        return false;
                    }

                    public String getDescription() {
                        return description;
                    }
                });
            }
            jFileChooser.setFileFilter(jFileChooser.getChoosableFileFilters()[0]);
        }
        if ((n2 = (this.style & 0x2000) != 0 ? jFileChooser.showSaveDialog(this.getParent().handle) : jFileChooser.showOpenDialog(this.getParent().handle)) == 0) {
            currentDirectoryPath = jFileChooser.getSelectedFile().getParent();
            if ((this.style & 2) != 0) {
                object = jFileChooser.getSelectedFiles();
                this.fileNames = new String[((File[])object).length];
                for (int i2 = 0; i2 < this.fileNames.length; ++i2) {
                    this.fileNames[i2] = ((File)object[i2]).getName();
                }
                if (((Object)object).length > 0) {
                    string2 = ((File)object[0]).getParentFile().getAbsolutePath();
                }
            } else {
                object = jFileChooser.getSelectedFile();
                this.fileName = ((File)object).getName();
                string2 = ((File)object).getAbsolutePath();
            }
            this.filterPath = new String(string2);
        }
        return string2;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

