/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class OutputLocationDialog
extends StatusDialog {
    private StringButtonDialogField fContainerDialogField;
    private SelectionButtonDialogField fUseDefault;
    private SelectionButtonDialogField fUseSpecific;
    private StatusInfo fContainerFieldStatus;
    private IProject fCurrProject;
    private IPath fOutputLocation;
    private List fClassPathList;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public OutputLocationDialog(Shell parent, CPListElement entryToEdit, List classPathList) {
        super(parent);
        this.setTitle(NewWizardMessages.OutputLocationDialog_title);
        this.fContainerFieldStatus = new StatusInfo();
        OutputLocationAdapter adapter = new OutputLocationAdapter();
        this.fUseDefault = new SelectionButtonDialogField(16);
        this.fUseDefault.setLabelText(NewWizardMessages.OutputLocationDialog_usedefault_label);
        this.fUseDefault.setDialogFieldListener(adapter);
        String label = Messages.format(NewWizardMessages.OutputLocationDialog_usespecific_label, entryToEdit.getPath().segment(0));
        this.fUseSpecific = new SelectionButtonDialogField(16);
        this.fUseSpecific.setLabelText(label);
        this.fUseSpecific.setDialogFieldListener(adapter);
        this.fContainerDialogField = new StringButtonDialogField(adapter);
        this.fContainerDialogField.setButtonLabel(NewWizardMessages.OutputLocationDialog_location_button);
        this.fContainerDialogField.setDialogFieldListener(adapter);
        this.fUseSpecific.attachDialogField(this.fContainerDialogField);
        this.fCurrProject = entryToEdit.getJavaProject().getProject();
        this.fClassPathList = classPathList;
        classPathList.remove(entryToEdit);
        IPath outputLocation = (IPath)entryToEdit.getAttribute("output");
        if (outputLocation == null) {
            this.fUseDefault.setSelection(true);
        } else {
            this.fUseSpecific.setSelection(true);
            this.fContainerDialogField.setText(outputLocation.removeFirstSegments(1).makeRelative().toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int widthHint = this.convertWidthInCharsToPixels(60);
        int indent = this.convertWidthInCharsToPixels(4);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fUseDefault.doFillIntoGrid(inner, 2);
        this.fUseSpecific.doFillIntoGrid(inner, 2);
        Text textControl = this.fContainerDialogField.getTextControl(inner);
        GridData textData = new GridData();
        textData.widthHint = widthHint;
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalIndent = indent;
        textControl.setLayoutData((Object)textData);
        Button buttonControl = this.fContainerDialogField.getChangeControl(inner);
        GridData buttonData = new GridData();
        buttonData.widthHint = SWTUtil.getButtonWidthHint(buttonControl);
        buttonControl.setLayoutData((Object)buttonData);
        OutputLocationDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doChangeControlPressed() {
        IContainer container = this.chooseOutputLocation();
        if (container != null) {
            this.fContainerDialogField.setText(container.getProjectRelativePath().toString());
        }
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.warnIfPathDangerous();
        this.updateStatus(this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fOutputLocation = null;
        this.fContainerFieldStatus.setOK();
        if (this.fUseDefault.isSelected()) {
            return;
        }
        String pathStr = this.fContainerDialogField.getText();
        if (pathStr.length() == 0) {
            this.fContainerFieldStatus.setError("");
            return;
        }
        IPath projectPath = this.fCurrProject.getFullPath();
        IPath path = projectPath.append(pathStr);
        IWorkspace workspace = this.fCurrProject.getWorkspace();
        IStatus pathValidation = workspace.validatePath(path.toString(), 6);
        if (!pathValidation.isOK()) {
            this.fContainerFieldStatus.setError(Messages.format(NewWizardMessages.OutputLocationDialog_error_invalidpath, pathValidation.getMessage()));
            return;
        }
        IWorkspaceRoot root = workspace.getRoot();
        IResource res = root.findMember(path);
        if (res != null) {
            if (res.getType() == 1) {
                this.fContainerFieldStatus.setError(NewWizardMessages.OutputLocationDialog_error_existingisfile);
                return;
            }
            if (!this.checkIfFolderValid(path)) {
                this.fContainerFieldStatus.setError(Messages.format(NewWizardMessages.OutputLocationDialog_error_invalidFolder, path));
                return;
            }
        }
        this.fOutputLocation = path;
    }

    private void warnIfPathDangerous() {
        if (!this.fContainerFieldStatus.isOK()) {
            return;
        }
        if (this.fUseDefault.isSelected()) {
            return;
        }
        String pathStr = this.fContainerDialogField.getText();
        if (pathStr.length() == 0) {
            return;
        }
        Path outputPath = new Path(pathStr);
        if ((pathStr = outputPath.lastSegment()).equals(".settings") && outputPath.segmentCount() == 1) {
            this.fContainerFieldStatus.setWarning(NewWizardMessages.OutputLocation_SettingsAsLocation);
            return;
        }
        if (pathStr.charAt(0) == '.' && pathStr.length() > 1) {
            this.fContainerFieldStatus.setWarning(Messages.format(NewWizardMessages.OutputLocation_DotAsLocation, pathStr));
            return;
        }
    }

    private boolean checkIfFolderValid(IPath path) {
        Iterator iterator = this.fClassPathList.iterator();
        while (iterator.hasNext()) {
            CPListElement element = (CPListElement)iterator.next();
            if (!element.getPath().equals((Object)path)) continue;
            return false;
        }
        return true;
    }

    public IPath getOutputLocation() {
        return this.fOutputLocation;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.output_location_dialog_context");
    }

    private IContainer chooseOutputLocation() {
        IWorkspaceRoot root = this.fCurrProject.getWorkspace().getRoot();
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        IProject[] allProjects = root.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)this.fCurrProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IResource initSelection = null;
        if (this.fOutputLocation != null) {
            initSelection = root.findMember(this.fOutputLocation);
        }
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(NewWizardMessages.OutputLocationDialog_ChooseOutputFolder_title);
        dialog.setValidator(new ISelectionStatusValidator(acceptedClasses){
            ISelectionStatusValidator validator;
            {
                this.validator = new TypedElementSelectionValidator(classArray, false);
            }

            public IStatus validate(Object[] selection) {
                IFolder folder;
                boolean valid;
                IStatus typedStatus = this.validator.validate(selection);
                if (!typedStatus.isOK()) {
                    return typedStatus;
                }
                if (selection[0] instanceof IFolder && !(valid = OutputLocationDialog.this.checkIfFolderValid((folder = (IFolder)selection[0]).getFullPath()))) {
                    return new StatusInfo(4, Messages.format(NewWizardMessages.OutputLocationDialog_error_invalidFolder, folder.getFullPath()));
                }
                return new StatusInfo();
            }
        });
        dialog.setMessage(NewWizardMessages.OutputLocationDialog_ChooseOutputFolder_description);
        dialog.addFilter(filter);
        dialog.setInput(root);
        dialog.setInitialSelection(initSelection);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            return (IContainer)dialog.getFirstResult();
        }
        return null;
    }

    private class OutputLocationAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private OutputLocationAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            OutputLocationDialog.this.doStatusLineUpdate();
        }

        public void changeControlPressed(DialogField field) {
            OutputLocationDialog.this.doChangeControlPressed();
        }
    }
}

