/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.contexts.provisional.IDebugContextListener;
import org.eclipse.debug.internal.ui.viewers.AsynchronousTreeViewer;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryBlocksTreeViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.WorkbenchJob;

public class SwitchMemoryBlockAction
extends Action
implements IViewActionDelegate,
IActionDelegate2 {
    private IViewPart fView;
    private MenuCreator fMenuCreator;
    private IAction fAction;
    private IMemoryBlockListener fListener = new IMemoryBlockListener(){

        public void memoryBlocksAdded(IMemoryBlock[] memory) {
            SwitchMemoryBlockAction.this.updateActionEnablement();
        }

        public void memoryBlocksRemoved(IMemoryBlock[] memory) {
            SwitchMemoryBlockAction.this.updateActionEnablement();
        }
    };
    private IDebugContextListener fDebugContextListener = new IDebugContextListener(){

        public void contextActivated(ISelection selection, IWorkbenchPart part) {
            SwitchMemoryBlockAction.this.updateActionEnablement();
        }

        public void contextChanged(ISelection selection, IWorkbenchPart part) {
            SwitchMemoryBlockAction.this.updateActionEnablement();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewPart view) {
        this.fView = view;
        DebugContextManager.getDefault().addDebugContextListener(this.fDebugContextListener, this.fView.getViewSite().getWorkbenchWindow());
        DebugPlugin.getDefault().getMemoryBlockManager().addListener(this.fListener);
        this.updateActionEnablement();
    }

    private AsynchronousTreeViewer getViewer() {
        MemoryView memView;
        IMemoryViewPane pane;
        if (this.fView == null) {
            return null;
        }
        if (this.fView instanceof MemoryView && (pane = (memView = (MemoryView)this.fView).getViewPane(MemoryBlocksTreeViewPane.PANE_ID)) instanceof MemoryBlocksTreeViewPane) {
            AsynchronousTreeViewer viewer = ((MemoryBlocksTreeViewPane)pane).getViewer();
            return viewer;
        }
        return null;
    }

    private void updateActionEnablement() {
        if (this.fAction != null) {
            IAdaptable context = DebugUITools.getDebugContext();
            if (context != null) {
                AsynchronousTreeViewer viewer;
                IMemoryBlockRetrieval retrieval = null;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (context.getAdapter((Class)clazz) != null) {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    retrieval = (IMemoryBlockRetrieval)context.getAdapter((Class)clazz2);
                }
                if (retrieval == null && context instanceof IMemoryBlockRetrieval) {
                    retrieval = (IMemoryBlockRetrieval)context;
                }
                if (retrieval == null && context instanceof IDebugElement) {
                    retrieval = ((IDebugElement)context).getDebugTarget();
                }
                if (retrieval != null) {
                    IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                    this.fAction.setEnabled(memoryBlocks.length > 0);
                    return;
                }
                if (this.getViewer() != null && (viewer = this.getViewer()).getInput() != null && viewer.getInput() instanceof IMemoryBlockRetrieval) {
                    retrieval = (IMemoryBlockRetrieval)viewer.getInput();
                    IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                    this.fAction.setEnabled(memoryBlocks.length > 0);
                    return;
                }
            }
            this.fAction.setEnabled(false);
        }
    }

    public void run(IAction action) {
        this.switchToNext();
    }

    public void run() {
        this.switchToNext();
    }

    private void switchToNext() {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof IDebugElement) {
            IMemoryBlockRetrieval retrieval;
            IDebugElement debugContext = (IDebugElement)context;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((retrieval = (IMemoryBlockRetrieval)debugContext.getAdapter((Class)clazz)) == null) {
                retrieval = debugContext.getDebugTarget();
            }
            if (retrieval != null) {
                IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                this.doSwitchToNext(memoryBlocks);
            }
        }
    }

    private void doSwitchToNext(IMemoryBlock[] memoryBlocks) {
        if (memoryBlocks.length > 1) {
            IMemoryBlock current = this.getCurrentMemoryBlock();
            int next = 0;
            if (current != null) {
                int i = 0;
                while (i < memoryBlocks.length) {
                    if (memoryBlocks[i] == current) {
                        next = i + 1;
                    }
                    ++i;
                }
            }
            if (next > memoryBlocks.length - 1) {
                next = 0;
            }
            SwitchToAction switchAction = new SwitchToAction(memoryBlocks[next], false);
            switchAction.run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
        this.fAction = action;
        this.updateActionEnablement();
        this.fMenuCreator = new MenuCreator();
        action.setMenuCreator((IMenuCreator)this.fMenuCreator);
    }

    public void dispose() {
        this.fAction = null;
        DebugPlugin.getDefault().getMemoryBlockManager().removeListener(this.fListener);
        DebugContextManager.getDefault().removeDebugContextListener(this.fDebugContextListener, this.fView.getViewSite().getWorkbenchWindow());
        if (this.fMenuCreator != null) {
            this.fMenuCreator.dispose();
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.switchToNext();
    }

    private IMemoryBlock getCurrentMemoryBlock() {
        if (this.fView == null) {
            return null;
        }
        ISelection memBlkSelection = this.fView.getSite().getSelectionProvider().getSelection();
        IMemoryBlock memoryBlock = null;
        if (memBlkSelection != null && !memBlkSelection.isEmpty() && memBlkSelection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)memBlkSelection).getFirstElement();
            if (obj instanceof IMemoryBlock) {
                memoryBlock = (IMemoryBlock)obj;
            } else if (obj instanceof IMemoryRendering) {
                memoryBlock = ((IMemoryRendering)obj).getMemoryBlock();
            }
        }
        return memoryBlock;
    }

    private String decorateLabel(IMemoryBlock memBlk, String label) {
        ILabelDecorator decorator;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.viewers.ILabelDecorator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((decorator = (ILabelDecorator)memBlk.getAdapter((Class)clazz)) != null) {
            label = decorator.decorateText(label, (Object)memBlk);
        }
        return label;
    }

    class SwitchToAction
    extends Action {
        private IMemoryBlock fMemoryblock;

        public void run() {
            if (SwitchMemoryBlockAction.this.fView == null) {
                return;
            }
            SwitchMemoryBlockAction.this.fView.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.fMemoryblock));
        }

        public SwitchToAction(IMemoryBlock memBlk, boolean buildLabel) {
            if (buildLabel) {
                this.setText(DebugUIMessages.SwitchMemoryBlockAction_4);
                Job job = new Job(this, "SwtichToAction", memBlk){
                    final /* synthetic */ SwitchToAction this$1;
                    private final /* synthetic */ IMemoryBlock val$memBlk;
                    {
                        this.this$1 = switchToAction;
                        this.val$memBlk = iMemoryBlock;
                    }

                    protected IStatus run(IProgressMonitor monitor) {
                        SwitchToAction.access$0(this.this$1, this.val$memBlk);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            this.fMemoryblock = memBlk;
        }

        public SwitchToAction(IMemoryBlock memBlk, String label) {
            super(label);
            this.fMemoryblock = memBlk;
        }

        private void getLabels(IMemoryBlock memBlk) {
            StringBuffer text = new StringBuffer("");
            String label = new String("");
            if (memBlk instanceof IMemoryBlockExtension) {
                String expression = ((IMemoryBlockExtension)memBlk).getExpression();
                if (expression == null) {
                    expression = DebugUIMessages.SwitchMemoryBlockAction_0;
                }
                text.append(expression);
            } else {
                long address = memBlk.getStartAddress();
                text.append(Long.toHexString(address));
            }
            label = text.toString();
            String finalLabel = label = SwitchMemoryBlockAction.this.decorateLabel(memBlk, label);
            WorkbenchJob job = new WorkbenchJob(this, "SwtichToAction Update Label", finalLabel){
                final /* synthetic */ SwitchToAction this$1;
                private final /* synthetic */ String val$finalLabel;
                {
                    this.this$1 = switchToAction;
                    this.val$finalLabel = string;
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    SwitchToAction.access$1(this.this$1, this.val$finalLabel);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }

        static /* synthetic */ void access$0(SwitchToAction switchToAction, IMemoryBlock iMemoryBlock) {
            switchToAction.getLabels(iMemoryBlock);
        }

        static /* synthetic */ void access$1(SwitchToAction switchToAction, String string) {
            super.setText(string);
        }
    }

    class MenuCreator
    implements IMenuCreator {
        Menu dropdown;

        MenuCreator() {
        }

        public void dispose() {
            if (this.dropdown != null) {
                this.dropdown.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.dropdown != null) {
                this.dropdown.dispose();
                this.dropdown = null;
            }
            if (this.dropdown == null) {
                this.dropdown = new Menu(parent);
                IMemoryBlock[] allMemoryBlocks = null;
                IMemoryBlock memoryBlock = SwitchMemoryBlockAction.this.getCurrentMemoryBlock();
                IAdaptable context = DebugUITools.getDebugContext();
                IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context);
                if (retrieval != null) {
                    allMemoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
                }
                if (allMemoryBlocks != null) {
                    int i = 0;
                    while (i < allMemoryBlocks.length) {
                        SwitchToAction action = new SwitchToAction(allMemoryBlocks[i], true);
                        if (allMemoryBlocks[i] == memoryBlock) {
                            action.setChecked(true);
                        }
                        ActionContributionItem item = new ActionContributionItem((IAction)action);
                        item.fill(this.dropdown, -1);
                        item.getAction().setChecked(true);
                        ++i;
                    }
                }
            }
            return this.dropdown;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

