/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.jvnet.substance.SubstanceBorder;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceInternalFrameTitlePane;
import org.jvnet.substance.SubstanceLookAndFeel;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private MouseInputListener labelMouseInputListener;
    private int width;
    private JWindow previewWindow;
    private boolean isInDrag;
    protected PropertyChangeListener propertyListener;
    protected TitleMouseHandler titleMouseHandler;
    protected ActionListener closeListener;
    protected ActionListener restoreListener;
    protected ActionListener maximizeListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceDesktopIconUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Font f = this.desktopIcon.getFont();
        if (f == null || f instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(SubstanceLookAndFeel.getColorScheme().getExtraLightColor());
    }

    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.frame.setOpaque(false);
        this.previewWindow = new JWindow();
        this.previewWindow.getContentPane().setLayout(new BorderLayout());
        this.iconPane = new SubstanceInternalFrameTitlePane(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.frame = null;
    }

    protected void installListeners() {
        super.installListeners();
        this.labelMouseInputListener = this.createMouseInputListener();
        this.iconPane.addMouseMotionListener(this.labelMouseInputListener);
        this.iconPane.addMouseListener(this.labelMouseInputListener);
        this.titleMouseHandler = new TitleMouseHandler();
        this.iconPane.addMouseMotionListener(this.titleMouseHandler);
        this.iconPane.addMouseListener(this.titleMouseHandler);
    }

    protected void uninstallListeners() {
        this.iconPane.removeMouseMotionListener(this.titleMouseHandler);
        this.iconPane.removeMouseListener(this.titleMouseHandler);
        this.titleMouseHandler = null;
        this.iconPane.removeMouseMotionListener(this.labelMouseInputListener);
        this.iconPane.removeMouseListener(this.labelMouseInputListener);
        this.labelMouseInputListener = null;
        super.uninstallListeners();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        JInternalFrame.JDesktopIcon di = (JInternalFrame.JDesktopIcon)c;
        di.setOpaque(false);
        int width = di.getWidth();
        int height = di.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setComposite(AlphaComposite.getInstance(10, 0.6f));
        SubstanceImageCreator.paintRectangularBackground(graphics, 0, 0, width, height, SubstanceLookAndFeel.getColorScheme(), false, false);
        di.paintComponents(graphics);
        graphics.dispose();
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    private void syncPreviewWindow(boolean toShow) {
        if (toShow) {
            int x = this.desktopIcon.getLocationOnScreen().x;
            int y = this.desktopIcon.getLocationOnScreen().y;
            this.previewWindow.setLocation(x, y - this.previewWindow.getHeight());
        }
    }

    public void uninstallUI(JComponent c) {
        SubstanceInternalFrameTitlePane thePane = (SubstanceInternalFrameTitlePane)this.iconPane;
        super.uninstallUI(c);
        thePane.uninstallListeners();
    }

    protected class TitleMouseHandler
    extends BasicDesktopIconUI.MouseInputHandler {
        protected TitleMouseHandler() {
            super(SubstanceDesktopIconUI.this);
        }

        public void mouseEntered(MouseEvent e) {
            if (SubstanceDesktopIconUI.this.isInDrag) {
                return;
            }
            BufferedImage previewImage = SubstanceInternalFrameTitlePane.getSnapshot(SubstanceDesktopIconUI.this.frame);
            if (previewImage != null) {
                SubstanceDesktopIconUI.this.previewWindow.getContentPane().removeAll();
                JLabel previewLabel = new JLabel(new ImageIcon(previewImage));
                previewLabel.setBorder(new SubstanceBorder());
                SubstanceDesktopIconUI.this.previewWindow.getContentPane().add((Component)previewLabel, "Center");
                SubstanceDesktopIconUI.this.previewWindow.setSize(previewImage.getWidth(), previewImage.getHeight());
                SubstanceDesktopIconUI.this.syncPreviewWindow(true);
                SubstanceDesktopIconUI.this.previewWindow.setVisible(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            SubstanceDesktopIconUI.this.isInDrag = false;
            SubstanceDesktopIconUI.this.previewWindow.dispose();
        }

        public void mousePressed(MouseEvent e) {
            SubstanceDesktopIconUI.this.previewWindow.dispose();
        }

        public void mouseReleased(MouseEvent e) {
            SubstanceDesktopIconUI.this.isInDrag = false;
            SubstanceDesktopIconUI.this.syncPreviewWindow(true);
            SubstanceDesktopIconUI.this.previewWindow.setVisible(true);
        }

        public void mouseDragged(MouseEvent e) {
            SubstanceDesktopIconUI.this.isInDrag = true;
            if (SubstanceDesktopIconUI.this.previewWindow.isVisible()) {
                SubstanceDesktopIconUI.this.syncPreviewWindow(false);
                SubstanceDesktopIconUI.this.previewWindow.dispose();
            }
        }
    }
}

