/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.watermark;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.noise.NoiseFactory;
import org.jvnet.substance.painter.noise.NoiseFilter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.watermark.SubstanceWatermark;

public class SubstanceNoiseWatermark
implements SubstanceWatermark {
    private Image watermarkImage = null;
    protected String displayName;
    protected double xFactor;
    protected double yFactor;
    protected boolean hasConstantZ;
    protected NoiseFilter noiseFilter;
    protected boolean toBlur;

    public SubstanceNoiseWatermark(String displayName, double xFactor, double yFactor, boolean hasConstantZ, NoiseFilter noiseFilter, boolean toBlur) {
        this.displayName = displayName;
        this.xFactor = xFactor;
        this.yFactor = yFactor;
        this.hasConstantZ = hasConstantZ;
        this.noiseFilter = noiseFilter;
        this.toBlur = toBlur;
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(this.watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage() {
        GraphicsDevice[] gds;
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        this.watermarkImage = SubstanceCoreUtilities.getBlankImage(screenWidth, screenHeight);
        Graphics2D graphics = (Graphics2D)this.watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isDependingOnTheme() {
        return true;
    }

    public void previewWatermark(Graphics g, int x, int y, int width, int height) {
        this.drawWatermarkImage((Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        if (isPreview) {
            graphics.drawImage((Image)NoiseFactory.getNoiseImage(SubstanceLookAndFeel.getMetallicColorScheme(), SubstanceLookAndFeel.getMetallicColorScheme(), 0.0, width, height, this.xFactor, this.yFactor, this.hasConstantZ, this.noiseFilter, this.toBlur), x, y, null);
        } else {
            int alpha = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme()) ? 100 : 150;
            graphics.setComposite(AlphaComposite.getInstance(3, (float)alpha / 255.0f));
            graphics.drawImage((Image)NoiseFactory.getNoiseImage(SubstanceLookAndFeel.getColorScheme(), SubstanceLookAndFeel.getGrayColorScheme(), 0.2, width, height, this.xFactor, this.yFactor, this.hasConstantZ, this.noiseFilter, this.toBlur), x, y, null);
        }
        return true;
    }

    public void dispose() {
        this.watermarkImage = null;
    }
}

